/*
 * Decompiled with CFR 0.152.
 */
package test.ojb.broker;

import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import ojb.broker.Identity;
import ojb.broker.OptimisticLockException;
import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.PersistenceBrokerFactory;
import ojb.broker.util.LoggerFactory;
import test.ojb.broker.LockedByTimestamp;
import test.ojb.broker.LockedByVersion;

public class OptimisticLockingTest
extends TestCase {
    PersistenceBroker broker;
    private static Class CLASS = class$test$ojb$broker$OptimisticLockingTest == null ? (class$test$ojb$broker$OptimisticLockingTest = OptimisticLockingTest.class$("test.ojb.broker.OptimisticLockingTest")) : class$test$ojb$broker$OptimisticLockingTest;
    static /* synthetic */ Class class$test$ojb$broker$OptimisticLockingTest;

    public static void main(String[] args) {
        String[] arr = new String[]{CLASS.getName()};
        TestRunner.main((String[])arr);
    }

    public OptimisticLockingTest(String name) {
        super(name);
    }

    public void setUp() {
        this.broker = PersistenceBrokerFactory.createPersistenceBroker();
    }

    public void tearDown() {
        try {
            this.broker.clearCache();
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            // empty catch block
        }
    }

    public void testVersionLock() {
        try {
            LockedByVersion obj = new LockedByVersion();
            obj.setValue("original");
            Identity oid = new Identity(obj);
            this.broker.store(obj);
            this.broker.clearCache();
            LockedByVersion copy1 = (LockedByVersion)this.broker.getObjectByIdentity(oid);
            this.broker.clearCache();
            LockedByVersion copy2 = (LockedByVersion)this.broker.getObjectByIdentity(oid);
            copy1.setValue("copy 1");
            this.broker.store(copy1);
            copy2.setValue("copy 2");
            try {
                this.broker.store(copy2);
            }
            catch (OptimisticLockException ex) {
                LoggerFactory.getDefaultLogger().debug(ex);
                return;
            }
            Assert.fail((String)"Should throw an Optimistic Lock exception");
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    public void testLockHandling() {
        try {
            LockedByVersion obj = new LockedByVersion();
            obj.setValue("original");
            Identity oid = new Identity(obj);
            this.broker.store(obj);
            this.broker.clearCache();
            LockedByVersion copy1 = (LockedByVersion)this.broker.getObjectByIdentity(oid);
            this.broker.clearCache();
            LockedByVersion copy2 = (LockedByVersion)this.broker.getObjectByIdentity(oid);
            copy1.setValue("copy 1");
            this.broker.store(copy1);
            copy2.setValue("copy 2");
            try {
                this.broker.store(copy2);
            }
            catch (OptimisticLockException ex) {
                Object conflictingObject = ex.getSourceObject();
                this.broker.removeFromCache(conflictingObject);
                Object syncronizedObject = this.broker.getObjectByIdentity(new Identity(conflictingObject));
                ((LockedByVersion)syncronizedObject).setValue("copy 3");
                this.broker.store(syncronizedObject);
                return;
            }
            Assert.fail((String)"Should throw an Optimistic Lock exception");
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    public void testTimestampLock() {
        try {
            LockedByTimestamp obj = new LockedByTimestamp();
            obj.setValue("original");
            Identity oid = new Identity(obj);
            this.broker.store(obj);
            this.broker.clearCache();
            LockedByTimestamp copy1 = (LockedByTimestamp)this.broker.getObjectByIdentity(oid);
            this.broker.clearCache();
            LockedByTimestamp copy2 = (LockedByTimestamp)this.broker.getObjectByIdentity(oid);
            copy1.setValue("copy 1");
            this.broker.store(copy1);
            copy2.setValue("copy 2");
            try {
                this.broker.store(copy2);
            }
            catch (OptimisticLockException ex) {
                LoggerFactory.getDefaultLogger().debug(ex);
                return;
            }
            Assert.fail((String)"Should throw an Optimistic Lock exception");
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

