/*
 * Decompiled with CFR 0.152.
 */
package ojb.odmg.locking;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import ojb.broker.Identity;
import ojb.odmg.TransactionImpl;
import ojb.odmg.locking.AbstractLockStrategy;
import ojb.odmg.locking.LockEntry;
import ojb.odmg.locking.LockMap;
import ojb.odmg.locking.LockStrategyFactory;
import ojb.odmg.locking.ObjectLocks;

public class InMemoryLockMapImpl
implements LockMap {
    private Hashtable locktable = new Hashtable();

    public LockEntry getWriter(Object obj) {
        this.removeTimedOutLocks(AbstractLockStrategy.DEFAULT_LOCK_TIMEOUT);
        Identity oid = new Identity(obj);
        ObjectLocks objectLocks = (ObjectLocks)this.locktable.get(oid.toString());
        if (objectLocks == null) {
            return null;
        }
        return objectLocks.getWriter();
    }

    protected void removeTimedOutLocks(long timeout) {
        boolean count = false;
        long maxAge = System.currentTimeMillis() - timeout;
    }

    public Collection getReaders(Object obj) {
        this.removeTimedOutLocks(AbstractLockStrategy.DEFAULT_LOCK_TIMEOUT);
        Identity oid = new Identity(obj);
        ObjectLocks objectLocks = (ObjectLocks)this.locktable.get(oid.toString());
        if (objectLocks == null) {
            return new Vector();
        }
        return objectLocks.getReaders().values();
    }

    public boolean addReader(TransactionImpl tx, Object obj) {
        this.removeTimedOutLocks(AbstractLockStrategy.DEFAULT_LOCK_TIMEOUT);
        Identity oid = new Identity(obj);
        LockEntry reader = new LockEntry(oid.toString(), tx.getGUID(), System.currentTimeMillis(), LockStrategyFactory.getIsolationLevel(obj.getClass()), LockEntry.LOCK_READ);
        ObjectLocks objectLocks = (ObjectLocks)this.locktable.get(oid.toString());
        if (objectLocks == null) {
            objectLocks = new ObjectLocks();
            this.locktable.put(oid.toString(), objectLocks);
        }
        objectLocks.addReader(reader);
        return true;
    }

    public void removeReader(TransactionImpl tx, Object obj) {
        this.removeTimedOutLocks(AbstractLockStrategy.DEFAULT_LOCK_TIMEOUT);
        Identity oid = new Identity(obj);
        String oidString = oid.toString();
        ObjectLocks objectLocks = (ObjectLocks)this.locktable.get(oidString);
        if (objectLocks == null) {
            return;
        }
        objectLocks.getReaders().remove(tx.getGUID());
    }

    public void removeWriter(LockEntry writer) {
        this.removeTimedOutLocks(AbstractLockStrategy.DEFAULT_LOCK_TIMEOUT);
        String oidString = writer.getOidString();
        ObjectLocks objectLocks = (ObjectLocks)this.locktable.get(oidString);
        if (objectLocks == null) {
            return;
        }
        objectLocks.setWriter(null);
    }

    public boolean upgradeLock(LockEntry reader) {
        this.removeTimedOutLocks(AbstractLockStrategy.DEFAULT_LOCK_TIMEOUT);
        String oidString = reader.getOidString();
        ObjectLocks objectLocks = (ObjectLocks)this.locktable.get(oidString);
        if (objectLocks == null) {
            return false;
        }
        LockEntry writer = new LockEntry(reader.getOidString(), reader.getTransactionId(), System.currentTimeMillis(), reader.getIsolationLevel(), LockEntry.LOCK_WRITE);
        objectLocks.setWriter(writer);
        objectLocks.getReaders().remove(reader.getTransactionId());
        return true;
    }

    public boolean setWriter(TransactionImpl tx, Object obj) {
        this.removeTimedOutLocks(AbstractLockStrategy.DEFAULT_LOCK_TIMEOUT);
        Identity oid = new Identity(obj);
        LockEntry writer = new LockEntry(oid.toString(), tx.getGUID(), System.currentTimeMillis(), LockStrategyFactory.getIsolationLevel(obj.getClass()), LockEntry.LOCK_WRITE);
        ObjectLocks objectLocks = (ObjectLocks)this.locktable.get(oid.toString());
        if (objectLocks == null) {
            objectLocks = new ObjectLocks();
            this.locktable.put(oid.toString(), objectLocks);
        }
        objectLocks.setWriter(writer);
        return true;
    }

    public boolean hasReadLock(TransactionImpl tx, Object obj) {
        this.removeTimedOutLocks(AbstractLockStrategy.DEFAULT_LOCK_TIMEOUT);
        Identity oid = new Identity(obj);
        ObjectLocks objectLocks = (ObjectLocks)this.locktable.get(oid.toString());
        if (objectLocks == null) {
            return false;
        }
        String txGuid = tx.getGUID();
        LockEntry reader = objectLocks.getReader(txGuid);
        return reader != null;
    }
}

