/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.util;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.PersistenceBrokerSQLException;
import ojb.broker.metadata.ClassDescriptor;
import ojb.broker.query.QueryByExample;
import ojb.broker.singlevm.PersistenceBrokerImpl;
import ojb.broker.util.LoggerFactory;
import ojb.broker.util.SequenceEntry;
import ojb.broker.util.SequenceManager;

public class SequenceManagerDefaultImpl
implements SequenceManager {
    protected PersistenceBrokerImpl broker;
    private static SequenceManagerDefaultImpl _instance;

    public SequenceManagerDefaultImpl(PersistenceBrokerImpl broker) {
        this.broker = broker;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getMaxIdForClass(ClassDescriptor cld, String fieldName) throws PersistenceBrokerException {
        int result = 0;
        ResultSet rs = null;
        Statement stmt = null;
        try {
            try {
                String table = cld.getFullTableName();
                String column = cld.getFieldDescriptorByName(fieldName).getColumnName();
                String sql = "SELECT MAX(" + column + ") FROM " + table;
                stmt = this.broker.getStatementManager().getGenericStatement(cld);
                rs = stmt.executeQuery(sql);
                rs.next();
                result = rs.getInt(1);
            }
            catch (Throwable t) {
                LoggerFactory.getDefaultLogger().error(t);
                throw new PersistenceBrokerException(t);
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            try {
                rs.close();
                stmt.close();
                return result;
            }
            catch (SQLException e) {
                LoggerFactory.getDefaultLogger().error(e);
                throw new PersistenceBrokerSQLException(e);
            }
        }
        try {}
        catch (SQLException e) {
            LoggerFactory.getDefaultLogger().error(e);
            throw new PersistenceBrokerSQLException(e);
        }
        rs.close();
        stmt.close();
        return result;
    }

    private synchronized int getNextId(Class clazz, String fieldName) throws PersistenceBrokerException {
        SequenceEntry tmp = new SequenceEntry();
        tmp.setClassname(clazz.getName());
        tmp.setFieldname(fieldName);
        SequenceEntry entry = (SequenceEntry)this.broker.getObjectByQuery(new QueryByExample(tmp));
        if (entry == null) {
            int lastId = this.getMaxForExtent(clazz, fieldName);
            entry = new SequenceEntry(clazz.getName(), fieldName, lastId);
        }
        int nextId = entry.getCurrent() + 1;
        entry.setCurrent(nextId);
        this.broker.store(entry);
        return nextId;
    }

    public int getUniqueId(Class clazz, String fieldName) {
        return this.getNextId(clazz, fieldName);
    }

    protected int getMaxForExtent(Class clazz, String fieldName) throws PersistenceBrokerException {
        int tmp;
        int max = 0;
        ClassDescriptor cld = this.broker.getClassDescriptor(clazz);
        if (!cld.isInterface() && (tmp = this.getMaxIdForClass(cld, fieldName)) > max) {
            max = tmp;
        }
        if (cld.isExtent()) {
            Vector extentClasses = cld.getExtentClasses();
            int i = 0;
            while (i < extentClasses.size()) {
                Class ec = (Class)extentClasses.get(i);
                cld = this.broker.getClassDescriptor(ec);
                int tmp2 = this.getMaxIdForClass(cld, fieldName);
                if (tmp2 > max) {
                    max = tmp2;
                }
                ++i;
            }
        }
        return max;
    }

    public String getUniqueString(Class clazz, String fieldName) {
        return Integer.toString(this.getUniqueId(clazz, fieldName));
    }

    public long getUniqueLong(Class clazz, String fieldName) {
        return this.getUniqueId(clazz, fieldName);
    }

    public Object getUniqueObject(Class clazz, String fieldName) {
        return this.getUniqueString(clazz, fieldName);
    }
}

