/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.accesslayer;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.PersistenceBrokerSQLException;
import ojb.broker.accesslayer.ConnectionManager;
import ojb.broker.accesslayer.SqlGenerator;
import ojb.broker.metadata.ClassDescriptor;
import ojb.broker.singlevm.PersistenceBrokerImpl;
import ojb.broker.util.Logger;
import ojb.broker.util.LoggerFactory;

class StatementsForClass {
    private Logger logger;
    private Class clazz;
    private ClassDescriptor cld;
    private ConnectionManager manager;
    private PreparedStatement selectByPKStmt;
    private PreparedStatement insertStmt;
    private PreparedStatement updateStmt;
    private PreparedStatement deleteStmt;
    private SqlGenerator sqlGenerator;
    public static int TYPE = 1004;
    public static int CONCUR = 1007;
    public static boolean ESCAPEPROCESSING = false;
    public boolean FORCEJDBC1_0 = false;

    private StatementsForClass() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public StatementsForClass(ClassDescriptor mif, PersistenceBrokerImpl broker) throws PersistenceBrokerException {
        this.cld = mif;
        this.clazz = mif.getClassOfObject();
        this.manager = broker.getConnectionManager();
        this.sqlGenerator = SqlGenerator.getInstance();
        this.logger = LoggerFactory.getLogger(this.getClass());
        String level = mif.getConnectionDescriptor().getJdbcLevel();
        this.FORCEJDBC1_0 = level.startsWith("1");
    }

    private Connection getConnection() throws SQLException {
        try {
            return this.manager.getConnectionForClassDescriptor(this.cld);
        }
        catch (PersistenceBrokerException e) {
            throw new SQLException("OJB Error: could not obtain a Connection");
        }
    }

    private PreparedStatement prepareStatement(String sql) throws SQLException {
        Connection connection = this.getConnection();
        PreparedStatement result = null;
        try {
            result = !this.FORCEJDBC1_0 ? connection.prepareStatement(connection.nativeSQL(sql), TYPE, CONCUR) : connection.prepareStatement(connection.nativeSQL(sql));
        }
        catch (AbstractMethodError err) {
            result = connection.prepareStatement(connection.nativeSQL(sql));
            this.FORCEJDBC1_0 = true;
        }
        catch (SQLException eSql) {
            if (eSql.getClass().getName().equals("interbase.interclient.DriverNotCapableException")) {
                result = connection.prepareStatement(connection.nativeSQL(sql));
                this.FORCEJDBC1_0 = true;
            }
            throw eSql;
        }
        result.setEscapeProcessing(ESCAPEPROCESSING);
        return result;
    }

    private Statement createStatement() throws SQLException {
        Connection connection = this.getConnection();
        Statement result = null;
        try {
            result = !this.FORCEJDBC1_0 ? connection.createStatement(TYPE, CONCUR) : connection.createStatement();
        }
        catch (AbstractMethodError err) {
            result = connection.createStatement();
            this.FORCEJDBC1_0 = true;
        }
        catch (SQLException eSql) {
            if (eSql.getClass().getName().equals("interbase.interclient.DriverNotCapableException")) {
                this.FORCEJDBC1_0 = true;
                result = connection.createStatement();
            }
            throw eSql;
        }
        result.setEscapeProcessing(ESCAPEPROCESSING);
        return result;
    }

    public PreparedStatement getDeleteStmt() throws SQLException {
        if (this.deleteStmt != null && !this.isAlive(this.deleteStmt.getConnection())) {
            this.deleteStmt = null;
        }
        if (this.deleteStmt == null) {
            StatementsForClass statementsForClass = this;
            synchronized (statementsForClass) {
                String sql = this.sqlGenerator.getPreparedDeleteStatement(this.cld);
                try {
                    this.deleteStmt = this.prepareStatement(sql);
                }
                catch (SQLException ex) {
                    this.logger.error(ex);
                    throw ex;
                }
            }
        }
        return this.deleteStmt;
    }

    public Statement getGenericStmt() throws PersistenceBrokerSQLException {
        Statement stmt = null;
        try {
            stmt = this.createStatement();
        }
        catch (SQLException ex) {
            this.logger.error(ex);
            throw new PersistenceBrokerSQLException(ex);
        }
        return stmt;
    }

    public PreparedStatement getInsertStmt() throws SQLException {
        if (this.insertStmt != null && !this.isAlive(this.insertStmt.getConnection())) {
            this.insertStmt = null;
        }
        if (this.insertStmt == null) {
            StatementsForClass statementsForClass = this;
            synchronized (statementsForClass) {
                String sql = this.sqlGenerator.getPreparedInsertStatement(this.cld);
                try {
                    this.insertStmt = this.prepareStatement(sql);
                }
                catch (SQLException ex) {
                    this.logger.error(ex);
                    throw ex;
                }
            }
        }
        return this.insertStmt;
    }

    public PreparedStatement getPreparedStmt(String sql) throws PersistenceBrokerSQLException {
        PreparedStatement stmt = null;
        try {
            stmt = this.prepareStatement(sql);
        }
        catch (SQLException ex) {
            this.logger.error(ex);
            throw new PersistenceBrokerSQLException(ex);
        }
        return stmt;
    }

    public PreparedStatement getSelectByPKStmt() throws SQLException {
        if (this.selectByPKStmt != null && !this.isAlive(this.selectByPKStmt.getConnection())) {
            this.selectByPKStmt = null;
        }
        if (this.selectByPKStmt == null) {
            StatementsForClass statementsForClass = this;
            synchronized (statementsForClass) {
                String sql = this.sqlGenerator.getPreparedSelectByPkStatement(this.cld);
                try {
                    this.selectByPKStmt = this.prepareStatement(sql);
                }
                catch (SQLException ex) {
                    this.logger.error(ex);
                    throw ex;
                }
            }
        }
        return this.selectByPKStmt;
    }

    public PreparedStatement getUpdateStmt() throws SQLException {
        if (this.updateStmt != null && !this.isAlive(this.updateStmt.getConnection())) {
            this.updateStmt = null;
        }
        if (this.updateStmt == null) {
            StatementsForClass statementsForClass = this;
            synchronized (statementsForClass) {
                String sql = this.sqlGenerator.getPreparedUpdateStatement(this.cld);
                if (sql == null) {
                    PreparedStatement preparedStatement = null;
                    return preparedStatement;
                }
                try {
                    this.updateStmt = this.prepareStatement(sql);
                }
                catch (SQLException ex) {
                    this.logger.error(ex);
                    throw ex;
                }
            }
        }
        return this.updateStmt;
    }

    private boolean isAlive(Connection conn) {
        boolean result;
        try {
            result = !conn.isClosed();
        }
        catch (SQLException e) {
            result = false;
        }
        return result;
    }
}

