/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.accesslayer;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import ojb.broker.Identity;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.PersistenceBrokerSQLException;
import ojb.broker.accesslayer.JdbcAccess;
import ojb.broker.metadata.ClassDescriptor;
import ojb.broker.metadata.FieldDescriptor;
import ojb.broker.query.Query;
import ojb.broker.singlevm.PersistenceBrokerImpl;
import ojb.broker.util.LoggerFactory;

public class PkEnumeration
implements Enumeration,
Serializable {
    protected boolean hasCalledCheck = false;
    protected boolean hasNext = false;
    protected ResultSet resultSet;
    protected ClassDescriptor classDescriptor;
    protected Constructor constructor;
    static /* synthetic */ Class class$ojb$broker$Identity;

    public PkEnumeration(Query query, ClassDescriptor mif, Class primaryKeyClass, PersistenceBrokerImpl broker) {
        ResultSet rs;
        this.resultSet = rs = new JdbcAccess(broker).executeQuery(query, mif);
        this.classDescriptor = mif;
        try {
            Class[] argArray = new Class[]{class$ojb$broker$Identity == null ? (class$ojb$broker$Identity = PkEnumeration.class$("ojb.broker.Identity")) : class$ojb$broker$Identity};
            this.constructor = primaryKeyClass.getConstructor(argArray);
        }
        catch (NoSuchMethodException e) {
            LoggerFactory.getDefaultLogger().error(primaryKeyClass.getName() + " must implement a Constructor with one argument of type ojb.broker.Identity");
            throw new PersistenceBrokerException(e);
        }
        catch (SecurityException e) {
            LoggerFactory.getDefaultLogger().error(e);
            throw new PersistenceBrokerException(e);
        }
    }

    private Identity getIdentityFromResultSet() {
        try {
            Class c = this.classDescriptor.getClassOfObject();
            Object obj = c.newInstance();
            FieldDescriptor[] pkfields = this.classDescriptor.getPkFields();
            int i = 0;
            while (i < pkfields.length) {
                FieldDescriptor fld = pkfields[i];
                Object colValue = JdbcAccess.getObjectFromColumn(this.resultSet, fld);
                fld.getPersistentField().set(obj, colValue);
                ++i;
            }
            return new Identity(obj);
        }
        catch (SQLException e) {
            LoggerFactory.getDefaultLogger().error(e);
            throw new PersistenceBrokerSQLException(e);
        }
        catch (Throwable e) {
            LoggerFactory.getDefaultLogger().error(e);
            throw new PersistenceBrokerException(e);
        }
    }

    public boolean hasMoreElements() {
        try {
            if (!this.hasCalledCheck) {
                this.hasCalledCheck = true;
                this.hasNext = this.resultSet.next();
                if (!this.hasNext) {
                    this.releaseDbResources();
                }
            }
        }
        catch (SQLException e) {
            LoggerFactory.getDefaultLogger().error(e);
            this.hasNext = false;
        }
        return this.hasNext;
    }

    private void releaseDbResources() {
        try {
            Statement stmt = null;
            if (this.resultSet != null) {
                stmt = this.resultSet.getStatement();
            }
            if (stmt != null) {
                stmt.close();
            }
            this.resultSet = null;
        }
        catch (Throwable t) {
            LoggerFactory.getDefaultLogger().error(t.getMessage());
        }
    }

    public Object nextElement() {
        try {
            if (!this.hasCalledCheck) {
                this.hasMoreElements();
            }
            this.hasCalledCheck = false;
            if (this.hasNext) {
                Identity oid = this.getIdentityFromResultSet();
                Object[] args = new Identity[]{oid};
                return this.constructor.newInstance(args);
            }
            throw new NoSuchElementException();
        }
        catch (Exception ex) {
            LoggerFactory.getDefaultLogger().error(ex);
            throw new NoSuchElementException();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

