/*
 * Decompiled with CFR 0.152.
 */
package com.develop.jcfe;

import com.develop.jcfe.ClassFile;
import com.develop.jcfe.attribute.Attribute;
import com.develop.jcfe.attribute.AttributeSet;
import com.develop.jcfe.attribute.CodeAttribute;
import com.develop.jcfe.attribute.ExceptionsAttribute;
import com.develop.jcfe.cpool.ConstantPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;

public class method_info {
    private short methodsOffset;
    private short access_flags;
    private short name_index;
    private short descriptor_index;
    private final AttributeSet attset;

    public method_info(ConstantPool cp, short access_flags, short name_index, short descriptor_index) {
        this.access_flags = access_flags;
        this.name_index = name_index;
        this.descriptor_index = descriptor_index;
        this.attset = new AttributeSet(cp);
    }

    public short getNameIndex() {
        return this.name_index;
    }

    public short getDescriptorIndex() {
        return this.descriptor_index;
    }

    public Attribute getAttribute(int n) {
        return this.attset.get(n);
    }

    public void writeToStream(DataOutputStream ds) throws IOException {
        ds.writeShort(this.access_flags);
        ds.writeShort(this.name_index);
        ds.writeShort(this.descriptor_index);
        ds.writeShort(this.attset.size());
        int n = 0;
        while (n < this.attset.size()) {
            this.getAttribute(n).writeToStream(ds);
            ++n;
        }
    }

    public void addCodeAttribute(CodeAttribute ca) {
        this.attset.add(ca);
    }

    public void addExceptionsAttribute(ExceptionsAttribute ea) {
        if (ea.getNumberOfExceptions() <= 0) {
            throw new Error("exception attribute must have exceptions detail");
        }
        this.attset.add(ea);
    }

    public CodeAttribute getCodeAttribute() {
        CodeAttribute ca = null;
        Iterator it = this.attset.iterator();
        while (it.hasNext()) {
            try {
                ca = (CodeAttribute)it.next();
                break;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return ca;
    }

    public method_info(ClassFile cf, DataInputStream dis, short methodsOffset) throws IOException {
        this.methodsOffset = methodsOffset;
        ConstantPool cp = cf.getConstantPool();
        this.attset = new AttributeSet(cp);
        this.access_flags = dis.readShort();
        this.name_index = dis.readShort();
        this.descriptor_index = dis.readShort();
        short attributes_count = dis.readShort();
        short loop = 0;
        while (loop < attributes_count) {
            this.attset.add(Attribute.read(cp, dis));
            loop = (short)(loop + 1);
        }
    }
}

