<?php
// K-12向け日本語言語パック開発支援Ｗｅｂツール
// 2010/04/24(Sat) T.Shirai (shirai@mech.suzuka-ct.ac.jp)

require_once "config.php";
require_once "lib.php";

print_header("K-12向け日本語言語パック開発用支援環境：言語パックの漢字のチェック");

    if (!can_execute()) {
        echo 'サーバの負担が大きいため，外部の方は利用できません．ごめんなさい．<br />';
        bye();
    }

    if (!empty($_GET['check_kanji'])) $targetname = $_GET['check_kanji'];

    // 設定のチェック（config.phpを参照）
    initialize_settings($targetname);

    include "version.php";
    echo "<hr />\n";
    echo "<b>{$lang->desc}</b><br />\n";
    echo "<hr />\n";

    // 漢字辞書の生成
    prepare_kanjidic($targetname);
    echo "<hr />\n";

    // フォルダの確認
    if (!file_exists($lang->root)) {
        echo $lang->root.'フォルダが存在しません．<br />';
        bye();
        if (!is_dir($lang->root)) {
            echo $lang->root.'はフォルダではありません．<br />';
            bye();
        }
    }

    // 再帰的にチェック
    $cnt = (object)null;
    $cnt->totalfiles = $cnt->totallines = 0;        // チェックした対象
    $cnt->files = $cnt->lines = $cnt->letters = 0;  // 検査に該当した対象
    $cnt->cantread = array();                       // 読めないと判断した文字（読めるかも知れない．記号など）
    $output = '';     // 検査結果のHTMLデータ
    if (langfiles_check($lang->root, 'kanji')) {
        echo "漢字チェックは無事に終了しました．<br />\n";
    } else {
        echo "漢字チェックは完了しませんでした．<br />\n";
    }
    echo "チェックしたファイル数：{$cnt->totalfiles}<br />\n";
    echo "チェックした行数　　　：{$cnt->totallines}<br />\n";
    echo "発見したファイル数　　：{$cnt->files}<br />\n";
    echo "発見した行数　　　　　：{$cnt->lines}<br />\n";
    echo "発見した文字数　　　　：{$cnt->letters}<br />\n";
    echo "発見された文字種　　　：".count($cnt->cantread)."<br />\n";
    if ((count($cnt->cantread)) > 0 and debugdisplay()) {
        echo '<hr />';
        print_return();
        echo "<b>発見された文字一覧</b><br />\n";
        display_cantread($cnt->cantread);
    }
    echo '<hr />';
    print_return();
    echo $output;
    echo "<hr />\n";
    print_return();
    if (tag_output()) {
        echo "Tags<br />\n";
        foreach ($cnt->linedata as $path=>$lines) {
            while ($line = array_shift($lines)) {
                echo $path."($line)<br />\n";
            }
        }
        echo "<hr />\n";
    }
/*
    echo "for Wiki<br />\n";
    foreach ($cnt->linedata as $path=>$lines) {
        while ($line = array_shift($lines)) {
            echo mb_substr($path, mb_strlen($lang->root)+1)."($line)<br />\n";
        }
    }
    echo "<hr />\n";
*/
    echo "以上です．<br />\n";
    print_return();

print_footer();
?>
