#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Parser.pm 1481 2007-10-24 14:13:30Z hikarin $
#

package Zeromin2::Translate::JBBS::Parser;

use strict;
use LWP::UserAgent qw();
use HTML::TreeBuilder qw();

my $BASE_URL     = 'http://jbbs.livedoor.jp';
my $APP_BASE_URL = 'http://jbbs.livedoor.jp/bbs';

sub get_base_url {
    return $BASE_URL;
}

sub get_app_base_url {
    return $APP_BASE_URL;
}

sub new {
    my ($zClass) = @_;
    bless {}, $zClass;
}

sub is_login_ok {
    my ($zTJP) = @_;
    return $zTJP->{__login_ok} ? 1 : 0;
}

sub is_invalid_login {
    my ($zTJP) = @_;
    return $zTJP->{__is_invalid_login} ? 1 : 0;
}

sub get_status_code {
    my ($zTJP) = @_;
    return Img0ch::Kernel::intval( $zTJP->{__status_code} ) || 200;
}

sub get_status_line {
    my ($zTJP) = @_;
    return $zTJP->{__status_line} || '';
}

sub set_password {
    my ( $zTJP, $password ) = @_;
    $zTJP->{__pass} = $password;
    return;
}

sub set_request_timeout {
    my ( $zTJP, $timeout ) = @_;
    $zTJP->{__timeout} = Img0ch::Kernel::intval($timeout) || 60;
    return;
}

sub set_url {
    my ( $zTJP, $url ) = @_;
    $url =~ m{\A$BASE_URL/(\w+)/(\d+)/\z}xms;
    my ( $category_id, $bbs_id ) = ( $1, $2 );

    $zTJP->{__base_url}    = $url;
    $zTJP->{__category_id} = $category_id;
    $zTJP->{__bbs_id}      = $bbs_id;

    return;
}

my $form_cgi_names = {
    'main'      => 'config.cgi',
    'control'   => 'config_control_form.cgi',
    'handle'    => 'config_handle.cgi',
    'localrule' => 'config_localrule_form.cgi',
    'supporter' => 'config_support.cgi',
    'csv'       => 'config_log_csv_download.cgi',
};

sub try_post_form {
    my ( $zTJP, $tree, $form_cgi_name, $param ) = @_;
    $form_cgi_name = $form_cgi_names->{$form_cgi_name} || return 0;
    $param ||= {};

    my $category_id = $zTJP->{__category_id} || return 0;
    my $bbs_id      = $zTJP->{__bbs_id}      || return 0;
    my $ua          = LWP::UserAgent->new();
    my $config_url = join '/', $APP_BASE_URL, $form_cgi_name;
    my $login_param = {
        %$param,
        DIR      => $category_id,
        BBS      => $bbs_id,
        PASSWORD => $zTJP->{__pass},
    };

    $ua->timeout( $zTJP->{__timeout} );
    my $res = $ua->post( $config_url, $login_param );
    $zTJP->{__status_code} = $res->code();
    $zTJP->{__status_line} = $res->status_line();

    if ( $res->is_success() ) {
        my $content = $res->content();
        if ( index( $content, '<!-- 2ch_X:error -->' ) < 0 ) {
            $$tree
                = $param->{-raw}
                ? $content
                : HTML::TreeBuilder->new_from_content($content);
            return 1;
        }
        else {
            $zTJP->{__is_invalid_login} = 1;
        }
    }

    return 0;
}

1;
__END__
