#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: migrate.pm 1809 2009-01-10 16:27:27Z hikarin $
#

package Zeromin2::App::migrate;

use strict;

sub load {
    my ($zApp) = @_;
    $zApp->privilege(undef) or return $zApp->return_value(1);
    return $zApp->return_value(0);
}

sub save {
    my ($zApp) = @_;
    $zApp->check_csrf() or return $zApp->return_value(1);
    $zApp->privilege(undef) or return $zApp->return_value(1);

    my $ret;
    my $iKernel  = $zApp->kernel();
    my $iRequest = $zApp->request();
    my $zUser    = $zApp->user();
    my $utf8     = $zApp->request()->param('utf8') ? 1 : 0;

    if ( $iRequest->param('archive') ) {
        $zUser->can_create_archive() or return $zApp->return_value(1);
        $zUser->can_remove_archive() or return $zApp->return_value(1);
        $zUser->can_update_archive() or return $zApp->return_value(1);
        require Zeromin2::Translate::Img0ch::v2::Archive;
        $ret = Zeromin2::Translate::Img0ch::v2::Archive->work($iKernel);
        $ret->{code} and return $zApp->return_value( $ret->{code} );
    }
    if ( $iRequest->param('pool') ) {
        $zUser->can_create_pool()  or return $zApp->return_value(1);
        $zUser->can_recover_pool() or return $zApp->return_value(1);
        $zUser->can_remove_pool()  or return $zApp->return_value(1);
        require Zeromin2::Translate::Img0ch::v2::Pool;
        $ret = Zeromin2::Translate::Img0ch::v2::Pool->work($iKernel);
        $ret->{code} and return $zApp->return_value( $ret->{code} );
    }
    if ( $iRequest->param('banner') ) {
        $zUser->can_edit_banner() or return $zApp->return_value(1);
        require Zeromin2::Translate::Img0ch::v2::Banner;
        $ret = Zeromin2::Translate::Img0ch::v2::Banner->work( $iKernel,
            $utf8 );
        $ret->{code} and return $zApp->return_value( $ret->{code} );
    }
    if ( $iRequest->param('category') ) {
        $zUser->can_add_category()    or return $zApp->return_value(1);
        $zUser->can_edit_category()   or return $zApp->return_value(1);
        $zUser->can_remove_category() or return $zApp->return_value(1);
        require Zeromin2::Translate::Img0ch::v2::Category;
        $ret = Zeromin2::Translate::Img0ch::v2::Category->work($iKernel);
        $ret->{code} and return $zApp->return_value( $ret->{code} );
    }
    if ( $iRequest->param('user') ) {
        $zUser->can_create_user()   or return $zApp->return_value(1);
        $zUser->can_edit_user()     or return $zApp->return_value(1);
        $zUser->can_remove_user()   or return $zApp->return_value(1);
        $zUser->can_create_ugroup() or return $zApp->return_value(1);
        $zUser->can_edit_ugroup()   or return $zApp->return_value(1);
        $zUser->can_remove_ugroup() or return $zApp->return_value(1);
        require Zeromin2::Translate::Img0ch::v2::User;
        $ret
            = Zeromin2::Translate::Img0ch::v2::User->work( $iKernel, $zUser );
        $ret->{code} and return $zApp->return_value( $ret->{code} );
    }
    if ( $iRequest->param('cap') ) {
        $zUser->can_create_cap()    or return $zApp->return_value(1);
        $zUser->can_edit_cap()      or return $zApp->return_value(1);
        $zUser->can_remove_cap()    or return $zApp->return_value(1);
        $zUser->can_create_cgroup() or return $zApp->return_value(1);
        $zUser->can_edit_cgroup()   or return $zApp->return_value(1);
        $zUser->can_remove_cgroup() or return $zApp->return_value(1);
        require Zeromin2::Translate::Img0ch::v2::Cap;
        $ret = Zeromin2::Translate::Img0ch::v2::Cap->work( $iKernel, $utf8 );
        $ret->{code} and return $zApp->return_value( $ret->{code} );
    }
    if ( $iRequest->param('hostlog') ) {
        $zUser->can_create_bbs()      or return $zApp->return_value(1);
        $zUser->can_remove_bbs()      or return $zApp->return_value(1);
        $zUser->can_view_thread_log() or return $zApp->return_value(1);
        require Zeromin2::Translate::Img0ch::v2::Log::Host;
        $ret = Zeromin2::Translate::Img0ch::v2::Log::Host->work($iKernel);
        $ret->{code} and return $zApp->return_value( $ret->{code} );
    }
    if ( $iRequest->param('threadlog') ) {
        $zUser->can_create_bbs()      or return $zApp->return_value(1);
        $zUser->can_remove_bbs()      or return $zApp->return_value(1);
        $zUser->can_view_create_log() or return $zApp->return_value(1);
        require Zeromin2::Translate::Img0ch::v2::Log::Thread;
        $ret = Zeromin2::Translate::Img0ch::v2::Log::Thread->work($iKernel);
        $ret->{code} and return $zApp->return_value( $ret->{code} );
    }

    return $zApp->return_value(0);
}

sub import_from_jbbs {
    my ($zApp) = @_;
    $zApp->privilege(undef) or return $zApp->return_value(1);

    require Zeromin::BBS;
    my $iKernel  = $zApp->kernel();
    my $iRequest = $zApp->request();
    my $zBBS     = Zeromin::BBS->new($iKernel);
    my $url      = $iRequest->param('url');
    my $pass     = $iRequest->param('pass');
    my $bbs      = $iRequest->param('board');
    my ( $unijp, $encoding ) = $zApp->unijp();

    if ( $url and $pass and $bbs ) {
        $zApp->check_csrf() or return $zApp->return_value(1);

        my $iBBS = Img0ch::BBS->new( $iKernel, { id => $bbs } );
        my $param = {
            BBSList  => $zBBS->all($unijp),
            Password => $pass,
            URL      => $url,
        };

        if ( !$iBBS->get_id() ) {
            $zApp->add_template_param($param);
            return $zApp->return_value(2);
        }

        require Zeromin2::Translate::JBBS::Parser;
        my $zTJP = Zeromin2::Translate::JBBS::Parser->new();
        my $tree;
        my $nospace = sub {
            my ($str) = @_;
            $str =~ s/\A\s+//xms;
            $str =~ s/\s+\z//xms;
            return $str;
        };
        $zTJP->set_url( $nospace->($url) );
        $zTJP->set_password( $nospace->($pass) );
        if ( !$zTJP->try_post_form( \$tree, 'main', { -raw => 1 } ) ) {
            $param->{Status} = $zTJP->get_status_line();
            $zApp->add_template_param($param);
            return $zApp->return_value( $zTJP->is_invalid_login() ? 4 : 3 );
        }

        my $ret = {};
        if ( $iRequest->param('control') ) {
            $zApp->privilege('can_add_access')
                or return $zApp->return_value(1);
            $zApp->privilege('can_remove_access')
                or return $zApp->return_value(1);
            $zApp->privilege('can_add_ngword')
                or return $zApp->return_value(1);
            require Zeromin::Filter::NGWord;
            require Zeromin::Filter::RemoteHost;
            require Zeromin2::Translate::JBBS::Control;
            my $zFNG = Zeromin::Filter::NGWord->new($iBBS);
            my $zFRH = Zeromin::Filter::RemoteHost->new($iBBS);
            $ret->{control} = Zeromin2::Translate::JBBS::Control->work(
                $iKernel,
                {   host   => $zFRH,
                    ngword => $zFNG,
                    -url   => $url,
                    -pass  => $pass,
                },
            );
        }
        if ( $iRequest->param('handle') ) {
            $zApp->privilege('can_create_cap')
                or return $zApp->return_value(1);
            require Zeromin::Cap;
            require Zeromin2::Translate::JBBS::Handle;
            my $zCap = Zeromin::Cap->new($iBBS);
            $ret->{handle} = Zeromin2::Translate::JBBS::Handle->work(
                $iKernel,
                {   cap   => $zCap,
                    -bbs  => $bbs,
                    -url  => $url,
                    -pass => $pass,
                },
            );
        }
        if ( $iRequest->param('localrule') ) {
            $zApp->privilege('can_edit_head')
                or return $zApp->return_value(1);
            require Zeromin::Metadata;
            require Zeromin2::Translate::JBBS::LocalRule;
            my $zMeta = Zeromin::Metadata->new($iBBS);
            $ret->{localrule} = Zeromin2::Translate::JBBS::LocalRule->work(
                $iKernel,
                {   metadata => $zMeta,
                    -url     => $url,
                    -pass    => $pass,
                }
            );
        }
        if ( $iRequest->param('setting') ) {
            $zApp->privilege('can_change_import_setting')
                or return $zApp->return_value(1);
            require Zeromin::Setting;
            require Zeromin2::Translate::JBBS::Setting;
            my $zSetting = Zeromin::Setting->new($iBBS);
            $ret->{setting} = Zeromin2::Translate::JBBS::Setting->work(
                $iKernel,
                {   setting => $zSetting,
                    -url    => $url,
                    -pass   => $pass,
                }
            );
        }
        if ( $iRequest->param('supporter') ) {
            $zApp->privilege('can_create_user')
                or return $zApp->return_value(1);
            require Zeromin2::Translate::JBBS::Supporter;
            $ret->{supporter} = Zeromin2::Translate::JBBS::Supporter->work(
                $iKernel,
                {   user  => $zApp->user(),
                    -bbs  => $bbs,
                    -url  => $url,
                    -pass => $pass,
                }
            );
        }
        if ( $iRequest->param('thread') ) {
            $zApp->privilege('can_create_bbs')
                or return $zApp->return_value(1);
            require Zeromin2::Translate::JBBS::Thread;
            my $zTJT
                = Zeromin2::Translate::JBBS::Thread->new( $iBBS->get_kernel(),
                $url );
            my $subject = {};
            $zTJT->get_subject( $iBBS->get_subject_instance(), $subject );

            for my $key ( keys %$subject ) {
                my $iLog    = $iBBS->get_log_instance($key);
                my $iThread = $iBBS->get_thread_instance($key);
                $iThread->exists() and next;
                $zTJT->get_thread( $key, $iThread );
                $zTJT->get_thread_log( $key, $pass, $iLog );
            }
            $ret->{thread} = $subject;
        }

        $param->{Done_migrate_imported_from_jbbs} = 1;
        $zApp->add_template_param($param);
        return $zApp->return_value( 0, $ret );
    }

    $zApp->add_template_param( { BBSList => $zBBS->all($unijp) } );
    return $zApp->return_value(0);
}

1;
__END__
