#/*
# *  Copyright 2007-2010 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Metadata.pm 1901 2009-12-31 02:40:20Z hikarin $
#

package Img0ch::Compat::Metadata;

use strict;

sub load {
    my ( $iRepos, $iBBS ) = @_;
    my $iKernel = $iBBS->get_kernel();
    my $bbs     = $iBBS->get_name();

    for my $file ( 'head', 'meta', 'foot' ) {
        my $path = $iBBS->path("${file}.txt");
        -r $path or next;
        my $fh = $iKernel->get_read_file_handle($path);
        my $content = do { local $/ = undef; <$fh> };
        close $fh or $iKernel->throw_io_exception($path);
        $iRepos->set_binary( "I:M.${bbs}.${file}", $content );
    }

    my $base = $iKernel->get_config()->get('BBSPath');
    my $hash = {
        'banner.main'   => 'bannerpc.cgi',
        'banner.sub'    => 'bannersub.cgi',
        'banner.mobile' => 'bannermb.cgi',
    };
    for my $key ( keys %$hash ) {
        my $path = join '/', $base, $hash->{$key};
        -r $path or next;
        my $fh           = $iKernel->get_read_file_handle($path);
        my $banner_color = <$fh>;
        my $content      = do { local $/ = undef; <$fh> };
        close $fh or $iKernel->throw_io_exception($path);
        $iRepos->set_binary( "I:M.${key}", $content );
    }
    return 1;
}

1;
__END__
