<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN"
  "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja">
<head>
<title>img0ch - 画像検索</title>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="Content-Script-Type" content="text/javascript" />
<meta http-equiv="Content-Style-Type" content="text/css" />
<meta name="generator" content="<?cs var:html_escape(VERSION) ?>" />
<link media="screen" href="<?cs var:html_escape(StaticURI) ?>/tdiary/base.css" rel="stylesheet" />
<link media="screen" href="<?cs var:html_escape(StaticURI) ?>/tdiary/<?cs if:BBS_TYPE_THEME ?><?cs var:html_escape(BBS_TYPE_THEME) ?>/<?cs var:html_escape(BBS_TYPE_THEME) ?>.css<?cs else ?>default/default.css<?cs /if ?>" rel="stylesheet" />
<script type="text/javascript" src="<?cs var:html_escape(StaticURI) ?>/js/img0ch.js" charset="UTF-8"></script>
<script type="text/javascript">
//<![CDATA[
var app = Img0ch.App;
app.setBBS("<?cs var:html_escape(BBS) ?>");
app.setBBSURI("<?cs var:html_escape(BBSURI) ?>");
app.setCGIURI("<?cs var:html_escape(CGIURI) ?>");
app.setStaticURI("<?cs var:html_escape(StaticURI) ?>");
jQuery(function(){
    jQuery("//input[@name='word']").get(0).focus();
});
function redir(element) {
    app.redirectRenderer( element,
        { "theme": "<?cs var:html_escape(BBS_TYPE_THEME) ?>" } );
    return true;
}
//]]>
</script>
<style type="text/css">
img { border: 0px; }
div#searchForm {
  text-align: center;
  margin-left: auto;
  margin-right: auto;
}
<?cs var:TagCloudCSS ?>
</style>
<?cs var:META ?>
</head>
<body>

<?cs if:Banner ?>
<div class="day" id="mainBanner">
 <h2><span class="title">告知欄</span></h2>
 <div class="body">
  <div class="section">
   <?cs var:Banner ?>
  </div>
 </div>
</div>
<hr class="sep" />
<?cs /if ?>

<div class="day">
 <h2 class="thread_header">
  <span class="title thread_subject">「<?cs var:html_escape(BBS_TITLE) ?>」の画像検索</span>
 </h2>
 <div class="form">
  <form action="<?cs var:html_escape(CGIURI) ?>/img0ch-sf.cgi" method="post">
  <div class="caption">
   <p>
    <a href="<?cs var:html_escape(BBSURI) ?>/">掲示板に戻る</a>
    <a href="<?cs var:html_escape(CGIURI) ?>/img0ch-sf.cgi/<?cs var:html_escape(BBS) ?>/">検索フォーム</a>
    <a href="<?cs var:html_escape(CGIURI) ?>/img0ch-st.cgi/<?cs var:html_escape(BBS) ?>/">掲示板内全文検索</a>
   </p>
  </div>
  <div id="searchForm" class="section">
   <div class="field"><input type="text" name="word" size="70" /></div>
   <div><input type="submit" name="submit" value="このタグで検索" /></div>
   <div class="hidden_field"><input type="hidden" name="bbs" value="<?cs var:html_escape(BBS) ?>" /></div>
  </div>
  </form>
 </div>
 <div class="body">
  <div class="caption">
   <p>「<?cs var:html_escape(BBS_TITLE) ?>」のタグ一覧</p>
  </div>
  <div class="section">
   <p><?cs var:TagCloudHTML ?></p>
  </div>
 </div>
</div>

<?cs if:Total ?>
<div class="day">
 <h2 class="thread_header">
  <span class="title thread_subject">
   「<?cs var:html_escape(Word) ?>」の検索結果：<?cs var:html_escape(Total) ?>件
  </span>
 </h2>
 <div class="body">
  <div class="caption">
   <p>
<?cs if:Prev ?><a href="<?cs var:CGIURI ?>/img0ch-sf.cgi?bbs=<?cs var:html_escape(BBS) ?>&amp;word=<?cs var:html_escape(WordURLEscaped) ?>&amp;entries=<?cs var:html_escape(Item) ?>&amp;offset=<?cs var:html_escape(Prev) ?>">&lt;&lt;前</a><?cs /if ?>
<?cs each:item = Pages ?><a href="<?cs var:CGIURI ?>/img0ch-sf.cgi?bbs=<?cs var:html_escape(BBS) ?>&amp;word=<?cs var:html_escape(WordURLEscaped) ?>&amp;entries=<?cs var:html_escape(Item) ?>&amp;offset=<?cs var:html_escape(item.num) ?>">[<?cs var:html_escape(item.num) ?>]</a>
<?cs /each ?>
<?cs if:Next ?><a href="<?cs var:CGIURI ?>/img0ch-sf.cgi?bbs=<?cs var:html_escape(BBS) ?>&amp;word=<?cs var:html_escape(WordURLEscaped) ?>&amp;entries=<?cs var:html_escape(Item) ?>&amp;offset=<?cs var:html_escape(Next) ?>">次&gt;&gt;</a><?cs /if ?>
   </p>
  </div>
  <?cs each:item = Result ?>
  <div class="section">
   <p>
    <?cs if:item.thumbpath ?><a href="<?cs var:html_escape(item.url) ?>"><img class="image" src="<?cs var:html_escape(item.thumbpath) ?>" width="<?cs var:html_escape(item.width2) ?>" height="<?cs var:html_escape(item.height2) ?>" alt="<?cs var:html_escape(item.resno) ?>.<?cs var:html_escape(item.extension) ?> (<?cs var:html_escape(item.width) ?>x<?cs var:html_escape(item.height) ?>)"></a><?cs else ?><a href="<?cs var:html_escape(item.url) ?>"><?cs var:html_escape(item.resno) ?>.<?cs var:html_escape(item.extension) ?></a><?cs /if ?><br />スレッド元：&nbsp;<a href="<?cs var:html_escape(CGIURI) ?>/read.cgi/<?cs var:html_escape(BBS) ?>/<?cs var:html_escape(item.key) ?>/<?cs var:item.resno ?>" onclick="redir(this)"><?cs var:html_escape(item.subject) ?></a>&nbsp;(<a href="<?cs var:html_escape(CGIURI) ?>/img0ch-ufm.cgi/<?cs var:html_escape(BBS) ?>/<?cs var:html_escape(item.key) ?>/<?cs var:item.resno ?>">ファイル管理</a>)<br />ファイルのハッシュ：&nbsp;<?cs var:item.hash ?>
   </p>
  </div>
  <?cs /each ?>
 </div>
</div>
<?cs /if ?>

<div class="footer" id="VERSION"><a href="http://img0ch.sourceforge.jp">img0ch-sf.cgi - img0ch BBS</a></div>

</body>
</html>
