<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:php="http://php.net/xsl"
                              xmlns:xh="http://www.w3.org/1999/xhtml"
                              xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:nt="http://www.arielworks.net/works/codeyard/himmel/xnm"
                              xmlns:nts="http://www.arielworks.net/works/codeyard/himmel/xnm/settings"
                              xmlns:nidx="http://www.arielworks.net/works/codeyard/himmel/xnm/index"
                              xmlns:sdf="http://www.arielworks.net/works/codeyard/sdf"
                              xmlns:hml="http://www.arielworks.net/works/codeyard/himmel"
                              xmlns:s3="http://www.arielworks.net/works/codeyard/sdf/s3"
                              xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                              xmlns:dc="http://purl.org/dc/elements/1.1/"
                              xmlns:dcterms="http://purl.org/dc/terms/">

<xsl:include href="IndexToSdfUtil.xsl"/>

<xsl:template match="/nidx:index">
    <sdf:document xml:lang="ja">
        <sdf:meta>
            <dc:title>
                <xsl:value-of select="$nts:settings/nts:value[@name = 'SiteName']"/>
                <xsl:text>::Latest Notes</xsl:text>
            </dc:title>
            <xsl:call-template name="nidx:copy_latest_modified">
                <xsl:with-param name="nidx:targets_dom" select="/nidx:index/nidx:year/nidx:month/nidx:day/nidx:note"/>
            </xsl:call-template>
            <xsl:call-template name="nidx:copy_oldest_created">
                <xsl:with-param name="nidx:targets_dom" select="/nidx:index/nidx:year/nidx:month/nidx:day/nidx:note"/>
            </xsl:call-template>
            <link rel="up" href="{$nts:settings/nts:value[@name = 'RootPath']}" title="{$nts:settings/nts:value[@name = 'SiteName']}"/>
            <link rel="alternate" type="application/rss+xml" href="{$nts:settings/nts:value[@name = 'RootPath']}/latest.rss" title="RSS"/>
        </sdf:meta>
        <sdf:body>
            <p>最近の5件分。</p>
            <xsl:call-template name="listNotes">
                <xsl:with-param name="target" select="/nidx:index/nidx:year/nidx:month/nidx:day/nidx:note[nt:category/nt:li = $nidx:category]"/>
                <xsl:with-param name="layer" select="2"/>
                <xsl:with-param name="sortOrder" select="'descending'"/>
                <xsl:with-param name="limit" select="5"/>
            </xsl:call-template>
        </sdf:body>
    </sdf:document>
</xsl:template>

</xsl:stylesheet>