<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:php="http://php.net/xsl"
                              xmlns:xh="http://www.w3.org/1999/xhtml"
                              xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:nt="http://www.arielworks.net/works/codeyard/himmel/xnm"
                              xmlns:nts="http://www.arielworks.net/works/codeyard/himmel/xnm/settings"
                              xmlns:nidx="http://www.arielworks.net/works/codeyard/himmel/xnm/index"
                              xmlns:sdf="http://www.arielworks.net/works/codeyard/sdf"
                              xmlns:hml="http://www.arielworks.net/works/codeyard/himmel"
                              xmlns:s3="http://www.arielworks.net/works/codeyard/sdf/s3"
                              xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                              xmlns:dc="http://purl.org/dc/elements/1.1/"
                              xmlns:dcterms="http://purl.org/dc/terms/">

<xsl:include href="IndexToSdfUtil.xsl"/>

<xsl:template match="/nidx:index">
    <sdf:document xml:lang="ja">
        <sdf:meta>
            <dc:title>
                <xsl:value-of select="$nts:settings/nts:value[@name = 'siteName']"/>
                <xsl:text>::</xsl:text>
                <xsl:value-of select="$nidx:year"/>
                <xsl:text>-</xsl:text>
                <xsl:value-of select="$nidx:month"/>
            </dc:title>
            <xsl:call-template name="nidx:copy_latest_modified">
                <xsl:with-param name="nidx:targets_dom" select="./nidx:note[@year = $nidx:year and @month = $nidx:month]"/>
            </xsl:call-template>
            <xsl:call-template name="nidx:copy_oldest_created">
                <xsl:with-param name="nidx:targets_dom" select="./nidx:note[@year = $nidx:year and @month = $nidx:month]"/>
            </xsl:call-template>

            <link rel="up" href="../{$nidx:year}" title="{$nts:settings/nts:value[@name = 'siteName']}::{$nidx:year}"/>

            <xsl:variable name="next_page" select="nidx:note[@year = $nidx:year and @month = $nidx:month][last()]/following-sibling::nidx:note[1]"/>
            <xsl:if test="$next_page">
                <link rel="next" href="../{$next_page/@year}/{$next_page/@month}" title="{$nts:settings/nts:value[@name = 'siteName']}::{$next_page/@year}-{$next_page/@month}"/>
            </xsl:if>
            <xsl:variable name="prev_page" select="nidx:note[@year = $nidx:year and @month = $nidx:month][1]/preceding-sibling::nidx:note[1]"/>
            <xsl:if test="$prev_page">
                <link rel="prev" href="../{$prev_page/@year}/{$prev_page/@month}" title="{$nts:settings/nts:value[@name = 'siteName']}::{$prev_page/@year}-{$prev_page/@month}"/>
            </xsl:if>
        </sdf:meta>
        <sdf:body>
            <dl>
                <xsl:apply-templates select="./nidx:note[@year = $nidx:year and @month = $nidx:month and not(@day = preceding-sibling::nidx:note[@year = $nidx:year and @month = $nidx:month]/@day)]"/>
            </dl>
        </sdf:body>
    </sdf:document>
</xsl:template>

<xsl:template match="nidx:note">
    <dt>
        <a>
            <xsl:attribute name="href">
                <xsl:value-of select="concat('./', @month, '/', @day)"/>
            </xsl:attribute>
            <xsl:value-of select="./@year"/>
            <xsl:text>-</xsl:text>
            <xsl:value-of select="./@month"/>
            <xsl:text>-</xsl:text>
            <xsl:value-of select="./@day"/>
        </a>
    </dt>
    <dd>
        <ul>
            <xsl:for-each select="/nidx:index/nidx:note[@year = current()/@year and @month = current()/@month and @day = current()/@day]">
                <li>
                    <xsl:value-of select="concat('（', @hour, ':', @minute, ':',@second, '）')"/>
                    <a>
                        <xsl:attribute name="href">
                            <xsl:value-of select="concat('./', @month, '/', @day, '/', @hour, @minute, @second)"/>
                        </xsl:attribute>
                        <xsl:value-of select="./dc:title"/>
                    </a>
                </li>
            </xsl:for-each>
        </ul>
    </dd>
</xsl:template>

</xsl:stylesheet>