#ifndef _KOZOS_SYSCALL_H_INCLUDED_
#define _KOZOS_SYSCALL_H_INCLUDED_

#include "../kozos.h"

typedef enum {
  KZ_SYSCALL_TYPE_RUN,
  KZ_SYSCALL_TYPE_EXIT,
  KZ_SYSCALL_TYPE_WAIT,
  KZ_SYSCALL_TYPE_SLEEP,
  KZ_SYSCALL_TYPE_WAKEUP,
  KZ_SYSCALL_TYPE_GETID,
  KZ_SYSCALL_TYPE_CHPRI,
  KZ_SYSCALL_TYPE_SEND,
  KZ_SYSCALL_TYPE_RECV,
} kz_syscall_type_t;

typedef struct {
  union {
    struct {
      kz_func func;
      char *name;
      int pri;
      int argc;
      char **argv;
      int ret;
    } run;
    struct {
      int dummy;
    } exit;
    struct {
      int ret;
    } wait;
    struct {
      int ret;
    } sleep;
    struct {
      int id;
      int ret;
    } wakeup;
    struct {
      int ret;
    } getid;
    struct {
      int pri;
      int ret;
    } chpri;
    struct {
      int id;
      int size;
      char *p;
      int ret;
    } send;
    struct {
      int *idp;
      char **pp;
      int ret;
    } recv;
  } un;
} kz_syscall_param_t;

void kz_syscall(kz_syscall_type_t type, kz_syscall_param_t *param);

#endif
