/* head.nas */
struct binfo {
	char cyls, leds, cols, reserve;
	short scrnx, scrny;
	unsigned char *vram;
};
#define BINFO_ADDR	0x00000ff0
#define DISK_ADDR	0x00100000
/* low.nas */
void hlt(void);
void cli(void);
void sti(void);
void stihlt(void);
int in8(int port);
void out8(int port, int data);
int eflagsLoad(void);
void eflagsStore(int eflags);
void gdtrLoad(int limit, int addr);
void idtrLoad(int limit, int addr);
int cr0Load(void);
void cr0Store(int cr0);
void trLoad(int tr);
void farjmp(int eip, int cs);
void farcall(int eip, int cs);
void clts(void);
void fnsave(int *addr);
void frstor(int *addr);
void appRun(int eip, int cs, int ds, int esp, int *esp0);
void appEnd(void);
void int07Asm(void);
void int0cAsm(void);
void int0dAsm(void);
void int20Asm(void);
void int21Asm(void);
void int27Asm(void);
void int2cAsm(void);
void apiAsm(void);
unsigned int memTest0(unsigned int start, unsigned int end);
void int26Asm(void);
void cpuid(int id_eax, int id_ecx, int *eax, int *ebx, int *ecx, int *edx);
/* hardware.c */
#define TIMERS	500
struct segdesc {
	short limit_low, base_low;
	char base_mid, access_right;
	char limit_high, base_high;
};
struct gatedesc {
	short offset_low, selector;
	char dw_count, access_right;
	short offset_high;
};
struct mouse {
	unsigned char buf[4], phase, wheel;
	int x, y, btn, scroll;
	int mx, my, stat;
};
struct mapi {
	int x, y, btn, stat, scroll;
};
struct timer {
	struct timer *next;
	struct fifo *fifo;
	unsigned int tout, flag, fapp;
	int data;
};
struct timers {
	unsigned int count;
	struct timer *t, timer[TIMERS];
};
struct clock {
	unsigned short year;
	unsigned char month, day, hour, min, sec;
};
#define IDT_ADDR	0x0026f800
#define GDT_ADDR	0x00270000
#define MAIN_ADDR	0x00280000
#define IDT_LIMIT	0x000007ff
#define GDT_LIMIT	0x0000ffff
#define MAIN_LIMIT	0x0007ffff
#define	INT			0x008e
#define LDT			0x0082
#define TSS			0x0089
#define RWDATA		0x4092
#define RXCODE		0x409a
#define MOUSE_RELEASED	1
#define MOUSE_PRESSED	2
#define MOUSE_MOVED		3
#define MOUSE_DRAGGED	4
#define TIMER_ALLOC	1
#define TIMER_USING	2
void gdtInit(void);
void idtInit(void);
void segdescSet(struct segdesc *sd, int base, unsigned int limit, int ar);
void gatedescSet(struct gatedesc *gd, int offset, int selector, int ar);
void picInit(void);
int *int07(int *esp);
int *int0c(int *esp);
int *int0d(int *esp);
void int27(int *esp);
void keyInit(void);
void int21(int *esp);
void keyReady(void);
void mouseEnable(void);
void int2c(int *esp);
int mouseDecode(unsigned char data);
void mouseGet(struct mapi *m);
void pitInit(void);
void timersInit(void);
void int20(int *esp);
struct timer *timerAlloc(void);
void timerFree(struct timer *timer);
void timerInit(struct timer *timer, struct fifo *f);
void timerSet(struct timer *timer, unsigned int tout, int data);
void timerAllcancel(struct fifo *fifo);
int timerCancel(struct timer *timer);
void clockGet(struct clock *c);
void clockRtc(unsigned char *t);
void beep(int mhz);
/* memory.c */
#define MEMORY_FREES	4090
struct free {
	unsigned int addr, size;
};
struct memory {
	int allsize, frees;
	struct free free[MEMORY_FREES];
};
#define MEMORY_ADDR	0x003c0000
void memInit(struct memory *mem);
unsigned int memTest(unsigned int start, unsigned int end);
unsigned int memStat(struct memory *mem);
unsigned int memAlloc(struct memory *mem, unsigned int size);
void memFree(struct memory *mem, unsigned int addr, unsigned int size);
/* graphic.c */
#define SHEETS	256
#define SELECTS	10
struct sheet {
	unsigned char *buf;
	int cinv, height, flag, x, y, sx, sy;
	struct task *task;
	struct menu *menu;
};
struct sheets {
	unsigned char *vram, *map;
	int scrnx, scrny, top;
	struct sheet *sht[SHEETS], sheet[SHEETS];
};
struct window {
	struct sheet *sht;
	unsigned char title[31];
};
struct tbar {
	struct window win[SHEETS];
	struct sheet *sht;
	int cont, select, start, each;
};
struct select {
	unsigned char name[31], line[31];
	struct menu *menu;
	int mode;
};
struct menu {
	struct select sel[SELECTS], *now;
	unsigned char *title;
	struct sheet *sht, *csht;
	int mode;
};
#define SHEET_USING		0x0001
#define	SHEET_APP		0x0002
#define SHEET_CUR		0x0004
#define SHEET_MENU		0x0008
#define SHEET_DIALOGUE	0x0010
#define SHEET_FILER		0x0020
#define SHEET_TMGR		0x0040
#define SHEET_MOUSE		0x0080
#define MENU_ACCTIVE	1
#define SEL_SELECT		1
#define SEL_SUBMENU		2
#define _000000	0
#define _FF0000	1
#define _00FF00	2
#define	_FFFF00	3
#define _0000FF	4
#define _FF00FF	5
#define _00FFFF	6
#define _FFFFFF	7
#define _C6C6C6	8
#define _840000	9
#define _008400	10
#define _848400	11
#define _000084	12
#define _840084	13
#define _008484	14
#define _848484	15
void shtInit(void);
struct sheet *shtAlloc(void);
void shtFree(struct sheet *sht);
void shtSet(struct sheet *sht, unsigned char *buf, int sx, int sy, int cinv);
void shtRefresh(struct sheet *sht, int x0, int y0, int x1, int y1);
void shtUpdown(struct sheet *sht, int height);
void shtSlide(struct sheet *sht, int x, int y);
void shtClean(struct task *task);
void shtApp(struct sheet *sht);
void shtMclose(void);
struct menu *shtMchk(int h);
void shtMupdown(struct sheet *sht);
void shtTupdown(struct sheet *sht);
void palInit(void);
void screenInit(struct sheet *sht, int *fat, char *name);
void mcurInit(struct sheet *sht);
void graphicLine(struct sheet *sht, unsigned char c, int x0, int y0, int x1, int y1);
void graphicBox(struct sheet *sht, unsigned char c, int x0, int y0, int x1, int y1);
void graphicPutc(struct sheet *sht, unsigned char col, int x, int y, unsigned char *c);
void graphicPuts(struct sheet *sht, unsigned char c, int x, int y, unsigned char *s);
void graphicPutsl(struct sheet *sht, unsigned char c, int x, int y, unsigned char *s, int l);
void graphicPutsml(struct sheet *sht, unsigned char c, int x, int y, unsigned char *s, int l);
void graphicBlock(struct sheet *sht, int x0, int y0, int spx, int spy, unsigned char *buf, int sx);
unsigned char rgb2pal(int x, int y, int r, int g, int b);
void graphicButton(struct sheet *sht, int x, int y, int sx, int sy, unsigned char *str, int mode);
void winAlloc(struct sheet *sht, unsigned char *title, char m);
void winChange(struct sheet *sht, char m);
void textbox(struct sheet *sht, unsigned char c, int x0, int y0, int sx, int sy);
void winOn(struct sheet *skey);
void winOff(struct sheet *skey);
void winRefresh(void);
void dialog(char *s);
int inputDialog(char *buf, int n);
struct task *ssaverInit(void);
void menuInit(struct menu *menu, unsigned char *title);
void menuAdd(struct menu *menu, unsigned char *name, unsigned char *line, struct menu *m);
void menuRun(struct sheet *sht, struct menu *m, int mx, int my, int h);
void menuLight(struct menu *menu, int mx, int my);
void tbarInit(struct sheet *sht);
void tbarAdd(struct sheet *sht, unsigned char *title);
void tbarRemove(struct sheet *sht);
void tbarSelect(struct sheet *sht);
void tbarUnselect(void);
void tbarRun(int h, int x, int y);
/* task.c */
#define TASKS	1000
#define TLEVELS	10
#define TLTASKS	100
struct fifo {
	int *buf, size, free, wp, rp;
	struct task *task;
};
struct tss {
	int blink, esp0, ss0, esp1, ss1, esp2, ss2, cr3;
	int eip, eflags, eax, ecx, edx, ebx, esp, ebp, esi, edi;
	int es, cs, ss, ds, fs, gs;
	int	ldtr, iomap;
};
struct task {
	int flag, sel, pri, lv;
	unsigned int time;
	struct tss tss;
	int fpu[27];
	struct segdesc ldt[2];
	struct fifo fifo;
	struct memory *mem;
	struct console *cons;
	struct fhandle *fh;
	int *fat, ds, stack;
	unsigned char lbyte, name[25];
};
struct tlevel {
	int running, now;
	struct task *task[TLTASKS];
};
struct tasks {
	int now;
	char chlv;
	struct tlevel level[TLEVELS];
	struct task task[TASKS], *tfpu;
};
struct tmgr {
	struct sheet *sht;
	int start, now, dc, act;
	struct task *task[8];
};
struct task *taskNow(void);
struct task *taskInit(void);
void taskSwitch(void);
struct task *taskAlloc(char *name);
void taskRun(struct task *task, int lv, int pri);
void taskSleep(struct task *task);
void fifoInit(struct fifo *fifo, int *buf, int size, struct task *task);
void fifoPut(struct fifo *fifo, int data);
int fifoGet(struct fifo *fifo);
int fifoStat(struct fifo *fifo);
struct sheet *tmgrOpen(int *fat);
void tmgrClose(struct sheet *sht);
void tmgrExitreq(struct sheet *sht);
/* tek.c */
int tek_getsize(unsigned char *p);
int tek_decomp(unsigned char *p, char *q, int size);
/* file.c */
struct file {
	unsigned char name[8], ext[3], type;
	unsigned char reserve[10];
	unsigned short time, date, cno;
	unsigned int size;
};
struct fhandle {
	struct file *file;
	unsigned char *buf, mode;
	int size, pos, bcaddr, baddr;
};
struct filer {
	struct sheet *sht;
	int start, now, dc, act;
	struct file *file[8];
};
void fileInit(struct memory *mem, int cyls);
void fatRead(int *fat);
struct file *fileSearch(unsigned char *name);
void bufSet(struct fhandle *fh, int addr);
void bufFlush(struct fhandle *fh);
struct file *fileCreate(int *fat, unsigned char *name);
void fileDelete(int *fat, struct file *file);
int fileRename(struct file *file, unsigned char *name);
unsigned char *fileRead(int *fat, int cno, int size);
unsigned char *fileReadTek(int *fat, int cno, int *psize);
void fileassAdd(char *ext, char *assoc, char *desc);
void fileSetname(struct file *file, unsigned char *name);
void fileSetdate(struct file *file);
void fileGetdate(struct file *file, struct clock *clock);
struct sheet *filerOpen(int *fat);
void filerClose(struct sheet *sht);
void filerExitreq(struct sheet *sht);
/* console.c */
struct console {
	struct sheet *sht;
	int cx, cy, cc, start;
	unsigned char *str, line[30];
};
struct pict {
	int m, sx, sy;
};
struct meminfo {
	unsigned int all, free;
};
struct sheet *consOpen(int *fat);
struct task *consOpen0(struct sheet *sht, int *fat, char *name);
void consClose(struct sheet *sht);
void consClose0(struct task *task);
void consPutc(struct console *cons, unsigned char c, char m);
void consPuts(struct console *cons, unsigned char *s, int n);
struct task *consNcst(unsigned char *line, int *fat);
void consTask(struct sheet *sht);
int *api(int edi, int esi, int ebp, int esp, int ebx, int edx, int ecx, int eax);
/* bmp.nasm */
struct DLL_STRPICENV {
	int work[64 * 1024 / 4];
};
struct RGB {
	unsigned char b, g, r, t;
};
int info_BMP(struct DLL_STRPICENV *env, int *info, int size, char *fp);
int decode0_BMP(struct DLL_STRPICENV *env, int size, char *fp, int b_type, char *buf, int skip);
/* jpeg.c */
int info_JPEG(struct DLL_STRPICENV *env, int *info, int size, char *fp);
int decode0_JPEG(struct DLL_STRPICENV *env, int size, char *fp, int b_type, char *buf, int skip);
/* fdc.c */
#define FDCBUF_ADDR		0x00268000
void fdcTask(void);
void fdcInit(int *fat);
void fdcReq(unsigned char mode, int sect, int n);
void int26(int *esp);
/* main.c */
#define KEY_DOWN	0xf2
#define KEY_LEFT	0xf4
#define KEY_RIGHT	0xf6
#define KEY_UP		0xf8
#define KEY_INSERT	0xff
#define MOUSE_ADDR		0x0fe4
#define NIHONGO_ADDR	0x0fe8
#define FIFO_ADDR		0x0fec
#define TITLE_BACKGROUND	1
#define TITLE_FILEASS		2
#define TITLE_MENULIST		3
void reset(void);
