[INSTRSET "i486p"]
VBEMODE	EQU		0x0101		; VESA, 640 x 480, 8bit
MAIN	EQU		0x00280000
DISKC	EQU		0x00100000
DISKCR	EQU		0x00008000

CYLS	EQU		0x0ff0
LEDS	EQU		0x0ff1
COLS	EQU		0x0ff2
SCRNX	EQU		0x0ff4
SCRNY	EQU		0x0ff6
VRAM	EQU		0x0ff8

		ORG		0xc200

		MOV		AX,0x9000
		MOV		ES,AX
		MOV		DI,0
		MOV		AX,0x04f00
		INT		0x10
		CMP		AX,0x004f
		JNE		scrn320

		MOV		AX,[ES:DI+4]
		CMP		AX,0x0200
		JB		scrn320

		MOV		CX,VBEMODE
		MOV		AX,0x4f01
		INT		0x10
		CMP		AX,0x004f
		JNE		scrn320

		CMP		BYTE [ES:DI+0x19],8
		JNE		scrn320
		CMP		BYTE [ES:DI+0x1b],4
		JNE		scrn320
		MOV		AX,[ES:DI+0x00]
		AND		AX,0x0080
		JZ		scrn320

		MOV		bx,0x4000+VBEMODE
		MOV		AX,0x4f02
		INT		0x10
		MOV		BYTE [COLS],8
		MOV		AX,[ES:DI+0x12]
		MOV		WORD [SCRNX],AX
		MOV		AX,[ES:DI+0x14]
		MOV		WORD [SCRNY],AX
		MOV		EAX,[ES:DI+0x28]
		MOV		DWORD [VRAM],EAX
		JMP		kstat
scrn320:
		MOV		AL,0x13
		MOV		AH,0x00
		INT		0x10
		MOV		BYTE [COLS],8
		MOV		WORD [SCRNX],320
		MOV		WORD [SCRNY],200
		MOV		DWORD [VRAM],0x000a0000

kstat:
		MOV		AH,0x02
		INT		0x16
		MOV		[LEDS],AL

		MOV		AL, 0xff
		OUT		0x21, AL
		NOP
		OUT		0xa1, AL
		CLI

		CALL	waitkbdout
		MOV		AL,0xd1
		OUT		0x64,AL
		CALL	waitkbdout
		MOV		AL,0xdf
		OUT		0x60,AL
		CALL	waitkbdout

		LGDT	[gdtr0]
		MOV		EAX,CR0
		AND		EAX,0x7fffffff
		OR		EAX,0x00000001
		MOV		CR0,EAX
		JMP		pipelineflash
pipelineflash:
		MOV		AX,1*8
		MOV		DS,AX
		MOV		ES,AX
		MOV		FS,AX
		MOV		GS,AX
		MOV		SS,AX

		MOV		ESI,main
		MOV		EDI,MAIN
		MOV		ECX,512*1024/4
		CALL	memcpy

		MOV		ESI,0x7c00
		MOV		EDI,DISKC
		MOV		ECX,512/4
		CALL 	memcpy

		MOV		ESI,DISKCR+512
		MOV		EDI,DISKC+512
		MOV		ECX,0
		MOV		CL,[CYLS]
		IMUL	ECX,512*18*2/4
		SUB		ECX,512/4
		CALL	memcpy

		MOV		EBX,MAIN
		MOV		ECX,[EBX+16]
		ADD		ECX,3
		SHR		ECX,2
		JZ		skip
		MOV		ESI,[EBX+20]
		ADD		ESI,EBX
		MOV		EDI,[EBX+12]
		CALL	memcpy
skip:
		MOV		ESP,[EBX+12]
		JMP		DWORD 2*8:0x0000001b

waitkbdout:
		IN		AL,0x64
		AND		AL,0x02
		JNZ		waitkbdout
		RET

memcpy:
		MOV		EAX,[ESI]
		ADD		ESI,4
		MOV		[EDI],EAX
		ADD		EDI,4
		SUB		ECX,1
		JNZ		memcpy
		RET

		ALIGNB	8
gdt0:
		RESB	8
		DW		0xffff,0x0000,0x9200,0x00cf	; 32bitǂݏZOg
		DW		0xffff,0x0000,0x9a28,0x0047	; mainp32bitsZOg
		DW		0
gdtr0:
		DW		8*3-1
		DD		gdt0
		ALIGNB	8
main:
