#ifndef _KOZOS_THREAD_H_INCLUDED_
#define _KOZOS_THREAD_H_INCLUDED_

#include "../kozos.h"
#include "syscall.h"

#include <stdio.h>
#include <stdlib.h>
#include <setjmp.h>

#define THREAD_NUM 16
#define PRI_NUM 32
#define THREAD_NAME_SIZE 16

typedef struct _kz_membuf {
  struct _kz_membuf *next;
  int id;
  int size;
  char *p;
} kz_membuf;

typedef struct _kz_thread {
  struct _kz_thread *next;
  char name[THREAD_NAME_SIZE + 1];
  struct _kz_thread *id;
  kz_func func;
  int pri;
  char *stack;

  struct {
    kz_syscall_type_t type;
    kz_syscall_param_t *param;
  } syscall;

  kz_membuf *messages;

  struct {
#ifdef __TEASEOS
    struct jmp_buf env;
#else
    jmp_buf env;
#endif
  } context;
} kz_thread;

extern kz_thread *current;

#endif
