#include "../api.h"
#include <stdio.h>	/* sprintf */
#include <string.h>	/* strlen */

static unsigned char cset[128] = {
	/* invader 0 */
	0x00, 0x00, 0x00, 0x43, 0x5f, 0x5f, 0x5f, 0x7f,
	0x1f, 0x1f, 0x1f, 0x1f, 0x00, 0x20, 0x3f, 0x00,
	/* invader 1 */
	0x00, 0x0f, 0x7f, 0xff, 0xcf, 0xcf, 0xcf, 0xff,
	0xff, 0xe0, 0xff, 0xff, 0xc0, 0xc0, 0xc0, 0x00,
	/* invader 2 */
	0x00, 0xf0, 0xfe, 0xff, 0xf3, 0xf3, 0xf3, 0xff,
	0xff, 0x07, 0xff, 0xff, 0x03, 0x03, 0x03, 0x00,
	/* invader 3 */
	0x00, 0x00, 0x00, 0xc2, 0xfa, 0xfa, 0xfa, 0xfe,
	0xf8, 0xf8, 0xf8, 0xf8, 0x00, 0x04, 0xfc, 0x00,
	/* fighter 0 */
	0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x43, 0x47, 0x4f, 0x5f, 0x7f, 0x7f, 0x00,
	/* fighter 1 */
	0x18, 0x7e, 0xff, 0xc3, 0xc3, 0xc3, 0xc3, 0xff,
	0xff, 0xff, 0xe7, 0xe7, 0xe7, 0xe7, 0xff, 0x00,
	/* fighter 2 */
	0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
	0x80, 0xc2, 0xe2, 0xf2, 0xfa, 0xfe, 0xfe, 0x00,
	/* laser */
	0x00, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00
};	/* invader = "abcd", fighter = "efg", laser = "h" */

void winPuts(int win, unsigned char *wbuf, unsigned char c, int x, int y, unsigned char *s)
{
	unsigned char *p, *q;
	int x0, i;
	x = x * 8 + 8;
	y = y * 16 + 29;
	x0 = x;
	i = strlen(s);
	tWbox(win + 1, _000000, x, y, x + i * 8 - 1, y + 15);
	q = wbuf + y * 336;
	for (;;) {
		if (*s == 0) {
			break;
		}
		if (c != ' ') {
			if ('a' <= *s && *s <= 'h') {
				p = cset + 16 * (*s - 'a');
				q += x;
				for (i = 0; i < 16; i++) {
					if ((p[i] & 0x80) != 0) { q[0] = c; }
					if ((p[i] & 0x40) != 0) { q[1] = c; }
					if ((p[i] & 0x20) != 0) { q[2] = c; }
					if ((p[i] & 0x10) != 0) { q[3] = c; }
					if ((p[i] & 0x08) != 0) { q[4] = c; }
					if ((p[i] & 0x04) != 0) { q[5] = c; }
					if ((p[i] & 0x02) != 0) { q[6] = c; }
					if ((p[i] & 0x01) != 0) { q[7] = c; }
					q += 336;
				}
				q -= 336 * 16 + x;
			} else {
				tWputs(win + 1, c, x, y, s, 1);
			}
		}
		s++;
		x += 8;
	}
	tWrefresh(win, x0, y, x, y + 16);
	return;
}

void wait(int timer, int *kflag, int i)
{
	int j;
	if (i > 0) {
		tTset(timer, i, 128);
		i = 128;
	} else {
		i = 0x0a;
	}
	for (;;) {
		j = tGetc(1);
		if (i == j) {
			break;
		}
		if (j == '4') {
			*kflag |= 0x01;
		} else if (j == '6') {
			*kflag |= 0x02;
		} else if (j == ' ') {
			*kflag |= 0x04;
		}
	}
	return;
}

void HariMain(void)
{
	static unsigned char istr0[32] = " abcd abcd abcd abcd abcd ";
	unsigned char wbuf[87696], istr[192], s[9], *p;
	int win, timer, lwait, lx = 0, ly = 0, fx, kflag, i, j;
	int ix, iy, mwait0, mwait, idir;
	int iline, score, high = 0, point;
	win = tWopen(wbuf, 336, 261, -1, "Cx[_");
	tWbox(win, _000000, 6, 27, 329, 254);
	timer = tTalloc();
	winPuts(win, wbuf, _FFFFFF, 22, 0, "HIGH:00000000");

restart:
	score = 0;
	point = 1;
	winPuts(win, wbuf, _FFFFFF, 4, 0, "SCORE:00000000");
	mwait0 = 20;
	fx = 18;
	winPuts(win, wbuf, _00FFFF, fx, 13, "efg");
	wait(timer, &kflag, 100);

group:
	wait(timer, &kflag, 100);
	ix = 7;
	iy = 1;
	iline = 6;
	for (i = 0; i < 6; i++) {
		for (j = 0; j < 27; j++) {
			istr[i * 32 + j] = istr0[j];
		}
		winPuts(win, wbuf, _00FF00, ix, iy + i, istr + i * 32);
	}
	kflag = 0;
	ly = 0;
	lwait = 0;
	mwait = mwait0;
	idir = 1;
	wait(timer, &kflag, 100);

	for (;;) {
		if (lwait != 0) {
			lwait--;
			kflag &= ~0x04;
		}
		wait(timer, &kflag, 4);
		if ((kflag & 0x01) != 0) {
			if (fx > 0) {
				fx--;
				winPuts(win, wbuf, _00FFFF, fx, 13, "efg ");
			}
			kflag &= ~0x01;
		}
		if ((kflag & 0x02) != 0) {
			if (fx < 37) {
				winPuts(win, wbuf, _00FFFF, fx, 13, " efg");
				fx++;
			}
			kflag &= ~0x02;
		}
		if ((kflag & 0x04) != 0 && lwait == 0) {
			lwait = 15;
			lx = fx + 1;
			ly = 13;
		}

		if (mwait != 0) {
			mwait--;
		} else {
			mwait = mwait0;
			if (ix + idir > 14 || ix + idir < 0) {
				if (iy + iline == 13) {
					break;
				}
				idir = -idir;
				winPuts(win, wbuf, _000000, ix + 1, iy, "                         ");
				iy++;
			} else {
				ix += idir;
			}
			for (i = 0; i < iline; i++) {
				winPuts(win, wbuf, _00FF00, ix, iy + i, istr + i * 32);
			}
		}

		if (ly > 0) {
			if (ly < 13) {
				if (ix < lx && lx < ix + 25 && iy <= ly && ly < iy + iline) {
					winPuts(win, wbuf, _00FF00, ix, ly, istr + (ly - iy) * 32);
				} else {
					winPuts(win, wbuf, _000000, lx, ly, " ");
				}
			}
			ly--;
			if (ly > 0) {
				winPuts(win, wbuf, _FFFF00, lx, ly, "h");
			} else {
				point -= 10;
				if (point <= 0) {
					point = 1;
				}
			}
			if (ix < lx && lx < ix + 25 && iy <= ly && ly < iy + iline) {
				p = istr + (ly - iy) * 32 + (lx - ix);
				if (*p != ' ') {
					score += point;
					point++;
					sprintf(s, "%08d", score);
					winPuts(win, wbuf, _FFFFFF, 10, 0, s);
					if (high < score) {
						high = score;
						winPuts(win, wbuf, _FFFFFF, 27, 0, s);
					}
					for (p--; *p != ' '; p--) { }
					for (i = 1; i < 5; i++) {
						p[i] = ' ';
					}
					winPuts(win, wbuf, _00FF00, ix, ly, istr + (ly - iy) * 32);
					for (; iline > 0; iline--) {
						for (p = istr + (iline - 1) * 32; *p != 0; p++) {
							if (*p != ' ') {
								goto alive;
							}
						}
					}

					mwait0 -= mwait0 / 3;
					goto group;
alive:
					ly = 0;
				}
			}
		}
	}

	winPuts(win, wbuf, 1, 15, 6, "GAME OVER");
	wait(timer, &kflag, 0);
	for (i = 1; i < 14; i++) {
		winPuts(win, wbuf, _000000, 0, i, "                                        ");
	}
	goto restart;
	return;
}
