/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.transaction;

import java.util.Observable;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;
import org.neodatis.odb.core.layers.layer3.engine.IFileSystemInterface;
import org.neodatis.odb.core.transaction.ICache;
import org.neodatis.odb.core.transaction.ITmpCache;
import org.neodatis.odb.core.transaction.ITransaction;
import org.neodatis.odb.impl.core.transaction.CacheFactory;
import org.neodatis.odb.impl.core.transaction.Session;
import org.neodatis.tool.wrappers.OdbRandom;
import org.neodatis.tool.wrappers.OdbTime;

public class LocalSession
extends Session {
    private ITransaction transaction;
    private IFileSystemInterface fsiToApplyTransaction;
    private IStorageEngine storageEngine;

    public LocalSession(IStorageEngine engine, String sessionId) {
        super(sessionId, engine.getBaseIdentification().getIdentification());
        this.storageEngine = engine;
    }

    public LocalSession(IStorageEngine engine) {
        this(engine, "local " + OdbTime.getCurrentTimeInMs() + OdbRandom.getRandomInteger());
    }

    public void setFileSystemInterfaceToApplyTransaction(IFileSystemInterface fsi) {
        this.fsiToApplyTransaction = fsi;
        if (this.transaction != null) {
            this.transaction.setFsiToApplyWriteActions(this.fsiToApplyTransaction);
        }
    }

    public ITransaction getTransaction() {
        if (this.transaction == null) {
            this.transaction = OdbConfiguration.getCoreProvider().getTransaction(this, this.fsiToApplyTransaction);
        }
        return this.transaction;
    }

    public boolean transactionIsPending() {
        if (this.transaction == null) {
            return false;
        }
        return this.transaction.getNumberOfWriteActions() != 0;
    }

    private void resetTranstion() {
        if (this.transaction != null) {
            this.transaction.clear();
            this.transaction = null;
        }
    }

    public void commit() {
        if (this.transaction != null) {
            this.transaction.commit();
            this.transaction.reset();
        }
    }

    public void rollback() {
        if (this.transaction != null) {
            this.transaction.rollback();
            this.resetTranstion();
        }
        super.rollback();
    }

    public IStorageEngine getStorageEngine() {
        return this.storageEngine;
    }

    public void clear() {
        super.clear();
        if (this.transaction != null) {
            this.transaction.clear();
        }
        this.storageEngine = null;
    }

    public ICache buildCache() {
        return CacheFactory.getLocalCache(this, "permanent");
    }

    public ITmpCache buildTmpCache() {
        return CacheFactory.getLocalTmpCache(this, "tmp");
    }

    public void update(Observable o, Object arg) {
    }
}

