/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.query.criteria;

import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfoIndex;
import org.neodatis.odb.core.query.criteria.ICriterion;
import org.neodatis.odb.core.query.execution.IQueryExecutionPlan;
import org.neodatis.odb.impl.core.query.criteria.CriteriaQuery;
import org.neodatis.tool.wrappers.OdbTime;
import org.neodatis.tool.wrappers.list.IOdbList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CriteriaQueryExecutionPlan
implements IQueryExecutionPlan {
    protected transient ClassInfo classInfo;
    protected transient CriteriaQuery query;
    protected boolean useIndex;
    protected transient ClassInfoIndex classInfoIndex;
    protected long start;
    protected long end;
    protected String details;

    public CriteriaQueryExecutionPlan() {
    }

    public CriteriaQueryExecutionPlan(ClassInfo classInfo, CriteriaQuery query) {
        this.classInfo = classInfo;
        this.query = query;
        this.query.setExecutionPlan(this);
        this.init();
    }

    protected void init() {
        this.start = 0L;
        this.end = 0L;
        if (this.classInfo.hasIndex() && this.query.hasCriteria() && this.canUseIndex(this.query.getCriteria())) {
            IOdbList<String> fields = this.query.getAllInvolvedFields();
            if (fields.isEmpty()) {
                this.useIndex = false;
            } else {
                int[] fieldIds = this.getAllInvolvedFieldIds(fields);
                this.classInfoIndex = this.classInfo.getIndexForAttributeIds(fieldIds);
                if (this.classInfoIndex != null) {
                    this.useIndex = true;
                }
            }
        }
        this.details = this.getDetails();
    }

    protected int[] getAllInvolvedFieldIds(IOdbList<String> fields) {
        int nbFields = fields.size();
        int[] fieldIds = new int[nbFields];
        for (int i = 0; i < nbFields; ++i) {
            fieldIds[i] = this.classInfo.getAttributeId(fields.get(i).toString());
        }
        return fieldIds;
    }

    private boolean canUseIndex(ICriterion criteria) {
        return criteria.canUseIndex();
    }

    @Override
    public ClassInfoIndex getIndex() {
        return this.classInfoIndex;
    }

    @Override
    public boolean useIndex() {
        return this.useIndex;
    }

    @Override
    public String getDetails() {
        if (this.details != null) {
            return this.details;
        }
        StringBuffer buffer = new StringBuffer();
        if (this.classInfoIndex == null) {
            buffer.append("No index used, Execution time=").append(this.getDuration()).append("ms");
            return buffer.toString();
        }
        return buffer.append("Following indexes have been used : ").append(this.classInfoIndex.getName()).append(", Execution time=").append(this.getDuration()).append("ms").toString();
    }

    @Override
    public void end() {
        this.end = OdbTime.getCurrentTimeInMs();
    }

    @Override
    public long getDuration() {
        return this.end - this.start;
    }

    @Override
    public void start() {
        this.start = OdbTime.getCurrentTimeInMs();
    }
}

