/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.layers.layer1.introspector;

import org.neodatis.odb.OID;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.core.layers.layer1.introspector.IIntrospectionCallback;
import org.neodatis.odb.core.layers.layer2.meta.ObjectInfoHeader;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;
import org.neodatis.odb.core.transaction.ICrossSessionCache;
import org.neodatis.odb.core.transaction.ISession;
import org.neodatis.odb.core.trigger.ITriggerManager;
import org.neodatis.odb.impl.core.transaction.CacheFactory;

public class DefaultInstrospectionCallbackForStore
implements IIntrospectionCallback {
    protected boolean isUpdate;
    protected ITriggerManager triggerManager;
    protected ICrossSessionCache crossSessionCache;
    protected IStorageEngine engine;

    public DefaultInstrospectionCallbackForStore(IStorageEngine engine, ITriggerManager triggerManager, boolean isUpdate) {
        this.engine = engine;
        this.triggerManager = triggerManager;
        this.isUpdate = isUpdate;
        if (engine != null) {
            this.crossSessionCache = CacheFactory.getCrossSessionCache(engine.getBaseIdentification().getIdentification());
        }
    }

    public boolean objectFound(Object object) {
        if (!this.isUpdate) {
            if (this.triggerManager != null) {
                this.triggerManager.manageInsertTriggerBefore(object.getClass().getName(), object);
            }
        } else if (this.triggerManager != null) {
            this.triggerManager.manageUpdateTriggerBefore(object.getClass().getName(), null, object, null);
        }
        if (OdbConfiguration.reconnectObjectsToSession()) {
            this.checkIfObjectMustBeReconnected(object);
        }
        return true;
    }

    private OID checkIfObjectMustBeReconnected(Object o) {
        if (this.engine == null) {
            return null;
        }
        ISession session = this.engine.getSession(true);
        OID oid = session.getCache().getOid(o, false);
        if (oid != null) {
            return oid;
        }
        OID oidCrossSession = this.crossSessionCache.getOid(o);
        if (oidCrossSession != null) {
            ObjectInfoHeader oih = this.engine.getObjectInfoHeaderFromOid(oidCrossSession, true);
            session.addObjectToCache(oidCrossSession, o, oih);
            return oidCrossSession;
        }
        return null;
    }
}

