/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.gui;

import java.awt.BorderLayout;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.neodatis.tool.ILogger;
import org.neodatis.tool.wrappers.OdbString;

public class LoggerPanel
extends JPanel
implements ILogger {
    private JTextArea ta;

    public LoggerPanel() {
        this.initGUI();
    }

    private void initGUI() {
        this.ta = new JTextArea(5, 30);
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane(this.ta));
    }

    public void debug(Object object) {
        String s = this.ta.getText();
        this.ta.setText(s + "\n" + String.valueOf(object));
        this.ta.setCaretPosition(this.ta.getText().length());
    }

    public void error(Object object) {
        String header = "An internal error occured,please email the error stack trace displayed below to odb.support@neodatis.org";
        String s = this.ta.getText();
        this.ta.setText(s + "\n" + header + "\n" + String.valueOf(object));
        this.ta.setCaretPosition(this.ta.getText().length());
        JOptionPane.showMessageDialog(null, header);
    }

    public void error(Object object, Throwable throwable) {
        String header = "An internal error occured,please email the error stack trace displayed below to odb.support@neodatis.org";
        String s = this.ta.getText();
        this.ta.setText(s + "\n" + header + "\n" + String.valueOf(object) + ":\n" + OdbString.exceptionToString(throwable, false));
        this.ta.setCaretPosition(this.ta.getText().length());
        JOptionPane.showMessageDialog(null, header);
    }

    public void info(Object object) {
        String s = this.ta.getText();
        this.ta.setText(s + "\n" + String.valueOf(object));
        this.ta.setCaretPosition(this.ta.getText().length());
    }
}

