/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.model;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.gtdfree.Messages;
import org.gtdfree.model.Action;
import org.gtdfree.model.ActionEvent;
import org.gtdfree.model.ActionFilter;
import org.gtdfree.model.ConsistencyException;
import org.gtdfree.model.Folder;
import org.gtdfree.model.FolderEvent;
import org.gtdfree.model.GTDData;
import org.gtdfree.model.GTDDataDefault;
import org.gtdfree.model.GTDDataXMLTools;
import org.gtdfree.model.GTDModelListener;
import org.gtdfree.model.Priority;
import org.gtdfree.model.Project;
import org.gtdfree.model.Visitor;

public class GTDModel
implements Iterable<Folder> {
    private Map<Integer, Folder> folders = new HashMap<Integer, Folder>();
    private Map<Integer, Project> projects = new HashMap<Integer, Project>();
    private int lastActionID = 0;
    private int lastFolderID = 0;
    private transient ModelListenerSupport support = new ModelListenerSupport(this);
    private Folder resolved;
    private Folder deleted;
    private Folder reminder;
    private Folder inBucket;
    private boolean suspendedForMultipleChanges = false;
    private Folder queue;
    private Folder priority;
    private transient GTDData dataRepository;

    public static final void checkConsistency(GTDModel m, Logger log, boolean fail, boolean correct) throws ConsistencyException {
        Action[] a;
        Object[] id;
        GTDData.ActionProxy ap;
        GTDData.ActionProxy ap2;
        GTDData.ActionProxy ap3;
        HashMap<Integer, Folder> actions2Folders = new HashMap<Integer, Folder>();
        HashSet<Integer> project = new HashSet<Integer>();
        HashSet<Integer> resolved = new HashSet<Integer>();
        HashSet<Integer> reminder = new HashSet<Integer>();
        HashSet<Integer> deleted = new HashSet<Integer>();
        HashSet<Integer> priority = new HashSet<Integer>();
        int lastIDA = 0;
        int lastIDF = 0;
        boolean restart = true;
        while (restart) {
            restart = false;
            actions2Folders.clear();
            project.clear();
            resolved.clear();
            reminder.clear();
            deleted.clear();
            priority.clear();
            if (lastIDF > m.lastFolderID) {
                if (log != null) {
                    log.log(Level.WARNING, "Internal inconsistency, highest folder ID not property registered.");
                }
                m.lastFolderID = lastIDF;
            }
            if (lastIDA > m.lastActionID) {
                if (log != null) {
                    log.log(Level.WARNING, "Internal inconsistency, highest action ID not properly registered.");
                }
                m.lastActionID = lastIDA;
            }
            block1: for (Folder f : m) {
                if (f.getId() > lastIDF) {
                    lastIDF = f.getId();
                }
                if (f.getParent() != m) {
                    ConsistencyException e = new ConsistencyException("Folder has no reference to model.", null, new Folder[]{f}, null);
                    if (fail) {
                        throw e;
                    }
                    log.log(Level.WARNING, "Folder '" + f.getName() + "' has no reference to model.", e);
                    if (correct) {
                        f.setParent(m);
                        log.log(Level.INFO, "Parent set to folder  '" + f.getName() + "'.");
                    }
                }
                if (f.isMeta()) continue;
                for (int i = 0; i < f.size(); ++i) {
                    ConsistencyException e;
                    Action a2 = f.get(i);
                    if (a2 == null) {
                        e = new ConsistencyException("Action at position '" + i + "' is null.", new Action[0], new Folder[]{f}, null);
                        if (fail) {
                            throw e;
                        }
                        log.log(Level.WARNING, "Action at position '" + i + "' is null.", e);
                        if (!correct) {
                            // empty if block
                        }
                        ap3 = f.getProxy(i);
                        f.remove(i);
                        m.removeDeleted(null, ap3);
                        ap3.delete();
                        log.log(Level.INFO, "Null action at position '" + i + "' in '" + f.getName() + "' is removed.");
                        --i;
                        continue;
                    }
                    if (a2.getId() > lastIDA) {
                        lastIDA = a2.getId();
                    }
                    if (a2.getProxy() == null) {
                        e = new ConsistencyException("Action with ID '" + a2.getId() + "' has no internal proxy.", new Action[]{a2}, new Folder[]{f}, null);
                        if (fail) {
                            throw e;
                        }
                        log.log(Level.WARNING, "Action with ID '" + a2.getId() + "' has no internal proxy.", e);
                        if (correct) {
                            a2.setProxy(m.getDataRepository().getProxy(a2));
                            log.log(Level.INFO, "Proxy set to action with ID '" + a2.getId() + "'.");
                        }
                    }
                    if (a2.getParent() != f) {
                        e = new ConsistencyException("Action with ID '" + a2.getId() + "' has inconsistent parent list reference.", new Action[]{a2}, new Folder[]{f}, null);
                        if (fail) {
                            throw e;
                        }
                        log.log(Level.WARNING, "Action with ID '" + a2.getId() + "' has inconsistent parent list reference.", e);
                        if (correct) {
                            Folder f2 = a2.getParent();
                            ap2 = m.getDataRepository().getProxy(a2);
                            if (f2 != null) {
                                f2.remove(a2, ap2);
                            }
                            a2.setParent(f);
                            log.log(Level.INFO, "Action with ID '" + a2.getId() + "' got reference to correct list.");
                        }
                    }
                    if (actions2Folders.containsKey(a2.getId())) {
                        ConsistencyException e2;
                        Folder f2 = (Folder)actions2Folders.get(a2.getId());
                        Action a22 = f2.getActionByID(a2.getId());
                        if (a22 == a2) {
                            e2 = new ConsistencyException("Action is registered in two lists.", new Action[]{a2}, new Folder[]{f, f2}, null);
                            if (fail) {
                                throw e2;
                            }
                            log.log(Level.WARNING, "Action with ID '" + a2.getId() + "' is registered in two lists.", e2);
                            if (correct) {
                                Folder f3 = a2.getParent();
                                if (f3 == f) {
                                    f2.remove(a2, m.getDataRepository().getProxy(a2));
                                    log.log(Level.INFO, "Action with ID '" + a2.getId() + "' is only in list '" + f.getName() + "' and removed from others.");
                                } else if (f3 == f2) {
                                    f.remove(a2, m.getDataRepository().getProxy(a2));
                                    log.log(Level.INFO, "Action with ID '" + a2.getId() + "' is only in list '" + f2.getName() + "' and removed from others.");
                                } else {
                                    GTDData.ActionProxy ap4 = m.getDataRepository().getProxy(a2);
                                    f2.remove(a2, ap4);
                                    f.remove(a2, ap4);
                                    f3.remove(a2, ap4);
                                    m.getInBucketFolder().add(a2, ap4);
                                    log.log(Level.INFO, "Action with ID '" + a2.getId() + "' has been moved to InBucket.");
                                }
                                restart = true;
                                continue block1;
                            }
                        } else {
                            e2 = new ConsistencyException("Two action has same ID.", new Action[]{a2, a22}, new Folder[]{f, f2}, null);
                            if (fail) {
                                throw e2;
                            }
                            log.log(Level.WARNING, "Two action has same ID '" + a2.getId() + "'.", e2);
                            if (correct) {
                                ap = m.getDataRepository().getProxy(a2);
                                f.remove(a2, ap);
                                Action a3 = m.createActionCopy(f, a2, a2.getProject());
                                m.removeDeleted(a2, ap);
                                ap.delete();
                                log.log(Level.INFO, "Action was reinserted to folder '" + f.getName() + "' with new ID '" + a3.getId() + "'.");
                                restart = true;
                                continue block1;
                            }
                        }
                    }
                    actions2Folders.put(a2.getId(), f);
                    if (a2.getProject() != null) {
                        project.add(a2.getId());
                    }
                    if (a2.isResolved()) {
                        resolved.add(a2.getId());
                    }
                    if (a2.isDeleted()) {
                        deleted.add(a2.getId());
                    }
                    if (a2.getRemind() != null) {
                        reminder.add(a2.getId());
                    }
                    if (a2.getPriority() == null || a2.getPriority() == Priority.None) continue;
                    priority.add(a2.getId());
                }
            }
        }
        if (lastIDF > m.lastFolderID) {
            log.log(Level.WARNING, "Internal inconsistency, highest folder ID not property registered.");
            m.lastFolderID = lastIDF;
        }
        if (lastIDA > m.lastActionID) {
            log.log(Level.WARNING, "Internal inconsistency, highest action ID not properly registered.");
            m.lastActionID = lastIDA;
        }
        for (Folder f : m) {
            restart = true;
            while (restart) {
                restart = false;
                int open = 0;
                for (int i = 0; i < f.size(); ++i) {
                    ConsistencyException e;
                    Action a3 = f.get(i);
                    if (a3 == null) {
                        e = new ConsistencyException("Action in '" + f.getName() + "'  at position '" + i + "' is null.", new Action[0], new Folder[]{f}, null);
                        if (fail) {
                            throw e;
                        }
                        log.log(Level.WARNING, "Action at position '" + i + "' is null.", e);
                        if (!correct) {
                            // empty if block
                        }
                        ap2 = f.getProxy(i);
                        f.remove(i);
                        m.removeDeleted(null, ap2);
                        ap2.delete();
                        log.log(Level.INFO, "Null action at position '" + i + "' in '" + f.getName() + "' is removed.");
                        --i;
                        continue;
                    }
                    if (a3.isOpen()) {
                        ++open;
                    }
                    if (!actions2Folders.containsKey(a3.getId())) {
                        e = new ConsistencyException("Action has no defined list.", new Action[]{a3}, new Folder[]{f}, null);
                        if (fail) {
                            throw e;
                        }
                        log.log(Level.WARNING, "Action with ID '" + a3.getId() + "' has no defined list.", e);
                        if (correct) {
                            Folder f1 = a3.getParent();
                            if (f1 == null) {
                                f1 = m.getInBucketFolder();
                            }
                            ap = m.getDataRepository().getProxy(a3);
                            f1.add(a3, ap);
                            actions2Folders.put(a3.getId(), f1);
                            if (a3.getId() > lastIDA) {
                                lastIDA = a3.getId();
                            }
                            log.log(Level.INFO, "Action with ID '" + a3.getId() + "' added to list '" + f1.getName() + "'.");
                        }
                    }
                    if (f == m.getDeletedFolder()) {
                        if (!a3.isDeleted()) {
                            e = new ConsistencyException("Action in deleted list is not deleted.", new Action[]{a3}, new Folder[]{f}, null);
                            if (fail) {
                                throw e;
                            }
                            log.log(Level.WARNING, "Action with ID '" + a3.getId() + "' in deleted list is not deleted.", e);
                            if (correct) {
                                ap2 = m.getDataRepository().getProxy(a3);
                                f.remove(a3, ap2);
                                log.log(Level.INFO, "Action with ID '" + a3.getId() + "' removed from list '" + f.getName() + "'.");
                                restart = true;
                                break;
                            }
                        }
                        deleted.remove(a3.getId());
                        continue;
                    }
                    if (f == m.getResolvedFolder()) {
                        if (!a3.isResolved()) {
                            e = new ConsistencyException("Action in resolved list is not resolved.", new Action[]{a3}, new Folder[]{f}, null);
                            if (fail) {
                                throw e;
                            }
                            log.log(Level.WARNING, "Action with ID '" + a3.getId() + "' in resolved list is not resolved.", e);
                            if (correct) {
                                ap2 = m.getDataRepository().getProxy(a3);
                                f.remove(a3, ap2);
                                log.log(Level.INFO, "Action with ID '" + a3.getId() + "' removed from list '" + f.getName() + "'.");
                                restart = true;
                                break;
                            }
                        }
                        resolved.remove(a3.getId());
                        continue;
                    }
                    if (f == m.getPriorityFolder()) {
                        if (a3.getPriority() == null || a3.getPriority() == Priority.None) {
                            e = new ConsistencyException("Action in priority list has no priority set.", new Action[]{a3}, new Folder[]{f}, null);
                            if (fail) {
                                throw e;
                            }
                            log.log(Level.WARNING, "Action with ID '" + a3.getId() + "' in priority list has no priority set.", e);
                            if (correct) {
                                ap2 = m.getDataRepository().getProxy(a3);
                                f.remove(a3, ap2);
                                log.log(Level.INFO, "Action with ID '" + a3.getId() + "' removed from list '" + f.getName() + "'.");
                                restart = true;
                                break;
                            }
                        }
                        priority.remove(a3.getId());
                        continue;
                    }
                    if (f == m.getRemindFolder()) {
                        if (a3.getRemind() == null) {
                            e = new ConsistencyException("Action in reminder list has no reminder set.", new Action[]{a3}, new Folder[]{f}, null);
                            if (fail) {
                                throw e;
                            }
                            log.log(Level.WARNING, "Action with ID '" + a3.getId() + "' in remind list has no reminder set.", e);
                            if (correct) {
                                ap2 = m.getDataRepository().getProxy(a3);
                                f.remove(a3, ap2);
                                log.log(Level.INFO, "Action with ID '" + a3.getId() + "' removed from list '" + f.getName() + "'.");
                                restart = true;
                                break;
                            }
                        }
                        reminder.remove(a3.getId());
                        continue;
                    }
                    if (!f.isProject()) continue;
                    if (a3.getProject() == null) {
                        e = new ConsistencyException("Action in project list has no project set.", new Action[]{a3}, new Folder[]{f}, null);
                        if (fail) {
                            throw e;
                        }
                        log.log(Level.WARNING, "Action with ID '" + a3.getId() + "' in project list has no project set.", e);
                        if (correct) {
                            ap2 = m.getDataRepository().getProxy(a3);
                            f.remove(a3, ap2);
                            log.log(Level.INFO, "Action with ID '" + a3.getId() + "' removed from list '" + f.getName() + "'.");
                            restart = true;
                            break;
                        }
                    } else if (!a3.getProject().equals(f.getId())) {
                        e = new ConsistencyException("Action's project and action's project list are not same.", new Action[]{a3}, new Folder[]{f}, new Project[]{m.getProject(a3.getProject())});
                        if (fail) {
                            throw e;
                        }
                        log.log(Level.WARNING, "Action with ID '" + a3.getId() + "' in is in wrong project list.", e);
                        if (correct) {
                            ap2 = m.getDataRepository().getProxy(a3);
                            f.remove(a3, ap2);
                            log.log(Level.INFO, "Action with ID '" + a3.getId() + "' removed from list '" + f.getName() + "'.");
                            restart = true;
                            break;
                        }
                    }
                    project.remove(a3.getId());
                }
                if (open == f.getOpenCount()) continue;
                log.log(Level.WARNING, "Internal inconsistency, folder '" + f.getName() + "' has wrong open count.");
                f.setOpenCount(open);
            }
        }
        if (lastIDF > m.lastFolderID) {
            log.log(Level.WARNING, "Internal inconsistency, highest folder ID not property registered.");
            m.lastFolderID = lastIDF;
        }
        if (lastIDA > m.lastActionID) {
            log.log(Level.WARNING, "Internal inconsistency, highest action ID not properly registered.");
            m.lastActionID = lastIDA;
        }
        if (project.size() > 0) {
            id = project.toArray(new Integer[project.size()]);
            a = new Action[id.length];
            for (int i = 0; i < a.length; ++i) {
                a[i] = m.getAction(id[i]);
            }
            ConsistencyException e = new ConsistencyException("Actions with project set are not listed in project lists.", a, null, null);
            if (fail) {
                throw e;
            }
            log.log(Level.WARNING, "Actions with IDs '" + Arrays.toString(id) + "' are not in project lists.", e);
            if (correct) {
                for (int i = 0; i < a.length; ++i) {
                    GTDData.ActionProxy ap5 = m.getDataRepository().getProxy(a[i]);
                    Project p = m.getProject(a[i].getProject());
                    p.add(a[i], ap5);
                    log.log(Level.INFO, "Action with ID '" + a[i].getId() + "' added to project list '" + p.getName() + "'.");
                }
            }
        }
        if (deleted.size() > 0) {
            id = deleted.toArray(new Integer[deleted.size()]);
            a = new Action[id.length];
            for (int i = 0; i < a.length; ++i) {
                a[i] = m.getAction(id[i]);
            }
            ConsistencyException e = new ConsistencyException("Actions with deleted status are not listed in deleted list.", a, null, null);
            if (fail) {
                throw e;
            }
            log.log(Level.WARNING, "Actions with IDs '" + Arrays.toString(id) + "' are not in deleted list.", e);
            if (correct) {
                Folder f = m.getDeletedFolder();
                for (int i = 0; i < a.length; ++i) {
                    ap3 = m.getDataRepository().getProxy(a[i]);
                    f.add(a[i], ap3);
                    log.log(Level.INFO, "Action with ID '" + a[i].getId() + "' added to list '" + f.getName() + "'.");
                }
            }
        }
        if (resolved.size() > 0) {
            id = resolved.toArray(new Integer[resolved.size()]);
            a = new Action[id.length];
            for (int i = 0; i < a.length; ++i) {
                a[i] = m.getAction(id[i]);
            }
            ConsistencyException e = new ConsistencyException("Actions with resolved status are not listed in resolved list.", a, null, null);
            if (fail) {
                throw e;
            }
            log.log(Level.WARNING, "Actions with IDs '" + Arrays.toString(id) + "' are not in resolved list.", e);
            if (correct) {
                Folder f = m.getResolvedFolder();
                for (int i = 0; i < a.length; ++i) {
                    ap3 = m.getDataRepository().getProxy(a[i]);
                    f.add(a[i], ap3);
                    log.log(Level.INFO, "Action with ID '" + a[i].getId() + "' added to list '" + f.getName() + "'.");
                }
            }
        }
        if (reminder.size() > 0) {
            id = reminder.toArray(new Integer[reminder.size()]);
            a = new Action[id.length];
            for (int i = 0; i < a.length; ++i) {
                a[i] = m.getAction(id[i]);
            }
            ConsistencyException e = new ConsistencyException("Actions with reminder are not listed in reminder list.", a, null, null);
            if (fail) {
                throw e;
            }
            log.log(Level.WARNING, "Actions with IDs '" + Arrays.toString(id) + "' are not in remind list.", e);
            if (correct) {
                Folder f = m.getRemindFolder();
                for (int i = 0; i < a.length; ++i) {
                    ap3 = m.getDataRepository().getProxy(a[i]);
                    f.add(a[i], ap3);
                    log.log(Level.INFO, "Action with ID '" + a[i].getId() + "' added to list '" + f.getName() + "'.");
                }
            }
        }
        if (priority.size() > 0) {
            id = priority.toArray(new Integer[priority.size()]);
            a = new Action[id.length];
            for (int i = 0; i < a.length; ++i) {
                a[i] = m.getAction(id[i]);
            }
            ConsistencyException e = new ConsistencyException("Actions with priority are not listed in priority list.", a, null, null);
            if (fail) {
                throw e;
            }
            log.log(Level.WARNING, "Actions with IDs '" + Arrays.toString(id) + "' are not in priority list.", e);
            if (correct) {
                Folder f = m.getPriorityFolder();
                for (int i = 0; i < a.length; ++i) {
                    ap3 = m.getDataRepository().getProxy(a[i]);
                    f.add(a[i], ap3);
                    log.log(Level.INFO, "Action with ID '" + a[i].getId() + "' added to list '" + f.getName() + "'.");
                }
            }
        }
    }

    public Action createAction(Folder f, String desc) {
        GTDData.ActionProxy ap = this.getDataRepository().newAction(++this.lastActionID, new Date(), null, desc);
        Action a = ap.get();
        f.add(0, a, ap);
        return a;
    }

    public void removeDeleted(Action a, GTDData.ActionProxy ap) {
        this.deleted.remove(a, ap);
        if (a == null || a.getRemind() != null) {
            this.reminder.remove(a, ap);
        }
        if (a == null || a.getPriority() != null && a.getPriority() != Priority.None) {
            this.priority.remove(a, ap);
        }
        if (a == null || a.isQueued()) {
            this.queue.remove(a, ap);
        }
        if (a != null && a.getProject() != null && this.getProject(a.getProject()) != null) {
            this.getProject(a.getProject()).remove(a, ap);
        }
    }

    public void removeDeleted(ActionEvent.SortedElements se) {
        this.deleted.remove(se.getActions(), se.getActionProxies());
        this.reminder.remove(se.getActions(ActionEvent.SortedElements.ActionIndex.REMINDER), se.getActionProxies(ActionEvent.SortedElements.ActionIndex.REMINDER));
        this.priority.remove(se.getActions(ActionEvent.SortedElements.ActionIndex.PRIORITY), se.getActionProxies(ActionEvent.SortedElements.ActionIndex.PRIORITY));
        this.queue.remove(se.getActions(ActionEvent.SortedElements.ActionIndex.QUEUE), se.getActionProxies(ActionEvent.SortedElements.ActionIndex.QUEUE));
        Action[] ac = se.getActions(ActionEvent.SortedElements.ActionIndex.PROJECT);
        GTDData.ActionProxy[] ap = se.getActionProxies(ActionEvent.SortedElements.ActionIndex.PROJECT);
        for (int i = 0; i < ac.length; ++i) {
            Project p = this.getProject(ac[i].getProject());
            if (p == null) continue;
            p.remove(ac[i], ap[i]);
        }
    }

    public Action createActionCopy(Folder f, Action aa, Integer project) {
        GTDData.ActionProxy ap = this.getDataRepository().newAction(++this.lastActionID, aa, project);
        Action a = ap.get();
        f.add(0, a, ap);
        return a;
    }

    public GTDModel() {
    }

    public GTDModel(GTDData data) {
        this();
        this.initialize(data);
    }

    public void initialize(GTDData data) {
        this.dataRepository = data;
        this.createMetaFolders();
    }

    private void createMetaFolders() {
        if (this.resolved == null || !this.folders.containsKey(-1)) {
            this.resolved = this.createFolder(-1, Messages.getString("GTDModel.Resolved"), Folder.FolderType.BUILDIN_RESOLVED);
            this.resolved.setDescription(Messages.getString("GTDModel.Resolved.desc"));
            this.resolved.setComparator(new Comparator<Action>(){

                @Override
                public int compare(Action o1, Action o2) {
                    return o1.getId() - o2.getId();
                }
            });
        }
        if (this.reminder == null || !this.folders.containsKey(-2)) {
            this.reminder = this.createFolder(-2, Messages.getString("GTDModel.Tickler"), Folder.FolderType.BUILDIN_REMIND);
            this.reminder.setDescription(Messages.getString("GTDModel.Tickler.desc"));
            this.reminder.setComparator(new Comparator<Action>(){

                @Override
                public int compare(Action o1, Action o2) {
                    if (o1.getRemind() == null && o2.getRemind() == null) {
                        return 0;
                    }
                    if (o1.getRemind() == null) {
                        return -1;
                    }
                    if (o2.getRemind() == null) {
                        return 1;
                    }
                    return o1.getRemind().compareTo(o2.getRemind());
                }
            });
        }
        if (this.inBucket == null || !this.folders.containsKey(-3)) {
            this.inBucket = this.createFolder(-3, Messages.getString("GTDModel.InB"), Folder.FolderType.INBUCKET);
            this.inBucket.setDescription(Messages.getString("GTDModel.InB.desc"));
        }
        if (this.queue == null || !this.folders.containsKey(-4)) {
            this.queue = this.createFolder(-4, Messages.getString("GTDModel.Queue"), Folder.FolderType.QUEUE);
            this.queue.setDescription(Messages.getString("GTDModel.Queue.desc"));
        }
        if (this.priority == null || !this.folders.containsKey(-5)) {
            this.priority = this.createFolder(-5, Messages.getString("GTDModel.Priority"), Folder.FolderType.BUILDIN_PRIORITY);
            this.priority.setDescription(Messages.getString("GTDModel.Priority.desc"));
            this.priority.setComparator(new Comparator<Action>(){

                @Override
                public int compare(Action o1, Action o2) {
                    return -o1.getPriority().compareTo(o2.getPriority());
                }
            });
        }
        if (this.deleted == null || !this.folders.containsKey(-6)) {
            this.deleted = this.createFolder(-6, Messages.getString("GTDModel.Deleted"), Folder.FolderType.BUILDIN_DELETED);
            this.deleted.setDescription(Messages.getString("GTDModel.Deleted.desc"));
            this.deleted.setComparator(new Comparator<Action>(){

                @Override
                public int compare(Action o1, Action o2) {
                    return o1.getId() - o2.getId();
                }
            });
        }
    }

    public void addGTDModelListener(GTDModelListener l) {
        this.support.addlistener(l);
    }

    public void removeGTDModelListener(GTDModelListener l) {
        this.support.removelistener(l);
    }

    public synchronized Folder createFolder(String name, Folder.FolderType type) {
        return this.createFolder(++this.lastFolderID, name, type);
    }

    synchronized Folder createFolder(int id, String name, Folder.FolderType type) {
        Folder f = this.folders.get(id);
        if (f == null) {
            if (this.lastFolderID < id) {
                this.lastFolderID = id;
            }
            f = this.getDataRepository().newFolder(id, name, type);
            if (type == Folder.FolderType.PROJECT) {
                this.projects.put(id, (Project)f);
            }
            f.addFolderListener(this.support);
            this.folders.put(id, f);
            this.support.folderAdded(f);
            this.getDataRepository().store();
        }
        return f;
    }

    public synchronized void renameFolder(Folder f, String newName) {
        String o = f.getName();
        f.setName(newName);
        this.support.folderModified(f, "name", o, newName, false);
    }

    void fireFolderModified(Folder f, String p, Object o, Object n, boolean recycled) {
        this.support.folderModified(f, p, o, n, recycled);
    }

    public synchronized Folder removeFolder(int id) {
        Folder f = this.folders.remove(id);
        if (f != null) {
            f.removeFolderListener(this.support);
            this.support.folderRemoved(f);
        }
        return f;
    }

    @Override
    public Iterator<Folder> iterator() {
        return this.folders.values().iterator();
    }

    public Iterator<Object> iterator(ActionFilter filter) {
        return new TotalIterator(this.folders.values().iterator(), filter);
    }

    public int size() {
        return this.folders.size();
    }

    public Action getAction(int id) {
        for (Folder f : this) {
            Action a = f.getActionByID(id);
            if (a == null) continue;
            return a;
        }
        return null;
    }

    public boolean moveAction(Action action, Folder toFolder) {
        Folder f = action.getParent();
        GTDData.ActionProxy ap = this.getDataRepository().getProxy(action);
        if (f != null && toFolder != null && f != toFolder && !toFolder.contains(ap)) {
            toFolder.add(0, action, ap);
            f.remove(action, ap);
            return true;
        }
        return false;
    }

    public boolean moveActions(Action[] actions, Folder toFolder) {
        LinkedList<Action> a = new LinkedList<Action>(Arrays.asList(actions));
        LinkedList<Folder> f = new LinkedList<Folder>();
        ListIterator i = a.listIterator();
        while (i.hasNext()) {
            Action aa = (Action)i.next();
            Folder ff = aa.getParent();
            if (f == null || toFolder == null || ff == toFolder || toFolder.contains(aa.getProxy())) {
                i.remove();
                continue;
            }
            f.add(ff);
        }
        if (a.size() == 0) {
            return false;
        }
        toFolder.add(0, a.toArray(new Action[a.size()]));
        Iterator fi = f.iterator();
        for (Action aa : a) {
            ((Folder)fi.next()).remove(aa, aa.getProxy());
        }
        return true;
    }

    public synchronized Folder[] toFoldersArray() {
        return this.folders.values().toArray(new Folder[this.folders.size()]);
    }

    public synchronized Project[] toProjectsArray() {
        return this.projects.values().toArray(new Project[this.projects.size()]);
    }

    public synchronized void visit(Visitor v) {
        for (Folder f : this.folders.values()) {
            f.visit(v);
        }
    }

    public Project getProject(int id) {
        return this.projects.get(id);
    }

    public Folder getFolder(int id) {
        return this.folders.get(id);
    }

    public Folder getInBucketFolder() {
        return this.inBucket;
    }

    public Folder getResolvedFolder() {
        return this.resolved;
    }

    public Folder getDeletedFolder() {
        return this.deleted;
    }

    public void importData(GTDModel m) {
        this.getDataRepository().suspend(true);
        HashMap<Integer, Integer> folderMap = new HashMap<Integer, Integer>();
        HashMap<String, Folder> folderNames = new HashMap<String, Folder>();
        for (Folder f : this) {
            folderNames.put(f.getName() + "TYPE" + (Object)((Object)f.getType()), f);
        }
        Folder[] pp = m.toFoldersArray();
        for (Folder inP : pp) {
            if (inP.isBuildIn()) continue;
            Folder f = (Folder)folderNames.get(inP.getName() + "TYPE" + (Object)((Object)inP.getType()));
            if (f == null) {
                f = this.createFolder(inP.getName(), inP.getType());
                f.setDescription(inP.getDescription());
                f.setClosed(inP.isClosed());
            }
            folderMap.put(inP.getId(), f.getId());
        }
        for (Folder inF : m) {
            if (inF.isMeta()) continue;
            Folder f = this.getFolder((Integer)folderMap.get(inF.getId()));
            for (int i = inF.size() - 1; i > -1; --i) {
                Action inA = inF.get(i);
                this.createActionCopy(f, inA, (Integer)folderMap.get(inA.getProject()));
            }
        }
        this.getDataRepository().suspend(false);
    }

    public int getLastActionID() {
        return this.lastActionID;
    }

    public boolean isSuspendedForMultipleChanges() {
        return this.suspendedForMultipleChanges;
    }

    public void setSuspendedForMultipleChanges(boolean suspendedForMultipleChanges) {
        this.suspendedForMultipleChanges = suspendedForMultipleChanges;
        this.reminder.setSuspendedForMultipleChanges(suspendedForMultipleChanges);
        this.resolved.setSuspendedForMultipleChanges(suspendedForMultipleChanges);
        this.deleted.setSuspendedForMultipleChanges(suspendedForMultipleChanges);
        this.queue.setSuspendedForMultipleChanges(suspendedForMultipleChanges);
        this.priority.setSuspendedForMultipleChanges(suspendedForMultipleChanges);
    }

    public Folder getQueue() {
        return this.queue;
    }

    public Folder getRemindFolder() {
        return this.reminder;
    }

    public Folder getPriorityFolder() {
        return this.priority;
    }

    public void purgeDeletedActions() {
        HashSet<Action> actionsToRemove = new HashSet<Action>();
        HashSet<Folder> parentFolders = new HashSet<Folder>();
        for (Action a : this.deleted) {
            actionsToRemove.add(a);
            parentFolders.add(a.getParent());
        }
        for (Folder f : parentFolders) {
            for (int i = f.size() - 1; i >= 0; --i) {
                if (!actionsToRemove.contains(f.get(i))) continue;
                f.remove(i);
            }
        }
        this.deleted.purgeAll();
    }

    void setLastActionID(int i) {
        this.lastActionID = i;
    }

    public GTDData getDataRepository() {
        if (this.dataRepository == null) {
            this.dataRepository = new GTDDataDefault(this);
        }
        return this.dataRepository;
    }

    void reconnect() {
        ModelListenerSupport s = this.support;
        this.support = new ModelListenerSupport(this);
        for (Folder f : this) {
            if (s != null) {
                f.removeFolderListener(s);
            }
            f.addFolderListener(this.support);
            f.setParent(this);
        }
    }

    public Folder findFirstFolder(String name) {
        for (Folder f : this.folders.values()) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    public Project findFirstProject(String name) {
        for (Project f : this.projects.values()) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    public Action collectAction(String string) {
        Action a = this.createAction(this.inBucket, string);
        return a;
    }

    public void importXMLFile(File file) throws XMLStreamException, FactoryConfigurationError, IOException {
        GTDDataXMLTools.importFile(this, file);
    }

    public void exportXML(File f) throws IOException, XMLStreamException, FactoryConfigurationError {
        GTDDataXMLTools.store(this, f);
    }

    public void importXML(File f) throws XMLStreamException, IOException {
        GTDDataXMLTools.importFile(this, f);
    }

    static class ModelListenerSupport
    implements GTDModelListener {
        private EventListenerList listeners = new EventListenerList();
        private GTDModel model;

        public ModelListenerSupport(GTDModel model) {
            this.model = model;
        }

        public void addlistener(GTDModelListener l) {
            this.listeners.add(GTDModelListener.class, l);
        }

        public void removelistener(GTDModelListener l) {
            this.listeners.remove(GTDModelListener.class, l);
        }

        void checkEvent(ActionEvent e) {
            if (e.getNewValue() == e.getOldValue()) {
                throw new RuntimeException("Internal error, property not changed: " + e.toString());
            }
        }

        void updateMetaAdd(FolderEvent a) {
            ActionEvent.SortedElements se = a.getSortedElements();
            if (se.size(ActionEvent.SortedElements.ActionIndex.RESOLVED) > 0) {
                this.model.resolved.add(se.getActions(ActionEvent.SortedElements.ActionIndex.RESOLVED), se.getActionProxies(ActionEvent.SortedElements.ActionIndex.RESOLVED));
            }
            if (se.size(ActionEvent.SortedElements.ActionIndex.DELETED) > 0) {
                this.model.deleted.add(se.getActions(ActionEvent.SortedElements.ActionIndex.DELETED), se.getActionProxies(ActionEvent.SortedElements.ActionIndex.DELETED));
            }
            if (se.size(ActionEvent.SortedElements.ActionIndex.REMINDER) > 0) {
                this.model.reminder.add(se.getActions(ActionEvent.SortedElements.ActionIndex.REMINDER), se.getActionProxies(ActionEvent.SortedElements.ActionIndex.REMINDER));
            }
            if (se.size(ActionEvent.SortedElements.ActionIndex.PRIORITY) > 0) {
                this.model.priority.add(se.getActions(ActionEvent.SortedElements.ActionIndex.PRIORITY), se.getActionProxies(ActionEvent.SortedElements.ActionIndex.PRIORITY));
            }
            if (se.size(ActionEvent.SortedElements.ActionIndex.QUEUE) > 0 && !this.model.suspendedForMultipleChanges) {
                this.model.queue.add(se.getActions(ActionEvent.SortedElements.ActionIndex.QUEUE), se.getActionProxies(ActionEvent.SortedElements.ActionIndex.QUEUE));
            }
            if (se.size(ActionEvent.SortedElements.ActionIndex.PROJECT) > 0) {
                Action[] aac = se.getActions(ActionEvent.SortedElements.ActionIndex.PROJECT);
                GTDData.ActionProxy[] aap = se.getActionProxies(ActionEvent.SortedElements.ActionIndex.PROJECT);
                for (int j = 0; j < aac.length; ++j) {
                    if (this.getProject(aac[j].getProject()) == null) continue;
                    this.getProject(aac[j].getProject()).add(aac[j], aap[j]);
                }
            }
        }

        private Project getProject(Integer project) {
            return (Project)this.model.projects.get(project);
        }

        void updateMetaRemove(FolderEvent a) {
            if (a.getFolder() == this.model.deleted) {
                this.model.removeDeleted(a.getSortedElements());
            }
        }

        void updateMetaModify(ActionEvent a) {
            ActionEvent.SortedElements se = a.getSortedElements();
            if (a.getProperty().equals("resolution")) {
                this.model.resolved.add(se.getActions(ActionEvent.SortedElements.ActionIndex.RESOLVED), se.getActionProxies(ActionEvent.SortedElements.ActionIndex.RESOLVED));
                this.model.resolved.remove(se.getActionsInv(ActionEvent.SortedElements.ActionIndex.RESOLVED), se.getActionProxiesInv(ActionEvent.SortedElements.ActionIndex.RESOLVED));
                this.model.deleted.add(se.getActions(ActionEvent.SortedElements.ActionIndex.DELETED), se.getActionProxies(ActionEvent.SortedElements.ActionIndex.DELETED));
                this.model.deleted.remove(se.getActionsInv(ActionEvent.SortedElements.ActionIndex.DELETED), se.getActionProxiesInv(ActionEvent.SortedElements.ActionIndex.DELETED));
            }
            if (a.getProperty().equals("remind")) {
                this.model.reminder.add(se.getActions(ActionEvent.SortedElements.ActionIndex.REMINDER), se.getActionProxies(ActionEvent.SortedElements.ActionIndex.REMINDER));
                this.model.reminder.remove(se.getActionsInv(ActionEvent.SortedElements.ActionIndex.REMINDER), se.getActionProxiesInv(ActionEvent.SortedElements.ActionIndex.REMINDER));
            }
            if (a.getProperty().equals("priority")) {
                this.model.priority.add(se.getActions(ActionEvent.SortedElements.ActionIndex.PRIORITY), se.getActionProxies(ActionEvent.SortedElements.ActionIndex.PRIORITY));
                this.model.priority.remove(se.getActionsInv(ActionEvent.SortedElements.ActionIndex.PRIORITY), se.getActionProxiesInv(ActionEvent.SortedElements.ActionIndex.PRIORITY));
            }
            if (a.getProperty().equals("queued") && !this.model.suspendedForMultipleChanges) {
                this.model.queue.add(se.getActions(ActionEvent.SortedElements.ActionIndex.QUEUE), se.getActionProxies(ActionEvent.SortedElements.ActionIndex.QUEUE));
                this.model.queue.remove(se.getActionsInv(ActionEvent.SortedElements.ActionIndex.QUEUE), se.getActionProxiesInv(ActionEvent.SortedElements.ActionIndex.QUEUE));
            }
            if (a.getProperty().equals("project")) {
                if (a.getOldValue() != null) {
                    this.getProject((Integer)a.getOldValue()).remove(se.getActions(), se.getActionProxies());
                }
                if (a.getNewValue() != null) {
                    this.getProject((Integer)a.getNewValue()).add(se.getActions(), se.getActionProxies());
                }
            }
        }

        @Override
        public void elementAdded(FolderEvent a) {
            this.updateMetaAdd(a);
            GTDModelListener[] l = (GTDModelListener[])this.listeners.getListeners(GTDModelListener.class);
            for (int i = 0; i < l.length; ++i) {
                try {
                    l[i].elementAdded(a);
                    continue;
                }
                catch (Exception e) {
                    org.apache.log4j.Logger.getLogger(this.getClass()).debug("Internal error.", e);
                }
            }
        }

        @Override
        public void elementModified(ActionEvent a) {
            this.checkEvent(a);
            if (!((Folder)a.getSource()).isMeta()) {
                this.updateMetaModify(a);
                this.model.queue.fireElementModified(a.getSortedElements().getActions(ActionEvent.SortedElements.ActionIndex.QUEUE), a.getSortedElements().getActionProxies(ActionEvent.SortedElements.ActionIndex.QUEUE), a.getProperty(), a.getOldValue(), a.getNewValue(), true);
                this.model.reminder.fireElementModified(a.getSortedElements().getActions(ActionEvent.SortedElements.ActionIndex.REMINDER), a.getSortedElements().getActionProxies(ActionEvent.SortedElements.ActionIndex.REMINDER), a.getProperty(), a.getOldValue(), a.getNewValue(), true);
                this.model.priority.fireElementModified(a.getSortedElements().getActions(ActionEvent.SortedElements.ActionIndex.PRIORITY), a.getSortedElements().getActionProxies(ActionEvent.SortedElements.ActionIndex.PRIORITY), a.getProperty(), a.getOldValue(), a.getNewValue(), true);
                Action[] aac = a.getSortedElements().getActions(ActionEvent.SortedElements.ActionIndex.PROJECT);
                GTDData.ActionProxy[] aap = a.getSortedElements().getActionProxies(ActionEvent.SortedElements.ActionIndex.PROJECT);
                for (int j = 0; j < aac.length; ++j) {
                    Project p = this.getProject(aac[j].getProject());
                    if (p == null) continue;
                    p.fireElementModified(aac[j], aap[j], a.getProperty(), a.getOldValue(), a.getNewValue(), true);
                }
            }
            GTDModelListener[] l = (GTDModelListener[])this.listeners.getListeners(GTDModelListener.class);
            for (int i = 0; i < l.length; ++i) {
                try {
                    l[i].elementModified(a);
                    continue;
                }
                catch (Exception e) {
                    org.apache.log4j.Logger.getLogger(this.getClass()).debug("Internal error.", e);
                }
            }
        }

        @Override
        public void elementRemoved(FolderEvent a) {
            this.updateMetaRemove(a);
            GTDModelListener[] l = (GTDModelListener[])this.listeners.getListeners(GTDModelListener.class);
            for (int i = 0; i < l.length; ++i) {
                try {
                    l[i].elementRemoved(a);
                    continue;
                }
                catch (Exception e) {
                    org.apache.log4j.Logger.getLogger(this.getClass()).debug("Internal error.", e);
                }
            }
        }

        @Override
        public void folderAdded(Folder folder) {
            GTDModelListener[] l = (GTDModelListener[])this.listeners.getListeners(GTDModelListener.class);
            for (int i = 0; i < l.length; ++i) {
                try {
                    l[i].folderAdded(folder);
                    continue;
                }
                catch (Exception e) {
                    org.apache.log4j.Logger.getLogger(this.getClass()).debug("Internal error.", e);
                }
            }
        }

        public void folderModified(Folder f, String p, Object o, Object n, boolean recycled) {
            this.folderModified(new FolderEvent(f, (Action[])null, (GTDData.ActionProxy[])null, p, o, n, recycled));
        }

        @Override
        public void folderModified(FolderEvent folder) {
            GTDModelListener[] l = (GTDModelListener[])this.listeners.getListeners(GTDModelListener.class);
            for (int i = 0; i < l.length; ++i) {
                try {
                    l[i].folderModified(folder);
                    continue;
                }
                catch (Exception e) {
                    org.apache.log4j.Logger.getLogger(this.getClass()).debug("Internal error.", e);
                }
            }
        }

        @Override
        public void folderRemoved(Folder folder) {
            GTDModelListener[] l = (GTDModelListener[])this.listeners.getListeners(GTDModelListener.class);
            for (int i = 0; i < l.length; ++i) {
                try {
                    l[i].folderRemoved(folder);
                    continue;
                }
                catch (Exception e) {
                    org.apache.log4j.Logger.getLogger(this.getClass()).debug("Internal error.", e);
                }
            }
        }

        @Override
        public void orderChanged(Folder f) {
            GTDModelListener[] l = (GTDModelListener[])this.listeners.getListeners(GTDModelListener.class);
            for (int i = 0; i < l.length; ++i) {
                try {
                    l[i].orderChanged(f);
                    continue;
                }
                catch (Exception e) {
                    org.apache.log4j.Logger.getLogger(this.getClass()).debug("Internal error.", e);
                }
            }
        }
    }

    public static class TotalIterator
    implements Iterator<Object> {
        private Iterator<Folder> folders;
        private Iterator<Action> actions;
        private Folder folder;
        private Action action;
        private ActionFilter filter;
        private boolean folderConsumed = false;

        public TotalIterator(Iterator<Folder> i, ActionFilter f) {
            this.folders = i;
            this.filter = f;
        }

        @Override
        public boolean hasNext() {
            if (this.folder == null) {
                if (!this.folders.hasNext()) {
                    return false;
                }
                this.folder = this.folders.next();
                if (!this.filter.isAcceptable(this.folder, null)) {
                    this.folder = null;
                    return this.hasNext();
                }
                this.folderConsumed = false;
                return true;
            }
            if (this.actions == null) {
                this.actions = this.folder.iterator();
            }
            if (this.action != null) {
                return true;
            }
            boolean b = this.actions.hasNext();
            if (b) {
                this.action = this.actions.next();
                if (!this.filter.isAcceptable(this.folder, this.action)) {
                    this.action = null;
                    return this.hasNext();
                }
                return true;
            }
            if (!b) {
                this.folder = null;
                this.actions = null;
                return this.hasNext();
            }
            return b;
        }

        @Override
        public Object next() {
            if (!this.hasNext()) {
                return null;
            }
            if (!this.folderConsumed) {
                this.folderConsumed = true;
                return this.folder;
            }
            Action a = this.action;
            this.action = null;
            return a;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

