/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.model;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.gtdfree.GlobalProperties;
import org.gtdfree.Messages;
import org.gtdfree.model.Action;
import org.gtdfree.model.ConsistencyException;
import org.gtdfree.model.Folder;
import org.gtdfree.model.GTDData;
import org.gtdfree.model.GTDModel;
import org.gtdfree.model.Project;
import org.neodatis.odb.ODB;
import org.neodatis.odb.ODBFactory;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.Objects;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.core.oid.OIDFactory;
import org.neodatis.odb.core.trigger.SelectTrigger;
import org.neodatis.odb.xml.XMLExporter;
import org.neodatis.odb.xml.XMLImporter;

public final class GTDDataODB
implements GTDData {
    private static final boolean debug = false;
    public static final String BACKUP_EXPORT_FILE_NAME = "odb-backup.odb-xml";
    private File file;
    private ODB odb;
    private GTDModel model;
    private boolean suspend = false;
    private boolean exportOnClose = true;
    private transient boolean closed = false;
    private org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger(GTDDataODB.class);

    public static boolean isUsed(GTDModel m) {
        return m.getDataRepository() instanceof GTDDataODB;
    }

    public boolean isExportOnClose() {
        return this.exportOnClose;
    }

    public void setExportOnClose(boolean exportOnClose) {
        this.exportOnClose = exportOnClose;
    }

    public GTDDataODB() {
    }

    public GTDDataODB(File f, GlobalProperties gp) {
        this.initialize(f, gp);
    }

    public GTDDataODB(File f) {
        this.initialize(f, new GlobalProperties());
    }

    public ODB getODB() {
        if (this.odb == null && !this.closed) {
            OdbConfiguration.setThrowExceptionWhenInconsistencyFound(true);
            OdbConfiguration.setAutomaticCloseFileOnExit(true);
            OdbConfiguration.setUseLazyCache(false);
            OdbConfiguration.setReconnectObjectsToSession(true);
            try {
                OdbConfiguration.setDatabaseCharacterEncoding("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                org.apache.log4j.Logger.getLogger(this.getClass()).error("Database error.", e);
            }
            this.odb = ODBFactory.open(this.file.getAbsolutePath());
            this.odb.addSelectTrigger(Folder.class, new SelectTrigger(){

                @Override
                public void afterSelect(Object object, OID oid) {
                    Folder f = (Folder)GTDDataODB.this.odb.getObjectFromId(oid);
                    ((FolderDataODB)f.getData()).connect(f, GTDDataODB.this.getODB());
                }
            });
            this.odb.addSelectTrigger(Project.class, new SelectTrigger(){

                @Override
                public void afterSelect(Object object, OID oid) {
                    Folder f = (Folder)GTDDataODB.this.odb.getObjectFromId(oid);
                    ((FolderDataODB)f.getData()).connect(f, GTDDataODB.this.getODB());
                }
            });
        }
        return this.odb;
    }

    @Override
    public GTDData.ActionProxy getProxy(Action a) {
        if (a.getProxy() != null && a.getProxy() instanceof ActionProxyODB && ((ActionProxyODB)a.getProxy()).get() == a) {
            return a.getProxy();
        }
        return new ActionProxyODB(a, this.getODB());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store() {
        if (this.closed) {
            return;
        }
        ODB oDB = this.getODB();
        synchronized (oDB) {
            long time = System.currentTimeMillis();
            this.getODB().store(this.model);
            this.commit();
        }
    }

    @Override
    public boolean close(boolean terminal) throws IOException {
        if (!this.closed) {
            this.close(true, true);
            this.closed = true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean close(boolean store, boolean doExport) throws IOException {
        if (store) {
            this.store();
        }
        if (this.exportOnClose && doExport && !this.closed) {
            long time = System.currentTimeMillis();
            try {
                File f = this.getShutdownBackupFile();
                this._exportODB(f);
                this.logger.info(Messages.getString("GTDDataODB.Backup") + f.toString());
            }
            catch (Exception e) {
                org.apache.log4j.Logger.getLogger(this.getClass()).error("Database error.", e);
            }
        }
        if (!this.closed && this.odb != null) {
            ODB oDB = this.getODB();
            synchronized (oDB) {
                long time = System.currentTimeMillis();
                this.getODB().close();
            }
        }
        return true;
    }

    public File getShutdownBackupFile() {
        return new File(this.file.getParent(), BACKUP_EXPORT_FILE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        ODB oDB = this.getODB();
        synchronized (oDB) {
            long time = System.currentTimeMillis();
            this.getODB().store(this.model);
            this.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit() {
        ODB oDB = this.getODB();
        synchronized (oDB) {
            long time = System.currentTimeMillis();
            this.getODB().commit();
        }
    }

    @Override
    public GTDModel restore() throws IOException {
        if (this.model != null) {
            return this.model;
        }
        try {
            DBInfo info;
            Objects o = this.getODB().getObjects(DBInfo.class);
            DBInfo dBInfo = info = o.hasNext() ? (DBInfo)o.next() : null;
            if (info == null) {
                info = new DBInfo("1.0", GTDModel.class.getName());
                this.getODB().store(info);
                this.getODB().commit();
            }
            Class<Object> c = null;
            try {
                c = Class.forName(info.modelImpl);
            }
            catch (ClassNotFoundException e) {
                org.apache.log4j.Logger.getLogger(this.getClass()).debug("Internal error.", e);
                c = GTDModel.class;
            }
            long time = System.currentTimeMillis();
            Objects om = this.getODB().getObjects(c);
            GTDModel gTDModel = this.model = om.hasNext() ? (GTDModel)om.next() : null;
            if (this.model == null) {
                this.model = (GTDModel)c.newInstance();
                this.getODB().store(this.model);
                this.getODB().commit();
            }
            this.model.initialize(this);
            this.model.reconnect();
        }
        catch (Throwable e) {
            org.apache.log4j.Logger.getLogger(this.getClass()).fatal("Initialization error, closing.", e);
            JOptionPane.showMessageDialog(null, Messages.getString("GTDDataODB.Fail.1") + " '" + this.file.toString() + "'\n" + Messages.getString("GTDDataODB.Fail.2") + " \n\n\"" + e.toString() + "\".\n\n" + Messages.getString("GTDDataODB.Fail.3") + " '" + this.file.getParent() + "':\n " + Messages.getString("GTDDataODB.Fail.4") + " '" + this.file.getName() + "' " + Messages.getString("GTDDataODB.Fail.5") + " '" + BACKUP_EXPORT_FILE_NAME + "'.", Messages.getString("GTDDataODB.Fail.title"), 0);
            try {
                this.close(false, false);
            }
            catch (Exception ex) {
                org.apache.log4j.Logger.getLogger(this.getClass()).error("Initialization error.", ex);
            }
            throw new IOException(e);
        }
        return this.model;
    }

    @Override
    public void initialize(File f, GlobalProperties gp) {
        if (f == null) {
            return;
        }
        if (f.exists() && f.isFile() || f.getName().toLowerCase().endsWith(".odb")) {
            this.file = f;
        } else {
            this.file = new File(f, "odb");
            if (!this.file.exists()) {
                this.file.mkdir();
            }
            this.file = new File(this.file, "gtd-free.odb");
        }
        this.setExportOnClose(gp.getBoolean("shutdownBackupODB", true));
    }

    @Override
    public GTDData.ActionProxy newAction(int id, Date created, Date resolved, String description) {
        Action a = new Action(id, created, resolved, description);
        GTDData.ActionProxy ap = this.getProxy(a);
        this.store();
        return ap;
    }

    @Override
    public GTDData.ActionProxy newAction(int id, Action aa, Integer project) {
        Action a = new Action(id, aa.getCreated(), aa.getResolved(), aa.getDescription());
        a.copy(aa);
        a.setProject(project);
        GTDData.ActionProxy ap = this.getProxy(a);
        this.store();
        return ap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Folder newFolder(int id, String name, Folder.FolderType type) {
        Folder f = null;
        FolderDataODB fd = new FolderDataODB();
        f = type == Folder.FolderType.PROJECT ? new Project(this.model, id, name, fd) : new Folder(this.model, id, name, type, fd);
        fd.connect(f, this.getODB());
        fd.setModified(new Date());
        ODB oDB = this.getODB();
        synchronized (oDB) {
            long time = System.currentTimeMillis();
            fd.store();
            this.getODB().store(this.model);
            this.commit();
        }
        return f;
    }

    @Override
    public void suspend(boolean b) {
        this.suspend = b;
        if (!this.suspend) {
            this.store();
        }
    }

    @Override
    public void checkConsistency(Logger log, boolean fail, boolean correct) throws ConsistencyException {
        ActionProxyODB ap;
        Iterator<GTDData.ActionProxy> it;
        ArrayList<ActionProxyODB> a;
        ConsistencyException e;
        OID oid;
        HashSet<OID> oids = new HashSet<OID>();
        ODB odb = this.getODB();
        HashMap<String, Folder> folderNames = new HashMap<String, Folder>();
        HashMap<OID, OID> del2new = new HashMap<OID, OID>();
        for (Folder f : this.model) {
            oids.add(odb.getObjectId(f));
            folderNames.put(f.getName() + "TYPE" + (Object)((Object)f.getType()), f);
            if (f.isMeta()) continue;
            Iterator<GTDData.ActionProxy> i = f.proxyIterator(Folder.FolderPreset.ALL);
            while (i.hasNext()) {
                ActionProxyODB a2 = (ActionProxyODB)i.next();
                oids.add(a2.getOid());
                oids.add(odb.getObjectId(a2));
            }
        }
        Objects of = odb.getObjects(Folder.class);
        Objects op = odb.getObjects(Project.class);
        ArrayList ff = new ArrayList(of.size() + op.size());
        ff.addAll(of);
        ff.addAll(op);
        for (Folder f : ff) {
            if (f.isMeta() || oids.contains(oid = odb.getObjectId(f))) continue;
            e = new ConsistencyException("Folder not in model.", null, new Folder[]{f}, null);
            if (fail) {
                throw e;
            }
            log.log(Level.WARNING, "Folder '" + f.getName() + "' not in model.", e);
            if (!correct) continue;
            a = new ArrayList<ActionProxyODB>(f.size());
            it = f.proxyIterator(Folder.FolderPreset.ALL);
            while (it.hasNext()) {
                ap = (ActionProxyODB)it.next();
                if (oids.contains(ap.getOid())) continue;
                a.add(ap);
            }
            f.clear();
            Folder f1 = (Folder)folderNames.get(f.getName() + "TYPE" + (Object)((Object)f.getType()));
            if (f1 == null) {
                f1 = this.model.createFolder(f.getName(), f.getType());
                f1.setDescription(f.getDescription());
                log.log(Level.INFO, "Created folder  '" + f.getName() + "' in model.");
            } else {
                log.log(Level.INFO, "Found folder  '" + f.getName() + "' in model.");
            }
            for (ActionProxyODB ap2 : a) {
                OID apoid;
                Action aa = ap2.get();
                if (aa == null) continue;
                Action aaa = this.model.createActionCopy(f1, aa, aa.getProject() != null && this.model.getProject(aa.getProject()) == null ? aa.getProject() : null);
                ActionProxyODB aap = (ActionProxyODB)this.getProxy(aaa);
                oids.add(aap.getOid());
                OID aapoid = odb.getObjectId(aap);
                oids.add(aapoid);
                if (!del2new.containsKey(ap2.getOid())) {
                    try {
                        odb.delete(aa);
                    }
                    catch (Exception e2) {
                        System.out.println(e2.getMessage());
                    }
                    del2new.put(ap2.getOid(), aap.getOid());
                }
                if (!del2new.containsKey(apoid = odb.getObjectId(ap2))) {
                    try {
                        odb.delete(ap2);
                    }
                    catch (Exception e2) {
                        System.out.println(e2.getMessage());
                    }
                    del2new.put(apoid, aapoid);
                }
                log.log(Level.INFO, "Added action with ID '" + aaa.getId() + "' to folder  '" + f1.getName() + "'.");
            }
            oids.add(odb.getObjectId(f1));
            odb.deleteObjectWithId(oid);
        }
        for (Folder f : ff) {
            if (f.isMeta() && !oids.contains(oid = odb.getObjectId(f))) {
                e = new ConsistencyException("Folder not in model.", null, new Folder[]{f}, null);
                if (fail) {
                    throw e;
                }
                log.log(Level.WARNING, "Folder '" + f.getName() + "' not in model.", e);
                if (correct) {
                    a = new ArrayList(f.size());
                    it = f.proxyIterator(Folder.FolderPreset.ALL);
                    while (it.hasNext()) {
                        ap = (ActionProxyODB)it.next();
                        if (oids.contains(ap.getOid())) continue;
                        a.add(ap);
                    }
                    f.clear();
                    Project p = null;
                    if (f.isProject() && (p = this.model.findFirstProject(f.getName())) == null) {
                        p = (Project)this.model.createFolder(f.getName(), Folder.FolderType.PROJECT);
                        p.setDescription(f.getDescription());
                        p.setClosed(f.isClosed());
                    }
                    Folder f1 = this.model.getInBucketFolder();
                    for (ActionProxyODB ap3 : a) {
                        OID apoid;
                        Action aa;
                        if (del2new.containsKey(ap3.getOid()) || (aa = ap3.get()) == null) continue;
                        Action aaa = this.model.createActionCopy(f1, aa, p != null ? Integer.valueOf(p.getId()) : null);
                        ActionProxyODB aap = (ActionProxyODB)this.getProxy(aaa);
                        oids.add(aap.getOid());
                        OID aapoid = odb.getObjectId(aap);
                        oids.add(aapoid);
                        if (!del2new.containsKey(ap3.getOid())) {
                            try {
                                odb.delete(aa);
                            }
                            catch (Exception e2) {
                                System.out.println(e2.getMessage());
                            }
                            del2new.put(ap3.getOid(), aap.getOid());
                        }
                        if (!del2new.containsKey(apoid = odb.getObjectId(ap3))) {
                            try {
                                odb.delete(ap3);
                            }
                            catch (Exception e2) {
                                System.out.println(e2.getMessage());
                            }
                            del2new.put(apoid, aapoid);
                        }
                        log.log(Level.INFO, "Added action with ID '" + aaa.getId() + "' to folder  '" + f1.getName() + "'.");
                    }
                    odb.deleteObjectWithId(oid);
                }
            }
            odb.commit();
        }
        Objects oa = odb.getObjects(Action.class);
        for (Action a3 : oa) {
            OID oid2 = odb.getObjectId(a3);
            if (oids.contains(oid2)) continue;
            ActionProxyODB ap4 = (ActionProxyODB)this.getProxy(a3);
            Folder f = ap4.getParent();
            if (f == null || this.model.getFolder(f.getId()) != f) {
                f = this.model.getInBucketFolder();
            }
            f.add(a3, ap4);
            oids.add(oid2);
            oids.add(odb.getObjectId(ap4));
        }
    }

    @Override
    public String getDatabaseType() {
        return "ODB";
    }

    public void exportODB(File f) throws Exception {
        this.store();
        this.flush();
        this._exportODB(f);
        this.close(false, false);
        this.odb = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _exportODB(File f) throws Exception {
        f.delete();
        ODB oDB = this.getODB();
        synchronized (oDB) {
            XMLExporter xml = new XMLExporter(this.getODB());
            xml.export(f.getParent(), f.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importODB(File f) throws Exception {
        this.close(true, true);
        ODB oDB = this.getODB();
        synchronized (oDB) {
            this.odb = null;
        }
        oDB = this.getODB();
        synchronized (oDB) {
            XMLImporter xml = new XMLImporter(this.getODB());
            xml.importFile(f.getParent(), f.getName());
        }
        this.close(false, false);
        this.odb = null;
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    static class DBInfo {
        public String version;
        public String modelImpl;

        public DBInfo() {
        }

        public DBInfo(String v, String c) {
            this.version = v;
            this.modelImpl = c;
        }
    }

    public static class FolderDataODB
    implements GTDData.FolderDataProxy {
        private transient WeakReference<Data> dataRef;
        private transient ODB odb;
        private transient Folder folder;
        private transient Set<Object> references = new HashSet<Object>();
        private transient OID dataOID;
        private long _dataOID;
        private Integer folderID;
        private boolean suspend;
        private int size;

        private OID getDataOID() {
            if (this.dataOID == null && this._dataOID != 0L) {
                this.dataOID = OIDFactory.buildObjectOID(this._dataOID);
            }
            return this.dataOID;
        }

        private Data getDataFromRef() {
            Data d = null;
            if (this.dataRef != null) {
                d = (Data)this.dataRef.get();
            }
            return d;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Data getData() {
            long time;
            ODB oDB;
            Data d = this.getDataFromRef();
            if (d != null) {
                return d;
            }
            if (this.getDataOID() != null) {
                oDB = this.odb;
                synchronized (oDB) {
                    time = System.currentTimeMillis();
                    try {
                        d = (Data)this.odb.getObjectFromId(this.getDataOID());
                    }
                    catch (Exception e) {
                        org.apache.log4j.Logger.getLogger(this.getClass()).error("Database error.", e);
                    }
                }
            }
            if (d != null) {
                this.dataRef = new WeakReference<Data>(d);
                return d;
            }
            oDB = this.odb;
            synchronized (oDB) {
                d = new Data();
                this.dataRef = new WeakReference<Data>(d);
                time = System.currentTimeMillis();
                this.dataOID = this.odb.store(d);
                this._dataOID = this.dataOID.getObjectId();
                this.odb.store(this);
                this.commit();
            }
            return d;
        }

        public void connect(Folder folder, ODB odb) {
            this.folderID = folder.getId();
            this.folder = folder;
            this.odb = odb;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void delete() {
            if (this.getDataOID() == null) {
                return;
            }
            ODB oDB = this.odb;
            synchronized (oDB) {
                try {
                    this.odb.delete(this);
                }
                catch (Exception e) {
                    org.apache.log4j.Logger.getLogger(this.getClass()).debug("Database error.", e);
                }
                try {
                    this.odb.deleteObjectWithId(this.getDataOID());
                }
                catch (Exception e) {
                    org.apache.log4j.Logger.getLogger(this.getClass()).debug("Database error.", e);
                }
                this._dataOID = 0L;
                this.dataOID = null;
            }
        }

        @Override
        public String getDescription() {
            return this.getData().description;
        }

        @Override
        public void setDescription(String desc) {
            Data d = this.getData();
            d.description = desc;
            this.modified(d);
            if (this.suspend) {
                this.references.add(d);
            } else {
                this.store();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void store() {
            if (this.suspend) {
                Data d = this.getDataFromRef();
                if (d != null) {
                    this.references.add(d);
                }
                return;
            }
            ODB oDB = this.odb;
            synchronized (oDB) {
                long time = System.currentTimeMillis();
                if (this.folder != null) {
                    this.odb.store(this.folder);
                } else {
                    this.odb.store(this);
                }
                Data d = this.getDataFromRef();
                if (d != null) {
                    this.odb.store(d);
                    if (this._dataOID == 0L) {
                        this.dataOID = this.odb.getObjectId(d);
                        this._dataOID = this.dataOID.getObjectId();
                    }
                }
                this.commit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void commit() {
            ODB oDB = this.odb;
            synchronized (oDB) {
                long time = System.currentTimeMillis();
                this.odb.commit();
            }
        }

        @Override
        public boolean contains(GTDData.ActionProxy ap) {
            Data d = this.getData();
            if (d != null) {
                return d.actions.contains(ap);
            }
            return false;
        }

        @Override
        public GTDData.ActionProxy get(int i) {
            Data d = this.getData();
            if (d != null) {
                ActionProxyODB ap = d.actions.get(i);
                ap.connect(this.odb, this.folder);
                return ap;
            }
            return null;
        }

        @Override
        public int size() {
            Data d = this.getDataFromRef();
            if (d != null) {
                this.size = d.actions.size();
                return this.size;
            }
            return this.size;
        }

        @Override
        public Iterator<GTDData.ActionProxy> iterator(Folder.FolderPreset fp) {
            Data d = this.getData();
            if (d != null) {
                if (fp == Folder.FolderPreset.OPEN) {
                    return new Iterator<GTDData.ActionProxy>(){
                        Iterator<ActionProxyODB> i;
                        ActionProxyODB next;
                        {
                            this.i = ((FolderDataODB)FolderDataODB.this).getData().actions.iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            if (this.next == null) {
                                this.next = this._next();
                                if (this.next == null) {
                                    return false;
                                }
                            }
                            return true;
                        }

                        public ActionProxyODB _next() {
                            if (this.i.hasNext()) {
                                ActionProxyODB ap = this.i.next();
                                if (!ap.isOpen()) {
                                    return this._next();
                                }
                                return ap;
                            }
                            return null;
                        }

                        @Override
                        public GTDData.ActionProxy next() {
                            if (!this.hasNext()) {
                                return null;
                            }
                            ActionProxyODB ap = this.next;
                            this.next = null;
                            ap.connect(FolderDataODB.this.odb, FolderDataODB.this.folder);
                            return ap;
                        }

                        @Override
                        public void remove() {
                        }
                    };
                }
                return new Iterator<GTDData.ActionProxy>(){
                    Iterator<ActionProxyODB> i;
                    {
                        this.i = ((FolderDataODB)FolderDataODB.this).getData().actions.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public GTDData.ActionProxy next() {
                        ActionProxyODB ap = this.i.next();
                        ap.connect(FolderDataODB.this.odb, FolderDataODB.this.folder);
                        return ap;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
            return new Iterator<GTDData.ActionProxy>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public GTDData.ActionProxy next() {
                    return null;
                }

                @Override
                public void remove() {
                }
            };
        }

        @Override
        public void add(GTDData.ActionProxy ap) {
            Data d = this.getData();
            ActionProxyODB apo = (ActionProxyODB)ap;
            d.actions.add(apo);
            this.modified(d);
            if (!this.folder.isMeta()) {
                apo.connect(this.odb, this.folder);
            }
            this.size = d.actions.size();
            if (this.suspend) {
                this.references.add(d);
                this.references.add(ap);
            } else {
                this.store();
            }
        }

        @Override
        public void add(int i, GTDData.ActionProxy ap) {
            Data d = this.getData();
            ActionProxyODB apo = (ActionProxyODB)ap;
            d.actions.add(i, apo);
            this.modified(d);
            if (!this.folder.isMeta()) {
                apo.connect(this.odb, this.folder);
            }
            this.size = d.actions.size();
            if (this.suspend) {
                this.references.add(d);
                this.references.add(ap);
            } else {
                this.store();
            }
        }

        @Override
        public void clear() {
            Data d = this.getData();
            d.actions.clear();
            this.modified(d);
            if (this.suspend) {
                this.references.add(d);
            } else {
                this.store();
            }
        }

        @Override
        public boolean remove(GTDData.ActionProxy i) {
            Data d = this.getData();
            boolean b = d.actions.remove(i);
            this.modified(d);
            if (b) {
                this.size = d.actions.size();
                if (this.suspend) {
                    this.references.add(d);
                } else {
                    this.store();
                }
            }
            return b;
        }

        @Override
        public boolean remove(int i) {
            Data d = this.getData();
            boolean b = d.actions.remove(i) != null;
            this.modified(d);
            if (b) {
                this.size = d.actions.size();
                if (this.suspend) {
                    this.references.add(d);
                } else {
                    this.store();
                }
            }
            return b;
        }

        @Override
        public void set(int i, GTDData.ActionProxy ap) {
            Data d = this.getData();
            d.actions.set(i, (ActionProxyODB)ap);
            this.size = d.actions.size();
            if (this.suspend) {
                this.references.add(d);
                this.references.add(ap);
            } else {
                this.store();
            }
        }

        @Override
        public void sort(Comparator<Action> comparator) {
            Data d = this.getData();
            Collections.sort(d.actions, new ProxyComparator(comparator));
            this.modified(d);
            if (this.suspend) {
                this.references.add(d);
            } else {
                this.store();
            }
        }

        @Override
        public GTDData.ActionProxy[] toArray() {
            Data d = this.getData();
            Iterator<ActionProxyODB> it = d.actions.iterator();
            GTDData.ActionProxy[] a = new GTDData.ActionProxy[d.actions.size()];
            for (int i = 0; i < a.length; ++i) {
                ActionProxyODB ap = it.next();
                ap.connect(this.odb, this.folder);
                a[i] = ap;
            }
            return a;
        }

        @Override
        public void suspend(boolean b) {
            this.suspend = b;
            if (!b) {
                this.store();
                this.references.clear();
            }
        }

        @Override
        public Date getCreated() {
            return this.getData().created;
        }

        @Override
        public Date getModified() {
            return this.getData().modified;
        }

        @Override
        public Date getResolved() {
            return this.getData().resolved;
        }

        @Override
        public void setCreated(Date d) {
            Data dd = this.getData();
            dd.created = d;
            if (this.suspend) {
                this.references.add(dd);
            } else {
                this.store();
            }
        }

        @Override
        public void setModified(Date d) {
            Data dd = this.getData();
            dd.modified = d;
            if (this.suspend) {
                this.references.add(dd);
            } else {
                this.store();
            }
        }

        @Override
        public void setResolved(Date d) {
            Data dd = this.getData();
            dd.resolved = d;
            if (this.suspend) {
                this.references.add(dd);
            } else {
                this.store();
            }
        }

        public void modified(Data d) {
            d.modified = new Date();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(128);
            sb.append("FD{");
            sb.append(this.folderID);
            sb.append(',');
            sb.append(this.size);
            sb.append(',');
            sb.append(Arrays.toString(this.getDataFromRef().actions.toArray()));
            sb.append('}');
            return sb.toString();
        }

        @Override
        public void reorder(Action[] order) {
            int i;
            boolean s = this.suspend;
            if (s) {
                this.suspend(false);
            }
            Data d = this.getData();
            for (i = 0; i < order.length; ++i) {
                d.actions.remove(order[i].getProxy());
            }
            for (i = 0; i < order.length; ++i) {
                if (d.actions.size() > i) {
                    d.actions.set(i, (ActionProxyODB)order[i].getProxy());
                    continue;
                }
                d.actions.add((ActionProxyODB)order[i].getProxy());
            }
            if (s) {
                this.suspend(true);
            }
        }

        private class ProxyComparator
        implements Comparator<ActionProxyODB> {
            Comparator<Action> c;

            public ProxyComparator(Comparator<Action> c) {
                this.c = c;
            }

            @Override
            public int compare(ActionProxyODB o1, ActionProxyODB o2) {
                o1.connect(FolderDataODB.this.odb, FolderDataODB.this.folder);
                o2.connect(FolderDataODB.this.odb, FolderDataODB.this.folder);
                return this.c.compare(o1.get(), o2.get());
            }
        }

        class Data {
            public List<ActionProxyODB> actions = new ArrayList<ActionProxyODB>();
            public String description;
            private Date created;
            private Date resolved;
            private Date modified;

            Data() {
            }
        }
    }

    public static class ActionProxyODB
    implements GTDData.ActionProxy {
        private long _oid;
        private int id;
        private Integer parentID;
        private boolean open;
        private transient OID oid;
        private transient WeakReference<Action> ref;
        private transient ODB odb;
        private transient Folder parent;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ActionProxyODB(Action a, ODB odb) {
            this.odb = odb;
            this.ref = new WeakReference<Action>(a);
            this.id = a.getId();
            this.open = a.isOpen();
            a.setProxy(this);
            ODB oDB = odb;
            synchronized (oDB) {
                long time = System.currentTimeMillis();
                this.oid = odb.store(a);
                this._oid = this.oid.getObjectId();
                this.commit();
            }
        }

        public OID getOid() {
            if (this.oid == null && this._oid != 0L) {
                this.oid = OIDFactory.buildObjectOID(this._oid);
            }
            return this.oid;
        }

        void connect(ODB odb, Folder f) {
            this.odb = odb;
            if (this.parent == null && this.parentID != null) {
                this.parent = f.getId() == this.parentID.intValue() ? f : f.getParent().getFolder(this.parentID);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Action get() {
            Action a = this._get();
            if (a == null) {
                ODB oDB = this.odb;
                synchronized (oDB) {
                    long time = System.currentTimeMillis();
                    try {
                        a = (Action)this.odb.getObjectFromId(this.getOid());
                    }
                    catch (ODBRuntimeException e) {
                        org.apache.log4j.Logger.getLogger(this.getClass()).error("Database error.", e);
                        return null;
                    }
                    a.setProxy(this);
                    boolean b = this.open;
                    this.open = a.isOpen();
                    if (b != this.open) {
                        this.odb.store(this);
                    }
                }
                this.ref = new WeakReference<Action>(a);
            }
            return a;
        }

        Action _get() {
            Action a = null;
            if (this.ref != null) {
                a = (Action)this.ref.get();
            }
            return a;
        }

        @Override
        public int getId() {
            return this.id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void store() {
            Action a = this._get();
            if (a != null) {
                ODB oDB = this.odb;
                synchronized (oDB) {
                    long time = System.currentTimeMillis();
                    this.odb.store(a);
                    this.commit();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void delete() {
            if (this.getOid() == null) {
                return;
            }
            ODB oDB = this.odb;
            synchronized (oDB) {
                try {
                    this.odb.delete(this);
                }
                catch (Exception e) {
                    org.apache.log4j.Logger.getLogger(this.getClass()).debug("Database error.", e);
                }
                try {
                    this.odb.deleteObjectWithId(this.getOid());
                }
                catch (Exception e) {
                    org.apache.log4j.Logger.getLogger(this.getClass()).debug("Database error.", e);
                }
                this.oid = null;
                this._oid = 0L;
            }
        }

        @Override
        public Folder getParent() {
            return this.parent;
        }

        @Override
        public void setParent(Folder parent) {
            this.parent = parent;
            this.parentID = parent.getId();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void commit() {
            ODB oDB = this.odb;
            synchronized (oDB) {
                long time = System.currentTimeMillis();
                this.odb.commit();
            }
        }

        public boolean isOpen() {
            Action a = this._get();
            if (a != null) {
                this.open = a.isOpen();
            }
            return this.open;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(64);
            sb.append("AP{");
            sb.append(this.id);
            sb.append(',');
            sb.append(this.open);
            sb.append('}');
            return sb.toString();
        }
    }
}

