/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.model;

import java.util.Set;
import org.gtdfree.model.Action;
import org.gtdfree.model.ActionFilter;
import org.gtdfree.model.DummyFilter;
import org.gtdfree.model.Folder;

public class FolderProjectActionFilter
implements ActionFilter {
    private Set<Integer> folders;
    private Set<Integer> projects;
    private ActionFilter filter;
    private boolean includeWithoutProject;

    public FolderProjectActionFilter(Set<Integer> folders, Set<Integer> projects, ActionFilter f, boolean includeWithoutProject) {
        this.folders = folders;
        this.projects = projects;
        this.filter = f;
        this.includeWithoutProject = includeWithoutProject;
        if (this.filter == null) {
            this.filter = new DummyFilter(true);
        }
    }

    @Override
    public boolean isAcceptable(Folder f, Action a) {
        if (f.isProject() ? !this.projects.contains(f.getId()) : !this.folders.contains(f.getId())) {
            return false;
        }
        if (a == null) {
            return this.filter.isAcceptable(f, null);
        }
        if (a.getProject() == null ? !this.includeWithoutProject : !this.projects.contains(a.getProject())) {
            return false;
        }
        return this.filter.isAcceptable(f, a);
    }
}

