/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.model;

import org.gtdfree.model.Action;
import org.gtdfree.model.Folder;
import org.gtdfree.model.Project;

public class ConsistencyException
extends Exception {
    private static final long serialVersionUID = 1L;
    private Action[] actions;
    private Folder[] folders;
    private Project[] projects;

    public ConsistencyException(String message) {
        super(message);
    }

    public ConsistencyException(String message, Throwable cause) {
        super(message, cause);
    }

    public ConsistencyException(String message, Action[] a, Folder[] f, Project[] p) {
        super(message);
        this.actions = a;
        this.folders = f;
        this.projects = p;
    }

    public Action[] getActions() {
        return this.actions;
    }

    public Folder[] getFolders() {
        return this.folders;
    }

    public Project[] getProjects() {
        return this.projects;
    }

    @Override
    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessage());
        sb.append('\n');
        sb.append('\n');
        if (this.actions != null) {
            if (this.actions.length == 1) {
                sb.append("Action:\n");
                this.append(sb, this.actions[0]);
            } else {
                sb.append("Actions:\n");
                for (i = 0; i < this.actions.length; ++i) {
                    this.append(sb, this.actions[i]);
                }
            }
            sb.append('\n');
        }
        if (this.folders != null) {
            if (this.folders.length == 1) {
                sb.append("List:\n");
                this.append(sb, this.folders[0]);
            } else {
                sb.append("Lists:\n");
                for (i = 0; i < this.folders.length; ++i) {
                    this.append(sb, this.folders[i]);
                }
            }
            sb.append('\n');
        }
        if (this.projects != null) {
            if (this.projects.length == 1) {
                sb.append("Project:\n");
                this.append(sb, this.projects[0]);
            } else {
                sb.append("Projects:\n");
                for (i = 0; i < this.projects.length; ++i) {
                    this.append(sb, this.projects[i]);
                }
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    private void append(StringBuilder sb, Action a) {
        sb.append("ID=");
        sb.append(a.getId());
        sb.append(" status=");
        sb.append((Object)a.getResolution());
        sb.append(" desc='");
        if (a.getDescription() != null) {
            if (a.getDescription().length() > 15) {
                sb.append(a.getDescription().substring(0, 11));
                sb.append("...'\n");
            } else {
                sb.append(a.getDescription());
                sb.append("'\n");
            }
        } else {
            sb.append("'\n");
        }
    }

    private void append(StringBuilder sb, Folder a) {
        sb.append("ID=");
        sb.append(a.getId());
        sb.append(" name=");
        sb.append(a.getName());
        sb.append(" type=");
        sb.append((Object)a.getType());
        sb.append('\n');
    }

    private void append(StringBuilder sb, Project a) {
        sb.append("ID=");
        sb.append(a.getId());
        sb.append(" name=");
        sb.append(a.getName());
        sb.append('\n');
    }
}

