/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.model;

import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.gtdfree.model.Action;
import org.gtdfree.model.Folder;
import org.gtdfree.model.GTDData;
import org.gtdfree.model.Priority;

public class ActionEvent
extends EventObject {
    private static final long serialVersionUID = 1L;
    private Action[] action;
    private GTDData.ActionProxy[] actionP;
    private String property;
    private Object oldValue;
    private Object newValue;
    private boolean recycled = false;
    private SortedElements sortedElements;

    public ActionEvent(Folder f, Action action, GTDData.ActionProxy actionP, String property, Object oldValue, Object newValue, boolean recycled) {
        this(f, new Action[]{action}, new GTDData.ActionProxy[]{actionP}, property, oldValue, newValue, recycled);
    }

    public ActionEvent(Folder f, Action[] action, GTDData.ActionProxy[] actionP, String property, Object oldValue, Object newValue, boolean recycled) {
        super(f);
        this.action = action;
        this.actionP = actionP;
        this.property = property;
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.recycled = recycled;
        if (property != null) {
            if (this.getNewValue() == this.getOldValue()) {
                throw new RuntimeException("Internal error, property not changed: " + this.toString());
            }
            if (this.getNewValue() != null && !"".equals(this.getNewValue()) || !"remind".equals(property)) {
                // empty if block
            }
        }
    }

    public ActionEvent(Folder f, Action[] a, GTDData.ActionProxy[] ap, boolean recycled) {
        super(f);
        this.action = a;
        this.actionP = ap;
        this.recycled = recycled;
    }

    public ActionEvent(Folder f, Action a, GTDData.ActionProxy ap, boolean recycled) {
        this(f, new Action[]{a}, new GTDData.ActionProxy[]{ap}, recycled);
    }

    public boolean isRecycled() {
        return this.recycled;
    }

    public Action getAction() {
        return this.action[0];
    }

    public GTDData.ActionProxy getActionProxy() {
        return this.actionP[0];
    }

    public Object getNewValue() {
        return this.newValue;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public String getProperty() {
        return this.property;
    }

    public Action[] getActions() {
        return this.action;
    }

    public GTDData.ActionProxy[] getActionProxies() {
        return this.actionP;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ActionEvent={source=");
        sb.append(((Folder)this.getSource()).getName());
        sb.append(", actions=");
        sb.append(this.action.length);
        sb.append(", prop=");
        sb.append(this.property);
        sb.append(", old=");
        sb.append(this.oldValue);
        sb.append(", new=");
        sb.append(this.newValue);
        sb.append("}");
        return sb.toString();
    }

    public synchronized SortedElements getSortedElements() {
        if (this.sortedElements == null) {
            this.sortedElements = new SortedElements(this.action, this.actionP);
        }
        return this.sortedElements;
    }

    static class SortedElements {
        private Action[] ac;
        private GTDData.ActionProxy[] ap;
        private List<Integer>[] indices;

        public SortedElements(Action[] ac, GTDData.ActionProxy[] ap) {
            this.ac = ac;
            this.ap = ap;
            this.indices = new List[ActionIndex.values().length];
            Integer i = 0;
            while (i < ap.length) {
                Action aa = ac[i];
                if (aa.isResolved()) {
                    this.index(ActionIndex.RESOLVED).add(i);
                }
                if (aa.isDeleted()) {
                    this.index(ActionIndex.DELETED).add(i);
                }
                if (aa.getRemind() != null) {
                    this.index(ActionIndex.REMINDER).add(i);
                }
                if (aa.getPriority() != null && aa.getPriority() != Priority.None) {
                    this.index(ActionIndex.PRIORITY).add(i);
                }
                if (aa.isQueued()) {
                    this.index(ActionIndex.QUEUE).add(i);
                }
                if (aa.getProject() != null) {
                    this.index(ActionIndex.PROJECT).add(i);
                }
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
        }

        private List<Integer> index(ActionIndex i) {
            List<Integer> l = this.indices[i.ordinal()];
            if (l == null) {
                this.indices[i.ordinal()] = l = new LinkedList<Integer>();
            }
            return l;
        }

        private Action[] getActions(List<Integer> l) {
            Action[] a = new Action[l.size()];
            int k = 0;
            for (Integer i : l) {
                a[k++] = this.ac[i];
            }
            return a;
        }

        private GTDData.ActionProxy[] getActionProxies(List<Integer> l) {
            GTDData.ActionProxy[] a = new GTDData.ActionProxy[l.size()];
            int k = 0;
            for (Integer i : l) {
                a[k++] = this.ap[i];
            }
            return a;
        }

        private Action[] getActionsInv(List<Integer> l) {
            if (l.size() == 0) {
                return this.ac;
            }
            Action[] a = new Action[this.ac.length - l.size()];
            int k = 0;
            Iterator<Integer> it = l.iterator();
            int in = it.next();
            for (int i = 0; i < this.ac.length; ++i) {
                if (i == in) {
                    in = it.hasNext() ? it.next() : -1;
                    continue;
                }
                a[k++] = this.ac[i];
            }
            return a;
        }

        private GTDData.ActionProxy[] getActionProxiesInv(List<Integer> l) {
            if (l.size() == 0) {
                return this.ap;
            }
            GTDData.ActionProxy[] a = new GTDData.ActionProxy[this.ap.length - l.size()];
            int k = 0;
            Iterator<Integer> it = l.iterator();
            int in = it.next();
            for (int i = 0; i < this.ap.length; ++i) {
                if (i == in) {
                    in = it.hasNext() ? it.next() : -1;
                    continue;
                }
                a[k++] = this.ap[i];
            }
            return a;
        }

        public Action[] getActions() {
            return this.ac;
        }

        public GTDData.ActionProxy[] getActionProxies() {
            return this.ap;
        }

        public Action[] getActions(ActionIndex i) {
            return this.getActions(this.index(i));
        }

        public GTDData.ActionProxy[] getActionProxies(ActionIndex i) {
            return this.getActionProxies(this.index(i));
        }

        public Action[] getActionsInv(ActionIndex i) {
            return this.getActionsInv(this.index(i));
        }

        public GTDData.ActionProxy[] getActionProxiesInv(ActionIndex i) {
            return this.getActionProxiesInv(this.index(i));
        }

        public int size(ActionIndex i) {
            return this.indices[i.ordinal()] == null ? 0 : this.index(i).size();
        }

        public int sizeInv(ActionIndex i) {
            return this.ac.length - (this.indices[i.ordinal()] == null ? 0 : this.index(i).size());
        }

        static enum ActionIndex {
            RESOLVED,
            DELETED,
            REMINDER,
            PRIORITY,
            QUEUE,
            PROJECT;

        }
    }
}

