/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.journal;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.gtdfree.journal.Interval;
import org.gtdfree.journal.JournalEntryEvent;
import org.gtdfree.journal.JournalEntryListener;
import org.gtdfree.model.Action;

public class JournalEntry {
    private long day;
    private String comment;
    private List<Interval> intervals = new ArrayList<Interval>();
    private List<Action> actions;
    private boolean checked = false;
    private EventListenerList listeners = new EventListenerList();

    public long getDay() {
        return this.day;
    }

    public void setDay(long day) {
        if (this.day == day) {
            return;
        }
        long old = this.day;
        this.day = day;
        this.fireJournalEntryChanged("day", day, old);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        if (comment != null && comment.equals(this.comment) || comment == null && this.comment == null) {
            return;
        }
        String old = this.comment;
        this.comment = comment;
        this.fireJournalEntryChanged("comment", comment, old);
    }

    public Interval[] getIntervals() {
        return this.intervals.toArray(new Interval[this.intervals.size()]);
    }

    public int getIntervalCount() {
        return this.intervals.size();
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        if (checked == this.checked) {
            return;
        }
        this.checked = checked;
        this.fireJournalEntryChanged("checked", checked);
    }

    public void addInterval(Interval interval) {
        this.intervals.add(interval);
        this.fireJournalEntryIntervalAdded(interval, this.intervals.size() - 1);
    }

    public void removeInterval(Interval interval) {
        int i = this.intervals.indexOf(interval);
        if (i == -1) {
            return;
        }
        this.intervals.remove(i);
        this.fireJournalEntryIntervalRemoved(interval, i);
    }

    public void setInterval(int index, Interval interval) {
        Interval i = this.intervals.get(index);
        if (interval != null && interval.equals(i) || interval == null && i == null) {
            return;
        }
        this.intervals.set(index, interval);
        this.fireJournalEntryChanged(new JournalEntryEvent(this, "intervals", interval, i, index));
    }

    public void addJournalEntryListener(JournalEntryListener l) {
        this.listeners.add(JournalEntryListener.class, l);
    }

    public void removeJournalEntryListener(JournalEntryListener l) {
        this.listeners.remove(JournalEntryListener.class, l);
    }

    private void fireJournalEntryChanged(JournalEntryEvent e) {
        if (e.getNewValue() == e.getOldValue()) {
            return;
        }
        JournalEntryListener[] l = (JournalEntryListener[])this.listeners.getListeners(JournalEntryListener.class);
        for (int i = 0; i < l.length; ++i) {
            l[i].journalEntryChanged(e);
        }
    }

    private void fireJournalEntryIntervalAdded(Interval it, int ix) {
        JournalEntryEvent e = new JournalEntryEvent(this, "intervals", it, null, ix);
        JournalEntryListener[] l = (JournalEntryListener[])this.listeners.getListeners(JournalEntryListener.class);
        for (int i = 0; i < l.length; ++i) {
            l[i].journalEntryIntervalAdded(e);
        }
    }

    private void fireJournalEntryIntervalRemoved(Interval it, int ix) {
        JournalEntryEvent e = new JournalEntryEvent(this, "intervals", null, it, ix);
        JournalEntryListener[] l = (JournalEntryListener[])this.listeners.getListeners(JournalEntryListener.class);
        for (int i = 0; i < l.length; ++i) {
            l[i].journalEntryIntervalRemoved(e);
        }
    }

    private void fireJournalEntryChanged(String prop, Object newValue, Object oldValue) {
        this.fireJournalEntryChanged(new JournalEntryEvent(this, prop, newValue, oldValue, -1));
    }

    private void fireJournalEntryChanged(String prop, boolean b) {
        this.fireJournalEntryChanged(new JournalEntryEvent(this, prop, b, !b, -1));
    }

    public Interval getInterval(int index) {
        return this.intervals.get(index);
    }

    public void intervalChanged(Interval interval) {
        this.fireJournalEntryChanged(new JournalEntryEvent(this, "intervals", interval, null, -1));
    }
}

