/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TimeInputPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String TIME_OF_DAY = "timeOfDay";
    private JComboBox hour;
    private JComboBox minutes;
    private int timeOfDay;

    public static void main(String[] args) {
        TimeInputPanel p = new TimeInputPanel();
        p.addPropertyChangeListener(TIME_OF_DAY, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                System.out.println(evt.getNewValue());
            }
        });
        JFrame f = new JFrame();
        f.setContentPane(p);
        f.pack();
        f.setVisible(true);
    }

    public TimeInputPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        this.hour = new JComboBox<Integer>(new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29});
        this.hour.setEditable(false);
        this.hour.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    TimeInputPanel.this.updateTime();
                }
            }
        });
        this.minutes = new JComboBox<Integer>(new Integer[]{0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55});
        this.minutes.setEditable(false);
        this.minutes.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    TimeInputPanel.this.updateTime();
                }
            }
        });
        this.add((Component)this.hour, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JLabel(":"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.minutes, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void updateTime() {
        this.setTimeOfDay(60 * (Integer)this.hour.getSelectedItem() + (Integer)this.minutes.getSelectedItem());
    }

    public int getTimeOfDay() {
        return this.timeOfDay;
    }

    public void setTimeOfDay(int timeOfDay) {
        if (this.timeOfDay == timeOfDay) {
            return;
        }
        int old = this.timeOfDay;
        this.timeOfDay = timeOfDay;
        this.hour.setSelectedItem(timeOfDay / 60);
        this.minutes.setSelectedItem(timeOfDay % 60);
        this.firePropertyChange(TIME_OF_DAY, old, timeOfDay);
    }
}

