/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.gui;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.apache.log4j.Logger;

public abstract class StringTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 1L;

    StringTransferHandler() {
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        DataFlavor f = this.getStringFlavor(support.getDataFlavors());
        Object drop = null;
        String s = null;
        if (f != null) {
            try {
                drop = support.getTransferable().getTransferData(f);
            }
            catch (UnsupportedFlavorException e) {
                Logger.getLogger(this.getClass()).debug("Internal error.", e);
            }
            catch (IOException e) {
                Logger.getLogger(this.getClass()).debug("Internal error.", e);
            }
        } else {
            try {
                drop = support.getTransferable().getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException e) {
                Logger.getLogger(this.getClass()).debug("Internal error.", e);
            }
            catch (IOException e) {
                Logger.getLogger(this.getClass()).debug("Internal error.", e);
            }
        }
        if (drop != null) {
            s = String.valueOf(drop);
        }
        if (s != null) {
            return this.importString(s, support);
        }
        return false;
    }

    protected abstract boolean importString(String var1, TransferHandler.TransferSupport var2);

    protected abstract String exportString();

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        DataFlavor f = this.getStringFlavor(support.getDataFlavors());
        return f != null;
    }

    private DataFlavor getStringFlavor(DataFlavor[] f) {
        for (int i = 0; i < f.length; ++i) {
            if (!f[i].equals(DataFlavor.stringFlavor)) continue;
            return f[i];
        }
        return null;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        return new Transferable(){

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return DataFlavor.stringFlavor.equals(flavor);
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{DataFlavor.stringFlavor};
            }

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                if (flavor.equals(DataFlavor.stringFlavor)) {
                    return StringTransferHandler.this.exportString();
                }
                return null;
            }
        };
    }
}

