/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.gtdfree.ApplicationHelper;

public class StopwatchPanel
extends JPanel
implements Runnable {
    private static final long serialVersionUID = 1L;
    private JProgressBar displayLabel;
    private JToggleButton startButton;
    private JButton resetButton;
    private long offset = 0L;
    private long start = 0L;
    private boolean running = false;
    private Thread thread = null;

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setContentPane(new StopwatchPanel());
        f.pack();
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }

    public StopwatchPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        this.displayLabel = new JProgressBar();
        this.displayLabel.setFont(new Font("SansSerif", 1, this.displayLabel.getFont().getSize()));
        this.displayLabel.setString("2:00");
        this.displayLabel.setStringPainted(true);
        this.displayLabel.setMinimum(0);
        this.displayLabel.setMaximum(120);
        Dimension d = new Dimension(65, this.displayLabel.getPreferredSize().height);
        this.displayLabel.setPreferredSize(d);
        this.displayLabel.setMinimumSize(d);
        this.add((Component)this.displayLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.startButton = new JToggleButton();
        this.startButton.setIcon(ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_start));
        this.startButton.setMargin(new Insets(2, 2, 2, 2));
        this.startButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (StopwatchPanel.this.startButton.isSelected()) {
                    StopwatchPanel.this.start();
                } else {
                    StopwatchPanel.this.stop();
                }
            }
        });
        this.add((Component)this.startButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 4, 0, 0), 0, 0));
        this.resetButton = new JButton();
        this.resetButton.setIcon(ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_clear));
        this.resetButton.setMargin(new Insets(2, 2, 2, 2));
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StopwatchPanel.this.reset();
            }
        });
        this.add((Component)this.resetButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 4, 0, 0), 0, 0));
    }

    public void updateDisplay() {
        if (SwingUtilities.isEventDispatchThread()) {
            this._updateDisplay();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StopwatchPanel.this._updateDisplay();
                }
            });
        }
    }

    public synchronized void _updateDisplay() {
        int time = 0;
        if (this.running) {
            long now = System.currentTimeMillis();
            time = (int)(now - this.start + this.offset) / 1000;
        } else {
            time = (int)(this.offset / 1000L);
        }
        this.displayLabel.setValue(time);
        if (time < 120) {
            time = 120 - time;
        }
        StringBuilder sb = new StringBuilder(6);
        int t = time / 60;
        sb.append(t);
        sb.append(':');
        t = time % 60;
        if (t < 10) {
            sb.append('0');
        }
        sb.append(t);
        this.displayLabel.setString(sb.toString());
    }

    public synchronized void reset() {
        this.start = System.currentTimeMillis();
        this.offset = 0L;
        this.updateDisplay();
    }

    public synchronized void stop() {
        if (!this.running) {
            return;
        }
        long now = System.currentTimeMillis();
        this.offset += now - this.start;
        this.running = false;
        this.thread = null;
        this.updateDisplay();
        if (this.startButton.isSelected()) {
            this.startButton.setSelected(false);
        }
    }

    public synchronized void start() {
        this.thread = new Thread(this);
        this.running = true;
        this.start = System.currentTimeMillis();
        this.thread.setDaemon(false);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.running && this.thread == Thread.currentThread()) {
            this.updateDisplay();
            JToggleButton jToggleButton = this.startButton;
            synchronized (jToggleButton) {
                try {
                    this.startButton.wait(999L);
                }
                catch (Exception e) {
                    Logger.getLogger(this.getClass()).debug("Internal error.", e);
                }
            }
        }
    }
}

