/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.gtdfree.ApplicationHelper;
import org.gtdfree.Messages;
import org.gtdfree.model.Folder;
import org.gtdfree.model.FolderEvent;
import org.gtdfree.model.GTDModel;
import org.gtdfree.model.GTDModelAdapter;
import org.gtdfree.model.Project;

public class ProjectsCombo
extends JComboBox {
    private static final long serialVersionUID = 1L;
    private static final String NONE = Messages.getString("ProjectsCombo.None");
    public static final String CANCELED_PROPERTY_NAME = "canceled";
    public static final String SELECTED_PROJECT_PROPERTY_NAME = "selectedProject";
    private GTDModel gtdModel;
    private ProjectsComboBoxModel comboModel;
    private Object last;
    private ProjectEditor projectEditor;
    private boolean showClosedFolders = false;

    public ProjectsCombo() {
        this.initialize();
    }

    private void initialize() {
        this.setFont(this.getFont().deriveFont(2));
        this.comboModel = new ProjectsComboBoxModel();
        this.setModel(this.comboModel);
        this.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof Project) {
                    value = ((Project)value).getName();
                }
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        });
        this.projectEditor = new ProjectEditor();
        this.setEditor(this.projectEditor);
        this.setEditable(true);
        this.setBorder(null);
        this.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ProjectsCombo.this.fireProjectChanged();
            }
        });
        this.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                ProjectsCombo.this.projectEditor.cancelEditing();
            }
        });
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.firePropertyChange("preferedSize", null, this.getPreferredSize());
    }

    public boolean isInitialized() {
        return this.comboModel.getSelectedItem() != null;
    }

    public GTDModel getGTDModel() {
        return this.gtdModel;
    }

    public void setGTDModel(GTDModel m) {
        this.gtdModel = m;
        this.comboModel.reload();
        m.addGTDModelListener(new GTDModelAdapter(){

            @Override
            public void folderRemoved(Folder folder) {
                ProjectsCombo.this.comboModel.reload();
            }

            @Override
            public void folderModified(FolderEvent folder) {
                ProjectsCombo.this.comboModel.reload();
            }

            @Override
            public void folderAdded(Folder folder) {
                ProjectsCombo.this.comboModel.reload();
            }
        });
    }

    public Project getSelectedProject() {
        Object o = this.comboModel.getSelectedItem();
        if (o instanceof Project) {
            return (Project)o;
        }
        return null;
    }

    public void fireProjectChanged() {
        if (this.last == this.comboModel.getSelectedItem()) {
            return;
        }
        Project old = this.last instanceof Project ? (Project)this.last : null;
        this.last = this.comboModel.getSelectedItem();
        this.firePropertyChange(SELECTED_PROJECT_PROPERTY_NAME, old, this.getSelectedProject());
    }

    public void setSelectedProject(Project selectedProject) {
        if (selectedProject == this.getSelectedProject()) {
            return;
        }
        if (selectedProject == null) {
            this.comboModel.setSelectedItem(NONE);
        } else {
            this.comboModel.setSelectedItem(selectedProject);
        }
        this.fireProjectChanged();
    }

    public int getPreferredWidth() {
        Dimension d = this.getUI().getPreferredSize(this);
        return d.width - d.height + this.getInsets().bottom + this.getInsets().top + 4;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        return new Dimension(this.getPreferredWidth(), ApplicationHelper.getDefaultFieldHeigth());
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void setOpaque(boolean isOpaque) {
        super.setOpaque(isOpaque);
        Component[] c = this.getComponents();
        if (c != null) {
            for (int i = 0; i < c.length; ++i) {
                if (!(c[i] instanceof JComponent)) continue;
                ((JComponent)c[i]).setOpaque(isOpaque);
            }
        }
    }

    public boolean isShowClosedFolders() {
        return this.showClosedFolders;
    }

    public void setShowClosedFolders(boolean showClosedFolders) {
        this.showClosedFolders = showClosedFolders;
        this.comboModel.reload();
    }

    class ProjectsComboBoxModel
    extends DefaultComboBoxModel {
        private static final long serialVersionUID = 1L;
        private boolean reloading = false;

        ProjectsComboBoxModel() {
        }

        @Override
        public void setSelectedItem(Object sel) {
            if (sel instanceof String && sel != NONE) {
                sel = ProjectsCombo.this.gtdModel.createFolder((String)sel, Folder.FolderType.PROJECT);
                this.reload();
            }
            super.setSelectedItem(sel);
        }

        @Override
        protected void fireContentsChanged(Object source, int index0, int index1) {
            if (this.reloading) {
                return;
            }
            super.fireContentsChanged(source, index0, index1);
        }

        @Override
        protected void fireIntervalAdded(Object source, int index0, int index1) {
            if (this.reloading) {
                return;
            }
            super.fireIntervalAdded(source, index0, index1);
        }

        @Override
        protected void fireIntervalRemoved(Object source, int index0, int index1) {
            if (this.reloading) {
                return;
            }
            super.fireIntervalRemoved(source, index0, index1);
        }

        private void reload() {
            this.reloading = true;
            Object selected = this.getSelectedItem();
            ProjectsCombo.this.comboModel.removeAllElements();
            ProjectsCombo.this.comboModel.addElement(NONE);
            if (ProjectsCombo.this.gtdModel == null) {
                return;
            }
            Project[] p = ProjectsCombo.this.gtdModel.toProjectsArray();
            Arrays.sort(p, new Comparator<Project>(){

                @Override
                public int compare(Project o1, Project o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            boolean contains = false;
            for (int i = 0; i < p.length; ++i) {
                if (!ProjectsCombo.this.showClosedFolders && p[i].isClosed()) continue;
                ProjectsCombo.this.comboModel.addElement(p[i]);
                contains = contains || p[i].equals(selected);
            }
            if (contains) {
                this.setSelectedItem(selected);
            }
            this.reloading = false;
            this.fireIntervalAdded(this, 0, this.getSize());
            if (!contains) {
                ProjectsCombo.this.setSelectedProject(null);
            }
        }
    }

    class ProjectEditor
    extends JTextField
    implements ComboBoxEditor {
        private static final long serialVersionUID = 1L;
        Object item;

        public ProjectEditor() {
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    if (e.getKeyChar() == '\u001b') {
                        ProjectEditor.this.cancelEditing();
                    }
                }
            });
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    ProjectsCombo.this.projectEditor.cancelEditing();
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
            this.setMargin(new Insets(0, 0, 0, 0));
        }

        @Override
        public Component getEditorComponent() {
            return this;
        }

        @Override
        public Object getItem() {
            if (this.item instanceof Project && this.getText().length() > 0) {
                if (!this.getText().equals(((Project)this.item).getName())) {
                    ((Project)this.item).rename(this.getText());
                }
            } else if (this.getText().length() > 0) {
                this.item = this.getText();
            }
            return this.item;
        }

        @Override
        public void selectAll() {
            this.select(0, this.getText().length() - 1);
        }

        @Override
        public void setItem(Object anObject) {
            this.item = anObject;
            if (this.item instanceof Project) {
                this.setText(((Project)this.item).getName());
            } else {
                this.setText(this.item != null && this.item != NONE ? this.item.toString() : "");
            }
        }

        private void cancelEditing() {
            ProjectsCombo.this.hidePopup();
            this.setItem(this.item);
            ProjectsCombo.this.firePropertyChange(ProjectsCombo.CANCELED_PROPERTY_NAME, false, true);
        }
    }
}

