/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import org.gtdfree.ApplicationHelper;
import org.gtdfree.GTDFreeEngine;
import org.gtdfree.GlobalProperties;
import org.gtdfree.Messages;
import org.gtdfree.gui.ActionPanel;
import org.gtdfree.gui.ActionSpinner;
import org.gtdfree.gui.ActionTable;
import org.gtdfree.gui.FolderPanel;
import org.gtdfree.gui.StopwatchPanel;
import org.gtdfree.gui.WorkflowPane;
import org.gtdfree.model.Action;
import org.gtdfree.model.ActionsCollection;
import org.gtdfree.model.Folder;
import org.gtdfree.model.FolderEvent;
import org.gtdfree.model.GTDModelAdapter;

public class ProcessPane
extends JSplitPane
implements WorkflowPane {
    private static final long serialVersionUID = 1L;
    private GTDFreeEngine engine;
    private ActionTable actionTable;
    private javax.swing.Action resolveAction;
    private javax.swing.Action deleteAction;
    private AbstractAction moveAction;
    private ActionPanel actionPanel;
    private FolderPanel folders;
    private ActionSpinner actionSpinner;
    private JSplitPane split;
    private JLabel leftLabel;
    private JLabel idLabel;
    private StopwatchPanel stopwatch;

    public GTDFreeEngine getEngine() {
        return this.engine;
    }

    private void initialize() {
        this.setOrientation(0);
        JPanel jp1 = new JPanel();
        jp1.setLayout(new GridBagLayout());
        JPanel jpp = new JPanel();
        jpp.setLayout(new GridBagLayout());
        jpp.setBorder(new TitledBorder(Messages.getString("ProcessPane.InB")));
        this.idLabel = new JLabel();
        this.idLabel.setText(Messages.getString("ActionPanel.ID") + " " + Messages.getString("ActionPanel.NA"));
        jpp.add((Component)this.idLabel, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 4, 0, 4), 0, 0));
        this.actionSpinner = new ActionSpinner();
        this.actionSpinner.addPropertyChangeListener("selectedAction", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                boolean b = ProcessPane.this.actionSpinner.getSelectedAction() != null;
                ProcessPane.this.getDeleteAction().setEnabled(b);
                ProcessPane.this.getResolveAction().setEnabled(b);
                if (b) {
                    String s = Messages.getString("ActionPanel.ID") + " " + ProcessPane.this.actionSpinner.getSelectedAction().getId();
                    ProcessPane.this.idLabel.setText(s);
                    ProcessPane.this.stopwatch.reset();
                } else {
                    ProcessPane.this.idLabel.setText(Messages.getString("ActionPanel.ID") + " " + Messages.getString("ActionPanel.NA"));
                    ProcessPane.this.stopwatch.stop();
                }
                b = b && ProcessPane.this.folders.getSelectedFolder() != null;
                ProcessPane.this.getMoveAction().setEnabled(b);
            }
        });
        jpp.add((Component)this.actionSpinner, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 4, 0, 4), 0, 0));
        this.leftLabel = new JLabel();
        this.leftLabel.setToolTipText(Messages.getString("ProcessPane.Left"));
        jpp.add((Component)this.leftLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        JButton b = new JButton(this.getResolveAction());
        b.setMargin(ApplicationHelper.getDefaultFatButtonMargin());
        jpp.add((Component)b, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 13, 0, new Insets(4, 4, 4, 4), 0, 0));
        b = new JButton(this.getDeleteAction());
        b.setMargin(ApplicationHelper.getDefaultFatButtonMargin());
        jpp.add((Component)b, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        b = new JButton(this.getMoveAction());
        b.setMargin(ApplicationHelper.getDefaultFatButtonMargin());
        jpp.add((Component)b, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.stopwatch = new StopwatchPanel();
        jpp.add((Component)this.stopwatch, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 13, 0, new Insets(4, 4, 4, 4), 0, 0));
        jp1.add((Component)jpp, new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 10, 1, new Insets(4, 4, 0, 4), 0, 0));
        jp1.setMinimumSize(new Dimension(200, 100));
        jp1.setPreferredSize(new Dimension(200, 100));
        this.split = new JSplitPane();
        this.split.setOrientation(1);
        this.split.setResizeWeight(0.0);
        JPanel jp2 = new JPanel();
        jp2.setBorder(new TitledBorder(Messages.getString("ProcessPane.Lists")));
        jp2.setLayout(new GridBagLayout());
        this.folders = new FolderPanel();
        this.folders.setDefaultFoldersVisible(false);
        this.folders.addPropertyChangeListener("selectedFolder", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ProcessPane.this.actionTable.setFolder(ProcessPane.this.folders.getSelectedFolder());
                int i = ProcessPane.this.folders.getLastDroppedActionIndex();
                if (i > -1 && ProcessPane.this.actionTable.getRowCount() > 0) {
                    if (i >= ProcessPane.this.actionTable.getRowCount()) {
                        i = ProcessPane.this.actionTable.getRowCount() - 1;
                    }
                    ProcessPane.this.actionTable.setRowSelectionInterval(i, i);
                }
                ProcessPane.this.getMoveAction().setEnabled(ProcessPane.this.actionSpinner.getSelectedAction() != null && ProcessPane.this.folders.getSelectedFolder() != null);
            }
        });
        jp2.add((Component)this.folders, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
        this.split.setLeftComponent(jp2);
        JPanel jp3 = new JPanel();
        jp3.setLayout(new GridBagLayout());
        this.actionPanel = new ActionPanel(false);
        this.actionPanel.setBorder(new TitledBorder(Messages.getString("ProcessPane.Sel")));
        this.actionPanel.setDescriptionTextMinimumHeight(48);
        jp3.add((Component)this.actionPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 4, 0, 0), 0, 0));
        this.actionTable = new ActionTable();
        this.actionTable.setMoveEnabled(true);
        this.actionTable.addPropertyChangeListener("selectedActions", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ProcessPane.this.actionPanel.setActions(ProcessPane.this.actionTable.getSelectedActions());
            }
        });
        JScrollPane jsp = new JScrollPane(this.actionTable);
        jp3.add((Component)jsp, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
        this.split.setRightComponent(jp3);
        this.split.setDividerLocation(210);
        this.split.setPreferredSize(new Dimension(200, 200));
        this.split.setMinimumSize(new Dimension(200, 200));
        this.actionPanel.addSwingActions(this.actionTable.getActionMap());
        this.actionTable.addSwingActions(this.actionPanel.getActionMap());
        this.setLeftComponent(jp1);
        this.setRightComponent(this.split);
        this.setDividerLocation(140);
    }

    public void packLayout() {
        this.setDividerLocation((int)((JSplitPane)this.getRightComponent()).getLeftComponent().getMinimumSize().getHeight() + 68);
    }

    private javax.swing.Action getMoveAction() {
        if (this.moveAction == null) {
            this.moveAction = new AbstractAction(Messages.getString("ProcessPane.Move"), ApplicationHelper.getIcon(ApplicationHelper.icon_name_large_move)){
                private static final long serialVersionUID = -8908528493980828208L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    Action n = ProcessPane.this.actionSpinner.getSelectedAction();
                    Folder f = ProcessPane.this.folders.getSelectedFolder();
                    if (n != null && f != null) {
                        ProcessPane.this.engine.getGTDModel().moveAction(n, f);
                    }
                }
            };
            this.moveAction.setEnabled(false);
        }
        return this.moveAction;
    }

    private javax.swing.Action getDeleteAction() {
        if (this.deleteAction == null) {
            this.deleteAction = new AbstractAction(Messages.getString("ProcessPane.Delete"), ApplicationHelper.getIcon(ApplicationHelper.icon_name_large_delete)){
                private static final long serialVersionUID = 5483273497818329289L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    Action n = ProcessPane.this.actionSpinner.getSelectedAction();
                    if (n != null) {
                        n.setResolution(Action.Resolution.DELETED);
                    }
                }
            };
            this.deleteAction.setEnabled(false);
        }
        return this.deleteAction;
    }

    private javax.swing.Action getResolveAction() {
        if (this.resolveAction == null) {
            this.resolveAction = new AbstractAction(Messages.getString("ProcessPane.Resolve"), ApplicationHelper.getIcon(ApplicationHelper.icon_name_large_resolve)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    Action n = ProcessPane.this.actionSpinner.getSelectedAction();
                    if (n != null) {
                        n.setResolution(Action.Resolution.RESOLVED);
                    }
                }
            };
            this.resolveAction.setEnabled(false);
        }
        return this.resolveAction;
    }

    public void setEngine(GTDFreeEngine engine) {
        this.engine = engine;
        this.actionSpinner.setFolder(engine.getGTDModel().getInBucketFolder());
        this.folders.setEngine(this.getEngine());
        this.actionPanel.setEngine(engine);
        this.actionTable.setEngine(engine);
        this.actionSpinner.setEngine(engine);
        engine.addPropertyChangeListener("aborting", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ProcessPane.this.stopwatch.stop();
            }
        });
        engine.getGTDModel().addGTDModelListener(new GTDModelAdapter(){

            @Override
            public void elementRemoved(FolderEvent a) {
                ProcessPane.this.checkSelection();
                if (a.getFolder().isInBucket()) {
                    ProcessPane.this.checkLeft();
                }
            }

            @Override
            public void elementAdded(FolderEvent a) {
                ProcessPane.this.checkSelection();
                if (a.getFolder().isInBucket()) {
                    ProcessPane.this.checkLeft();
                }
            }

            @Override
            public void elementModified(org.gtdfree.model.ActionEvent a) {
                if (a.getAction().getParent().isInBucket()) {
                    ProcessPane.this.checkLeft();
                }
            }
        });
        this.checkSelection();
        this.checkLeft();
    }

    private void checkSelection() {
        if (this.actionTable.getSelectedAction() == null && this.actionTable.getRowCount() > 0) {
            this.actionTable.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private void checkLeft() {
        this.leftLabel.setText(Messages.getString("ProcessPane.Items") + " " + this.engine.getGTDModel().getInBucketFolder().getOpenCount());
    }

    public void store(GlobalProperties p) {
        p.putProperty("process.dividerLocation1", this.getDividerLocation());
        p.putProperty("process.dividerLocation2", this.split.getDividerLocation());
        p.putProperty("process.tree.openNodes", this.folders.getExpendedNodes());
        p.putProperty("organize.tree.foldingStates", this.folders.getFoldingStates());
    }

    public void restore(GlobalProperties p) {
        boolean[] bb;
        int[] ii;
        Integer i = p.getInteger("process.dividerLocation1");
        if (i != null) {
            this.setDividerLocation(i);
        }
        if ((i = p.getInteger("process.dividerLocation2")) != null) {
            this.split.setDividerLocation(i);
        }
        if ((ii = p.getIntegerArray("process.tree.openNodes")) != null) {
            this.folders.setExpendedNodes(ii);
        }
        if ((bb = p.getBooleanArray("organize.tree.foldingStates")) != null) {
            this.folders.setFoldingStates(bb);
        }
    }

    @Override
    public ActionsCollection getActionsInView() {
        return new ActionsCollection(this.actionTable);
    }

    public void printTable() throws PrinterException {
        if (this.actionTable.getFolder() != null) {
            this.actionTable.print(JTable.PrintMode.FIT_WIDTH, new MessageFormat("GTD-Free Data - " + this.actionTable.getFolder().getName() + " - " + ApplicationHelper.toISODateTimeString(new Date())), new MessageFormat("Page - {0}"));
        }
    }

    @Override
    public void initialize(GTDFreeEngine engine) {
        this.initialize();
        this.setEngine(engine);
        this.restore(engine.getGlobalProperties());
    }

    @Override
    public boolean isInitialized() {
        return this.engine != null;
    }

    @Override
    public Folder getSelectedFolder() {
        return this.folders.getSelectedFolder();
    }
}

