/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.gui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.gtdfree.ApplicationHelper;
import org.gtdfree.Messages;
import org.gtdfree.model.Priority;

public class PriorityPicker
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Icon yellow = ApplicationHelper.getIcon("icons/Neu/12x12/actions/help-about.png");
    private static final Icon orange = ApplicationHelper.getIcon("icons/Neu/12x12/actions/help-about-orange.png");
    private static final Icon red = ApplicationHelper.getIcon("icons/Neu/12x12/actions/help-about-red.png");
    private static final Icon grey = ApplicationHelper.getIcon("icons/Neu/12x12/actions/help-about-grey.png");
    private static final Icon blue = ApplicationHelper.getIcon("icons/Neu/12x12/actions/help-about-blue.png");
    private static final int star_size = 12;
    public static final String PRIORITY_PROPERTY_NAME = "priority";
    private Priority priority = Priority.None;
    private Priority hover;

    public static void main(String[] args) {
        JFrame f = new JFrame();
        PriorityPicker p = new PriorityPicker();
        f.setContentPane(p);
        f.pack();
        f.setVisible(true);
    }

    public PriorityPicker() {
        Dimension d = new Dimension(45, 15);
        this.setMinimumSize(d);
        this.setPreferredSize(d);
        MouseAdapter ma = new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                PriorityPicker.this.callHover(e.getPoint(), true);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!PriorityPicker.this.isEnabled()) {
                    return;
                }
                int q = PriorityPicker.this.getWidth() / 3;
                if (e.getX() < q) {
                    if (PriorityPicker.this.priority == Priority.Low) {
                        PriorityPicker.this.setPriority(Priority.None);
                    } else {
                        PriorityPicker.this.setPriority(Priority.Low);
                    }
                } else if (e.getX() < q * 2) {
                    if (PriorityPicker.this.priority == Priority.Medium) {
                        PriorityPicker.this.setPriority(Priority.None);
                    } else {
                        PriorityPicker.this.setPriority(Priority.Medium);
                    }
                } else if (PriorityPicker.this.priority == Priority.High) {
                    PriorityPicker.this.setPriority(Priority.None);
                } else {
                    PriorityPicker.this.setPriority(Priority.High);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (!PriorityPicker.this.isEnabled()) {
                    return;
                }
                PriorityPicker.this.setHover(null, true);
            }
        };
        this.addMouseListener(ma);
        this.addMouseMotionListener(ma);
    }

    public void setPriority(Priority priority) {
        if (this.priority == priority) {
            return;
        }
        Priority old = this.priority;
        this.priority = priority;
        this.firePropertyChange(PRIORITY_PROPERTY_NAME, (Object)old, (Object)priority);
        this.setToolTipText(Messages.getString("PriorityPicker.Priority") + " " + (Object)((Object)priority));
        this.repaint();
    }

    public Priority getPriority() {
        return this.priority;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int space = (this.getWidth() - 36) / 6;
        int top = (this.getHeight() - 12) / 2;
        Icon i1 = grey;
        Icon i2 = grey;
        Icon i3 = grey;
        if (this.hover != null && this.isEnabled()) {
            if (this.hover.ordinal() > 0) {
                i1 = blue;
            }
            if (this.hover.ordinal() > 1) {
                i2 = blue;
            }
            if (this.hover.ordinal() > 2) {
                i3 = blue;
            }
        } else if (this.priority != null && this.isEnabled()) {
            if (this.priority.ordinal() > 0) {
                i1 = yellow;
            }
            if (this.priority.ordinal() > 1) {
                i2 = orange;
            }
            if (this.priority.ordinal() > 2) {
                i3 = red;
            }
        }
        i1.paintIcon(this, g, space, top);
        i2.paintIcon(this, g, space * 3 + 12, top);
        i3.paintIcon(this, g, space * 5 + 24, top);
    }

    protected void callHover(Point p, boolean repaint) {
        if (!this.isEnabled()) {
            return;
        }
        int q = this.getWidth() / 3;
        if (p.getX() < (double)q) {
            this.setHover(Priority.Low, repaint);
        } else if (p.getX() < (double)(q * 2)) {
            this.setHover(Priority.Medium, repaint);
        } else {
            this.setHover(Priority.High, repaint);
        }
    }

    private void setHover(Priority hover, boolean repaint) {
        if (this.hover == hover) {
            return;
        }
        this.hover = hover;
        this.setToolTipText(Messages.getString("PriorityPicker.Priority") + " " + (Object)((Object)(hover != null ? hover : this.priority)));
        if (repaint) {
            this.repaint();
        }
    }
}

