/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class Monitor
extends JPanel {
    private static final long serialVersionUID = 1L;
    private long max;
    private long maxTotal;
    private LinkedList<Point> points;
    private JComponent graph;
    private JLabel label;
    protected boolean monitoring = true;
    private JFrame frame;

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setContentPane(new Monitor());
        f.setSize(300, 100);
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }

    public Monitor() {
        this.initialize();
    }

    private void initialize() {
        this.max = Runtime.getRuntime().maxMemory();
        this.points = new LinkedList();
        this.setLayout(new BorderLayout());
        this.graph = new JComponent(){
            private static final long serialVersionUID = 1L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void paintComponent(Graphics g) {
                Rectangle r = g.getClipBounds();
                g.setColor(Color.white);
                g.fillRect(r.x, r.y, r.width, r.height);
                LinkedList linkedList = Monitor.this.points;
                synchronized (linkedList) {
                    int i = 0;
                    for (Point p : Monitor.this.points) {
                        if (i >= r.width) break;
                        g.setColor(Color.green);
                        g.drawLine(r.x + i, r.height, r.x + i, r.y + r.height - (int)((long)r.height * p.total / Monitor.this.maxTotal));
                        g.setColor(Color.gray);
                        g.drawLine(r.x + i, r.height, r.x + i, r.y + r.height - (int)((long)r.height * (p.total - p.free) / Monitor.this.maxTotal));
                        ++i;
                    }
                }
            }
        };
        this.graph.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Monitor.this.trimPoints();
            }
        });
        this.add((Component)this.graph, "Center");
        this.label = new JLabel();
        this.add((Component)this.label, "South");
        new Thread(){
            protected Runnable task;

            @Override
            public synchronized void run() {
                while (Monitor.this.isMonitoring()) {
                    Monitor.this.updatePoints();
                    if (this.task == null) {
                        this.task = new Runnable(){

                            @Override
                            public void run() {
                                if (!Monitor.this.isMonitoring()) {
                                    return;
                                }
                                Monitor.this.updateDisplay();
                                task = null;
                            }
                        };
                        SwingUtilities.invokeLater(this.task);
                    }
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException e) {
                        Logger.getLogger(this.getClass()).debug("Internal error.", e);
                    }
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePoints() {
        LinkedList<Point> linkedList = this.points;
        synchronized (linkedList) {
            this.points.add(new Point());
            this.trimPoints();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trimPoints() {
        LinkedList<Point> linkedList = this.points;
        synchronized (linkedList) {
            while (this.points.size() > this.graph.getWidth()) {
                this.points.removeFirst();
            }
        }
    }

    private void updateDisplay() {
        if (this.points.isEmpty()) {
            return;
        }
        Point p = this.points.getLast();
        this.label.setText(" Used: " + (int)((p.total - p.free) / 1000000L) + "MB  Total: " + (int)(p.total / 1000000L) + "MB  Max: " + (int)(this.max / 1000000L) + "MB ");
        this.graph.repaint();
    }

    public JFrame getDialog() {
        if (this.frame == null) {
            this.frame = new JFrame("Memory Monitor");
            this.frame.setContentPane(this);
            this.frame.setSize(320, 100);
            this.frame.setLocationRelativeTo(null);
        }
        return this.frame;
    }

    public void close() {
        this.monitoring = false;
        if (this.frame != null) {
            this.frame.dispose();
        }
    }

    public boolean isMonitoring() {
        return this.monitoring;
    }

    class Point {
        private long free = Runtime.getRuntime().freeMemory();
        private long total = Runtime.getRuntime().totalMemory();

        public Point() {
            if (this.total > Monitor.this.maxTotal) {
                Monitor.this.maxTotal = this.total;
            }
        }
    }
}

