/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.gtdfree.gui.IntervalField;
import org.gtdfree.journal.Interval;
import org.gtdfree.journal.JournalEntry;
import org.gtdfree.journal.JournalEntryEvent;
import org.gtdfree.journal.JournalEntryListener;
import org.gtdfree.journal.JournalTools;

public class IntervalFieldPanel
extends JPanel
implements JournalEntryListener {
    private static final long serialVersionUID = 1L;
    private List<IntervalField> fields = new ArrayList<IntervalField>();
    private JournalEntry entry;

    public IntervalFieldPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
    }

    public IntervalField addInterval(Interval i) {
        this.entry.addInterval(i);
        IntervalField f = new IntervalField(this, this.entry, i);
        this.fields.add(f);
        this.add((Component)f, new GridBagConstraints(0, this.fields.size() - 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.checkLast();
        if (this.getParent() != null && this.getParent().getParent() != null) {
            this.getParent().getParent().validate();
        }
        return f;
    }

    public void removeField(IntervalField f) {
        this.fields.remove(f);
        this.remove(f);
        f.release();
        this.checkLast();
        this.validate();
    }

    public void setEntry(JournalEntry entry) {
        if (entry == this.entry) {
            return;
        }
        if (this.entry != null) {
            this.entry.removeJournalEntryListener(this);
            this.removeAll();
            for (IntervalField f : this.fields) {
                f.release();
            }
            this.fields.clear();
        }
        this.entry = entry;
        if (this.entry != null) {
            this.entry.addJournalEntryListener(this);
            this.removeAll();
            Interval[] ii = entry.getIntervals();
            if (ii == null || ii.length == 0) {
                int i = JournalTools.secondsOfDay();
                this.addInterval(new Interval(this.entry, i, i));
            } else {
                for (int i = 0; i < ii.length; ++i) {
                    IntervalField f = new IntervalField(this, entry, entry.getInterval(i));
                    this.fields.add(f);
                    this.add((Component)f, new GridBagConstraints(0, i, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
                }
            }
            this.checkLast();
        }
        this.validate();
    }

    private void checkLast() {
        this.fields.get(0).setRemoveEnabled(this.fields.size() > 1);
        this.setPreferredSize(new Dimension(this.fields.get((int)0).getPreferredSize().width, this.fields.get((int)0).getPreferredSize().height * this.fields.size()));
        this.setMinimumSize(this.getPreferredSize());
    }

    @Override
    public void journalEntryChanged(JournalEntryEvent e) {
    }

    @Override
    public void journalEntryIntervalAdded(JournalEntryEvent e) {
    }

    @Override
    public void journalEntryIntervalRemoved(JournalEntryEvent e) {
    }
}

