/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.gtdfree.ApplicationHelper;
import org.gtdfree.gui.IntervalFieldPanel;
import org.gtdfree.journal.Interval;
import org.gtdfree.journal.JournalEntry;
import org.gtdfree.journal.JournalEntryEvent;
import org.gtdfree.journal.JournalEntryListener;
import org.gtdfree.journal.JournalModel;
import org.gtdfree.journal.JournalTools;

public class IntervalField
extends JPanel
implements JournalEntryListener {
    private static final long serialVersionUID = 1L;
    private JournalEntry entry;
    private Interval interval;
    private JTextField field;
    private boolean setting;
    private IntervalFieldPanel parent;
    private boolean removeEnabled = true;
    private JButton removeButton;
    private Dimension minFieldSize;
    private static Interval activeInterval;
    private static Thread intervalUpdater;

    public IntervalField() {
    }

    public IntervalField(IntervalFieldPanel parent, JournalEntry entry, Interval interval) {
        this.initialize(parent, entry, interval);
    }

    private void initialize(IntervalFieldPanel parent, JournalEntry entry, Interval interval) {
        this.parent = parent;
        this.entry = entry;
        this.interval = interval;
        this.setLayout(new GridBagLayout());
        this.field = new JTextField();
        this.field.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                String s = ((JTextField)input).getText();
                return IntervalField.this.toInterval(IntervalField.this.interval, s);
            }
        });
        this.field.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IntervalField.this.setting = true;
                if (IntervalField.this.toInterval(IntervalField.this.interval, IntervalField.this.field.getText())) {
                    IntervalField.this.updateInterval();
                }
                IntervalField.this.setting = false;
            }
        });
        this.field.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                IntervalField.this.setting = true;
                IntervalField.this.toInterval(IntervalField.this.interval, IntervalField.this.field.getText());
                IntervalField.this.updateInterval();
                IntervalField.this.setting = false;
            }
        });
        this.add((Component)this.field, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        entry.addJournalEntryListener(this);
        JButton b = new JButton();
        b.setIcon(ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_add));
        b.setMargin(new Insets(0, 0, 0, 0));
        b.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                IntervalField newField = IntervalField.this.parent.addInterval(new Interval(IntervalField.this.entry, JournalTools.secondsOfDay(), JournalTools.secondsOfDay()));
                Thread thread = intervalUpdater;
                synchronized (thread) {
                    activeInterval = newField.interval;
                }
            }
        });
        this.add((Component)b, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 11, 0, 0), 0, 0));
        this.removeButton = new JButton();
        this.removeButton.setIcon(ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_remove));
        this.removeButton.setMargin(new Insets(0, 0, 0, 0));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IntervalField.this.entry.removeInterval(IntervalField.this.interval);
            }
        });
        this.add((Component)this.removeButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.updateInterval();
    }

    @Override
    public void journalEntryIntervalRemoved(JournalEntryEvent e) {
        if (e.getOldValue() == this.interval) {
            this.parent.remove(this);
            this.release();
        }
    }

    @Override
    public void journalEntryIntervalAdded(JournalEntryEvent e) {
    }

    @Override
    public void journalEntryChanged(JournalEntryEvent e) {
        if (e.getNewValue() == this.interval) {
            this.updateInterval();
        }
    }

    public void release() {
        this.entry.removeJournalEntryListener(this);
        this.entry = null;
        this.interval = null;
    }

    private String toString(Interval i) {
        return JournalModel.timeToString(i.getStart()) + " - " + JournalModel.timeToString(i.getEnd());
    }

    private boolean toInterval(Interval i, String s) {
        String[] startEnd = s.split("-");
        if (startEnd.length != 2) {
            return false;
        }
        int start = JournalModel.timeFromString(startEnd[0]);
        int end = JournalModel.timeFromString(startEnd[1]);
        if (start == -1 || end == -1) {
            return false;
        }
        i.setStart(start);
        i.setEnd(end);
        return true;
    }

    public void updateInterval() {
        if (!this.setting) {
            this.field.setText(this.toString(this.interval));
        }
        if (this.minFieldSize == null) {
            this.minFieldSize = new Dimension(this.field.getPreferredSize().width, this.removeButton.getPreferredSize().height);
            this.field.setMinimumSize(this.minFieldSize);
            this.field.setPreferredSize(this.minFieldSize);
            this.validate();
        }
    }

    public boolean isRemoveEnabled() {
        return this.removeEnabled;
    }

    public void setRemoveEnabled(boolean removeEnabled) {
        this.removeEnabled = removeEnabled;
        this.removeButton.setEnabled(removeEnabled);
    }

    static {
        intervalUpdater = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    while (true) {
                        Thread thread = intervalUpdater;
                        synchronized (thread) {
                            if (activeInterval == null) {
                                continue;
                            }
                            activeInterval.setEnd(JournalTools.secondsOfDay());
                        }
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        });
        intervalUpdater.setDaemon(true);
        intervalUpdater.start();
    }
}

