/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.gui;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;
import org.apache.log4j.Logger;
import org.gtdfree.ApplicationHelper;
import org.gtdfree.GTDFreeEngine;
import org.gtdfree.Messages;
import org.gtdfree.model.Folder;

public class InputTextArea
extends JTextArea {
    private static final long serialVersionUID = 1L;
    private UndoManager undoManager;
    private AbstractAction undoAction;
    private AbstractAction redoAction;
    private JPopupMenu popup;
    private AbstractAction selectionAsNewItem;
    private GTDFreeEngine engine;
    private AbstractAction selectionAsNewActionList;
    private AbstractAction selectionAsNewSomedayList;
    private AbstractAction selectionAsNewReferencelist;
    private AbstractAction selectionAsNewProject;

    public static void main(String[] args) {
        try {
            JFrame f = new JFrame();
            f.setContentPane(new JScrollPane(new InputTextArea()));
            f.setSize(500, 500);
            f.setLocationRelativeTo(null);
            f.setDefaultCloseOperation(3);
            f.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public InputTextArea() {
        this.initialize();
    }

    private void initialize() {
        this.setWrapStyleWord(true);
        this.setLineWrap(true);
        this.setMargin(new Insets(2, 4, 2, 4));
        InputMap imap = this.getInputMap();
        imap.put(KeyStroke.getKeyStroke(10, 64), "NewLine");
        imap.put(KeyStroke.getKeyStroke(10, 128), "NewLine");
        imap.put(KeyStroke.getKeyStroke(90, 128), "Undo");
        imap.put(KeyStroke.getKeyStroke(89, 128), "Redo");
        ActionMap amap = this.getActionMap();
        amap.put("NewLine", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                InputTextArea.this.insert("\n", InputTextArea.this.getCaretPosition());
            }
        });
        this.undoManager = new UndoManager();
        this.undoManager.setLimit(100);
        this.undoAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    InputTextArea.this.undoManager.undo();
                }
                catch (Exception ex) {
                    Logger.getLogger(this.getClass()).debug("Internal error.", ex);
                }
                InputTextArea.this.updateUndoRedoActions();
            }
        };
        this.undoAction.putValue("Name", Messages.getString("InputTextArea.Undo"));
        this.undoAction.putValue("LongDescription", Messages.getString("InputTextArea.Undo.desc"));
        this.undoAction.putValue("SmallIcon", ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_undo));
        amap.put("Undo", this.undoAction);
        this.redoAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    InputTextArea.this.undoManager.redo();
                }
                catch (Exception ex) {
                    Logger.getLogger(this.getClass()).debug("Internal error.", ex);
                }
                InputTextArea.this.updateUndoRedoActions();
            }
        };
        this.redoAction.putValue("Name", Messages.getString("InputTextArea.Redo"));
        this.redoAction.putValue("LongDescription", Messages.getString("InputTextArea.Redo.desc"));
        this.redoAction.putValue("SmallIcon", ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_redo));
        amap.put("Redo", this.redoAction);
        this.getDocument().addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent e) {
                InputTextArea.this.undoManager.addEdit(e.getEdit());
                InputTextArea.this.updateUndoRedoActions();
            }
        });
        this.updateUndoRedoActions();
        JMenuItem jm = new JMenuItem();
        jm.setAction(amap.get("cut-to-clipboard"));
        jm.setText(Messages.getString("InputTextArea.Cut"));
        jm.setToolTipText(Messages.getString("InputTextArea.Cut.desc"));
        jm.setIcon(ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_cut));
        this.getPopupMenu().add(jm);
        jm = new JMenuItem();
        jm.setAction(amap.get("copy-to-clipboard"));
        jm.setText(Messages.getString("InputTextArea.Copy"));
        jm.setToolTipText(Messages.getString("InputTextArea.Copy.desc"));
        jm.setIcon(ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_copy));
        this.getPopupMenu().add(jm);
        jm = new JMenuItem();
        jm.setAction(amap.get("paste-from-clipboard"));
        jm.setText(Messages.getString("InputTextArea.Paste"));
        jm.setToolTipText(Messages.getString("InputTextArea.Paste.desc"));
        jm.setIcon(ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_paste));
        this.getPopupMenu().add(jm);
        jm = new JMenuItem();
        jm.setAction(amap.get("select-all"));
        jm.setText(Messages.getString("InputTextArea.SelAll"));
        jm.setToolTipText(Messages.getString("InputTextArea.SelAll.desc"));
        jm.setIcon(ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_select_all));
        this.getPopupMenu().add(jm);
        this.getPopupMenu().add(new JSeparator());
        this.getPopupMenu().add(this.undoAction);
        this.getPopupMenu().add(this.redoAction);
        this.getPopupMenu().add(new JSeparator());
        this.selectionAsNewItem = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (InputTextArea.this.getSelectedText() != null && InputTextArea.this.getSelectedText().length() > 0) {
                    InputTextArea.this.engine.getGTDModel().collectAction(InputTextArea.this.getSelectedText());
                }
            }
        };
        this.selectionAsNewItem.putValue("Name", Messages.getString("InputTextArea.NewItem"));
        this.selectionAsNewItem.putValue("LongDescription", Messages.getString("InputTextArea.NewItem.desc"));
        this.getPopupMenu().add(this.selectionAsNewItem);
        this.selectionAsNewActionList = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (InputTextArea.this.getSelectedText() != null && InputTextArea.this.getSelectedText().length() > 0) {
                    InputTextArea.this.engine.getGTDModel().createFolder(InputTextArea.this.getSelectedText(), Folder.FolderType.ACTION);
                }
            }
        };
        this.selectionAsNewActionList.putValue("Name", Messages.getString("InputTextArea.NewActionList"));
        this.selectionAsNewActionList.putValue("LongDescription", Messages.getString("InputTextArea.NewList.desc"));
        this.getPopupMenu().add(this.selectionAsNewActionList);
        this.selectionAsNewSomedayList = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (InputTextArea.this.getSelectedText() != null && InputTextArea.this.getSelectedText().length() > 0) {
                    InputTextArea.this.engine.getGTDModel().createFolder(InputTextArea.this.getSelectedText(), Folder.FolderType.SOMEDAY);
                }
            }
        };
        this.selectionAsNewSomedayList.putValue("Name", Messages.getString("InputTextArea.NewSomedayList"));
        this.selectionAsNewSomedayList.putValue("LongDescription", Messages.getString("InputTextArea.NewList.desc"));
        this.getPopupMenu().add(this.selectionAsNewSomedayList);
        this.selectionAsNewReferencelist = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (InputTextArea.this.getSelectedText() != null && InputTextArea.this.getSelectedText().length() > 0) {
                    InputTextArea.this.engine.getGTDModel().createFolder(InputTextArea.this.getSelectedText(), Folder.FolderType.REFERENCE);
                }
            }
        };
        this.selectionAsNewReferencelist.putValue("Name", Messages.getString("InputTextArea.NewReferenceList"));
        this.selectionAsNewReferencelist.putValue("LongDescription", Messages.getString("InputTextArea.NewList.desc"));
        this.getPopupMenu().add(this.selectionAsNewReferencelist);
        this.selectionAsNewProject = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (InputTextArea.this.getSelectedText() != null && InputTextArea.this.getSelectedText().length() > 0) {
                    InputTextArea.this.engine.getGTDModel().createFolder(InputTextArea.this.getSelectedText(), Folder.FolderType.PROJECT);
                }
            }
        };
        this.selectionAsNewProject.putValue("Name", Messages.getString("InputTextArea.NewProject"));
        this.selectionAsNewSomedayList.putValue("LongDescription", Messages.getString("InputTextArea.NewProject.desc"));
        this.getPopupMenu().add(this.selectionAsNewProject);
    }

    private void updateUndoRedoActions() {
        this.undoAction.setEnabled(this.undoManager.canUndo());
        this.redoAction.setEnabled(this.undoManager.canRedo());
    }

    private JPopupMenu getPopupMenu() {
        if (this.popup == null) {
            this.popup = new JPopupMenu();
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    InputTextArea.this.maybeShowPopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    InputTextArea.this.maybeShowPopup(e);
                }
            });
        }
        return this.popup;
    }

    private void maybeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            boolean b = this.getSelectedText() != null && this.getSelectedText().length() > 0;
            this.selectionAsNewActionList.setEnabled(b);
            this.selectionAsNewItem.setEnabled(b);
            this.selectionAsNewProject.setEnabled(b);
            this.selectionAsNewReferencelist.setEnabled(b);
            this.selectionAsNewSomedayList.setEnabled(b);
            this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void clearUndoHistory() {
        this.undoManager.discardAllEdits();
    }

    public void setEngine(GTDFreeEngine engine) {
        this.engine = engine;
    }
}

