/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.gui;

import de.wannawork.jcalendar.JCalendarComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.gtdfree.ApplicationHelper;
import org.gtdfree.GTDFreeEngine;
import org.gtdfree.GlobalProperties;
import org.gtdfree.Messages;
import org.gtdfree.gui.ActionTable;
import org.gtdfree.gui.InputTextArea;
import org.gtdfree.gui.WorkflowPane;
import org.gtdfree.model.Action;
import org.gtdfree.model.ActionsCollection;
import org.gtdfree.model.Folder;
import org.gtdfree.model.FolderEvent;
import org.gtdfree.model.FolderListener;

public class InBasketPane
extends JPanel
implements WorkflowPane {
    private static final long serialVersionUID = 1L;
    private GTDFreeEngine engine;
    InputTextArea ideaText;
    private AbstractAction newNoteAction;
    private ActionTable noteTable;
    private Action selectedAction;
    private JLabel idLabel;
    private AbstractAction delAction;
    private AbstractAction clearAction;
    private boolean setting = false;
    private JCalendarComboBox datePicker;
    private FolderListener noteListener = new FolderListener(){

        @Override
        public void elementRemoved(FolderEvent note) {
        }

        @Override
        public void elementModified(org.gtdfree.model.ActionEvent note) {
            if (!InBasketPane.this.setting && InBasketPane.this.getSelectedAction() != null && !InBasketPane.this.getSelectedAction().getDescription().equals(InBasketPane.this.ideaText.getText())) {
                InBasketPane.this.setting = true;
                InBasketPane.this.ideaText.setText(InBasketPane.this.getSelectedAction().getDescription());
                InBasketPane.this.ideaText.clearUndoHistory();
                InBasketPane.this.setting = false;
            }
        }

        @Override
        public void elementAdded(FolderEvent note) {
        }

        @Override
        public void orderChanged(Folder f) {
        }
    };
    private AbstractAction cloneNoteAction;
    private AbstractAction doneNoteAction;
    private JSplitPane split;
    private boolean adding;
    private JButton clearDateButton;

    public Action getSelectedAction() {
        return this.selectedAction;
    }

    public void setSelectedAction(Action selectedAction) {
        if (this.adding) {
            return;
        }
        if (this.selectedAction == null && this.ideaText.getDocument().getLength() > 0 && !this.adding) {
            this.adding = true;
            this.getEngine().getGTDModel().createAction(this.noteTable.getFolder(), this.ideaText.getText());
            this.noteTable.setSelectedAction(selectedAction);
            this.adding = false;
        }
        this.selectedAction = selectedAction;
        if (selectedAction == null) {
            this.setting = true;
            this.idLabel.setText(Messages.getString("ActionPanel.ID") + Messages.getString("ActionPanel.NA"));
            this.ideaText.setText("");
            this.ideaText.clearUndoHistory();
            this.datePicker.setDate(null);
            this.datePicker.setEnabled(false);
            this.clearDateButton.setEnabled(false);
            this.getCloneNoteAction().setEnabled(false);
            this.getDeleteAction().setEnabled(false);
            this.getDoneNoteAction().setEnabled(true);
            this.getNewNoteAction().setEnabled(false);
            this.setting = false;
        } else {
            this.setting = true;
            this.idLabel.setText(Messages.getString("ActionPanel.ID") + selectedAction.getId());
            this.ideaText.setText(selectedAction.getDescription());
            this.ideaText.setCaretPosition(0);
            this.ideaText.clearUndoHistory();
            this.datePicker.setDate(selectedAction.getRemind());
            this.datePicker.setEnabled(true);
            this.clearDateButton.setEnabled(true);
            this.getCloneNoteAction().setEnabled(true);
            this.getDeleteAction().setEnabled(true);
            this.getDoneNoteAction().setEnabled(false);
            this.getNewNoteAction().setEnabled(true);
            this.setting = false;
        }
    }

    private void initialize() {
        this.split = new JSplitPane();
        this.split.setOrientation(0);
        this.split.setOneTouchExpandable(true);
        JPanel jp = new JPanel();
        jp.setLayout(new GridBagLayout());
        jp.setBorder(new TitledBorder(Messages.getString("InBasketPane.ActionTitle")));
        this.idLabel = new JLabel(Messages.getString("ActionPanel.ID") + Messages.getString("ActionPanel.NA"));
        jp.add((Component)this.idLabel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 4, 0, 4), 0, 0));
        JScrollPane jsp = new JScrollPane();
        this.ideaText = new InputTextArea();
        this.ideaText.setRows(3);
        this.ideaText.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "Enter");
        this.ideaText.getActionMap().put("Enter", new AbstractAction(){
            private static final long serialVersionUID = 1348070910974195411L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (InBasketPane.this.getDoneNoteAction().isEnabled()) {
                    InBasketPane.this.getDoneNoteAction().actionPerformed(e);
                } else {
                    InBasketPane.this.getNewNoteAction().actionPerformed(e);
                }
            }
        });
        this.ideaText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                InBasketPane.this.updateSelectedAction();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                InBasketPane.this.updateSelectedAction();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                InBasketPane.this.updateSelectedAction();
            }
        });
        jsp.setViewportView(this.ideaText);
        jsp.setMinimumSize(this.ideaText.getPreferredScrollableViewportSize());
        jsp.setPreferredSize(this.ideaText.getPreferredScrollableViewportSize());
        jp.add((Component)jsp, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 4, 0, 4), 0, 0));
        JPanel pp = new JPanel();
        pp.setLayout(new GridBagLayout());
        this.datePicker = new JCalendarComboBox(){
            private static final long serialVersionUID = 1L;
            Dimension d = null;

            @Override
            public Dimension getPreferredSize() {
                int w;
                if (this.d == null) {
                    Insets in = ApplicationHelper.getDefaultSlimButtonMargin();
                    this.d = new Dimension(super.getPreferredSize().width + 6, super.getPreferredSize().height + in.top + in.bottom - 4);
                }
                if ((w = super.getPreferredSize().width + 6) > this.d.width) {
                    this.d = new Dimension(w, this.d.height);
                }
                return this.d;
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.datePicker.setDateFormat(ApplicationHelper.defaultDateFormat);
        Dimension d = new Dimension(this.datePicker.getPreferredSize().height, this.datePicker.getPreferredSize().height);
        this.datePicker.setDate(null);
        this.datePicker.setSpiningCalendarField(5);
        this.datePicker.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (InBasketPane.this.setting) {
                    return;
                }
                if (InBasketPane.this.selectedAction != null) {
                    InBasketPane.this.selectedAction.setRemind(InBasketPane.this.datePicker.getDate());
                }
            }
        });
        pp.add((Component)this.datePicker, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 2), 0, 0));
        this.clearDateButton = new JButton();
        this.clearDateButton.setMargin(ApplicationHelper.getDefaultSlimButtonMargin());
        this.clearDateButton.setToolTipText(Messages.getString("ActionPanel.Clear"));
        this.clearDateButton.setIcon(ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_clear));
        this.clearDateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InBasketPane.this.datePicker.setDate(null);
            }
        });
        pp.add((Component)this.clearDateButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jp.add((Component)pp, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(2, 4, 0, 4), 0, 0));
        JPanel jp1 = new JPanel();
        jp1.setLayout(new GridBagLayout());
        JButton b = new JButton();
        b.setAction(this.getNewNoteAction());
        b.setMargin(ApplicationHelper.getDefaultFatButtonMargin());
        jp1.add((Component)b, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        b = new JButton();
        b.setMargin(ApplicationHelper.getDefaultFatButtonMargin());
        b.setAction(this.getDoneNoteAction());
        jp1.add((Component)b, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        b = new JButton();
        b.setMargin(ApplicationHelper.getDefaultFatButtonMargin());
        b.setAction(this.getCloneNoteAction());
        jp1.add((Component)b, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        b = new JButton();
        b.setMargin(ApplicationHelper.getDefaultFatButtonMargin());
        b.setAction(this.getClearAction());
        jp1.add((Component)b, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        b = new JButton();
        b.setMargin(ApplicationHelper.getDefaultFatButtonMargin());
        b.setAction(this.getDeleteAction());
        jp1.add((Component)b, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        jp.add((Component)jp1, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.split.setTopComponent(jp);
        this.noteTable = new ActionTable();
        this.noteTable.setShowQueueColumn(false);
        this.noteTable.setSingleSelectionMode(true);
        this.noteTable.setCellAction(ActionTable.CellAction.DELETE);
        this.noteTable.addPropertyChangeListener("selectedActions", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                InBasketPane.this.setSelectedAction(InBasketPane.this.noteTable.getSelectedAction());
            }
        });
        jp = new JPanel();
        jp.setBorder(new TitledBorder(Messages.getString("InBasketPane.InBasketTitle")));
        jp.setLayout(new BorderLayout());
        jsp = new JScrollPane();
        jsp.setViewportView(this.noteTable);
        jp.add(jsp);
        this.split.setBottomComponent(jp);
        this.setLayout(new BorderLayout());
        this.add(this.split);
        this.setSelectedAction(null);
    }

    private javax.swing.Action getDeleteAction() {
        if (this.delAction == null) {
            this.delAction = new AbstractAction(Messages.getString("ActionPanel.Delete"), ApplicationHelper.getIcon(ApplicationHelper.icon_name_large_delete)){
                private static final long serialVersionUID = 0L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (InBasketPane.this.selectedAction != null) {
                        InBasketPane.this.selectedAction.setResolution(Action.Resolution.DELETED);
                    }
                }
            };
            this.delAction.putValue("ShortDescription", Messages.getString("ActionPanel.Delete.desc"));
            this.delAction.setEnabled(false);
        }
        return this.delAction;
    }

    private javax.swing.Action getClearAction() {
        if (this.clearAction == null) {
            this.clearAction = new AbstractAction(Messages.getString("InBasketPane.Clear"), ApplicationHelper.getIcon(ApplicationHelper.icon_name_large_clear)){
                private static final long serialVersionUID = -6062912427153528136L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    InBasketPane.this.ideaText.setText("");
                    InBasketPane.this.ideaText.clearUndoHistory();
                    InBasketPane.this.ideaText.requestFocus();
                }
            };
            this.clearAction.putValue("ShortDescription", Messages.getString("InBasketPane.Clear.desc"));
            this.clearAction.setEnabled(true);
        }
        return this.clearAction;
    }

    private void updateSelectedAction() {
        if (!this.setting && this.selectedAction != null && this.ideaText.getText() != null && !this.ideaText.getText().equals(this.selectedAction.getDescription())) {
            this.setting = true;
            this.selectedAction.setDescription(this.ideaText.getText());
            this.setting = false;
        }
    }

    private javax.swing.Action getNewNoteAction() {
        if (this.newNoteAction == null) {
            this.newNoteAction = new AbstractAction(Messages.getString("InBasketPane.New"), ApplicationHelper.getIcon(ApplicationHelper.icon_name_large_new)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    InBasketPane.this.noteTable.getSelectionModel().clearSelection();
                    InBasketPane.this.ideaText.setText("");
                    InBasketPane.this.ideaText.clearUndoHistory();
                }
            };
            this.newNoteAction.putValue("ShortDescription", Messages.getString("InBasketPane.New.desc"));
        }
        return this.newNoteAction;
    }

    private javax.swing.Action getDoneNoteAction() {
        if (this.doneNoteAction == null) {
            this.doneNoteAction = new AbstractAction(Messages.getString("InBasketPane.Add"), ApplicationHelper.getIcon(ApplicationHelper.icon_name_large_add)){
                private static final long serialVersionUID = 5246080843920948091L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (InBasketPane.this.ideaText.getText() == null || InBasketPane.this.ideaText.getText().length() == 0) {
                        return;
                    }
                    InBasketPane.this.adding = true;
                    InBasketPane.this.getEngine().getGTDModel().createAction(InBasketPane.this.noteTable.getFolder(), InBasketPane.this.ideaText.getText());
                    InBasketPane.this.noteTable.getSelectionModel().clearSelection();
                    InBasketPane.this.ideaText.setText("");
                    InBasketPane.this.ideaText.clearUndoHistory();
                    InBasketPane.this.adding = false;
                }
            };
            this.doneNoteAction.putValue("ShortDescription", Messages.getString("InBasketPane.Add.desc"));
        }
        return this.doneNoteAction;
    }

    private javax.swing.Action getCloneNoteAction() {
        if (this.cloneNoteAction == null) {
            this.cloneNoteAction = new AbstractAction(Messages.getString("InBasketPane.Clone"), ApplicationHelper.getIcon(ApplicationHelper.icon_name_large_clone)){
                private static final long serialVersionUID = 5246080843920948091L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    InBasketPane.this.getEngine().getGTDModel().createAction(InBasketPane.this.noteTable.getFolder(), InBasketPane.this.ideaText.getText());
                    InBasketPane.this.noteTable.getSelectionModel().setSelectionInterval(0, 0);
                }
            };
            this.cloneNoteAction.putValue("ShortDescription", Messages.getString("InBasketPane.Clone.desc"));
        }
        return this.cloneNoteAction;
    }

    public void setEngine(GTDFreeEngine engine) {
        this.engine = engine;
        Folder folder = engine.getGTDModel().getInBucketFolder();
        this.noteTable.setEngine(engine);
        this.noteTable.setFolder(folder);
        this.ideaText.setEngine(engine);
        folder.addFolderListener(this.noteListener);
    }

    public GTDFreeEngine getEngine() {
        return this.engine;
    }

    public void store(GlobalProperties p) {
        p.putProperty("inbasket.dividerLocation", this.split.getDividerLocation());
    }

    public void restore(GlobalProperties p) {
        Integer i = p.getInteger("inbasket.dividerLocation");
        if (i != null) {
            this.split.setDividerLocation(i);
        }
    }

    @Override
    public ActionsCollection getActionsInView() {
        return new ActionsCollection(this.noteTable);
    }

    public void printTable() throws PrinterException {
        this.noteTable.print(JTable.PrintMode.FIT_WIDTH, new MessageFormat("GTD-Free Data - In-Bucket - " + ApplicationHelper.toISODateTimeString(new Date())), new MessageFormat("Page - {0}"));
    }

    @Override
    public void initialize(GTDFreeEngine engine) {
        this.initialize();
        this.setEngine(engine);
        this.restore(engine.getGlobalProperties());
    }

    @Override
    public boolean isInitialized() {
        return this.engine != null;
    }

    @Override
    public Folder getSelectedFolder() {
        return this.noteTable.getFolder();
    }
}

