/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.gtdfree.ApplicationHelper;
import org.gtdfree.GTDFreeEngine;
import org.gtdfree.Messages;
import org.gtdfree.gui.ActionTransferHandler;
import org.gtdfree.model.Action;
import org.gtdfree.model.Folder;
import org.gtdfree.model.FolderEvent;
import org.gtdfree.model.GTDModel;
import org.gtdfree.model.GTDModelListener;
import org.gtdfree.model.Project;

public class FolderTree
extends JTree {
    private static final long serialVersionUID = 1L;
    private GTDModel gtdModel;
    private GTDFreeEngine engine;
    private DefaultMutableTreeNode root;
    private DefaultTreeModel model;
    private SortedTreeNode actions;
    private SortedTreeNode meta;
    private SortedTreeNode references;
    private SortedTreeNode projects;
    private SortedTreeNode someday;
    private Folder selectedFolder;
    private boolean defaultFoldersVisible = true;
    private boolean showClosedFolders = false;
    private ActionTransferHandler transferHandler;
    private boolean showEmptyFolders = true;
    private JPopupMenu popupMenu;
    private AbstractAction deleteAllAction;
    private AbstractAction unqueueAllAction;
    private AbstractAction queueAllAction;
    private AbstractAction resolveAllAction;
    private AbstractAction renameListAction;
    private AbstractAction renameProjectAction;
    private AbstractAction addProjectAction;
    private AbstractAction addListAction;
    private AbstractAction addReferenceListAction;
    private AbstractAction addSomedayListAction;
    private AbstractAction closeListAction;
    private AbstractAction closeProjectAction;
    private int lastDroppedActionIndex = -1;

    public Folder getSelectedFolder() {
        return this.selectedFolder;
    }

    public FolderTree() {
        this.initialize();
    }

    private void initialize() {
        this.root = new DefaultMutableTreeNode(null, true);
        this.model = new DefaultTreeModel(this.root, true);
        this.setModel(this.model);
        this.setRootVisible(false);
        this.setExpandsSelectedPaths(true);
        this.setToggleClickCount(0);
        this.setEditable(true);
        this.setShowsRootHandles(true);
        this.actions = new SortedTreeNode(Messages.getString("FolderTree.Act"), true);
        this.meta = new SortedTreeNode(Messages.getString("FolderTree.Def"), true);
        this.references = new SortedTreeNode(Messages.getString("FolderTree.Ref"), true);
        this.someday = new SortedTreeNode(Messages.getString("FolderTree.Some"), true);
        this.projects = new SortedTreeNode(Messages.getString("FolderTree.Proj"), true);
        this.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                Folder old = FolderTree.this.selectedFolder;
                FolderTree.this.selectedFolder = null;
                if (e.getNewLeadSelectionPath() != null) {
                    FolderTree.this.selectedFolder = FolderTree.this.treePath2Folder(e.getNewLeadSelectionPath());
                }
                FolderTree.this.firePropertyChange("selectedFolder", old, FolderTree.this.selectedFolder);
            }
        });
        this.setCellRenderer(new FolderTreeCellRenderer());
        this.setCellEditor(new FolderTreeCellEditor(this, (DefaultTreeCellRenderer)this.getCellRenderer()));
        this.transferHandler = new FolderTreeTransferHandler();
        this.setTransferHandler(this.transferHandler);
        this.addMouseListener(new MouseAdapter(){

            private void popup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    TreePath t = FolderTree.this.getClosestPathForLocation(e.getPoint().x, e.getPoint().y);
                    FolderTree.this.showPopup(t, e.getPoint());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                TreePath t = FolderTree.this.getClosestPathForLocation(e.getPoint().x, e.getPoint().y);
                FolderTree.this.setSelectionPath(t);
                this.popup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                TreePath t = FolderTree.this.getClosestPathForLocation(e.getPoint().x, e.getPoint().y);
                FolderTree.this.setSelectionPath(t);
                this.popup(e);
            }
        });
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                TreePath tp = event.getPath();
                Enumeration<TreeNode> en = ((DefaultMutableTreeNode)tp.getLastPathComponent()).children();
                while (en.hasMoreElements()) {
                    DefaultMutableTreeNode n = (DefaultMutableTreeNode)en.nextElement();
                    Object o = n.getUserObject();
                    if (!(o instanceof Folder)) continue;
                    FolderTree.this.checkIfShow((Folder)o);
                }
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        this.rebuildTree();
    }

    public Folder treePath2Folder(TreePath tp) {
        Object o = ((DefaultMutableTreeNode)tp.getLastPathComponent()).getUserObject();
        if (o instanceof Folder) {
            return (Folder)o;
        }
        return null;
    }

    protected void showPopup(TreePath t, Point point) {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
        }
        this.popupMenu.removeAll();
        Folder f = this.treePath2Folder(t);
        if (f != null) {
            if (f.isProject()) {
                this.popupMenu.add(this.getRenameProjectAction());
                this.popupMenu.add(this.getAddProjectAction());
                this.popupMenu.add(this.getCloseProjectAction());
                this.getCloseProjectAction().setEnabled(f.getOpenCount() == 0);
                this.popupMenu.add(new JSeparator());
            } else if (!f.isDefault()) {
                this.popupMenu.add(this.getRenameListAction());
                if (f.isReference()) {
                    this.popupMenu.add(this.getAddReferenceListAction());
                } else if (f.isSomeday()) {
                    this.popupMenu.add(this.getAddSomedayListAction());
                } else {
                    this.popupMenu.add(this.getAddListAction());
                }
                this.popupMenu.add(this.getCloseListAction());
                this.getCloseListAction().setEnabled(f.getOpenCount() == 0);
                this.popupMenu.add(new JSeparator());
            }
            if (!f.isQueue() && !f.isInBucket() && f.getType() != Folder.FolderType.BUILDIN_RESOLVED && f.getType() != Folder.FolderType.BUILDIN_DELETED) {
                this.popupMenu.add(this.getQueueAllAction());
            }
            if (!f.isInBucket() && f.getType() != Folder.FolderType.BUILDIN_RESOLVED && f.getType() != Folder.FolderType.BUILDIN_DELETED) {
                this.popupMenu.add(this.getUnqueueAllAction());
            }
            if (f.getType() != Folder.FolderType.BUILDIN_RESOLVED && f.getType() != Folder.FolderType.BUILDIN_DELETED) {
                this.popupMenu.add(this.getResolveAllAction());
            }
            if (f.getType() != Folder.FolderType.BUILDIN_DELETED) {
                this.popupMenu.add(this.getDeleteAllAction());
            }
        } else if (t.getPathCount() > 0) {
            Object o = t.getPathComponent(1);
            if (o == this.actions) {
                this.popupMenu.add(this.getAddListAction());
            } else if (o == this.someday) {
                this.popupMenu.add(this.getAddSomedayListAction());
            } else if (o == this.references) {
                this.popupMenu.add(this.getAddReferenceListAction());
            } else if (o == this.projects) {
                this.popupMenu.add(this.getAddProjectAction());
            }
        }
        this.popupMenu.show(this, point.x, point.y);
    }

    private javax.swing.Action getAddProjectAction() {
        if (this.addProjectAction == null) {
            this.addProjectAction = new AbstractAction(Messages.getString("FolderTree.AddProject"), ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_add)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    Folder f = FolderTree.this.getGTDModel().createFolder("", Folder.FolderType.PROJECT);
                    for (int i = 0; i < FolderTree.this.getRowCount(); ++i) {
                        TreePath tp = FolderTree.this.getPathForRow(i);
                        if (tp != null && tp.getLastPathComponent() == FolderTree.this.projects) {
                            FolderTree.this.expandRow(i);
                            continue;
                        }
                        if (tp == null || !(tp.getLastPathComponent() instanceof FolderTreeNode) || ((FolderTreeNode)tp.getLastPathComponent()).getUserObject() != f) continue;
                        FolderTree.this.startEditingAtPath(tp);
                        return;
                    }
                }
            };
        }
        return this.addProjectAction;
    }

    private javax.swing.Action getAddListAction() {
        if (this.addListAction == null) {
            this.addListAction = new AbstractAction(Messages.getString("FolderTree.AddList"), ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_add)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    Folder f = FolderTree.this.getGTDModel().createFolder("", Folder.FolderType.ACTION);
                    for (int i = 0; i < FolderTree.this.getRowCount(); ++i) {
                        TreePath tp = FolderTree.this.getPathForRow(i);
                        if (tp != null && tp.getLastPathComponent() == FolderTree.this.actions) {
                            FolderTree.this.expandRow(i);
                            continue;
                        }
                        if (tp == null || !(tp.getLastPathComponent() instanceof FolderTreeNode) || ((FolderTreeNode)tp.getLastPathComponent()).getUserObject() != f) continue;
                        FolderTree.this.startEditingAtPath(tp);
                        return;
                    }
                }
            };
        }
        return this.addListAction;
    }

    private javax.swing.Action getAddReferenceListAction() {
        if (this.addReferenceListAction == null) {
            this.addReferenceListAction = new AbstractAction(Messages.getString("FolderTree.AddRefList"), ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_add)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    Folder f = FolderTree.this.getGTDModel().createFolder("", Folder.FolderType.REFERENCE);
                    for (int i = 0; i < FolderTree.this.getRowCount(); ++i) {
                        TreePath tp = FolderTree.this.getPathForRow(i);
                        if (tp != null && tp.getLastPathComponent() == FolderTree.this.references) {
                            FolderTree.this.expandRow(i);
                            continue;
                        }
                        if (tp == null || !(tp.getLastPathComponent() instanceof FolderTreeNode) || ((FolderTreeNode)tp.getLastPathComponent()).getUserObject() != f) continue;
                        FolderTree.this.startEditingAtPath(tp);
                        return;
                    }
                }
            };
        }
        return this.addReferenceListAction;
    }

    private javax.swing.Action getAddSomedayListAction() {
        if (this.addSomedayListAction == null) {
            this.addSomedayListAction = new AbstractAction(Messages.getString("FolderTree.AddSomeList"), ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_add)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    Folder f = FolderTree.this.getGTDModel().createFolder("", Folder.FolderType.SOMEDAY);
                    for (int i = 0; i < FolderTree.this.getRowCount(); ++i) {
                        TreePath tp = FolderTree.this.getPathForRow(i);
                        if (tp != null && tp.getLastPathComponent() == FolderTree.this.someday) {
                            FolderTree.this.expandRow(i);
                            continue;
                        }
                        if (tp == null || !(tp.getLastPathComponent() instanceof FolderTreeNode) || ((FolderTreeNode)tp.getLastPathComponent()).getUserObject() != f) continue;
                        FolderTree.this.startEditingAtPath(tp);
                        return;
                    }
                }
            };
        }
        return this.addSomedayListAction;
    }

    private javax.swing.Action getResolveAllAction() {
        if (this.resolveAllAction == null) {
            this.resolveAllAction = new AbstractAction(Messages.getString("FolderTree.ResolveActions"), ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_resolve)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    Iterator<Action> i = FolderTree.this.getSelectedFolder().iterator(Folder.FolderPreset.OPEN);
                    while (i.hasNext()) {
                        Action a = i.next();
                        a.setResolution(Action.Resolution.RESOLVED);
                    }
                }
            };
        }
        return this.resolveAllAction;
    }

    private javax.swing.Action getUnqueueAllAction() {
        if (this.unqueueAllAction == null) {
            this.unqueueAllAction = new AbstractAction(Messages.getString("FolderTree.UnqueueActions"), ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_queue_off)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    Iterator<Action> i = FolderTree.this.getSelectedFolder().iterator(Folder.FolderPreset.OPEN);
                    while (i.hasNext()) {
                        Action a = i.next();
                        a.setQueued(false);
                    }
                }
            };
        }
        return this.unqueueAllAction;
    }

    private javax.swing.Action getQueueAllAction() {
        if (this.queueAllAction == null) {
            this.queueAllAction = new AbstractAction(Messages.getString("FolderTree.QueueActions"), ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_queue_on)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    Iterator<Action> i = FolderTree.this.getSelectedFolder().iterator(Folder.FolderPreset.OPEN);
                    while (i.hasNext()) {
                        Action a = i.next();
                        a.setQueued(true);
                    }
                }
            };
        }
        return this.queueAllAction;
    }

    private javax.swing.Action getRenameListAction() {
        if (this.renameListAction == null) {
            this.renameListAction = new AbstractAction(Messages.getString("FolderTree.RenameList"), ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_rename)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    FolderTree.this.startEditingAtPath(FolderTree.this.getSelectionPath());
                }
            };
        }
        return this.renameListAction;
    }

    private javax.swing.Action getCloseListAction() {
        if (this.closeListAction == null) {
            this.closeListAction = new AbstractAction(Messages.getString("FolderTree.CloseList"), ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_resolve)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (FolderTree.this.getSelectedFolder().getOpenCount() == 0) {
                        FolderTree.this.getSelectedFolder().setClosed(true);
                    }
                }
            };
        }
        return this.closeListAction;
    }

    private javax.swing.Action getCloseProjectAction() {
        if (this.closeProjectAction == null) {
            this.closeProjectAction = new AbstractAction(Messages.getString("FolderTree.CloseProject"), ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_resolve)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (FolderTree.this.getSelectedFolder().getOpenCount() == 0) {
                        FolderTree.this.getSelectedFolder().setClosed(true);
                    }
                }
            };
        }
        return this.closeProjectAction;
    }

    private javax.swing.Action getRenameProjectAction() {
        if (this.renameProjectAction == null) {
            this.renameProjectAction = new AbstractAction(Messages.getString("FolderTree.RenameProject"), ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_rename)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    FolderTree.this.startEditingAtPath(FolderTree.this.getSelectionPath());
                }
            };
        }
        return this.renameProjectAction;
    }

    private javax.swing.Action getDeleteAllAction() {
        if (this.deleteAllAction == null) {
            this.deleteAllAction = new AbstractAction(Messages.getString("FolderTree.DeleteActions"), ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_delete)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    Iterator<Action> i = FolderTree.this.getSelectedFolder().iterator(Folder.FolderPreset.ALL);
                    while (i.hasNext()) {
                        Action a = i.next();
                        a.setResolution(Action.Resolution.DELETED);
                    }
                }
            };
        }
        return this.deleteAllAction;
    }

    GTDModel getGTDModel() {
        return this.gtdModel;
    }

    private void setGTDModel(GTDModel gtdModel) {
        this.gtdModel = gtdModel;
        this.transferHandler.setModel(gtdModel);
        gtdModel.addGTDModelListener(new GTDModelListener(){

            @Override
            public void elementRemoved(FolderEvent note) {
                FolderTree.this.model.nodeChanged(FolderTree.this.folderToNode(note.getFolder()));
                FolderTree.this.repaint();
            }

            @Override
            public void elementModified(org.gtdfree.model.ActionEvent note) {
                int[] i = new int[FolderTree.this.meta.getChildCount()];
                for (int j = 0; j < i.length; ++j) {
                    i[j] = j;
                }
                FolderTree.this.model.nodesChanged(FolderTree.this.meta, i);
                FolderTree.this.repaint();
                if (note.getProperty() == "resolution") {
                    HashSet<Integer> checked = new HashSet<Integer>();
                    for (Action a : note.getActions()) {
                        Folder f = a.getParent();
                        if (checked.contains(f.getId())) continue;
                        checked.add(f.getId());
                        FolderTree.this.checkIfShow(f);
                    }
                }
            }

            @Override
            public void elementAdded(FolderEvent note) {
                FolderTree.this.model.nodeChanged(FolderTree.this.folderToNode(note.getFolder()));
                FolderTree.this.repaint();
            }

            @Override
            public void folderRemoved(Folder folder) {
                FolderTree.this.removeFromTree(folder, true);
            }

            @Override
            public void folderModified(FolderEvent f) {
                if (f.getProperty() == "closed") {
                    FolderTree.this.checkIfShow(f.getFolder());
                } else if (f.getProperty() == "name") {
                    Folder sel = FolderTree.this.getSelectedFolder();
                    SortedTreeNode p = FolderTree.this.folderToParentNode(f.getFolder());
                    if (p != null) {
                        p.sort();
                        FolderTree.this.model.nodeStructureChanged(p);
                    }
                    if (sel != null) {
                        FolderTree.this.setSelectedFolder(sel, -1);
                    }
                } else {
                    DefaultMutableTreeNode p = FolderTree.this.folderToNode(f.getFolder());
                    if (p != null) {
                        FolderTree.this.model.nodeChanged(p);
                    }
                }
                FolderTree.this.repaint();
            }

            @Override
            public void folderAdded(Folder folder) {
                FolderTree.this.addToTree(folder, true);
            }

            @Override
            public void orderChanged(Folder f) {
            }
        });
        this.rebuildTree();
    }

    private void rebuildTree() {
        boolean rootChange = false;
        int pos = 0;
        if (this.root.getChildCount() > pos && this.root.getChildAt(pos) != this.actions) {
            this.root.removeAllChildren();
            rootChange = true;
        }
        if (this.root.getChildCount() == pos) {
            this.root.add(this.actions);
            rootChange = true;
        }
        ++pos;
        if (this.defaultFoldersVisible) {
            while (this.root.getChildCount() > pos && this.root.getChildAt(pos) != this.meta) {
                this.root.remove(this.root.getChildCount() - 1);
                rootChange = true;
            }
            if (this.root.getChildCount() == pos) {
                this.root.add(this.meta);
                rootChange = true;
            }
            ++pos;
            while (this.root.getChildCount() > pos && this.root.getChildAt(pos) != this.projects) {
                this.root.remove(this.root.getChildCount() - 1);
                rootChange = true;
            }
            if (this.root.getChildCount() == pos) {
                this.root.add(this.projects);
                rootChange = true;
            }
            ++pos;
        }
        while (this.root.getChildCount() > pos && this.root.getChildAt(pos) != this.someday) {
            this.root.remove(this.root.getChildCount() - 1);
            rootChange = true;
        }
        if (this.root.getChildCount() == pos) {
            this.root.add(this.someday);
            rootChange = true;
        }
        ++pos;
        while (this.root.getChildCount() > pos && this.root.getChildAt(pos) != this.references) {
            this.root.remove(this.root.getChildCount() - 1);
            rootChange = true;
        }
        if (this.root.getChildCount() == pos) {
            this.root.add(this.references);
            rootChange = true;
        }
        this.actions.removeAllChildren();
        this.someday.removeAllChildren();
        this.references.removeAllChildren();
        this.projects.removeAllChildren();
        this.meta.removeAllChildren();
        if (this.gtdModel != null) {
            for (Folder f : this.gtdModel) {
                if (!this.canShowFolder(f)) continue;
                this.addToTree(f, false);
            }
        }
        if (rootChange) {
            this.model.nodeStructureChanged(this.root);
        } else {
            this.model.nodeStructureChanged(this.actions);
            this.model.nodeStructureChanged(this.someday);
            this.model.nodeStructureChanged(this.references);
            this.model.nodeStructureChanged(this.projects);
            this.model.nodeStructureChanged(this.meta);
        }
    }

    private DefaultMutableTreeNode addToTree(Folder f, boolean notify) {
        SortedTreeNode n = null;
        FolderTreeNode r = null;
        if (f.isAction()) {
            r = new FolderTreeNode(f);
            this.actions.add(r);
            n = this.actions;
        } else if (f.isReference()) {
            r = new FolderTreeNode(f);
            this.references.add(r);
            n = this.references;
        } else if (f.isSomeday()) {
            r = new FolderTreeNode(f);
            this.someday.add(r);
            n = this.someday;
        } else if (this.defaultFoldersVisible && f.isDefault()) {
            r = new FolderTreeNode(f);
            this.meta.add(r);
            n = this.meta;
        } else if (this.defaultFoldersVisible && f.isProject()) {
            r = new FolderTreeNode(f);
            this.projects.add(r);
            n = this.projects;
        }
        if (notify && n != null) {
            this.model.nodeStructureChanged(n);
        }
        return r;
    }

    private DefaultMutableTreeNode removeFromTree(Folder f, boolean notify) {
        DefaultMutableTreeNode dn = this.folderToNode(f);
        if (dn != null && dn.getUserObject() == f) {
            DefaultMutableTreeNode p = (DefaultMutableTreeNode)dn.getParent();
            int[] id = new int[]{p.getIndex(dn)};
            p.remove(id[0]);
            if (notify) {
                this.model.nodesWereRemoved(p, id, new Object[]{dn});
                this.repaint();
            }
            return dn;
        }
        return null;
    }

    private boolean canShowFolder(Folder f) {
        return f.isDefault() || this.showClosedFolders && f.isClosed() || !f.isClosed() && (this.showEmptyFolders || f.getOpenCount() > 0);
    }

    private boolean checkIfShow(Folder f) {
        DefaultMutableTreeNode node = this.folderToNode(f);
        boolean show = this.canShowFolder(f);
        if (show && node == null) {
            this.addToTree(f, true);
            return true;
        }
        if (!show && node != null) {
            this.removeFromTree(f, true);
            return true;
        }
        return false;
    }

    public DefaultMutableTreeNode folderToNode(Folder f) {
        Enumeration<TreeNode> en = null;
        SortedTreeNode p = this.folderToParentNode(f);
        if (p != null) {
            en = p.children();
        }
        if (en != null) {
            while (en.hasMoreElements()) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)en.nextElement();
                if (n.getUserObject() != f) continue;
                return n;
            }
        }
        return null;
    }

    public SortedTreeNode folderToParentNode(Folder f) {
        if (f.getType() == Folder.FolderType.ACTION) {
            return this.actions;
        }
        if (f.isReference()) {
            return this.references;
        }
        if (f.getType() == Folder.FolderType.SOMEDAY) {
            return this.someday;
        }
        if (this.engine.getStateMachine().getDefaultTreeBranch(f.getType())) {
            return this.meta;
        }
        if (f.getType() == Folder.FolderType.PROJECT) {
            return this.projects;
        }
        return null;
    }

    public void addFolder(String name) {
        Folder.FolderType type = Folder.FolderType.ACTION;
        if (this.getSelectionPath() != null && this.getSelectionPath().getPathCount() > 0) {
            if (this.getSelectionPath().getPathComponent(1) == this.references) {
                type = Folder.FolderType.REFERENCE;
            } else if (this.getSelectionPath().getPathComponent(1) == this.someday) {
                type = Folder.FolderType.SOMEDAY;
            } else if (this.getSelectionPath().getPathComponent(1) == this.projects) {
                type = Folder.FolderType.PROJECT;
            }
        }
        Folder f = this.gtdModel.createFolder(name, type);
        this.setSelectionPath(new TreePath(this.model.getPathToRoot(this.folderToNode(f))));
    }

    public boolean isFolderRenamePossible() {
        return this.getSelectedFolder() != null && (this.getSelectedFolder().isUserFolder() || this.getSelectedFolder().isProject());
    }

    public boolean isFolderAddPossible() {
        return this.getSelectionPath() != null && this.getSelectionPath().getPathCount() > 0 && (this.getSelectionPath().getPathComponent(1) == this.someday || this.getSelectionPath().getPathComponent(1) == this.references || this.getSelectionPath().getPathComponent(1) == this.actions || this.getSelectionPath().getPathComponent(1) == this.projects);
    }

    public boolean isDefaultFoldersVisible() {
        return this.defaultFoldersVisible;
    }

    public void setDefaultFoldersVisible(boolean defaultFoldersVisible) {
        this.defaultFoldersVisible = defaultFoldersVisible;
        this.rebuildTree();
    }

    public boolean isShowClosedFolders() {
        return this.showClosedFolders;
    }

    public void setShowClosedFolders(boolean showClosedFolders) {
        this.showClosedFolders = showClosedFolders;
        this.rebuildTree();
    }

    public void setExpendedNodes(int[] ii) {
        if (ii == null || ii.length == 0) {
            return;
        }
        int i = 0;
        while (i < this.getRowCount()) {
            this.collapseRow(i++);
        }
        Arrays.sort(ii);
        for (i = 0; i < ii.length; ++i) {
            if (i <= -1) continue;
            this.expandRow(ii[i]);
        }
    }

    public int[] getExpendedNodes() {
        ArrayList<Integer> i = new ArrayList<Integer>();
        Enumeration<TreePath> en = this.getExpandedDescendants(new TreePath(this.root.getPath()));
        if (en == null) {
            return null;
        }
        while (en.hasMoreElements()) {
            TreePath tp = en.nextElement();
            int r = this.getRowForPath(tp);
            if (r <= -1) continue;
            i.add(r);
        }
        int[] ii = new int[i.size()];
        for (int j = 0; j < ii.length; ++j) {
            ii[j] = (Integer)i.get(j);
        }
        Arrays.sort(ii);
        return ii;
    }

    public void setEngine(GTDFreeEngine engine) {
        this.engine = engine;
        this.setGTDModel(engine.getGTDModel());
    }

    public GTDFreeEngine getEngine() {
        return this.engine;
    }

    public void setSelectedFolder(Folder f, int i) {
        this.lastDroppedActionIndex = i;
        DefaultMutableTreeNode n = this.folderToNode(f);
        if (n != null) {
            this.setSelectionPath(new TreePath(this.folderToNode(f).getPath()));
        }
    }

    public void setShowEmptyFolders(boolean b) {
        this.showEmptyFolders = b;
        this.rebuildTree();
    }

    public int getLastDroppedActionIndex() {
        return this.lastDroppedActionIndex;
    }

    @Override
    public boolean isPathEditable(TreePath path) {
        Object value;
        if (!this.isEditable()) {
            return false;
        }
        if (path != null && (value = path.getLastPathComponent()) instanceof FolderTreeNode) {
            return !((FolderTreeNode)value).folder.isDefault();
        }
        return false;
    }

    final class SortedTreeNode
    extends DefaultMutableTreeNode
    implements Comparator<DefaultMutableTreeNode> {
        private static final long serialVersionUID = 1L;

        public SortedTreeNode() {
        }

        public SortedTreeNode(Object userObject, boolean allowsChildren) {
            super(userObject, allowsChildren);
        }

        public SortedTreeNode(Object userObject) {
            super(userObject);
        }

        @Override
        public void add(MutableTreeNode newChild) {
            super.add(newChild);
            Collections.sort(this.children, this);
        }

        @Override
        public int compare(DefaultMutableTreeNode o1, DefaultMutableTreeNode o2) {
            Object f1 = o1.getUserObject();
            Object f2 = o2.getUserObject();
            if (f1 instanceof Folder && f2 instanceof Folder) {
                return ((Folder)f1).getName().compareTo(((Folder)f2).getName());
            }
            return 0;
        }

        public void sort() {
            if (this.children != null) {
                Collections.sort(this.children, this);
            }
        }
    }

    final class FolderTreeNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 1L;
        private Folder folder;

        public FolderTreeNode(Folder f) {
            super(f, false);
            this.folder = f;
        }

        @Override
        public void setUserObject(Object userObject) {
            if (userObject instanceof String) {
                this.folder.rename((String)userObject);
            } else if (userObject instanceof Folder) {
                this.folder = (Folder)userObject;
                super.setUserObject(userObject);
            }
        }
    }

    private final class FolderTreeTransferHandler
    extends ActionTransferHandler {
        private static final long serialVersionUID = 0L;

        private FolderTreeTransferHandler() {
        }

        @Override
        protected boolean importActions(Action[] a, Folder source, int[] indexes, TransferHandler.TransferSupport support) {
            try {
                TreePath tp = FolderTree.this.getClosestPathForLocation(support.getDropLocation().getDropPoint().x, support.getDropLocation().getDropPoint().y);
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)tp.getLastPathComponent();
                if (n != null && n.getUserObject() instanceof Folder && a != null) {
                    Folder target = (Folder)n.getUserObject();
                    if (target.isProject()) {
                        for (int i = 0; i < a.length; ++i) {
                            a[i].setProject(target.getId());
                        }
                    } else {
                        FolderTree.this.gtdModel.moveActions(a, target);
                    }
                    FolderTree.this.setSelectedFolder(source, indexes[indexes.length - 1] + 1 - indexes.length);
                    FolderTree.this.lastDroppedActionIndex = -1;
                    return true;
                }
            }
            catch (Throwable t) {
                Logger.getLogger(this.getClass()).debug("Internal error.", t);
            }
            FolderTree.this.setSelectedFolder(source, -1);
            return false;
        }

        @Override
        protected Action[] exportActions() {
            return null;
        }

        @Override
        protected Folder exportSourceFolder() {
            return null;
        }

        @Override
        protected int[] exportIndexes() {
            return null;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            TreePath tp = FolderTree.this.getClosestPathForLocation(support.getDropLocation().getDropPoint().x, support.getDropLocation().getDropPoint().y);
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)tp.getLastPathComponent();
            if (n != null && n.getUserObject() instanceof Folder && !((Folder)n.getUserObject()).isMeta() && ((Folder)n.getUserObject()).getType() != Folder.FolderType.INBUCKET) {
                return super.canImport(support);
            }
            if (n != null && n.getUserObject() instanceof Project) {
                return super.canImport(support);
            }
            return false;
        }
    }

    private final class FolderTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            super.getTreeCellRendererComponent(tree, "", sel, expanded, leaf, row, hasFocus);
            Font font = FolderTree.this.getFont();
            Folder f = null;
            if (node.getUserObject() instanceof Folder) {
                f = (Folder)node.getUserObject();
                StringBuilder sb = new StringBuilder(32);
                sb.append(f.getName());
                sb.append(' ');
                sb.append('(');
                if (f.getType() == Folder.FolderType.BUILDIN_RESOLVED || f.getType() == Folder.FolderType.BUILDIN_DELETED) {
                    sb.append(f.size());
                } else {
                    sb.append(f.getOpenCount());
                }
                sb.append(')');
                value = sb.toString();
            }
            if (f != null && f.isClosed()) {
                this.setForeground(Color.LIGHT_GRAY);
            }
            String s = String.valueOf(value);
            this.setText(s);
            this.setToolTipText(s);
            if (node.getLevel() == 1) {
                super.setFont(font.deriveFont(1).deriveFont((float)font.getSize() + 2.0f));
            } else if (f != null && f.getOpenCount() > 0) {
                super.setFont(font.deriveFont(1));
            } else {
                super.setFont(font);
            }
            return this;
        }

        @Override
        public void setFont(Font font) {
        }

        @Override
        public Icon getIcon() {
            return null;
        }

        @Override
        public void setIcon(Icon icon) {
        }
    }

    private final class FolderTreeCellEditor
    extends DefaultTreeCellEditor {
        private FolderTreeCellEditor(JTree tree, DefaultTreeCellRenderer renderer) {
            super(tree, renderer);
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            if (value instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)value).getUserObject() instanceof Folder) {
                value = ((Folder)((DefaultMutableTreeNode)value).getUserObject()).getName();
            }
            return super.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row);
        }

        @Override
        public boolean shouldSelectCell(EventObject event) {
            return true;
        }

        @Override
        public boolean isCellEditable(EventObject event) {
            Boolean b = super.isCellEditable(event);
            if (event instanceof MouseEvent) {
                MouseEvent m = (MouseEvent)event;
                return m.getClickCount() > 1;
            }
            return b;
        }
    }
}

