/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.gui;

import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFPrintPage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import javax.print.attribute.Attribute;
import javax.print.attribute.EnumSyntax;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.log4j.Logger;
import org.gtdfree.GTDFreeEngine;
import org.gtdfree.Messages;
import org.gtdfree.addons.ExportAddOn;
import org.gtdfree.addons.PDFExportAddOn;
import org.gtdfree.gui.SelectionPanel;
import org.gtdfree.model.ActionsCollection;
import org.gtdfree.model.GTDModel;

public class ExportDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final String EXPORT_FORMAT = "ExportDialog.format";
    private static final String EXPORT_ORDER = "ExportDialog.order";
    private SelectionPanel selectionPanel;
    private GTDModel gtdModel;
    private JComboBox formatCombo;
    private GTDFreeEngine engine;
    private ExportAddOn export;
    private JComboBox orderCombo;
    private JFileChooser fileChooser;
    private JCheckBox overwriteCheckBox;
    private JTabbedPane tabs;
    private ButtonGroup selectionButtonGroup;
    private JRadioButton currentViewRadioButton;
    private JRadioButton customRadioButton;
    private boolean printing = false;
    private PDFExportAddOn pdfExport;
    private JPanel optionsTab;

    public ExportDialog(Frame owner) {
        super(owner, true);
        this.initialize();
    }

    public ExportDialog(Frame owner, boolean printing) {
        super(owner, true);
        this.printing = printing;
        this.initialize();
    }

    private void initialize() {
        this.tabs = new JTabbedPane();
        int row = 0;
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        row = 0;
        JLabel l = new JLabel(Messages.getString("ExportDialog.Sel"));
        l.setFont(l.getFont().deriveFont(2));
        p.add((Component)l, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 13, 2, new Insets(11, 11, 2, 11), 0, 0));
        this.selectionButtonGroup = new ButtonGroup();
        this.currentViewRadioButton = new JRadioButton(Messages.getString("ExportDialog.Curr"));
        this.currentViewRadioButton.setSelected(true);
        this.selectionButtonGroup.add(this.currentViewRadioButton);
        this.currentViewRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ExportDialog.this.tabs.setEnabledAt(1, false);
            }
        });
        p.add((Component)this.currentViewRadioButton, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 18, 2, 11), 0, 0));
        this.customRadioButton = new JRadioButton(Messages.getString("ExportDialog.Custom"));
        this.selectionButtonGroup.add(this.customRadioButton);
        this.customRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ExportDialog.this.tabs.setEnabledAt(1, true);
            }
        });
        p.add((Component)this.customRadioButton, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 18, 2, 11), 0, 0));
        JPanel p1 = new JPanel();
        p1.setLayout(new GridBagLayout());
        int rrow = -1;
        if (!this.printing) {
            l = new JLabel(Messages.getString("ExportDialog.Format"));
            p1.add((Component)l, new GridBagConstraints(0, ++rrow, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 4), 0, 0));
            this.formatCombo = new JComboBox();
            this.formatCombo.setEditable(false);
            this.formatCombo.setRenderer(new DefaultListCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    if (value instanceof ExportAddOn) {
                        value = ((ExportAddOn)value).getName();
                    }
                    return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                }
            });
            this.formatCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ExportDialog.this.setExport((ExportAddOn)ExportDialog.this.formatCombo.getSelectedItem());
                }
            });
            p1.add((Component)this.formatCombo, new GridBagConstraints(1, rrow, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        l = new JLabel(Messages.getString("ExportDialog.Order"));
        p1.add((Component)l, new GridBagConstraints(0, ++rrow, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 4), 0, 0));
        this.orderCombo = new JComboBox();
        this.orderCombo.setEditable(false);
        this.orderCombo.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof ExportAddOn.ExportOrder) {
                    value = ((ExportAddOn.ExportOrder)((Object)value)).getDisplayName();
                }
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        });
        this.orderCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (ExportDialog.this.engine != null && ExportDialog.this.orderCombo != null && ExportDialog.this.orderCombo.getSelectedItem() != null) {
                    ExportDialog.this.engine.getGlobalProperties().putProperty(ExportDialog.EXPORT_ORDER, ExportDialog.this.orderCombo.getSelectedItem().toString());
                }
            }
        });
        p1.add((Component)this.orderCombo, new GridBagConstraints(1, rrow, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        p.add((Component)p1, new GridBagConstraints(0, ++row, 2, 1, 1.0, 0.0, 10, 2, new Insets(11, 11, 0, 11), 0, 0));
        if (!this.printing) {
            this.overwriteCheckBox = new JCheckBox();
            this.overwriteCheckBox.setText(Messages.getString("ExportDialog.Overwrite"));
            p.add((Component)this.overwriteCheckBox, new GridBagConstraints(0, ++row, 2, 1, 1.0, 1.0, 11, 2, new Insets(11, 11, 11, 11), 0, 0));
        } else {
            p.add((Component)new JPanel(), new GridBagConstraints(0, ++row, 2, 1, 1.0, 1.0, 10, 0, new Insets(11, 11, 11, 11), 0, 0));
        }
        this.tabs.add(Messages.getString("ExportDialog.General"), p);
        p = new JPanel();
        p.setLayout(new GridBagLayout());
        row = 0;
        this.selectionPanel = new SelectionPanel();
        p.add((Component)this.selectionPanel, new GridBagConstraints(0, row, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.tabs.addTab(Messages.getString("ExportDialog.Selection"), p);
        this.tabs.setEnabledAt(1, false);
        this.optionsTab = new JPanel();
        this.optionsTab.setLayout(new BorderLayout());
        this.tabs.addTab(Messages.getString("ExportDialog.Options"), this.optionsTab);
        this.tabs.setEnabledAt(2, false);
        p = new JPanel();
        p.setLayout(new GridBagLayout());
        row = 0;
        p.add((Component)this.tabs, new GridBagConstraints(0, row, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JButton b = null;
        if (this.printing) {
            b = new JButton(Messages.getString("ExportDialog.Print"));
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExportDialog.this.print();
                }
            });
            p.add((Component)b, new GridBagConstraints(0, ++row, 1, 1, 1.0, 0.0, 13, 0, new Insets(11, 11, 11, 2), 0, 0));
        } else {
            b = new JButton(Messages.getString("ExportDialog.Export"));
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExportDialog.this.export();
                }
            });
            p.add((Component)b, new GridBagConstraints(0, ++row, 1, 1, 1.0, 0.0, 13, 0, new Insets(11, 11, 11, 2), 0, 0));
        }
        b = new JButton(Messages.getString("ExportDialog.Close"));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportDialog.this.dispose();
            }
        });
        p.add((Component)b, new GridBagConstraints(1, row, 1, 1, 0.0, 0.0, 13, 0, new Insets(11, 2, 11, 11), 0, 0));
        this.setContentPane(p);
        this.setModalityType(DEFAULT_MODALITY_TYPE);
        this.setDefaultCloseOperation(2);
        if (this.printing) {
            this.setTitle(Messages.getString("ExportDialog.0") + Messages.getString("ExportDialog.Print.title"));
        } else {
            this.setTitle(Messages.getString("ExportDialog.2") + Messages.getString("ExportDialog.Export.title"));
        }
        this.pack();
        this.setSize(this.getSize().width + 50, this.getSize().height);
        if (this.printing) {
            this.pdfExport = new PDFExportAddOn();
            this.pdfExport.setPrintMode(true);
            this.setExport(this.pdfExport);
        }
    }

    @Override
    public void setVisible(boolean b) {
        boolean current;
        boolean bl = current = this.engine.getActiveWorkflowPane() != null && this.engine.getActiveWorkflowPane().getActionsInView().iterator(ExportAddOn.ExportOrder.Actions).hasNext();
        if (!current) {
            this.currentViewRadioButton.setSelected(current);
            this.customRadioButton.setSelected(!current);
        }
        this.currentViewRadioButton.setEnabled(current);
        if (this.tabs.getSelectedIndex() == 1 && current) {
            this.tabs.setSelectedIndex(0);
        }
        super.setVisible(b);
    }

    protected void print() {
        try {
            Object f;
            MediaPrintableArea mpa;
            double[] area;
            EnumSyntax n;
            int i;
            Field[] f2;
            this.dispose();
            final PrinterJob pj = PrinterJob.getPrinterJob();
            PageFormat pf = pj.defaultPage();
            HashPrintRequestAttributeSet set = new HashPrintRequestAttributeSet();
            Integer pn = this.engine.getGlobalProperties().getInteger("pageSizeName");
            if (pn != null) {
                f2 = MediaSizeName.class.getFields();
                for (i = 0; i < f2.length; ++i) {
                    if (!Modifier.isStatic(f2[i].getModifiers()) || f2[i].getType() != MediaSizeName.class || ((MediaSizeName)f2[i].get(null)).getValue() != pn.intValue()) continue;
                    n = (MediaSizeName)f2[i].get(null);
                    set.add((Attribute)((Object)n));
                    break;
                }
            }
            if ((pn = this.engine.getGlobalProperties().getInteger("pageOrientation")) != null) {
                f2 = OrientationRequested.class.getFields();
                for (i = 0; i < f2.length; ++i) {
                    if (!Modifier.isStatic(f2[i].getModifiers()) || f2[i].getType() != OrientationRequested.class || ((OrientationRequested)f2[i].get(null)).getValue() != pn.intValue()) continue;
                    n = (OrientationRequested)f2[i].get(null);
                    set.add((Attribute)((Object)n));
                    break;
                }
            }
            if ((area = this.engine.getGlobalProperties().getDoubleArray("pagePrintableArea")) != null && area.length == 4) {
                MediaPrintableArea a = new MediaPrintableArea((float)area[0], (float)area[1], (float)area[2], (float)area[3], 1000);
                set.add(a);
            }
            if (!pj.printDialog(set)) {
                return;
            }
            pf = pj.getPageFormat(set);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ActionsCollection ac = this.currentViewRadioButton.isSelected() ? this.engine.getActiveWorkflowPane().getActionsInView() : this.selectionPanel.getSelectionModel().getSelection();
            Media media = (Media)set.get(Media.class);
            if (media instanceof MediaSizeName) {
                MediaSizeName msn = (MediaSizeName)media;
                this.engine.getGlobalProperties().putProperty("pageSizeName", msn.getValue());
            } else {
                MediaSize ms = (MediaSize)set.get(MediaSize.class);
                if (ms != null) {
                    this.engine.getGlobalProperties().putProperty("pageSizeName", ms.getMediaSizeName().getValue());
                }
            }
            OrientationRequested ori = (OrientationRequested)set.get(OrientationRequested.class);
            if (ori != null) {
                this.engine.getGlobalProperties().putProperty("pageOrientation", ori.getValue());
            }
            if ((mpa = (MediaPrintableArea)set.get(MediaPrintableArea.class)) != null) {
                f = mpa.getPrintableArea(1000);
                this.engine.getGlobalProperties().putProperty("pagePrintableArea", new double[]{f[0], f[1], f[2], f[3]});
            }
            this.pdfExport.setPageSize((float)pf.getWidth(), (float)pf.getHeight());
            this.pdfExport.setMargins((float)pf.getImageableX(), (float)(pf.getWidth() - pf.getImageableX() - pf.getImageableWidth()), (float)pf.getImageableY(), (float)(pf.getHeight() - pf.getImageableY() - pf.getImageableHeight()));
            this.pdfExport.export(this.getGtdModel(), ac, out, (ExportAddOn.ExportOrder)((Object)this.orderCombo.getSelectedItem()), this.export.getFileFilters()[0], true);
            f = new PDFFile(ByteBuffer.wrap(out.toByteArray()));
            final PDFPrintPage p = new PDFPrintPage((PDFFile)f);
            Paper pap = new Paper();
            pap.setSize(pf.getWidth(), pf.getHeight());
            pap.setImageableArea(0.0, 0.0, pf.getWidth(), pf.getHeight());
            pf.setPaper(pap);
            pj.setPrintable(p, pf);
            p.show(pj, this);
            new Thread("PrintingThread"){

                @Override
                public void run() {
                    try {
                        pj.print();
                    }
                    catch (PrinterException e) {
                        ExportDialog.this.dispose();
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(ExportDialog.this, Messages.getString("ExportDialog.Print.Fail") + " " + e.toString(), Messages.getString("ExportDialog.Print.Tail.title"), 0);
                    }
                    p.hide();
                }
            }.start();
        }
        catch (Exception e) {
            this.dispose();
            Logger.getLogger(this.getClass()).error("Print error.", e);
            JOptionPane.showMessageDialog(this, Messages.getString("ExportDialog.Print.Fail") + " " + e.toString(), Messages.getString("ExportDialog.Print.Tail.title"), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void export() {
        if (this.export == null) {
            return;
        }
        FileFilter[] ff = this.export.getFileFilters();
        this.getFileChooser().resetChoosableFileFilters();
        if (ff.length == 1) {
            this.getFileChooser().setFileFilter(ff[0]);
        } else {
            for (FileFilter f : ff) {
                this.getFileChooser().addChoosableFileFilter(f);
            }
        }
        this.getFileChooser().rescanCurrentDirectory();
        if (0 == this.getFileChooser().showSaveDialog(this)) {
            int i;
            File f = this.getFileChooser().getSelectedFile();
            FileFilter fff = this.getFileChooser().getFileFilter();
            if (f.getName().indexOf(46) < 0 && fff instanceof FileNameExtensionFilter) {
                f = new File(f.toString() + '.' + ((FileNameExtensionFilter)fff).getExtensions()[0]);
            }
            if (f.exists() && !this.overwriteCheckBox.isSelected() && (i = JOptionPane.showConfirmDialog(this, Messages.getString("ExportDialog.OWR.1") + f.toString() + Messages.getString("ExportDialog.OWR.2"), Messages.getString("ExportDialog.OWR.title"), 2, 2)) != 0) {
                return;
            }
            OutputStream out = null;
            try {
                Logger.getLogger(this.getClass()).info("Exporting with '" + this.export.getName() + "' to " + f.toString());
                out = new BufferedOutputStream(new FileOutputStream(f));
                ActionsCollection ac = this.currentViewRadioButton.isSelected() ? this.engine.getActiveWorkflowPane().getActionsInView() : this.selectionPanel.getSelectionModel().getSelection();
                this.export.export(this.getGtdModel(), ac, out, (ExportAddOn.ExportOrder)((Object)this.orderCombo.getSelectedItem()), fff, true);
                this.dispose();
                this.showSuccessDialog(f);
            }
            catch (Exception e) {
                this.dispose();
                Logger.getLogger(this.getClass()).error("Export error.", e);
                JOptionPane.showMessageDialog(this, Messages.getString("ExportDialog.Exp.Fail.1") + f + Messages.getString("ExportDialog.exp.Fail.2") + " " + e.toString(), Messages.getString("ExportDialog.Exp.Fail.title"), 0);
            }
            finally {
                if (out != null) {
                    try {
                        out.flush();
                        out.close();
                    }
                    catch (Exception e) {
                        Logger.getLogger(this.getClass()).debug("Internal error.", e);
                    }
                }
            }
        }
    }

    protected void updatePreview() {
        if (this.export == null) {
            return;
        }
        new ByteArrayOutputStream();
    }

    private void showSuccessDialog(File f) {
        int i = JOptionPane.showOptionDialog(this.getOwner(), Messages.getString("ExportDialog.Exp.OK.1") + f.toString() + Messages.getString("ExportDialog.Exp.OK.2"), Messages.getString("ExportDialog.Exp.OK.title"), 0, 1, null, new Object[]{Messages.getString("ExportDialog.OK"), Messages.getString("ExportDialog.Open")}, null);
        if (i == 1) {
            try {
                Desktop.getDesktop().open(f);
            }
            catch (IOException e1) {
                Logger.getLogger(this.getClass()).error("File open error.", e1);
            }
        }
    }

    private JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setCurrentDirectory(new File(System.getProperty("user.home", ".")));
            this.fileChooser.setFileSelectionMode(0);
            this.fileChooser.setMultiSelectionEnabled(false);
            this.fileChooser.setFileHidingEnabled(false);
            this.fileChooser.setAcceptAllFileFilterUsed(false);
        }
        return this.fileChooser;
    }

    protected void setExport(ExportAddOn selectedItem) {
        this.export = selectedItem;
        ExportAddOn.ExportOrder[] o = this.export.getSupportedExportOrders();
        this.orderCombo.removeAllItems();
        for (ExportAddOn.ExportOrder e : o) {
            this.orderCombo.addItem(e);
        }
        this.fileChooser = null;
        this.orderCombo.setSelectedItem((Object)this.export.getDefaultExportOrder());
        if (this.export.getComponent() != null) {
            this.optionsTab.add(this.export.getComponent());
            this.tabs.setEnabledAt(2, true);
        } else {
            this.optionsTab.removeAll();
            this.tabs.setEnabledAt(2, false);
        }
        if (this.engine != null) {
            this.engine.getGlobalProperties().putProperty(EXPORT_FORMAT, this.export.getName());
        }
    }

    public GTDModel getGtdModel() {
        return this.gtdModel;
    }

    private void setGtdModel(GTDModel gtdModel) {
        this.gtdModel = gtdModel;
        this.selectionPanel.setGtdModel(gtdModel);
    }

    public void setEngine(GTDFreeEngine engine) {
        ExportAddOn.ExportOrder eo;
        this.engine = engine;
        this.setGtdModel(engine.getGTDModel());
        if (this.printing) {
            this.pdfExport.initialize(engine);
        } else {
            ExportAddOn[] e = engine.getExportAddOns();
            for (int i = 0; i < e.length; ++i) {
                e[i].initialize(engine);
            }
            DefaultComboBoxModel<ExportAddOn> m = new DefaultComboBoxModel<ExportAddOn>(e);
            this.formatCombo.setModel(m);
            Object o = engine.getGlobalProperties().getProperty(EXPORT_FORMAT);
            if (o != null) {
                for (ExportAddOn ex : e) {
                    if (!ex.getName().equals(o)) continue;
                    this.formatCombo.setSelectedItem(ex);
                    break;
                }
            }
            this.setExport((ExportAddOn)this.formatCombo.getSelectedItem());
        }
        Object o = engine.getGlobalProperties().getProperty(EXPORT_ORDER);
        if (o != null && (eo = ExportAddOn.ExportOrder.valueOf(o.toString())) != null) {
            this.orderCombo.setSelectedItem((Object)eo);
        }
    }
}

