/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.gui;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.apache.log4j.Logger;
import org.gtdfree.model.Action;
import org.gtdfree.model.Folder;
import org.gtdfree.model.GTDModel;

public abstract class ActionTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 1L;
    public static final DataFlavor ACTION_FLAVOR = new DataFlavor(ActionInfo.class, "Action");
    private GTDModel model;

    ActionTransferHandler() {
    }

    public void setModel(GTDModel model) {
        this.model = model;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        Object drop = null;
        ActionInfo[] i = null;
        try {
            drop = support.getTransferable().getTransferData(ACTION_FLAVOR);
        }
        catch (UnsupportedFlavorException e) {
            Logger.getLogger(this.getClass()).debug("Internal error.", e);
        }
        catch (IOException e) {
            Logger.getLogger(this.getClass()).debug("Internal error.", e);
        }
        if (drop != null) {
            i = (ActionInfo[])drop;
        }
        if (i != null) {
            return this.importActions(i, support);
        }
        return false;
    }

    private boolean importActions(ActionInfo[] id, TransferHandler.TransferSupport support) {
        Action[] a = new Action[id.length];
        int[] idx = new int[a.length];
        for (int i = 0; i < a.length; ++i) {
            a[i] = this.model.getFolder(id[i].folderID).getActionByID(id[i].actionID);
            idx[i] = id[i].actionIndex;
        }
        return this.importActions(a, this.model.getFolder(id[0].sourceID), idx, support);
    }

    protected abstract boolean importActions(Action[] var1, Folder var2, int[] var3, TransferHandler.TransferSupport var4);

    protected abstract Action[] exportActions();

    protected abstract int[] exportIndexes();

    protected abstract Folder exportSourceFolder();

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        DataFlavor[] f = support.getDataFlavors();
        for (int i = 0; i < f.length; ++i) {
            if (f[i] != ACTION_FLAVOR) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 2;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        return new ActionTransfer(this.exportActions(), this.exportSourceFolder(), this.exportIndexes());
    }

    static class ActionInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public int actionID;
        public int folderID;
        public int sourceID;
        public int actionIndex;

        public ActionInfo(int fID, int aID, int aIndex) {
            this.actionID = aID;
            this.folderID = fID;
            this.actionIndex = aIndex;
        }

        public ActionInfo(Action a, int aIndex) {
            this.actionID = a.getId();
            this.folderID = a.getParent().getId();
            this.actionIndex = aIndex;
        }
    }

    class ActionTransfer
    implements Transferable {
        ActionInfo[] id;

        public ActionTransfer(Action[] i, Folder source, int[] indeces) {
            this.id = new ActionInfo[i.length];
            for (int j = 0; j < i.length; ++j) {
                this.id[j] = new ActionInfo(i[j], indeces[j]);
            }
            this.id[0].sourceID = source.getId();
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return ACTION_FLAVOR == flavor;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{ACTION_FLAVOR};
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor == ACTION_FLAVOR) {
                return this.id;
            }
            return null;
        }

        public String toString() {
            return "transferable=" + Arrays.toString(this.id);
        }
    }
}

