/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.gui;

import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.ActionMap;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.apache.log4j.Logger;
import org.gtdfree.ApplicationHelper;
import org.gtdfree.GTDFreeEngine;
import org.gtdfree.Messages;
import org.gtdfree.gui.ActionTransferHandler;
import org.gtdfree.gui.PriorityPicker;
import org.gtdfree.gui.ProjectsCombo;
import org.gtdfree.html.TAG;
import org.gtdfree.model.Action;
import org.gtdfree.model.ActionFilter;
import org.gtdfree.model.Folder;
import org.gtdfree.model.FolderEvent;
import org.gtdfree.model.FolderListener;
import org.gtdfree.model.GTDModel;
import org.gtdfree.model.Priority;
import org.gtdfree.model.Project;
import org.gtdfree.model.Utils;

public class ActionTable
extends JTable {
    private static final long serialVersionUID = 1L;
    public static final String JACTION_MOVE_DOWN = "actionTable.moveDown";
    public static final String JACTION_MOVE_UP = "actionTable.moveUp";
    public static final String JACTION_SELECT_NEXT = "actionTable.selectNext";
    public static final String JACTION_SELECT_PREVIOUS = "actionTable.selectPrevious";
    public static final String FOLDER_PROPERTY_NAME = "folder";
    public static final String SELECTED_ACTIONS_PROPERTY_NAME = "selectedActions";
    public static List<RowSorter.SortKey> EMPTY_KEYS = Collections.emptyList();
    private int maxTooltipLines = 5;
    private boolean moveEnabled = false;
    protected Folder folder;
    private ActionTableModel model;
    private boolean showAll = false;
    private FolderListener folderListener = new FolderListener(){

        @Override
        public void elementRemoved(FolderEvent note) {
            ActionTable.this.model.remove(note.getAction());
            ActionTable.this.enableSelectActions();
        }

        @Override
        public void elementModified(org.gtdfree.model.ActionEvent note) {
            int i;
            ActionTable.this.model.fireActionChanged(note.getAction());
            if (note.getProperty() == "priority" && (i = ActionTable.this.getEditingRow()) > -1 && (i = ActionTable.this.convertRowIndexToModel(i)) == ActionTable.this.model.indexOf(note.getAction())) {
                ActionTable.this.getPriorityColumn().getCellEditor().cancelCellEditing();
            }
            if (ActionTable.this.filter != null && !ActionTable.this.filter.isAcceptable(ActionTable.this.folder, note.getAction())) {
                ActionTable.this.model.remove(note.getAction());
                ActionTable.this.enableSelectActions();
            }
        }

        @Override
        public void elementAdded(FolderEvent note) {
            ActionTable.this.updateIDColumnWidth();
            ActionTable.this.model.reload(ActionTable.this.folder, ActionTable.this.filter);
            ActionTable.this.enableSelectActions();
            int i = ActionTable.this.model.indexOf(note.getAction());
            ActionTable.this.getSelectionModel().setSelectionInterval(i, i);
        }

        @Override
        public void orderChanged(Folder f) {
            Action a = ActionTable.this.getSelectedAction();
            ActionTable.this.model.reload(ActionTable.this.folder, ActionTable.this.filter);
            int i = ActionTable.this.model.indexOf(a);
            ActionTable.this.getSelectionModel().setSelectionInterval(i, i);
        }
    };
    private AbstractAction moveUpAction;
    private AbstractAction moveDownAction;
    private Action[] selectedActions;
    private ActionFilter filter;
    private ProjectCellEditor projectEditor;
    private GTDFreeEngine engine;
    private TableColumn remindColumn;
    private TableColumn idColumn;
    private TableColumn descriptionColumn;
    private TableColumn actionColumn;
    private TableColumn projectColumn;
    private TableColumn folderColumn;
    private TableColumn resolvedColumn;
    private TableColumn priorityColumn;
    private TableColumn queueColumn;
    private boolean showResolvedColumn;
    private boolean showFolderColumn = false;
    private boolean showPriorityColumn = false;
    private boolean showQueueColumn = true;
    private boolean showProjectColumn;
    private boolean showRemindColumn = false;
    private boolean singleSelectionMode = false;
    private boolean showClosedFolders = false;
    private ActionRowSorter rowSorter;
    private AbstractAction goNextAction;
    private AbstractAction goPreviousAction;
    private CellAction cellAction = CellAction.RESOLVE;
    private ActionTransferHandler transferHandler;
    private JPopupMenu popupMenu;
    private AbstractAction saveRowOrder;

    public void setCellAction(CellAction a) {
        if (this.cellAction == a) {
            return;
        }
        this.cellAction = a;
    }

    public boolean isShowRemindColumn() {
        return this.showRemindColumn;
    }

    public void setShowRemindColumn(boolean showRemindColumn) {
        this.showRemindColumn = showRemindColumn;
        this.rebuildColumns();
    }

    public void setShowResolvedColumn(boolean showResolvedColumn) {
        this.showResolvedColumn = showResolvedColumn;
        this.rebuildColumns();
    }

    public boolean isShowResolvedColumn() {
        return this.showResolvedColumn;
    }

    private void rebuildColumns() {
        TableColumnModel cm = this.getColumnModel();
        int i = 0;
        if (cm.getColumnCount() == 0) {
            cm.addColumn(this.getIDColumn());
        }
        ++i;
        if (this.showFolderColumn) {
            while (cm.getColumnCount() > i && cm.getColumn(i) != this.getFolderColumn()) {
                cm.removeColumn(cm.getColumn(i));
            }
            if (cm.getColumnCount() == i) {
                cm.addColumn(this.getFolderColumn());
            }
            ++i;
        }
        if (this.showProjectColumn) {
            while (cm.getColumnCount() > i && cm.getColumn(i) != this.getProjectColumn()) {
                cm.removeColumn(cm.getColumn(i));
            }
            if (cm.getColumnCount() == i) {
                cm.addColumn(this.getProjectColumn());
            }
            ++i;
        }
        while (cm.getColumnCount() > i && cm.getColumn(i) != this.getDescriptionColumn()) {
            cm.removeColumn(cm.getColumn(i));
        }
        if (cm.getColumnCount() == i) {
            cm.addColumn(this.getDescriptionColumn());
        }
        ++i;
        if (this.showPriorityColumn) {
            while (cm.getColumnCount() > i && cm.getColumn(i) != this.getPriorityColumn()) {
                cm.removeColumn(cm.getColumn(i));
            }
            if (cm.getColumnCount() == i) {
                cm.addColumn(this.getPriorityColumn());
            }
            ++i;
        }
        if (this.showRemindColumn) {
            while (cm.getColumnCount() > i && cm.getColumn(i) != this.getRemindColumn()) {
                cm.removeColumn(cm.getColumn(i));
            }
            if (cm.getColumnCount() == i) {
                cm.addColumn(this.getRemindColumn());
            }
            ++i;
        }
        if (this.showResolvedColumn) {
            while (cm.getColumnCount() > i && cm.getColumn(i) != this.getResolvedColumn()) {
                cm.removeColumn(cm.getColumn(i));
            }
            if (cm.getColumnCount() == i) {
                cm.addColumn(this.getResolvedColumn());
            }
            ++i;
        }
        if (this.showQueueColumn) {
            while (cm.getColumnCount() > i && cm.getColumn(i) != this.getQueueColumn()) {
                cm.removeColumn(cm.getColumn(i));
            }
            if (cm.getColumnCount() == i) {
                cm.addColumn(this.getQueueColumn());
            }
            ++i;
        }
        while (cm.getColumnCount() > i && cm.getColumn(i) != this.getActionColumn()) {
            cm.removeColumn(cm.getColumn(i));
        }
        if (cm.getColumnCount() == i) {
            cm.addColumn(this.getActionColumn());
        }
    }

    private TableColumn getRemindColumn() {
        if (this.remindColumn == null) {
            this.remindColumn = new TableColumn();
            this.remindColumn.setModelIndex(3);
            this.remindColumn.setMinWidth(110);
            this.remindColumn.setMaxWidth(110);
            this.remindColumn.setPreferredWidth(110);
            this.remindColumn.setResizable(false);
            this.remindColumn.setHeaderValue(Messages.getString("ActionTable.Reminder"));
            this.remindColumn.setCellRenderer(new TicklingTableCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Date d = null;
                    if (value instanceof Date) {
                        d = (Date)value;
                        value = ApplicationHelper.toISODateString(d);
                        Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                        this.decorateByDate(d, isSelected, hasFocus);
                        return c;
                    }
                    return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                }
            });
        }
        return this.remindColumn;
    }

    private TableColumn getResolvedColumn() {
        if (this.resolvedColumn == null) {
            this.resolvedColumn = new TableColumn();
            this.resolvedColumn.setModelIndex(8);
            this.resolvedColumn.setMinWidth(110);
            this.resolvedColumn.setMaxWidth(110);
            this.resolvedColumn.setPreferredWidth(110);
            this.resolvedColumn.setResizable(false);
            this.resolvedColumn.setHeaderValue(Messages.getString("ActionTable.Resolved"));
            this.resolvedColumn.setCellRenderer(new DefaultTableCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    if (value instanceof Date) {
                        Date d = (Date)value;
                        value = ApplicationHelper.toISODateString(d);
                    }
                    return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                }
            });
        }
        return this.resolvedColumn;
    }

    private TableColumn getIDColumn() {
        if (this.idColumn == null) {
            this.idColumn = new TableColumn();
            this.idColumn.setMinWidth(45);
            this.idColumn.setMaxWidth(45);
            this.idColumn.setPreferredWidth(45);
            this.idColumn.setResizable(false);
            TicklingTableCellRenderer tce = new TicklingTableCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component c = super.getTableCellRendererComponent(table, value instanceof Integer ? value.toString() + " " : value, isSelected, hasFocus, row, column);
                    if (row < ActionTable.this.model.getRowCount()) {
                        this.decorateByDate(ActionTable.this.model.getAction(row).getRemind(), isSelected, hasFocus);
                    }
                    return c;
                }
            };
            tce.setHorizontalAlignment(4);
            this.idColumn.setCellRenderer(tce);
            this.idColumn.setModelIndex(0);
            this.idColumn.setHeaderValue(Messages.getString("ActionTable.ID"));
        }
        return this.idColumn;
    }

    private TableColumn getDescriptionColumn() {
        if (this.descriptionColumn == null) {
            this.descriptionColumn = new TableColumn();
            this.descriptionColumn.setResizable(true);
            DefaultTableCellRenderer tce = new DefaultTableCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    int r = ActionTable.this.convertRowIndexToModel(row);
                    this.setToolTipText(ActionTable.this.model.getTooltip(r));
                    return super.getTableCellRendererComponent(table, ActionTable.this.model.getDescription(r), isSelected, hasFocus, row, column);
                }
            };
            tce.setHorizontalAlignment(2);
            this.descriptionColumn.setCellRenderer(tce);
            this.descriptionColumn.setCellEditor(new DescriptionCellEditor());
            this.descriptionColumn.setModelIndex(1);
            this.descriptionColumn.setHeaderValue(Messages.getString("ActionTable.Description"));
        }
        return this.descriptionColumn;
    }

    private TableColumn getProjectColumn() {
        if (this.projectColumn == null) {
            this.projectColumn = new TableColumn();
            this.projectColumn.setResizable(true);
            DefaultTableCellRenderer tce = new DefaultTableCellRenderer(){
                private static final long serialVersionUID = -6660513206945588329L;

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Folder p = null;
                    if (ActionTable.this.engine != null && value != null) {
                        p = ActionTable.this.engine.getGTDModel().getProject((Integer)value);
                    }
                    value = p != null ? p.getName() : "";
                    this.setToolTipText(value.toString());
                    Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    c.setFont(c.getFont().deriveFont(2));
                    return c;
                }
            };
            tce.setHorizontalAlignment(2);
            this.projectColumn.setCellRenderer(tce);
            this.projectEditor = new ProjectCellEditor();
            this.projectEditor.setShowClosedFolders(this.showClosedFolders);
            this.projectColumn.setCellEditor(this.projectEditor);
            if (this.engine != null) {
                this.projectEditor.setGTDModel(this.engine.getGTDModel());
            }
            this.projectColumn.setModelIndex(5);
            this.projectColumn.setHeaderValue(Messages.getString("ActionTable.Project"));
            this.projectColumn.setResizable(false);
        }
        return this.projectColumn;
    }

    private TableColumn getPriorityColumn() {
        if (this.priorityColumn == null) {
            this.priorityColumn = new TableColumn();
            this.priorityColumn.setResizable(false);
            this.priorityColumn.setCellRenderer(new PriorityCellRenderer());
            PriorityCellEditor e = new PriorityCellEditor();
            this.priorityColumn.setCellEditor(e);
            this.priorityColumn.setModelIndex(9);
            this.priorityColumn.setHeaderValue(Messages.getString("ActionTable.Priority"));
            this.priorityColumn.setWidth(e.getPreferredSize().width);
            this.priorityColumn.setMinWidth(e.getPreferredSize().width);
            this.priorityColumn.setMaxWidth(e.getPreferredSize().width);
        }
        return this.priorityColumn;
    }

    private TableColumn getFolderColumn() {
        if (this.folderColumn == null) {
            this.folderColumn = new TableColumn();
            this.folderColumn.setResizable(true);
            DefaultTableCellRenderer tce = new DefaultTableCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    value = value instanceof Folder ? ((Folder)value).getName() : "";
                    this.setToolTipText(value.toString());
                    return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                }
            };
            tce.setHorizontalAlignment(2);
            this.folderColumn.setCellRenderer(tce);
            this.folderColumn.setModelIndex(6);
            this.folderColumn.setHeaderValue(Messages.getString("ActionTable.Folder"));
            this.folderColumn.setResizable(false);
            this.folderColumn.setWidth(150);
            this.folderColumn.setMaxWidth(150);
            this.folderColumn.setMinWidth(150);
            this.folderColumn.setPreferredWidth(150);
        }
        return this.folderColumn;
    }

    private TableColumn getActionColumn() {
        int i;
        if (this.actionColumn == null) {
            this.actionColumn = new TableColumn();
            i = this.getRowHeight();
            this.actionColumn.setMinWidth(i);
            this.actionColumn.setMaxWidth(i);
            this.actionColumn.setPreferredWidth(i);
            this.actionColumn.setModelIndex(7);
            this.actionColumn.setCellRenderer(new CellActionEditor());
            this.actionColumn.setCellEditor(new CellActionEditor());
        }
        if ((i = this.getRowHeight()) != this.actionColumn.getMinWidth()) {
            this.actionColumn.setMinWidth(i);
            this.actionColumn.setMaxWidth(i);
            this.actionColumn.setPreferredWidth(i);
        }
        return this.actionColumn;
    }

    private TableColumn getQueueColumn() {
        int i;
        if (this.queueColumn == null) {
            this.queueColumn = new TableColumn();
            this.queueColumn.setModelIndex(4);
            this.queueColumn.setCellRenderer(new QueueCellEditor());
            this.queueColumn.setCellEditor(new QueueCellEditor());
        }
        if ((i = this.getRowHeight()) != this.queueColumn.getMaxWidth()) {
            this.queueColumn.setMinWidth(i);
            this.queueColumn.setMaxWidth(i);
            this.queueColumn.setPreferredWidth(i);
        }
        return this.queueColumn;
    }

    public ActionTable() {
        this.initialize();
    }

    private void initialize() {
        this.setSelectionMode(2);
        this.setShowHorizontalLines(false);
        this.setShowVerticalLines(false);
        this.setCellSelectionEnabled(false);
        this.setRowSelectionAllowed(true);
        this.setBackground(Color.WHITE);
        this.setAutoResizeMode(1);
        this.setAutoCreateColumnsFromModel(false);
        HashSet<AWTKeyStroke> set = new HashSet<AWTKeyStroke>();
        set.add(AWTKeyStroke.getAWTKeyStroke(9, 0));
        set.add(AWTKeyStroke.getAWTKeyStroke(9, 2));
        this.setFocusTraversalKeys(0, set);
        set = new HashSet();
        set.add(AWTKeyStroke.getAWTKeyStroke(9, 64));
        set.add(AWTKeyStroke.getAWTKeyStroke(9, 66));
        this.setFocusTraversalKeys(1, set);
        this.model = new ActionTableModel();
        this.setModel(this.model);
        this.rebuildColumns();
        this.setDefaultEditor(String.class, new ActionCellEditor());
        this.rowSorter = new ActionRowSorter();
        this.setRowSorter(this.rowSorter);
        FontMetrics fm = this.getFontMetrics(this.getFont());
        this.setRowHeight(fm.getHeight() + 3);
        this.setDragEnabled(true);
        this.transferHandler = new ActionTransferHandler(){
            private static final long serialVersionUID = -1850999423399406990L;

            @Override
            protected boolean importActions(Action[] a, Folder source, int[] indexes, TransferHandler.TransferSupport support) {
                if (a != null && a.length > 0) {
                    ActionTable.this.engine.getGTDModel().moveActions(a, ActionTable.this.folder);
                    return true;
                }
                return false;
            }

            @Override
            protected Action[] exportActions() {
                Action[] a = ActionTable.this.getSelectedActions();
                if (a == null || a.length == 0) {
                    return null;
                }
                return a;
            }

            @Override
            protected int[] exportIndexes() {
                return ActionTable.this.getSelectedRows();
            }

            @Override
            protected Folder exportSourceFolder() {
                return ActionTable.this.getFolder();
            }
        };
        this.setTransferHandler(this.transferHandler);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    Action[] old = ActionTable.this.selectedActions;
                    int[] rows = ActionTable.this.getSelectedRows();
                    ArrayList<Action> a = new ArrayList<Action>();
                    for (int j = 0; j < rows.length; ++j) {
                        if (rows[j] <= -1 || rows[j] >= ActionTable.this.model.getRowCount()) continue;
                        a.add(ActionTable.this.model.getAction(ActionTable.this.convertRowIndexToModel(rows[j])));
                    }
                    if (a.size() > 0) {
                        ActionTable.access$1602(ActionTable.this, a.toArray(new Action[a.size()]));
                    } else {
                        ActionTable.access$1602(ActionTable.this, null);
                    }
                    ActionTable.this.enableMoveActions();
                    try {
                        ActionTable.this.firePropertyChange(ActionTable.SELECTED_ACTIONS_PROPERTY_NAME, old, ActionTable.this.selectedActions);
                    }
                    catch (Exception ex) {
                        Logger.getLogger(this.getClass()).debug("Internal error.", ex);
                    }
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                this.tryPopup(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.tryPopup(e);
            }

            public void tryPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ActionTable.this.getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.getActionMap().put(JACTION_MOVE_DOWN, this.getMoveDownAction());
        this.getActionMap().put(JACTION_MOVE_UP, this.getMoveUpAction());
        this.getActionMap().put(JACTION_SELECT_NEXT, this.getSelectNextAction());
        this.getActionMap().put(JACTION_SELECT_PREVIOUS, this.getSelectPreviousAction());
    }

    private JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.popupMenu.add(this.getActionMap().get("actionPanel.resolve"));
            this.popupMenu.add(this.getActionMap().get("actionPanel.queue"));
            this.popupMenu.add(this.getActionMap().get("actionPanel.delete"));
            this.popupMenu.add(this.getActionMap().get("actionPanel.reopen"));
            this.popupMenu.add(new JSeparator());
            this.popupMenu.add(this.getSelectNextAction());
            this.popupMenu.add(this.getSelectPreviousAction());
            this.popupMenu.add(this.getMoveUpAction());
            this.popupMenu.add(this.getMoveDownAction());
            this.popupMenu.add(new JSeparator());
            this.popupMenu.add(this.getSaveRowOrder());
        }
        return this.popupMenu;
    }

    private javax.swing.Action getSaveRowOrder() {
        if (this.saveRowOrder == null) {
            this.saveRowOrder = new AbstractAction(Messages.getString("ActionTable.SaveRowOrder")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActionTable.this.saveActionOrder();
                }
            };
            this.saveRowOrder.setEnabled(!this.rowSorter.isUnsorted());
            this.rowSorter.addRowSorterListener(new RowSorterListener(){

                @Override
                public void sorterChanged(RowSorterEvent e) {
                    ActionTable.this.saveRowOrder.setEnabled(!ActionTable.this.rowSorter.isUnsorted());
                }
            });
        }
        return this.saveRowOrder;
    }

    public void setSelectedAction(Action a) {
        int i = this.model.indexOf(a);
        if (i > -1) {
            i = this.convertRowIndexToView(i);
            this.getSelectionModel().setSelectionInterval(i, i);
        }
    }

    public Folder getFolder() {
        return this.folder;
    }

    public void setFolder(Folder folder) {
        this.setFolder(folder, this.showAll);
    }

    public void setFolder(Folder folder, boolean showAll) {
        if (this.folder != null) {
            this.folder.removeFolderListener(this.folderListener);
        }
        Folder old = this.folder;
        this.folder = folder;
        this.filter = null;
        if (folder != null) {
            this.updateIDColumnWidth();
            folder.addFolderListener(this.folderListener);
            this.setShowAll(showAll);
            this.setShowResolvedColumn(this.engine.getStateMachine().getShowResolvedColumn(folder.getType()));
            this.setShowRemindColumn(this.engine.getStateMachine().getShowRemindColumn(folder.getType()));
            this.setShowPriorityColumn(this.engine.getStateMachine().getShowPriorityColumn(folder.getType()));
            this.setShowProjectColumn(this.engine.getStateMachine().getShowProjectColumn(folder.getType()));
            this.setShowFolderColumn(this.engine.getStateMachine().getShowFolderColumn(folder.getType()));
            if (this.projectEditor != null) {
                int i = this.projectEditor.getPreferredWidth();
                this.getProjectColumn().setWidth(i);
                this.getProjectColumn().setMaxWidth(i);
                this.getProjectColumn().setMinWidth(Math.min(75, i));
                this.getProjectColumn().setPreferredWidth(i);
            }
            this.enableMoveActions();
        }
        this.model.reload(folder, this.filter);
        this.rowSorter.setSortKeys(EMPTY_KEYS);
        this.firePropertyChange(FOLDER_PROPERTY_NAME, old, folder);
    }

    private void updateIDColumnWidth() {
        int id = this.folder.getParent().getLastActionID();
        Component c = this.getColumnModel().getColumn(0).getCellRenderer().getTableCellRendererComponent(this, id, false, false, 0, 0);
        int size = c.getFontMetrics(c.getFont()).stringWidth(id + " ") + 10;
        if (size != this.getIDColumn().getPreferredWidth()) {
            this.getIDColumn().setWidth(size);
            this.getIDColumn().setMinWidth(size);
            this.getIDColumn().setMaxWidth(size);
            this.getIDColumn().setPreferredWidth(size);
        }
    }

    public Action getAction(int row) {
        return this.model.getAction(row);
    }

    public Action getActionAtView(int row) {
        return this.model.getAction(this.convertRowIndexToModel(row));
    }

    public boolean isShowAll() {
        return this.showAll;
    }

    public void setShowAll(boolean showAll) {
        if (this.showAll == showAll) {
            return;
        }
        this.showAll = showAll;
        this.model.reload(this.folder, this.filter);
    }

    public Action getSelectedAction() {
        return this.selectedActions != null ? this.selectedActions[0] : null;
    }

    public Action getFirstSelectedAction() {
        return this.selectedActions != null ? this.selectedActions[0] : null;
    }

    public Action getLastSelectedAction() {
        return this.selectedActions != null ? this.selectedActions[this.selectedActions.length - 1] : null;
    }

    public Action[] getSelectedActions() {
        return this.selectedActions;
    }

    public boolean isMoveEnabled() {
        return this.moveEnabled;
    }

    public void setMoveEnabled(boolean moveEnabled) {
        this.moveEnabled = moveEnabled;
        if (moveEnabled) {
            this.getMoveDownAction();
            this.getMoveUpAction();
        }
        this.enableMoveActions();
    }

    private void enableMoveActions() {
        if (this.moveUpAction != null) {
            this.moveUpAction.setEnabled(this.moveEnabled && this.getSelectedAction() != null && this.engine.getStateMachine().getChangeActionOrder(this.getFolder().getType()) && this.getFolder().canMoveUp(this.getSelectedAction()));
        }
        if (this.moveDownAction != null) {
            this.moveDownAction.setEnabled(this.moveEnabled && this.getSelectedAction() != null && this.engine.getStateMachine().getChangeActionOrder(this.getFolder().getType()) && this.getFolder().canMoveDown(this.getSelectedAction()));
        }
    }

    private void enableSelectActions() {
        if (this.goNextAction != null) {
            this.goNextAction.setEnabled(this.model.getRowCount() > 0);
        }
        if (this.goPreviousAction != null) {
            this.goPreviousAction.setEnabled(this.model.getRowCount() > 0);
        }
    }

    private javax.swing.Action getMoveUpAction() {
        if (this.moveUpAction == null) {
            this.moveUpAction = new AbstractAction(Messages.getString("ActionTable.MoveUp")){
                private static final long serialVersionUID = 9040402331054547898L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ActionTable.this.moveEnabled && ActionTable.this.getSelectedAction() != null) {
                        if (!ActionTable.this.rowSorter.isUnsorted()) {
                            ActionTable.this.saveActionOrder();
                            ActionTable.this.getRowSorter().setSortKeys(EMPTY_KEYS);
                        } else {
                            ActionTable.this.getRowSorter().setSortKeys(EMPTY_KEYS);
                            ActionTable.this.getFolder().moveUp(ActionTable.this.getFirstSelectedAction());
                            ActionTable.this.enableMoveActions();
                        }
                    }
                }
            };
            this.moveUpAction.putValue("ShortDescription", Messages.getString("ActionTable.MoveUp.desc"));
            this.moveUpAction.putValue("SwingLargeIconKey", ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_up));
            this.moveUpAction.putValue("SmallIcon", ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_up));
            this.moveUpAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(38, 128));
            this.getInputMap().put(KeyStroke.getKeyStroke(38, 128), JACTION_MOVE_UP);
            this.getActionMap().put(JACTION_MOVE_UP, this.moveUpAction);
            this.enableMoveActions();
        }
        return this.moveUpAction;
    }

    private javax.swing.Action getSelectNextAction() {
        if (this.goNextAction == null) {
            this.goNextAction = new AbstractAction(Messages.getString("ActionTable.Next")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    int[] i = ActionTable.this.getSelectedRows();
                    int sel = i == null || i.length == 0 || i[i.length - 1] == -1 || i[i.length - 1] + 1 >= ActionTable.this.getRowCount() ? 0 : i[i.length - 1] + 1;
                    ActionTable.this.getSelectionModel().setSelectionInterval(sel, sel);
                }
            };
            this.goNextAction.putValue("ShortDescription", Messages.getString("ActionTable.Next.desc"));
            this.goNextAction.putValue("SwingLargeIconKey", ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_next));
            this.goNextAction.putValue("SmallIcon", ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_next));
            this.getActionMap().put(JACTION_SELECT_NEXT, this.goNextAction);
        }
        return this.goNextAction;
    }

    private javax.swing.Action getSelectPreviousAction() {
        if (this.goPreviousAction == null) {
            this.goPreviousAction = new AbstractAction(Messages.getString("ActionTable.Prev")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    int[] i = ActionTable.this.getSelectedRows();
                    int sel = i == null || i.length == 0 || i[0] == -1 || i[0] - 1 < 0 ? ActionTable.this.getRowCount() - 1 : i[0] - 1;
                    ActionTable.this.getSelectionModel().setSelectionInterval(sel, sel);
                }
            };
            this.goPreviousAction.putValue("ShortDescription", Messages.getString("ActionTable.Prev.desc"));
            this.goPreviousAction.putValue("SwingLargeIconKey", ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_previous));
            this.goPreviousAction.putValue("SmallIcon", ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_previous));
            this.getActionMap().put(JACTION_SELECT_PREVIOUS, this.goPreviousAction);
        }
        return this.goPreviousAction;
    }

    private javax.swing.Action getMoveDownAction() {
        if (this.moveDownAction == null) {
            this.moveDownAction = new AbstractAction(Messages.getString("ActionTable.MoveDown")){
                private static final long serialVersionUID = 4715532030674163250L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ActionTable.this.moveEnabled && ActionTable.this.getSelectedAction() != null) {
                        if (!ActionTable.this.rowSorter.isUnsorted()) {
                            ActionTable.this.saveActionOrder();
                            ActionTable.this.getRowSorter().setSortKeys(EMPTY_KEYS);
                        } else {
                            ActionTable.this.getRowSorter().setSortKeys(EMPTY_KEYS);
                            Action a = ActionTable.this.getLastSelectedAction();
                            ActionTable.this.getFolder().moveDown(a);
                            ActionTable.this.setSelectedAction(a);
                            ActionTable.this.enableMoveActions();
                        }
                    }
                }
            };
            this.moveDownAction.putValue("ShortDescription", Messages.getString("ActionTable.MoveDown.desc"));
            this.moveDownAction.putValue("SwingLargeIconKey", ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_down));
            this.moveDownAction.putValue("SmallIcon", ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_down));
            this.moveDownAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(40, 128));
            this.getInputMap().put(KeyStroke.getKeyStroke(40, 128), JACTION_MOVE_DOWN);
            this.getActionMap().put(JACTION_MOVE_DOWN, this.moveDownAction);
            this.enableMoveActions();
        }
        return this.moveDownAction;
    }

    public ActionFilter getFilter() {
        return this.filter;
    }

    public void setFilter(ActionFilter filter) {
        if (this.filter != null && this.filter.equals(filter)) {
            return;
        }
        if (this.filter == null && filter == null) {
            return;
        }
        this.filter = filter;
        this.model.reload(this.folder, filter);
    }

    public boolean isShowProjectColumn() {
        return this.showProjectColumn;
    }

    public void setShowProjectColumn(boolean showProjectColumn) {
        this.showProjectColumn = showProjectColumn;
        this.rebuildColumns();
    }

    public void setEngine(GTDFreeEngine e) {
        this.engine = e;
        this.transferHandler.setModel(e.getGTDModel());
        if (this.projectEditor != null) {
            this.projectEditor.setGTDModel(this.engine.getGTDModel());
        }
    }

    public boolean isShowQueueColumn() {
        return this.showQueueColumn;
    }

    public void setShowQueueColumn(boolean showQueueColumn) {
        this.showQueueColumn = showQueueColumn;
        this.rebuildColumns();
    }

    public boolean isShowFolderColumn() {
        return this.showFolderColumn;
    }

    public void setShowFolderColumn(boolean showFolderColumn) {
        this.showFolderColumn = showFolderColumn;
        this.rebuildColumns();
    }

    public boolean isShowPriorityColumn() {
        return this.showPriorityColumn;
    }

    public void setShowPriorityColumn(boolean showPriorityColumn) {
        this.showPriorityColumn = showPriorityColumn;
        this.rebuildColumns();
    }

    public void setSingleSelectionMode(boolean singleSelectionMode) {
        this.singleSelectionMode = singleSelectionMode;
        if (singleSelectionMode) {
            this.setSelectionMode(0);
        } else {
            this.setSelectionMode(2);
        }
    }

    public boolean isSingleSelectionMode() {
        return this.singleSelectionMode;
    }

    public boolean containsAction(Action a) {
        return this.model.indexOf(a) > -1;
    }

    public boolean isShowClosedFolders() {
        return this.showClosedFolders;
    }

    public void setShowClosedFolders(boolean showClosedFolders) {
        this.showClosedFolders = showClosedFolders;
        if (this.projectEditor != null) {
            this.projectEditor.setShowClosedFolders(showClosedFolders);
        }
    }

    public void saveActionOrder() {
        if (this.rowSorter.isUnsorted()) {
            return;
        }
        Action[] order = new Action[this.model.getRowCount()];
        for (int i = 0; i < order.length; ++i) {
            order[i] = this.model.getAction(this.convertRowIndexToModel(i));
        }
        this.folder.reorder(order);
    }

    public void addSwingActions(ActionMap actions) {
        for (Object key : actions.allKeys()) {
            if (this.getActionMap().get(key) != null) continue;
            this.getActionMap().put(key, actions.get(key));
        }
    }

    static /* synthetic */ Action[] access$1602(ActionTable x0, Action[] x1) {
        x0.selectedActions = x1;
        return x1;
    }

    abstract class TicklingTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        private Color alarmBackground = new Color(0xF8FF89);

        TicklingTableCellRenderer() {
        }

        public void decorateByDate(Date d, boolean isSelected, boolean hasFocus) {
            if (isSelected || hasFocus) {
                return;
            }
            if (d == null) {
                this.setForeground(ActionTable.this.getForeground());
                this.setBackground(ActionTable.this.getBackground());
                this.setFont(this.getFont().deriveFont(0));
            } else {
                long today = Utils.today();
                if (d.getTime() < today) {
                    this.setForeground(Color.RED);
                    this.setBackground(ActionTable.this.getBackground());
                    this.setFont(this.getFont().deriveFont(0));
                } else {
                    if (d.getTime() < today + 86400000L) {
                        this.setForeground(Color.RED);
                        this.setFont(this.getFont().deriveFont(1));
                    } else {
                        this.setForeground(ActionTable.this.getForeground());
                        this.setFont(this.getFont().deriveFont(0));
                    }
                    if (d.getTime() - today < 259200000L) {
                        this.setBackground(this.alarmBackground);
                    } else {
                        this.setBackground(ActionTable.this.getBackground());
                    }
                }
            }
        }
    }

    class ActionRowSorter
    extends TableRowSorter<ActionTableModel> {
        public ActionRowSorter() {
            super(ActionTable.this.model);
            this.setSortsOnUpdates(true);
            this.setComparator(4, new Comparator<Action>(){

                @Override
                public int compare(Action o1, Action o2) {
                    if (o1.isQueued() && !o2.isQueued()) {
                        return -1;
                    }
                    if (!o1.isQueued() && o2.isQueued()) {
                        return 1;
                    }
                    return 0;
                }
            });
            this.setComparator(5, new Comparator<Integer>(){

                @Override
                public int compare(Integer o1, Integer o2) {
                    if (o1 == null && o2 == null) {
                        return 0;
                    }
                    if (o1 == null) {
                        return -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    if (o1.equals(o2)) {
                        return 0;
                    }
                    Project p1 = ActionTable.this.engine.getGTDModel().getProject(o1);
                    Project p2 = ActionTable.this.engine.getGTDModel().getProject(o2);
                    if (p1 == null && p2 == null) {
                        return 0;
                    }
                    if (p1 == null) {
                        return -1;
                    }
                    if (p2 == null) {
                        return 1;
                    }
                    return p1.getName().compareTo(p2.getName());
                }
            });
            this.setComparator(6, new Comparator<Folder>(){

                @Override
                public int compare(Folder o1, Folder o2) {
                    if (o1 == null && o2 == null) {
                        return 0;
                    }
                    if (o1 == null) {
                        return -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    return o1.getName().compareTo(o2.getName());
                }
            });
            this.setComparator(7, new Comparator<Action>(){

                @Override
                public int compare(Action o1, Action o2) {
                    if (o1.isOpen() && !o2.isOpen()) {
                        return -1;
                    }
                    if (!o1.isOpen() && o2.isOpen()) {
                        return 1;
                    }
                    return 0;
                }
            });
            this.addRowSorterListener(new RowSorterListener(){

                @Override
                public void sorterChanged(RowSorterEvent e) {
                    ActionTable.this.enableMoveActions();
                }
            });
        }

        public boolean isUnsorted() {
            List<RowSorter.SortKey> keys = this.getSortKeys();
            int keySize = keys.size();
            return keySize == 0 || keys.get(0).getSortOrder() == SortOrder.UNSORTED;
        }

        private void checkColumn(int column) {
            if (column < 0 || column >= this.getModelWrapper().getColumnCount()) {
                throw new IndexOutOfBoundsException("column beyond range of TableModel");
            }
        }

        @Override
        public void toggleSortOrder(int column) {
            this.checkColumn(column);
            if (this.isSortable(column)) {
                int sortIndex;
                List<RowSorter.SortKey> keys = new ArrayList<RowSorter.SortKey>(this.getSortKeys());
                for (sortIndex = keys.size() - 1; sortIndex >= 0 && ((RowSorter.SortKey)keys.get(sortIndex)).getColumn() != column; --sortIndex) {
                }
                if (sortIndex == -1) {
                    RowSorter.SortKey sortKey = new RowSorter.SortKey(column, SortOrder.ASCENDING);
                    keys.add(0, sortKey);
                } else if (sortIndex == 0) {
                    keys.set(0, this.toggle((RowSorter.SortKey)keys.get(0)));
                } else {
                    keys.remove(sortIndex);
                    keys.add(0, new RowSorter.SortKey(column, SortOrder.ASCENDING));
                }
                if (keys.size() > this.getMaxSortKeys()) {
                    keys = keys.subList(0, this.getMaxSortKeys());
                }
                this.setSortKeys(keys);
            }
        }

        private RowSorter.SortKey toggle(RowSorter.SortKey key) {
            if (key.getSortOrder() == SortOrder.ASCENDING) {
                return new RowSorter.SortKey(key.getColumn(), SortOrder.DESCENDING);
            }
            if (key.getSortOrder() == SortOrder.DESCENDING) {
                return new RowSorter.SortKey(key.getColumn(), SortOrder.UNSORTED);
            }
            return new RowSorter.SortKey(key.getColumn(), SortOrder.ASCENDING);
        }
    }

    class QueueCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    TableCellRenderer {
        private static final long serialVersionUID = 1L;
        private JToggleButton button = new JToggleButton();
        private Action note;

        public QueueCellEditor() {
            this.button.setMargin(new Insets(0, 0, 0, 0));
            this.button.setToolTipText(Messages.getString("ActionTable.Queue.desc"));
            this.button.setIcon(ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_queue_off));
            this.button.setSelectedIcon(ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_queue_on));
            this.button.setDisabledSelectedIcon(ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_queue_off));
            this.button.setBackground(ActionTable.this.getBackground());
            this.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    QueueCellEditor.this.stopCellEditing();
                    if (QueueCellEditor.this.note != null) {
                        QueueCellEditor.this.note.setQueued(QueueCellEditor.this.button.isSelected());
                    }
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value instanceof Action) {
                this.note = (Action)value;
                this.button.setEnabled(this.note.isOpen());
                if (this.note.isOpen()) {
                    this.button.setSelected(this.note.isQueued());
                } else {
                    this.button.setSelected(false);
                }
            } else {
                this.note = null;
                this.button.setEnabled(false);
                this.button.setSelected(false);
            }
            return this.button;
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Action) {
                Action n = (Action)value;
                this.button.setEnabled(n.isOpen());
                if (n.isOpen()) {
                    this.button.setSelected(n.isQueued());
                } else {
                    this.button.setSelected(false);
                }
            } else {
                this.button.setEnabled(false);
                this.button.setSelected(false);
            }
            return this.button;
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            return true;
        }
    }

    class CellActionEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    TableCellRenderer {
        private static final long serialVersionUID = 1L;
        private JButton button = new JButton();
        private Action note;
        private CellAction a;
        private Action.Resolution resolution;

        public CellActionEditor() {
            this.button.setMargin(new Insets(0, 0, 0, 0));
            this.button.setBackground(ActionTable.this.getBackground());
            this.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CellActionEditor.this.stopCellEditing();
                    if (CellActionEditor.this.note != null) {
                        CellActionEditor.this.note.setResolution(CellActionEditor.this.resolution);
                    }
                }
            });
        }

        private boolean setupAction(boolean isOpen) {
            if (isOpen) {
                if (this.a == ActionTable.this.cellAction) {
                    return ActionTable.this.cellAction != CellAction.REOPEN;
                }
                if (ActionTable.this.cellAction == CellAction.DELETE) {
                    this.a = CellAction.DELETE;
                    this.resolution = Action.Resolution.DELETED;
                    this.button.setToolTipText(Messages.getString("ActionTable.Delete.desc"));
                    this.button.setIcon(ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_delete));
                    return true;
                }
                if (ActionTable.this.cellAction == CellAction.RESOLVE) {
                    this.a = CellAction.RESOLVE;
                    this.resolution = Action.Resolution.RESOLVED;
                    this.button.setToolTipText(Messages.getString("ActionTable.Resolve"));
                    this.button.setIcon(ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_resolve));
                    return true;
                }
                this.a = CellAction.REOPEN;
                this.resolution = Action.Resolution.OPEN;
                this.button.setToolTipText(Messages.getString("ActionTable.Reopen.desc"));
                this.button.setIcon(ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_undelete));
                return false;
            }
            this.a = CellAction.REOPEN;
            this.resolution = Action.Resolution.OPEN;
            this.button.setToolTipText(Messages.getString("ActionTable.Reopen.desc"));
            this.button.setIcon(ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_undelete));
            return true;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value instanceof Action) {
                this.note = (Action)value;
                this.button.setEnabled(this.setupAction(this.note.isOpen()));
            } else {
                this.note = null;
                this.button.setEnabled(false);
            }
            return this.button;
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Action) {
                this.note = (Action)value;
                this.button.setEnabled(this.setupAction(this.note.isOpen()));
            } else {
                this.note = null;
                this.button.setEnabled(false);
            }
            return this.button;
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            return true;
        }
    }

    public class ActionTableModel
    extends AbstractTableModel
    implements TableModel {
        private static final String DOTS = "...";
        private static final long serialVersionUID = 1L;
        private List<Action> data = new ArrayList<Action>();
        private ArrayList<WeakReference<String>> descriptions = new ArrayList();
        private ArrayList<WeakReference<String>> tooltips = new ArrayList();

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Action i = this.data.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return i.getId();
                }
                case 1: {
                    return i.getDescription();
                }
                case 2: {
                    return i.getResolution();
                }
                case 3: {
                    return i.getRemind();
                }
                case 4: {
                    return i;
                }
                case 5: {
                    return i.getProject();
                }
                case 6: {
                    return i.getParent();
                }
                case 7: {
                    return i;
                }
                case 8: {
                    return i.getResolved();
                }
                case 9: {
                    return i.getPriority();
                }
            }
            return i;
        }

        public Action getAction(int rowIndex) {
            return this.data.get(rowIndex);
        }

        @Override
        public int getColumnCount() {
            return 10;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        public void remove(Action i) {
            int sel = ActionTable.this.getSelectedRow();
            int ix = this.data.indexOf(i);
            if (ix > -1) {
                this.data.remove(ix);
                this.descriptions.remove(ix);
                this.tooltips.remove(ix);
                this.fireTableRowsDeleted(ix, ix);
                if (sel >= this.getRowCount()) {
                    sel = this.getRowCount() - 1;
                }
                if (sel > -1) {
                    ActionTable.this.getSelectionModel().setSelectionInterval(sel, sel);
                }
            }
        }

        public void reload(Folder f, ActionFilter a) {
            this.data.clear();
            int width = 45;
            if (f != null) {
                int i;
                Action note;
                Iterator<Action> it;
                if (a != null) {
                    it = f.iterator(ActionTable.this.showAll ? Folder.FolderPreset.ALL : Folder.FolderPreset.OPEN);
                    while (it.hasNext()) {
                        note = it.next();
                        if (!a.isAcceptable(f, note)) continue;
                        this.data.add(note);
                        if (!ActionTable.this.showFolderColumn || (i = ActionTable.this.getFontMetrics(ActionTable.this.getFont()).stringWidth(note.getParent().getName())) <= width) continue;
                        width = i;
                    }
                } else {
                    it = f.iterator(ActionTable.this.showAll ? Folder.FolderPreset.ALL : Folder.FolderPreset.OPEN);
                    while (it.hasNext()) {
                        note = it.next();
                        this.data.add(note);
                        if (!ActionTable.this.showFolderColumn || (i = ActionTable.this.getFontMetrics(ActionTable.this.getFont()).stringWidth(note.getParent().getName())) <= width) continue;
                        width = i;
                    }
                }
            }
            if (ActionTable.this.showFolderColumn && (width += 6) != ActionTable.this.getFolderColumn().getMaxWidth()) {
                ActionTable.this.getFolderColumn().setWidth(width);
                ActionTable.this.getFolderColumn().setMaxWidth(width);
                ActionTable.this.getFolderColumn().setMinWidth(Math.min(75, width));
                ActionTable.this.getFolderColumn().setPreferredWidth(width);
            }
            this.descriptions.clear();
            this.tooltips.clear();
            this.descriptions.ensureCapacity(this.data.size());
            this.tooltips.ensureCapacity(this.data.size());
            for (int i = 0; i < this.data.size(); ++i) {
                this.descriptions.add(null);
                this.tooltips.add(null);
            }
            this.fireTableDataChanged();
            ActionTable.this.enableSelectActions();
        }

        public String getDescription(int row) {
            String s;
            if (this.descriptions.size() <= row) {
                return this.toDescription(this.data.get(row).getDescription());
            }
            WeakReference<String> w = this.descriptions.get(row);
            if (w != null && (s = (String)w.get()) != null) {
                return s;
            }
            s = this.toDescription(this.data.get(row).getDescription());
            this.descriptions.set(row, new WeakReference<String>(s));
            return s;
        }

        public String getTooltip(int row) {
            String s;
            if (this.tooltips.size() <= row) {
                return this.toTooltip(this.data.get(row).getDescription());
            }
            WeakReference<String> w = this.tooltips.get(row);
            if (w != null && (s = (String)w.get()) != null) {
                return s;
            }
            s = this.toTooltip(this.data.get(row).getDescription());
            this.tooltips.set(row, new WeakReference<String>(s));
            return s;
        }

        private String toDescription(String s) {
            if (s == null) {
                return "";
            }
            return s.replace('\n', ' ');
        }

        private String toTooltip(String s) {
            if (s == null) {
                return "";
            }
            StringBuilder sb = new StringBuilder(s.length() + 128);
            TAG.HTML.printTag(sb);
            TAG.BODY.printTag(sb);
            int line = 0;
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == '\n') {
                    TAG.BR.printTag(sb);
                    if (++line < ActionTable.this.maxTooltipLines) continue;
                    sb.append(DOTS);
                    break;
                }
                sb.append(c);
            }
            TAG.BODY.printTagEnd(sb);
            TAG.HTML.printTagEnd(sb);
            return sb.toString();
        }

        public void fireActionChanged(int ix) {
            this.fireTableRowsUpdated(ix, ix);
        }

        public void fireActionChanged(Action note) {
            int i = this.data.indexOf(note);
            if (i > -1) {
                if (!ActionTable.this.showAll && !note.isOpen()) {
                    int sel = ActionTable.this.getSelectedRow();
                    this.data.remove(i);
                    this.descriptions.remove(i);
                    this.tooltips.remove(i);
                    try {
                        this.fireTableRowsDeleted(i, i);
                    }
                    catch (Exception e) {
                        Logger.getLogger(this.getClass()).debug("Internal error.", e);
                    }
                    if (sel >= this.getRowCount()) {
                        sel = this.getRowCount() - 1;
                    }
                    if (sel > -1) {
                        ActionTable.this.getSelectionModel().setSelectionInterval(sel, sel);
                    }
                } else {
                    try {
                        this.descriptions.set(i, null);
                        this.tooltips.set(i, null);
                        this.fireTableRowsUpdated(i, i);
                    }
                    catch (Exception e) {
                        Logger.getLogger(this.getClass()).debug("Internal error.", e);
                    }
                }
            }
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            Action i = this.data.get(rowIndex);
            this.descriptions.set(rowIndex, null);
            this.tooltips.set(rowIndex, null);
            switch (columnIndex) {
                case 0: {
                    return;
                }
                case 1: {
                    i.setDescription(aValue.toString());
                    break;
                }
                case 5: {
                    if (aValue instanceof Integer) {
                        i.setProject((Integer)aValue);
                        break;
                    }
                    i.setProject(null);
                    break;
                }
                case 9: {
                    if (aValue instanceof Priority) {
                        i.setPriority((Priority)((Object)aValue));
                        break;
                    }
                    i.setPriority(Priority.None);
                    break;
                }
                default: {
                    return;
                }
            }
            if (rowIndex < this.data.size()) {
                this.fireTableCellUpdated(rowIndex, columnIndex);
            }
        }

        public void updateRow(int row) {
            this.descriptions.set(row, null);
            this.tooltips.set(row, null);
            this.fireTableRowsUpdated(row, row);
        }

        public void updateAction(Action a) {
            int i = this.data.indexOf(a);
            if (i >= 0) {
                this.updateRow(i);
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex == 1) {
                Action n = this.getAction(rowIndex);
                return n.isOpen();
            }
            return columnIndex == 4 || columnIndex == 5 || columnIndex == 7 || columnIndex == 9;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Integer.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return Action.Resolution.class;
                }
                case 3: {
                    return Date.class;
                }
                case 4: {
                    return Action.class;
                }
                case 5: {
                    return Project.class;
                }
                case 6: {
                    return Folder.class;
                }
                case 7: {
                    return Action.class;
                }
                case 8: {
                    return Date.class;
                }
                case 9: {
                    return Priority.class;
                }
            }
            return Action.class;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "ID";
                }
                case 1: {
                    return "Action";
                }
                case 2: {
                    return "Resolution";
                }
                case 3: {
                    return "Remind";
                }
                case 9: {
                    return Messages.getString("ActionTable.Priority");
                }
            }
            return "";
        }

        public void remove(int row) {
            int sel = ActionTable.this.getSelectedRow();
            this.data.remove(row);
            this.descriptions.remove(row);
            this.tooltips.remove(row);
            this.fireTableRowsDeleted(row, row);
            if (sel >= this.getRowCount()) {
                sel = this.getRowCount() - 1;
            }
            if (sel > -1) {
                ActionTable.this.getSelectionModel().setSelectionInterval(sel, sel);
            }
        }

        public int indexOf(Action a) {
            return this.data.indexOf(a);
        }
    }

    class PriorityCellRenderer
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;
        PriorityPicker pp;

        public PriorityCellRenderer() {
            this.pp = new PriorityPicker(){
                private static final long serialVersionUID = 1L;

                @Override
                public void invalidate() {
                }

                @Override
                public void validate() {
                }

                @Override
                public void revalidate() {
                }

                @Override
                public void repaint(long tm, int x, int y, int width, int height) {
                }

                @Override
                public void repaint(Rectangle r) {
                }

                @Override
                public void repaint() {
                }
            };
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.pp.setBackground(table.getSelectionBackground());
            } else {
                this.pp.setBackground(table.getBackground());
            }
            if (value instanceof Priority) {
                Priority p = (Priority)((Object)value);
                this.pp.setPriority(p);
            } else {
                this.pp.setPriority(null);
            }
            return this.pp;
        }
    }

    class PriorityCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;
        private Color editColor = new Color(232, 242, 254);
        PriorityPicker pp;
        Priority p;
        boolean editing = false;
        boolean setting = false;

        public PriorityCellEditor() {
            this.pp = new PriorityPicker(){
                private static final long serialVersionUID = 1L;

                @Override
                protected void paintComponent(Graphics g) {
                    Point p = this.getMousePosition();
                    if (p != null) {
                        this.callHover(p, false);
                    }
                    super.paintComponent(g);
                }
            };
            this.pp.addPropertyChangeListener("priority", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (PriorityCellEditor.this.setting) {
                        return;
                    }
                    PriorityCellEditor.this.stopCellEditing();
                }
            });
            this.pp.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    PriorityCellEditor.this.cancelCellEditing();
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
            this.pp.setOpaque(true);
            this.pp.setBackground(this.editColor);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.editing = true;
            this.setting = true;
            if (value instanceof Priority) {
                this.p = (Priority)((Object)value);
                this.pp.setPriority(this.p);
            } else {
                this.p = null;
                this.pp.setPriority(null);
            }
            this.setting = false;
            return this.pp;
        }

        @Override
        public Object getCellEditorValue() {
            return this.pp.getPriority();
        }

        @Override
        public void cancelCellEditing() {
            if (!this.editing) {
                return;
            }
            this.editing = false;
            this.setting = true;
            this.pp.setPriority(this.p);
            this.setting = false;
            super.cancelCellEditing();
        }

        public Dimension getPreferredSize() {
            return this.pp.getPreferredSize();
        }

        @Override
        public boolean stopCellEditing() {
            if (!this.editing) {
                return true;
            }
            this.editing = false;
            return super.stopCellEditing();
        }
    }

    class ProjectCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;
        ProjectsCombo combo = new ProjectsCombo();
        Project p;

        public ProjectCellEditor() {
            this.combo.addPropertyChangeListener("selectedProject", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    ProjectCellEditor.this.stopCellEditing();
                }
            });
            this.combo.addPropertyChangeListener("canceled", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (ActionTable.this.isEditing()) {
                        ProjectCellEditor.this.cancelCellEditing();
                    }
                }
            });
            this.combo.setOpaque(false);
        }

        public void setGTDModel(GTDModel m) {
            this.combo.setGTDModel(m);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value instanceof Integer) {
                this.p = ActionTable.this.engine.getGTDModel().getProject((Integer)value);
                this.combo.setSelectedProject(this.p);
            } else {
                this.p = null;
                this.combo.setSelectedProject(null);
            }
            return this.combo;
        }

        @Override
        public Object getCellEditorValue() {
            return this.combo.getSelectedProject() != null ? Integer.valueOf(this.combo.getSelectedProject().getId()) : null;
        }

        @Override
        public void cancelCellEditing() {
            this.combo.hidePopup();
            this.combo.setSelectedProject(this.p);
            super.cancelCellEditing();
        }

        @Override
        public boolean stopCellEditing() {
            this.combo.hidePopup();
            return super.stopCellEditing();
        }

        public Dimension getPreferredSize() {
            return this.combo.getPreferredSize();
        }

        public int getPreferredWidth() {
            return this.combo.getPreferredWidth();
        }

        public void setShowClosedFolders(boolean show) {
            this.combo.setShowClosedFolders(show);
        }
    }

    class ActionCellEditor
    extends DefaultCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = -4717152933319457542L;

        public ActionCellEditor() {
            super(new JTextField());
            this.editorComponent.setFont(ActionTable.this.getFont());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.editorComponent.setFont(ActionTable.this.getFont());
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        public void setMargin(Insets m) {
            ((JTextField)this.editorComponent).setMargin(m);
        }
    }

    class DescriptionCellEditor
    extends DefaultCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;

        public DescriptionCellEditor() {
            super(new JTextField());
            this.editorComponent.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    DescriptionCellEditor.this.stopCellEditing();
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value != null) {
                value = value.toString().replace('\n', '\u21b2');
            }
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        @Override
        public Object getCellEditorValue() {
            Object val = super.getCellEditorValue();
            if (val != null) {
                val = val.toString().replace('\u21b2', '\n');
            }
            return val;
        }
    }

    public static enum CellAction {
        RESOLVE,
        DELETE,
        REOPEN;

    }
}

