/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.addons;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.FontFactory;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.FontSelector;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.log4j.Logger;
import org.gtdfree.ApplicationHelper;
import org.gtdfree.GTDFreeEngine;
import org.gtdfree.addons.ExportAddOn;
import org.gtdfree.model.Action;
import org.gtdfree.model.ActionsCollection;
import org.gtdfree.model.Folder;
import org.gtdfree.model.GTDModel;
import org.gtdfree.model.Priority;

public class PDFExportAddOn
implements ExportAddOn {
    public static final String DEFAULT_FONT_NAME = "<Default>";
    private static final String NONE_DOT = "No actions selected or defined.";
    private static final String EMPTY = "";
    private static final String NONE = "None";
    private static final String REMINDER = "Reminder: ";
    private static final String PRIORITY = "Priority: ";
    private static final String PROJECT = "Project: ";
    private static final String CREATED = "Created: ";
    private static final String ID = "ID: ";
    private static final String OPEN = "OPEN ";
    private static final String RESOLVED = "RESOLVED ";
    private static final String DELETED = "DELETED ";
    private static final String STALLED = "STALLED ";
    private static final String CHECK_OPEN = "\u2610";
    private static final String CHECK_RESOLVED = "\u2611";
    private static final String CHECK_DELETED = "\u2612";
    private static final String CHECK_STALLED = "\u2205";
    private static final String FULL_STAR = "\u2605";
    private static final String HOLLOW_STAR = "\u2606";
    private static final Color COLOR_PRIORITY_LOW = new Color(0xFFF001);
    private static final Color COLOR_PRIORITY_MEDIUM = new Color(16761147);
    private static final Color COLOR_PRIORITY_HIGH = new Color(16722689);
    private static final Color COLOR_OPEN = new Color(255);
    private static final Color COLOR_DELETED = new Color(0x808080);
    private static final Color COLOR_RESOLVED = new Color(32768);
    private static final String FONT_PROPERTY = "PDFExportAddOn.font";
    private static final String FONT_SIZE_PROPERTY = "PDFExportAddOn.fontSize";
    private String description = "Exports GTD-Free data as PDF doument.";
    private ExportAddOn.ExportOrder[] orders = new ExportAddOn.ExportOrder[]{ExportAddOn.ExportOrder.FoldersProjectsActions, ExportAddOn.ExportOrder.FoldersActions, ExportAddOn.ExportOrder.ProjectsActions, ExportAddOn.ExportOrder.ProjectsFoldersActions, ExportAddOn.ExportOrder.Actions};
    private String name = "PDF";
    private FileFilter[] fileFilters = new FileFilter[]{new FileNameExtensionFilter("PDF documents", "pdf")};
    private float baseFontSize = 9.0f;
    private boolean marginSet = false;
    private float marginBottom;
    private float marginTop;
    private float marginRight;
    private float marginLeft;
    private FontSelector fontSelector;
    private boolean sizeSet;
    private Rectangle pageSize;
    private FontSelector fontSelectorB;
    private FontSelector fontSelectorB2;
    private FontSelector fontSelectorB4;
    private BaseFont baseFont;
    private FontModel fontModel = new FontModel();
    private OptionsPanel component;
    private boolean printMode;
    private GTDFreeEngine engine;

    public boolean isPrintMode() {
        return this.printMode;
    }

    public void setPrintMode(boolean printMode) {
        this.printMode = printMode;
    }

    public void setMargins(float marginLeft, float marginRight, float marginTop, float marginBottom) {
        this.marginLeft = marginLeft;
        this.marginRight = marginRight;
        this.marginTop = marginTop;
        this.marginBottom = marginBottom;
        this.marginSet = true;
    }

    @Override
    public void export(GTDModel model, ActionsCollection collection, OutputStream out, ExportAddOn.ExportOrder order, FileFilter ff, boolean compact) throws Exception {
        this.fontSelector = new FontSelector();
        this.fontSelectorB = new FontSelector();
        this.fontSelectorB2 = new FontSelector();
        this.fontSelectorB4 = new FontSelector();
        this.baseFont = this.fontModel.getBaseFont();
        for (BaseFont bf : this.fontModel.getFonts()) {
            this.fontSelector.addFont(new com.lowagie.text.Font(bf, this.baseFontSize));
            this.fontSelectorB.addFont(new com.lowagie.text.Font(bf, this.baseFontSize, 1));
            this.fontSelectorB2.addFont(new com.lowagie.text.Font(bf, this.baseFontSize + 2.0f, 1));
            this.fontSelectorB4.addFont(new com.lowagie.text.Font(bf, this.baseFontSize + 4.0f, 1));
        }
        boolean emptyH2 = false;
        boolean emptyH3 = false;
        PdfPTable actionTable = null;
        Document doc = new Document();
        if (this.sizeSet) {
            doc.setPageSize(this.pageSize);
        }
        if (this.marginSet) {
            doc.setMargins(this.marginLeft, this.marginRight, this.marginTop, this.marginBottom);
        }
        PdfWriter pw = PdfWriter.getInstance(doc, out);
        doc.addCreationDate();
        doc.addTitle("GTD-Free PDF");
        doc.addSubject("GTD-Free data exported as PDF");
        HeaderFooter footer = new HeaderFooter((Phrase)this.newParagraph(), true);
        footer.setAlignment(1);
        footer.setBorder(1);
        doc.setFooter(footer);
        doc.open();
        Phrase ch = this.newTitle("GTD-Free Data");
        Paragraph p = new Paragraph(ch);
        p.setAlignment(1);
        PdfPTable t = new PdfPTable(1);
        t.setWidthPercentage(100.0f);
        PdfPCell c = this.newCell(p);
        c.setBorder(2);
        c.setBorderWidth(2.5f);
        c.setHorizontalAlignment(1);
        c.setPadding(5.0f);
        t.addCell(c);
        doc.add(t);
        Iterator<Object> it = collection.iterator(order);
        while (it.hasNext()) {
            Object o = it.next();
            if (o == ActionsCollection.ACTIONS_WITHOUT_PROJECT) {
                if (order == ExportAddOn.ExportOrder.FoldersProjectsActions) {
                    doc.add(this.newSubSection(ActionsCollection.ACTIONS_WITHOUT_PROJECT));
                    emptyH2 = false;
                    emptyH3 = true;
                    continue;
                }
                doc.add(this.newSection(ActionsCollection.ACTIONS_WITHOUT_PROJECT));
                emptyH2 = true;
                emptyH3 = false;
                continue;
            }
            if (o instanceof Folder) {
                Folder f = (Folder)o;
                if (actionTable != null) {
                    doc.add(actionTable);
                    actionTable = null;
                }
                if (f.isProject()) {
                    if (order == ExportAddOn.ExportOrder.ProjectsActions || order == ExportAddOn.ExportOrder.ProjectsFoldersActions) {
                        if (emptyH2 || emptyH3) {
                            p = this.newParagraph(NONE_DOT);
                            doc.add(p);
                        }
                        doc.add(this.newSection(f.getName()));
                        if (compact) {
                            if (f.getDescription() != null && f.getDescription().length() > 0) {
                                p = this.newParagraph(f.getDescription());
                                p.setIndentationLeft(10.0f);
                                p.setIndentationRight(10.0f);
                                doc.add(p);
                            }
                        } else {
                            t = new PdfPTable(2);
                            t.setKeepTogether(true);
                            t.setSpacingBefore(5.0f);
                            t.setWidthPercentage(66.0f);
                            t.setWidths(new float[]{0.33f, 0.66f});
                            c = this.newCell("ID");
                            t.addCell(c);
                            c = this.newCell(this.newStrongParagraph(String.valueOf(f.getId())));
                            t.addCell(c);
                            c = this.newCell("Type");
                            t.addCell(c);
                            c = this.newCell(this.newStrongParagraph("Project"));
                            t.addCell(c);
                            c = this.newCell("Open");
                            t.addCell(c);
                            c = this.newCell(this.newStrongParagraph(String.valueOf(f.getOpenCount())));
                            t.addCell(c);
                            c = this.newCell("All");
                            t.addCell(c);
                            c = this.newCell(this.newStrongParagraph(String.valueOf(f.size())));
                            t.addCell(c);
                            c = this.newCell("Description");
                            t.addCell(c);
                            c = this.newDescriptionCell(f.getDescription());
                            t.addCell(c);
                            doc.add(t);
                        }
                        emptyH2 = true;
                        emptyH3 = false;
                        continue;
                    }
                    if (emptyH3) {
                        p = this.newParagraph(NONE_DOT);
                        doc.add(p);
                    }
                    doc.add(this.newSubSection(PROJECT + f.getName()));
                    emptyH2 = false;
                    emptyH3 = true;
                    continue;
                }
                if (order == ExportAddOn.ExportOrder.FoldersActions || order == ExportAddOn.ExportOrder.FoldersProjectsActions) {
                    if (emptyH2 || emptyH3) {
                        p = this.newParagraph(NONE_DOT);
                        doc.add(p);
                    }
                    doc.add(this.newSection(f.getName()));
                    if (compact) {
                        if (f.getDescription() != null && f.getDescription().length() > 0) {
                            p = this.newParagraph(f.getDescription());
                            p.setIndentationLeft(10.0f);
                            p.setIndentationRight(10.0f);
                            doc.add(p);
                        }
                    } else {
                        t = new PdfPTable(2);
                        t.setKeepTogether(true);
                        t.setSpacingBefore(5.0f);
                        t.setWidthPercentage(66.0f);
                        t.setWidths(new float[]{0.33f, 0.66f});
                        c = this.newCell("ID");
                        t.addCell(c);
                        c = this.newCell(this.newStrongParagraph(String.valueOf(f.getId())));
                        t.addCell(c);
                        String type = EMPTY;
                        if (f.isAction()) {
                            type = "Action list";
                        } else if (f.isInBucket()) {
                            type = "In-Bucket";
                        } else if (f.isQueue()) {
                            type = "Next action queue";
                        } else if (f.isReference()) {
                            type = "Reference list";
                        } else if (f.isSomeday()) {
                            type = "Someday/Maybe list";
                        } else if (f.isBuildIn()) {
                            type = "Default list";
                        }
                        c = this.newCell("Type");
                        t.addCell(c);
                        c = this.newCell(this.newStrongParagraph(type));
                        t.addCell(c);
                        c = this.newCell("Open");
                        t.addCell(c);
                        c = this.newCell(this.newStrongParagraph(String.valueOf(f.getOpenCount())));
                        t.addCell(c);
                        c = this.newCell("All");
                        t.addCell(c);
                        c = this.newCell(this.newStrongParagraph(String.valueOf(f.size())));
                        t.addCell(c);
                        c = this.newCell("Description");
                        t.addCell(c);
                        c = this.newDescriptionCell(f.getDescription());
                        t.addCell(c);
                        doc.add(t);
                    }
                    emptyH2 = true;
                    emptyH3 = false;
                    continue;
                }
                if (emptyH3) {
                    p = this.newParagraph(NONE_DOT);
                    doc.add(p);
                }
                doc.add(this.newSubSection("List: " + f.getName()));
                emptyH2 = false;
                emptyH3 = true;
                continue;
            }
            if (!(o instanceof Action)) continue;
            emptyH2 = false;
            emptyH3 = false;
            Action a = (Action)o;
            if (compact) {
                if (actionTable == null) {
                    actionTable = new PdfPTable(5);
                    actionTable.setWidthPercentage(100.0f);
                    actionTable.setHeaderRows(1);
                    actionTable.setSpacingBefore(5.0f);
                    c = this.newHeaderCell("ID");
                    actionTable.addCell(c);
                    c = this.newHeaderCell("Pri.");
                    actionTable.addCell(c);
                    c = this.newHeaderCell("Description");
                    actionTable.addCell(c);
                    c = this.newHeaderCell("Reminder");
                    actionTable.addCell(c);
                    c = this.newHeaderCell(CHECK_RESOLVED);
                    actionTable.addCell(c);
                    float width = doc.getPageSize().getWidth() - doc.getPageSize().getBorderWidthLeft() - doc.getPageSize().getBorderWidthRight();
                    int i = model.getLastActionID();
                    float step = this.baseFontSize - 1.0f;
                    int steps = (int)Math.floor(Math.log10(i)) + 1;
                    float col1 = 8.0f + (float)steps * step;
                    float col2 = 4.0f + 3.0f * (this.baseFontSize + 4.0f);
                    float col4 = 10.0f + step * 11.0f;
                    float col5 = 8.0f + this.baseFontSize;
                    float col3 = width - col1 - col2 - col4 - col5;
                    actionTable.setWidths(new float[]{col1, col2, col3, col4, col5});
                }
                this.addSingleActionRow(a, actionTable);
                continue;
            }
            this.addSingleActionTable(model, doc, a);
        }
        if (actionTable != null) {
            doc.add(actionTable);
            actionTable = null;
        }
        if (emptyH2 || emptyH3) {
            p = this.newParagraph(NONE_DOT);
            doc.add(p);
        }
        doc.close();
    }

    private Phrase newTitle(String string) {
        Phrase p = this.fontSelectorB4.process(string);
        return p;
    }

    private PdfPCell newHeaderCell(String string) throws DocumentException, IOException {
        Paragraph p = new Paragraph(this.fontSelectorB.process(string));
        PdfPCell c = this.newCell(p);
        c.setHorizontalAlignment(1);
        return c;
    }

    private void addSingleActionTable(GTDModel model, Document doc, Action a) throws DocumentException, IOException, BadElementException {
        PdfPTable t = new PdfPTable(3);
        t.setSpacingBefore(5.0f);
        t.setWidthPercentage(100.0f);
        Paragraph ph = this.newParagraph();
        Chunk ch = this.newChunk(ID);
        ph.add(ch);
        ch = this.newChunk(String.valueOf(a.getId()));
        ch.getFont().setStyle(1);
        ph.add(ch);
        PdfPCell c = this.newCell(ph);
        t.addCell(c);
        ph = this.newParagraph();
        ch = this.newChunk(CREATED);
        ph.add(ch);
        ch = this.newChunk(ApplicationHelper.toISODateTimeString(a.getCreated()));
        ch.getFont().setStyle(1);
        ph.add(ch);
        c = this.newCell(ph);
        t.addCell(c);
        ph = this.newParagraph();
        if (a.isOpen()) {
            ch = this.newChunk(OPEN);
            ch.getFont().setStyle(1);
            ch.getFont().setColor(COLOR_OPEN);
            ph.add(ch);
            ch = this.newOpenChunk();
            ph.add(ch);
        } else if (a.isResolved()) {
            ch = this.newChunk(RESOLVED);
            ch.getFont().setStyle(1);
            ch.getFont().setColor(COLOR_RESOLVED);
            ph.add(ch);
            ch = this.newResolvedChunk();
            ph.add(ch);
        } else if (a.isDeleted()) {
            ch = this.newChunk(DELETED);
            ch.getFont().setStyle(1);
            ch.getFont().setColor(COLOR_DELETED);
            ph.add(ch);
            ch = this.newDeletedChunk();
            ph.add(ch);
        } else {
            ch = this.newChunk(STALLED);
            ch.getFont().setStyle(1);
            ch.getFont().setColor(COLOR_DELETED);
            ph.add(ch);
            ch = this.newStalledChunk();
            ph.add(ch);
        }
        c = this.newCell(ph);
        c.setHorizontalAlignment(2);
        t.addCell(c);
        ph = this.newParagraph();
        ch = this.newChunk(PRIORITY);
        ph.add(ch);
        ch = this.newChunk(a.getPriority() == null ? NONE : a.getPriority().toString());
        ch.getFont().setStyle(1);
        ph.add(ch);
        ch = this.newChunk(" ");
        ch.getFont().setStyle(1);
        ph.add(ch);
        if (a.getPriority() == null || a.getPriority() == Priority.None) {
            ch = this.newNoneStarChunk();
            ph.add(ch);
            ch = this.newNoneStarChunk();
            ph.add(ch);
            ch = this.newNoneStarChunk();
            ph.add(ch);
        } else if (a.getPriority() == Priority.Low) {
            ch = this.newLowStarChunk();
            ph.add(ch);
            ch = this.newNoneStarChunk();
            ph.add(ch);
            ch = this.newNoneStarChunk();
            ph.add(ch);
        } else if (a.getPriority() == Priority.Medium) {
            ch = this.newLowStarChunk();
            ph.add(ch);
            ch = this.newMediumStarChunk();
            ph.add(ch);
            ch = this.newNoneStarChunk();
            ph.add(ch);
        } else if (a.getPriority() == Priority.High) {
            ch = this.newLowStarChunk();
            ph.add(ch);
            ch = this.newMediumStarChunk();
            ph.add(ch);
            ch = this.newHighStarChunk();
            ph.add(ch);
        }
        c = this.newCell(ph);
        t.addCell(c);
        ph = this.newParagraph();
        ch = this.newChunk(REMINDER);
        ph.add(ch);
        ch = this.newChunk(a.getRemind() != null ? ApplicationHelper.toISODateString(a.getRemind()) : NONE);
        ch.getFont().setStyle(1);
        ph.add(ch);
        c = this.newCell(ph);
        t.addCell(c);
        ph = this.newParagraph();
        ch = this.newChunk(PROJECT);
        ph.add(ch);
        ch = a.getProject() != null ? this.newChunk(model.getProject(a.getProject()).getName()) : this.newChunk(NONE);
        ch.getFont().setStyle(1);
        ph.add(ch);
        c = this.newCell(ph);
        t.addCell(c);
        c = this.newDescriptionCell(a.getDescription());
        c.setColspan(3);
        t.addCell(c);
        if (a.getUrl() != null) {
            ch = this.newChunk(a.getUrl().toString());
            ch.setAnchor(a.getUrl());
            ch.getFont().setColor(Color.BLUE);
            c = this.newCell(new Paragraph(ch));
            c.setColspan(3);
            t.addCell(c);
        }
        doc.add(t);
    }

    private void addSingleActionRow(Action a, PdfPTable t) throws DocumentException, IOException, BadElementException {
        Chunk ch;
        Paragraph ph = this.newParagraph(String.valueOf(a.getId()));
        PdfPCell c = this.newCell(ph);
        c.setHorizontalAlignment(2);
        t.addCell(c);
        ph = this.newParagraph();
        if (a.getPriority() == null || a.getPriority() == Priority.None) {
            ch = this.newNoneStarChunk();
            ph.add(ch);
            ch = this.newNoneStarChunk();
            ph.add(ch);
            ch = this.newNoneStarChunk();
            ph.add(ch);
        } else if (a.getPriority() == Priority.Low) {
            ch = this.newLowStarChunk();
            ph.add(ch);
            ch = this.newNoneStarChunk();
            ph.add(ch);
            ch = this.newNoneStarChunk();
            ph.add(ch);
        } else if (a.getPriority() == Priority.Medium) {
            ch = this.newLowStarChunk();
            ph.add(ch);
            ch = this.newMediumStarChunk();
            ph.add(ch);
            ch = this.newNoneStarChunk();
            ph.add(ch);
        } else if (a.getPriority() == Priority.High) {
            ch = this.newLowStarChunk();
            ph.add(ch);
            ch = this.newMediumStarChunk();
            ph.add(ch);
            ch = this.newHighStarChunk();
            ph.add(ch);
        }
        c = this.newCell(ph);
        t.addCell(c);
        c = this.newDescriptionCell(a.getDescription());
        t.addCell(c);
        ph = this.newParagraph(a.getRemind() != null ? ApplicationHelper.toDateString(a.getRemind()) : EMPTY);
        c = this.newCell(ph);
        c.setHorizontalAlignment(2);
        t.addCell(c);
        ph = this.newParagraph();
        if (a.isOpen()) {
            ch = this.newOpenChunk();
            ph.add(ch);
        } else if (a.isResolved()) {
            ch = this.newResolvedChunk();
            ph.add(ch);
        } else if (a.isDeleted()) {
            ch = this.newDeletedChunk();
            ph.add(ch);
        } else {
            ch = this.newStalledChunk();
            ph.add(ch);
        }
        c = this.newCell(ph);
        c.setHorizontalAlignment(2);
        t.addCell(c);
    }

    private Chunk newChunk(String s) throws DocumentException, IOException {
        if (s == null) {
            s = EMPTY;
        }
        Chunk c = new Chunk(s, this.newFont());
        return c;
    }

    private Paragraph newParagraph() throws DocumentException, IOException {
        Paragraph p = new Paragraph();
        return p;
    }

    private PdfPCell newCell(Paragraph p) throws BadElementException {
        PdfPCell c = new PdfPCell(p);
        c.setBorder(15);
        c.setBorderWidth(0.1f);
        c.setVerticalAlignment(5);
        c.setPaddingBottom(3.0f);
        c.setPaddingLeft(3.0f);
        c.setPaddingRight(3.0f);
        c.setPaddingTop(0.0f);
        c.setUseBorderPadding(true);
        return c;
    }

    private PdfPCell newCell(String string) throws DocumentException, IOException {
        PdfPCell c = this.newCell(this.newParagraph(string));
        return c;
    }

    private PdfPCell newDescriptionCell(String s) throws DocumentException, IOException {
        PdfPCell c = this.newCell(s);
        c.setPaddingBottom(5.0f);
        c.setPaddingLeft(5.0f);
        c.setPaddingRight(5.0f);
        c.setPaddingTop(2.0f);
        return c;
    }

    private Paragraph newParagraph(String string) throws DocumentException, IOException {
        Paragraph p = new Paragraph(this.fontSelector.process(string));
        return p;
    }

    private com.lowagie.text.Font newFont() throws DocumentException, IOException {
        return new com.lowagie.text.Font(this.baseFont, this.baseFontSize);
    }

    private Paragraph newStrongParagraph(String s) throws DocumentException, IOException {
        Paragraph p = new Paragraph(this.fontSelectorB.process(s));
        return p;
    }

    private Chunk newResolvedChunk() throws DocumentException, IOException {
        Chunk c = this.newChunk(CHECK_RESOLVED);
        c.getFont().setSize(this.baseFontSize + 2.0f);
        c.getFont().setColor(COLOR_RESOLVED);
        return c;
    }

    private Chunk newOpenChunk() throws DocumentException, IOException {
        Chunk c = this.newChunk(CHECK_OPEN);
        c.getFont().setSize(this.baseFontSize + 2.0f);
        c.getFont().setColor(COLOR_OPEN);
        return c;
    }

    private Chunk newStalledChunk() throws DocumentException, IOException {
        Chunk c = this.newChunk(CHECK_STALLED);
        c.getFont().setSize(this.baseFontSize + 2.0f);
        c.getFont().setColor(COLOR_DELETED);
        return c;
    }

    private Chunk newDeletedChunk() throws DocumentException, IOException {
        Chunk c = this.newChunk(CHECK_DELETED);
        c.getFont().setSize(this.baseFontSize + 2.0f);
        c.getFont().setColor(COLOR_DELETED);
        return c;
    }

    private Chunk newHighStarChunk() throws DocumentException, IOException {
        Chunk c = this.newChunk(FULL_STAR);
        c.getFont().setColor(COLOR_PRIORITY_HIGH);
        return c;
    }

    private Chunk newMediumStarChunk() throws DocumentException, IOException {
        Chunk c = this.newChunk(FULL_STAR);
        c.getFont().setColor(COLOR_PRIORITY_MEDIUM);
        return c;
    }

    private Chunk newLowStarChunk() throws DocumentException, IOException {
        Chunk c = this.newChunk(FULL_STAR);
        c.getFont().setColor(COLOR_PRIORITY_LOW);
        return c;
    }

    private Chunk newNoneStarChunk() throws DocumentException, IOException {
        Chunk c = this.newChunk(HOLLOW_STAR);
        c.getFont().setColor(Color.BLACK);
        return c;
    }

    private Element newSection(String s) throws DocumentException, IOException {
        Phrase c = this.fontSelectorB2.process(s);
        Paragraph p = new Paragraph(c);
        PdfPTable t = new PdfPTable(1);
        t.setSpacingBefore(15.0f);
        t.setSpacingAfter(7.0f);
        t.setWidthPercentage(100.0f);
        PdfPCell ce = this.newCell(p);
        ce.setBorder(2);
        ce.setBorderWidth(1.0f);
        ce.setPaddingLeft(0.0f);
        ce.setPaddingRight(0.0f);
        t.addCell(ce);
        return t;
    }

    private Element newSubSection(String s) throws DocumentException, IOException {
        Phrase c = this.fontSelectorB.process(s);
        Paragraph p = new Paragraph(c);
        PdfPTable t = new PdfPTable(1);
        t.setSpacingBefore(7.0f);
        t.setSpacingAfter(5.0f);
        t.setWidthPercentage(100.0f);
        PdfPCell ce = this.newCell(p);
        ce.setBorder(2);
        ce.setBorderWidth(0.75f);
        ce.setPaddingLeft(0.0f);
        ce.setPaddingRight(0.0f);
        t.addCell(ce);
        return t;
    }

    @Override
    public ExportAddOn.ExportOrder getDefaultExportOrder() {
        return ExportAddOn.ExportOrder.FoldersProjectsActions;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ExportAddOn.ExportOrder[] getSupportedExportOrders() {
        return this.orders;
    }

    @Override
    public FileFilter[] getFileFilters() {
        return this.fileFilters;
    }

    public float getBaseFontSize() {
        return this.baseFontSize;
    }

    public void setBaseFontSize(float defaultFontSize) {
        this.baseFontSize = defaultFontSize;
    }

    public void setPageSize(Rectangle pageSize) {
        this.pageSize = pageSize;
    }

    public void setPageSize(float width, float height) {
        this.pageSize = new Rectangle(width, height);
    }

    public Rectangle getPageSize() {
        return this.pageSize;
    }

    @Override
    public JComponent getComponent() {
        if (this.component == null) {
            this.component = new OptionsPanel();
        }
        return this.component;
    }

    public FontModel getFontModel() {
        return this.fontModel;
    }

    @Override
    public void initialize(GTDFreeEngine engine) {
        this.engine = engine;
        if (this.component != null) {
            this.component.setFromGlobalProperties();
        }
        PropertyChangeListener l = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (PDFExportAddOn.this.component != null) {
                    PDFExportAddOn.this.component.setFromGlobalProperties();
                }
            }
        };
        engine.getGlobalProperties().addPropertyChangeListener(FONT_PROPERTY, l);
        engine.getGlobalProperties().addPropertyChangeListener(FONT_SIZE_PROPERTY, l);
    }

    class OptionsPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JComboBox fontsCombo;
        private JCheckBox embedCheckBox;
        private JComboBox sizeComboBox;

        public OptionsPanel() {
            if (PDFExportAddOn.this.getFontModel().getAvailableFontNames().length == 0) {
                ApplicationHelper.executeInBackground(new Runnable(){

                    @Override
                    public void run() {
                        Logger.getLogger(this.getClass()).debug("Loading fonts...");
                        FontFactory.registerDirectories();
                        PDFExportAddOn.this.getFontModel().loadAvailableFontNames();
                        if (OptionsPanel.this.fontsCombo != null) {
                            OptionsPanel.this.rebuildFonts();
                            OptionsPanel.this.setFromGlobalProperties();
                        }
                        Logger.getLogger(this.getClass()).debug("Fonts loaded.");
                    }
                });
            }
            this.initialize();
        }

        private void initialize() {
            this.setLayout(new GridBagLayout());
            int row = 0;
            this.add((Component)new JLabel("Font:"), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(11, 11, 4, 4), 0, 0));
            this.fontsCombo = new JComboBox();
            this.fontsCombo.setRenderer(new DefaultListCellRenderer(){
                private static final long serialVersionUID = 1L;
                JTextField field;

                private JTextField getField(String s) {
                    if (this.field == null) {
                        this.field = new JTextField();
                        this.field.setEditable(false);
                    }
                    this.field.setText(s);
                    return this.field;
                }

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Component c = null;
                    String s = value != null ? value.toString() : PDFExportAddOn.EMPTY;
                    c = index < 0 ? this.getField(s) : super.getListCellRendererComponent((JList<?>)list, s, index, isSelected, cellHasFocus);
                    Font f = new Font(s, 0, this.getFont().getSize());
                    if (f != null && s.length() > 0 && f.canDisplay(s.charAt(0))) {
                        c.setFont(f);
                    } else {
                        c.setFont(new Font("Dialog", 0, this.getFont().getSize()));
                    }
                    return c;
                }
            });
            this.fontsCombo.setBackground(Color.WHITE);
            this.fontsCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (OptionsPanel.this.fontsCombo.getSelectedIndex() < 1) {
                        PDFExportAddOn.this.getFontModel().setSelectedFontNames(null);
                        if (PDFExportAddOn.this.engine != null) {
                            PDFExportAddOn.this.engine.getGlobalProperties().putProperty(PDFExportAddOn.FONT_PROPERTY, null);
                        }
                    } else {
                        PDFExportAddOn.this.getFontModel().setSelectedFontNames(new String[]{OptionsPanel.this.fontsCombo.getSelectedItem().toString()});
                        if (PDFExportAddOn.this.engine != null) {
                            PDFExportAddOn.this.engine.getGlobalProperties().putProperty(PDFExportAddOn.FONT_PROPERTY, OptionsPanel.this.fontsCombo.getSelectedItem().toString());
                        }
                    }
                }
            });
            this.add((Component)this.fontsCombo, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 17, 0, new Insets(11, 4, 4, 11), 0, 0));
            this.embedCheckBox = new JCheckBox();
            this.embedCheckBox.setVisible(!PDFExportAddOn.this.printMode);
            this.embedCheckBox.setText("Embed Fonts");
            this.embedCheckBox.setToolTipText("Fonts embedded in PDF document (preferred) ensures PDF looks same on each computer,\nbut they make PDF document slightly larger.");
            this.embedCheckBox.setSelected(true);
            this.embedCheckBox.addPropertyChangeListener("selected", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    PDFExportAddOn.this.getFontModel().setEmbedFonts(OptionsPanel.this.embedCheckBox.isSelected());
                    OptionsPanel.this.rebuildFonts();
                }
            });
            this.add((Component)this.embedCheckBox, new GridBagConstraints(0, ++row, 2, 1, 1.0, 0.0, 10, 0, new Insets(4, 11, 4, 11), 0, 0));
            this.add((Component)new JLabel("Base font size:"), new GridBagConstraints(0, ++row, 1, 1, 0.0, 1.0, 11, 0, new Insets(4, 11, 4, 4), 0, 0));
            this.sizeComboBox = new JComboBox<Object>(new Object[]{Float.valueOf(9.0f), Float.valueOf(10.0f), Float.valueOf(11.0f), Float.valueOf(12.0f), Float.valueOf(13.0f), Float.valueOf(14.0f)});
            this.sizeComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    PDFExportAddOn.this.setBaseFontSize(((Float)OptionsPanel.this.sizeComboBox.getSelectedItem()).floatValue());
                    if (PDFExportAddOn.this.engine != null) {
                        PDFExportAddOn.this.engine.getGlobalProperties().putProperty(PDFExportAddOn.FONT_SIZE_PROPERTY, ((Float)OptionsPanel.this.sizeComboBox.getSelectedItem()).intValue());
                    }
                }
            });
            this.add((Component)this.sizeComboBox, new GridBagConstraints(1, row, 1, 1, 1.0, 1.0, 18, 0, new Insets(4, 4, 4, 11), 0, 0));
            this.rebuildFonts();
        }

        private void rebuildFonts() {
            String sel = null;
            if (this.fontsCombo.getSelectedIndex() > 0) {
                sel = this.fontsCombo.getSelectedItem().toString();
            }
            String[] all = PDFExportAddOn.this.getFontModel().getAvailableFontNames();
            this.fontsCombo.removeAllItems();
            this.fontsCombo.addItem(PDFExportAddOn.DEFAULT_FONT_NAME);
            for (int i = 0; i < all.length; ++i) {
                this.fontsCombo.addItem(all[i]);
            }
            if (sel != null) {
                this.fontsCombo.setSelectedItem(sel);
            } else {
                this.fontsCombo.setSelectedIndex(0);
            }
            this.setFromGlobalProperties();
        }

        private void setFromGlobalProperties() {
            if (PDFExportAddOn.this.engine != null) {
                Integer i;
                if (this.fontsCombo != null && this.fontsCombo.getItemCount() > 1) {
                    Object o = PDFExportAddOn.this.engine.getGlobalProperties().getProperty(PDFExportAddOn.FONT_PROPERTY);
                    if (o instanceof String && o.toString().length() > 0) {
                        if (!o.equals(this.fontsCombo.getSelectedItem())) {
                            for (int i2 = 0; i2 < this.fontsCombo.getItemCount(); ++i2) {
                                if (!this.fontsCombo.getItemAt(i2).equals(o)) continue;
                                this.fontsCombo.setSelectedIndex(i2);
                            }
                        }
                    } else if (this.fontsCombo.getSelectedIndex() != 0) {
                        this.fontsCombo.setSelectedIndex(0);
                    }
                }
                if ((i = PDFExportAddOn.this.engine.getGlobalProperties().getInteger(PDFExportAddOn.FONT_SIZE_PROPERTY)) != null && ((Float)this.sizeComboBox.getSelectedItem()).intValue() != i.intValue()) {
                    this.sizeComboBox.setSelectedItem(Float.valueOf(i.floatValue()));
                }
            }
        }
    }

    static class FontModel {
        private static String[] availableFontNames = new String[0];
        private String[] selectedFontNames;
        private List<BaseFont> fonts;
        private boolean embedFonts = true;
        private String encoding = "Identity-H";
        public BaseFont baseFont;

        public void rebuildFonts() throws DocumentException, IOException {
            this.fonts = new ArrayList<BaseFont>(3);
            if (this.selectedFontNames != null && this.selectedFontNames.length > 0) {
                for (int i = 0; i < this.selectedFontNames.length; ++i) {
                    this.fonts.add(FontFactory.getFont(this.selectedFontNames[i], this.encoding, this.embedFonts, 12.0f, 0, Color.BLACK, true).getBaseFont());
                }
            }
            this.fonts.add(this.getBaseFont());
            this.fonts.add(BaseFont.createFont("Helvetica", "UTF-8", false));
        }

        public List<BaseFont> getFonts() throws DocumentException, IOException {
            if (this.fonts == null) {
                this.rebuildFonts();
            }
            return this.fonts;
        }

        public String[] getAvailableFontNames() {
            return availableFontNames;
        }

        public void loadAvailableFontNames() {
            Set s = FontFactory.getRegisteredFamilies();
            ArrayList<String> l = new ArrayList<String>(s.size());
            for (String name : s) {
                if (this.embedFonts) {
                    try {
                        BaseFont f = FontFactory.getFont(name.toString(), this.encoding, true, 12.0f, 0, Color.BLACK, true).getBaseFont();
                        if (f == null) continue;
                        String[][] names = f.getFamilyFontName();
                        l.add(names[0][names[0].length - 1]);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                l.add(name);
            }
            Collections.sort(l);
            availableFontNames = l.toArray(new String[l.size()]);
        }

        public String[] getSelectedFontNames() {
            return this.selectedFontNames;
        }

        public void setSelectedFontNames(String[] selectedFontNames) {
            this.selectedFontNames = selectedFontNames;
            this.fonts = null;
        }

        public boolean isEmbedFonts() {
            return this.embedFonts;
        }

        public void setEmbedFonts(boolean embedFonts) {
            this.embedFonts = embedFonts;
            this.fonts = null;
        }

        public BaseFont getBaseFont() {
            if (this.baseFont == null) {
                try {
                    this.baseFont = FontFactory.getFont("SansSerif", this.encoding, true, 12.0f, 0, Color.BLACK, true).getBaseFont();
                }
                catch (Exception e) {
                    Logger.getLogger(this.getClass()).debug("Internal error.", e);
                }
            }
            if (this.baseFont == null) {
                try {
                    this.baseFont = FontFactory.getFont("DeJaVu Sans", this.encoding, true, 12.0f, 0, Color.BLACK, true).getBaseFont();
                }
                catch (Exception e1) {
                    Logger.getLogger(this.getClass()).debug("Internal error.", e1);
                }
            }
            if (this.baseFont == null) {
                try {
                    this.baseFont = FontFactory.getFont("Arial", this.encoding, true, 12.0f, 0, Color.BLACK, true).getBaseFont();
                }
                catch (Exception e2) {
                    Logger.getLogger(this.getClass()).debug("Internal error.", e2);
                }
            }
            if (this.baseFont == null) {
                try {
                    this.baseFont = BaseFont.createFont("Helvetica", "UTF-8", false);
                }
                catch (Exception e) {
                    Logger.getLogger(this.getClass()).debug("Internal error.", e);
                }
            }
            return this.baseFont;
        }
    }
}

