/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree;

import java.io.UnsupportedEncodingException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Messages {
    private static final String BUNDLE_NAME = "org.gtdfree.messages";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("org.gtdfree.messages");
    private static Boolean utf8Convert;
    private static final String ENCODING = "@.ENCODING";

    private Messages() {
    }

    public static String getString(String key) {
        if (utf8Convert == null) {
            if (RESOURCE_BUNDLE.containsKey(ENCODING)) {
                try {
                    String s = RESOURCE_BUNDLE.getString(ENCODING);
                    utf8Convert = s != null && "UTF-8".equalsIgnoreCase(s);
                }
                catch (MissingResourceException s) {
                    // empty catch block
                }
            }
            if (utf8Convert == null) {
                utf8Convert = Boolean.FALSE;
            }
        }
        try {
            String message = RESOURCE_BUNDLE.getString(key);
            if (utf8Convert.booleanValue()) {
                try {
                    message = new String(message.getBytes("ISO-8859-1"), "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            return message;
        }
        catch (MissingResourceException e) {
            return '!' + key + '!';
        }
    }
}

