/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;
import org.gtdfree.ApplicationHelper;

public class GlobalProperties {
    public static final String DATE_FORMAT = "dateFormat";
    public static final String SHOW_ALL_ACTIONS = "showAllActions";
    public static final String SHOW_CLOSED_FOLDERS = "showClosedFolders";
    public static final String PROJECT_EDITOR_PREFERRED_SIZE = "projectEditorPreferredSize";
    public static final String SHOW_OVERVIEW_TAB = "showOverviewTab";
    public static final String SHOW_QUICK_COLLECT = "showQuickCollectBar";
    public static final String AUTO_SAVE = "autoSave";
    public static final String DATABASE = "database";
    public static final String DATABASE_VALUE_XML = "xml";
    public static final String DATABASE_VALUE_ODB = "odb";
    public static final String SHOW_TRAY_ICON = "showTrayIcon";
    public static final String SHOW_EMPTY_FOLDERS = "showEmptyFolders";
    public static final String SHUTDOWN_BACKUP_XML = "shutdownBackupXML";
    public static final String SHUTDOWN_BACKUP_ODB = "shutdownBackupODB";
    public static final String PAGE_SIZE_NAME = "pageSizeName";
    public static final String PAGE_ORIENTATION = "pageOrientation";
    public static final String PAGE_PRINTABLE_AREA = "pagePrintableArea";
    public static final String CHECK_FOR_UPDATE_AT_START = "checkForUpdateAtStart";
    private Properties prop = new Properties();
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public void addPropertyChangeListener(String s, PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(s, l);
    }

    public void removePropertyChangeListener(String s, PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(s, l);
    }

    public void putProperty(String s, Object v) {
        Object old = null;
        old = v == null ? this.prop.remove(s) : this.prop.put(s, v);
        this.pcs.firePropertyChange(s, old, v);
    }

    public Object getProperty(String s) {
        return this.prop.get(s);
    }

    public Object getProperty(String s, Object defaultValue) {
        Object o = this.prop.get(s);
        if (o == null) {
            return defaultValue;
        }
        return o;
    }

    public boolean getBoolean(String s) {
        return this.getBoolean(s, false);
    }

    public boolean getBoolean(String s, boolean def) {
        Object o = this.prop.get(s);
        if (o == null) {
            return def;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        Boolean b = Boolean.valueOf(o.toString());
        this.prop.put(s, b);
        return b;
    }

    public Integer getInteger(String s) {
        Object o = this.prop.get(s);
        if (o == null) {
            return null;
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        try {
            Integer b = Integer.valueOf(o.toString());
            this.prop.put(s, b);
            return b;
        }
        catch (Exception e) {
            Logger.getLogger(ApplicationHelper.class).warn("Internal error.", e);
            return null;
        }
    }

    public void load(Reader r) throws IOException {
        this.prop.load(r);
    }

    public void store(BufferedWriter w) throws IOException {
        Properties p = new Properties();
        for (Object s : this.prop.keySet()) {
            int i;
            StringBuilder sb;
            Object[] ii;
            Object o = this.prop.get(s);
            if (o instanceof int[]) {
                ii = (int[])o;
                sb = new StringBuilder();
                if (ii.length > 0) {
                    sb.append(ii[0]);
                }
                for (i = 1; i < ii.length; ++i) {
                    sb.append(',');
                    sb.append(ii[i]);
                }
                p.put(s, sb.toString());
                continue;
            }
            if (o instanceof double[]) {
                ii = (double[])o;
                sb = new StringBuilder();
                if (ii.length > 0) {
                    sb.append((double)ii[0]);
                }
                for (i = 1; i < ii.length; ++i) {
                    sb.append(',');
                    sb.append((double)ii[i]);
                }
                p.put(s, sb.toString());
                continue;
            }
            if (o instanceof boolean[]) {
                ii = (boolean[])o;
                sb = new StringBuilder(ii.length * 6);
                if (ii.length > 0) {
                    sb.append(ii[0]);
                }
                for (i = 1; i < ii.length; ++i) {
                    sb.append(',');
                    sb.append(ii[i]);
                }
                p.put(s, sb.toString());
                continue;
            }
            if (o == null) continue;
            p.put(s, o.toString());
        }
        p.store(w, "");
    }

    public int[] getIntegerArray(String s) {
        String[] ss;
        Object o = this.prop.get(s);
        if (o == null) {
            return null;
        }
        if (o instanceof int[]) {
            return (int[])o;
        }
        if (o instanceof String && s.length() > 0 && (ss = o.toString().split(",")) != null && ss.length > 0) {
            ArrayList<Integer> il = new ArrayList<Integer>(ss.length);
            for (int i = 0; i < ss.length; ++i) {
                ss[i] = ss[i].trim();
                if (ss[i].length() <= 0) continue;
                try {
                    il.add(Integer.valueOf(ss[i]));
                    continue;
                }
                catch (Exception e) {
                    Logger.getLogger(this.getClass()).warn("Internal error.", e);
                }
            }
            int[] ii = new int[il.size()];
            for (int i = 0; i < ii.length; ++i) {
                ii[i] = (Integer)il.get(i);
            }
            this.prop.put(s, ii);
            return ii;
        }
        return null;
    }

    public boolean[] getBooleanArray(String s) {
        String[] ss;
        Object o = this.prop.get(s);
        if (o == null) {
            return null;
        }
        if (o instanceof boolean[]) {
            return (boolean[])o;
        }
        if (o instanceof String && s.length() > 0 && (ss = o.toString().split(",")) != null && ss.length > 0) {
            boolean[] ii = new boolean[ss.length];
            for (int i = 0; i < ii.length; ++i) {
                try {
                    ii[i] = Boolean.valueOf(ss[i]);
                    continue;
                }
                catch (Exception e) {
                    Logger.getLogger(this.getClass()).warn("Internal error.", e);
                }
            }
            this.prop.put(s, ii);
            return ii;
        }
        return null;
    }

    public double[] getDoubleArray(String s) {
        String[] ss;
        Object o = this.prop.get(s);
        if (o == null) {
            return null;
        }
        if (o instanceof double[]) {
            return (double[])o;
        }
        if (o instanceof String && s.length() > 0 && (ss = o.toString().split(",")) != null && ss.length > 0) {
            ArrayList<Double> il = new ArrayList<Double>(ss.length);
            for (int i = 0; i < ss.length; ++i) {
                ss[i] = ss[i].trim();
                if (ss[i].length() <= 0) continue;
                try {
                    il.add(Double.valueOf(ss[i]));
                    continue;
                }
                catch (Exception e) {
                    Logger.getLogger(this.getClass()).warn("Internal error.", e);
                }
            }
            double[] ii = new double[il.size()];
            for (int i = 0; i < ii.length; ++i) {
                ii[i] = (Double)il.get(i);
            }
            this.prop.put(s, ii);
            return ii;
        }
        return null;
    }

    public void connectBooleanProperty(String globalProperty, Object target, String targetProperty, String getter, String setter, boolean defaultValue) {
        this.addPropertyChangeListener(globalProperty, new BooleanPropertyConnector(globalProperty, target, targetProperty, getter, setter, defaultValue));
    }

    private class BooleanPropertyConnector
    implements PropertyChangeListener,
    ChangeListener {
        private String globalProperty;
        private Object target;
        private String targetProperty;
        private Method getter;
        private Method setter;
        private boolean setting = false;
        private boolean defaultValue;

        public BooleanPropertyConnector(String globalProperty, Object target, String targetProperty, String getter, String setter, boolean defaultValue) {
            this.globalProperty = globalProperty;
            this.target = target;
            this.targetProperty = targetProperty;
            this.defaultValue = defaultValue;
            try {
                if (getter != null) {
                    this.getter = target.getClass().getMethod(getter, new Class[0]);
                }
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass()).debug("Internal error.", e);
            }
            try {
                if (setter != null) {
                    this.setter = target.getClass().getMethod(setter, Boolean.TYPE);
                }
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass()).debug("Internal error.", e);
            }
            this.setting = true;
            try {
                this.setter.invoke(target, GlobalProperties.this.getBoolean(globalProperty, defaultValue));
                if (getter != null) {
                    target.getClass().getMethod("addChangeListener", ChangeListener.class).invoke(target, this);
                }
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass()).debug("Internal error.", e);
            }
            this.setting = false;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this.setting) {
                return;
            }
            if (evt.getSource() == GlobalProperties.this && evt.getPropertyName().equals(this.globalProperty)) {
                this.setting = true;
                try {
                    this.setter.invoke(this.target, GlobalProperties.this.getBoolean(this.globalProperty, this.defaultValue));
                }
                catch (Exception e) {
                    Logger.getLogger(this.getClass()).debug("Internal error.", e);
                }
                this.setting = false;
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (this.setting || this.getter == null) {
                return;
            }
            this.setting = true;
            try {
                GlobalProperties.this.putProperty(this.globalProperty, this.getter.invoke(this.target, new Object[0]));
            }
            catch (Exception ex) {
                Logger.getLogger(this.getClass()).debug("Internal error.", ex);
            }
            this.setting = false;
        }
    }
}

