/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.ActionMap;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.gtdfree.ApplicationHelper;
import org.gtdfree.GlobalProperties;
import org.gtdfree.Messages;
import org.gtdfree.addons.DefaultXMLExportAddOn;
import org.gtdfree.addons.ExportAddOn;
import org.gtdfree.addons.HTMLExportAddOn;
import org.gtdfree.addons.PDFExportAddOn;
import org.gtdfree.addons.PlainTextExportAddOn;
import org.gtdfree.gui.DatabaseSelectionDialog;
import org.gtdfree.gui.GTDFreePane;
import org.gtdfree.gui.StateMachine;
import org.gtdfree.gui.WorkflowPane;
import org.gtdfree.journal.JournalModel;
import org.gtdfree.model.GTDDataODB;
import org.gtdfree.model.GTDDataXML;
import org.gtdfree.model.GTDModel;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class GTDFreeEngine {
    private volatile GTDModel gtdModel;
    private Properties configuration;
    private GlobalProperties globalProperties;
    private JournalModel journalModel;
    private StateMachine stateMachine;
    private ActionMap actionMap;
    private boolean aborting = false;
    private List<ExportAddOn> exportAddOns;
    private GTDFreePane activePane;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private JDialog upgradeImportDialog;
    private Logger logger = Logger.getLogger(GTDFreeEngine.class);

    public Properties getConfiguration() {
        if (this.configuration == null) {
            this.configuration = ApplicationHelper.loadConfiguration();
        }
        return this.configuration;
    }

    public GTDModel getGTDModel() {
        if (this.gtdModel == null) {
            Object db = this.getGlobalProperties().getProperty("database");
            boolean doImport = false;
            if (db == null || !"odb".equalsIgnoreCase(db.toString()) && !"xml".equalsIgnoreCase(db.toString())) {
                DatabaseSelectionDialog d = new DatabaseSelectionDialog(null);
                d.setVisible(true);
                if (!d.isSuccess()) {
                    this.logger.info("Database selection canceled, closing.");
                    try {
                        this.close(true, false);
                    }
                    catch (Exception e) {
                        this.logger.error("Internal error.", e);
                    }
                    System.exit(0);
                }
                db = d.getDatabase();
                doImport = d.isUpgrade();
                this.getGlobalProperties().putProperty("database", db);
            }
            if ("xml".equalsIgnoreCase(db.toString())) {
                GTDDataXML xml = new GTDDataXML(this.getDataFolder(), this.getGlobalProperties());
                try {
                    this.gtdModel = xml.restore();
                }
                catch (IOException e) {
                    Logger.getLogger(this.getClass()).fatal("Initialization error, closing.", e);
                    try {
                        this.close(true, false);
                    }
                    catch (Exception ex) {
                        Logger.getLogger(this.getClass()).error("Closing error.", ex);
                    }
                    System.exit(0);
                }
            } else {
                GTDDataODB odb = new GTDDataODB(this.getDataFolder(), this.getGlobalProperties());
                try {
                    this.gtdModel = odb.restore();
                }
                catch (IOException e) {
                    Logger.getLogger(this.getClass()).fatal("Initialization error.", e);
                    try {
                        this.close(true, false);
                    }
                    catch (Exception ex) {
                        Logger.getLogger(this.getClass()).error("Closing error.", ex);
                    }
                    System.exit(0);
                }
                if (doImport) {
                    final GTDDataXML xml = new GTDDataXML(this.getDataFolder(), this.getGlobalProperties());
                    new Thread("UpgradeImportThread"){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                GTDFreeEngine gTDFreeEngine = GTDFreeEngine.this;
                                synchronized (gTDFreeEngine) {
                                    GTDModel gtdXml = xml.restore();
                                    GTDFreeEngine.this.gtdModel.importData(gtdXml);
                                }
                                GTDFreeEngine.this.getUpgradeImportDialog(null).dispose();
                            }
                            catch (IOException e) {
                                GTDFreeEngine.this.getUpgradeImportDialog(null).dispose();
                                Logger.getLogger(this.getClass()).error("I/O error.", e);
                                JOptionPane.showMessageDialog(null, Messages.getString("GTDFreeEngine.XMLImport.1") + (e.getCause() != null ? e.getCause().toString() : e.toString()) + Messages.getString("GTDFreeEngine.XMLImport.2"), Messages.getString("GTDFreeEngine.XMLImport.Title"), 0);
                            }
                        }
                    }.start();
                    this.getUpgradeImportDialog(xml.getDataFile().toString()).setVisible(true);
                }
            }
            this.setAutoSave(this.getGlobalProperties().getBoolean("autoSave", true));
        }
        return this.gtdModel;
    }

    private JDialog getUpgradeImportDialog(String file) {
        if (this.upgradeImportDialog == null) {
            this.upgradeImportDialog = new JDialog();
            this.upgradeImportDialog.setTitle(Messages.getString("GTDFreeEngine.Upgrade.title"));
            JPanel p = new JPanel();
            p.setLayout(new GridBagLayout());
            p.add((Component)new JLabel(Messages.getString("GTDFreeEngine.Upgrade.1") + file), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(11, 11, 4, 11), 0, 0));
            p.add((Component)new JLabel(Messages.getString("GTDFreeEngine.Upgrade.2")), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(4, 11, 4, 11), 0, 0));
            JProgressBar pb = new JProgressBar();
            pb.setIndeterminate(true);
            p.add((Component)pb, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 2, new Insets(4, 11, 11, 11), 0, 0));
            this.upgradeImportDialog.setContentPane(p);
            this.upgradeImportDialog.pack();
            this.upgradeImportDialog.setLocationRelativeTo(null);
            this.upgradeImportDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            this.upgradeImportDialog.setDefaultCloseOperation(0);
            this.upgradeImportDialog.setResizable(false);
        }
        return this.upgradeImportDialog;
    }

    public JournalModel getJournalModel() {
        if (this.journalModel == null) {
            this.journalModel = new JournalModel(this.getDataFolder(), this.getGTDModel());
        }
        return this.journalModel;
    }

    public void save() throws IOException, XMLStreamException, FactoryConfigurationError {
        if (this.isAborting()) {
            return;
        }
        this.gtdModel.getDataRepository().flush();
    }

    public void emergencySave() {
        if (this.gtdModel == null) {
            return;
        }
        File save = ApplicationHelper.getShutdownBackupXMLFile();
        if (save.exists() && !save.delete()) {
            new IOException(Messages.getString("GTDFreeEngine.BackupRemoveFailed.1") + save.getAbsolutePath() + Messages.getString("GTDFreeEngine.BackupRemoveFailed.2")).toString();
        }
        try {
            this.gtdModel.exportXML(save);
            this.logger.info(Messages.getString("GTDFreeEngine.BackupSaved") + save.getAbsolutePath());
        }
        catch (Exception e) {
            this.logger.error(Messages.getString("GTDFreeEngine.BackupFailed") + save.getAbsolutePath(), e);
        }
    }

    public File getDataFolder() {
        return ApplicationHelper.getDataFolder();
    }

    public boolean isAutoSave() {
        if (this.gtdModel != null && this.gtdModel.getDataRepository() instanceof GTDDataXML) {
            return ((GTDDataXML)this.gtdModel.getDataRepository()).isAutoSave();
        }
        return true;
    }

    public void setAutoSave(boolean autoSave) {
        if (this.gtdModel != null && this.gtdModel.getDataRepository() instanceof GTDDataXML) {
            ((GTDDataXML)this.gtdModel.getDataRepository()).setAutoSave(autoSave);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalProperties getGlobalProperties() {
        if (this.globalProperties == null) {
            this.globalProperties = new GlobalProperties();
            File f = new File(this.getDataFolder(), "gtd-free-options.properties");
            if (f.exists()) {
                BufferedReader r = null;
                try {
                    r = new BufferedReader(new FileReader(f));
                    this.globalProperties.load(r);
                }
                catch (IOException e) {
                    Logger.getLogger(this.getClass()).error("Initialization error.", e);
                }
                finally {
                    try {
                        if (r != null) {
                            r.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return this.globalProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close(boolean terminal, boolean emergencySave) throws IOException, XMLStreamException, FactoryConfigurationError {
        if (this.aborting) {
            return true;
        }
        if (emergencySave || this.getGlobalProperties().getBoolean("shutdownBackupXML", true)) {
            this.emergencySave();
        }
        if (this.gtdModel != null) {
            try {
                boolean close = this.gtdModel.getDataRepository().close(terminal);
                if (!close && !terminal) {
                    return false;
                }
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass()).error("Close error.", e);
            }
        }
        this.aborting = true;
        this.firePropertyChange("aborting", true, false);
        File f = new File(this.getDataFolder(), "gtd-free-options.properties");
        BufferedWriter w = null;
        try {
            w = new BufferedWriter(new FileWriter(f));
            this.globalProperties.store(w);
        }
        catch (IOException e) {
            Logger.getLogger(this.getClass()).error("Close error.", e);
        }
        finally {
            try {
                if (w != null) {
                    w.close();
                }
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    public StateMachine getStateMachine() {
        if (this.stateMachine == null) {
            this.stateMachine = new StateMachine();
        }
        return this.stateMachine;
    }

    public ActionMap getActionMap() {
        if (this.actionMap == null) {
            this.actionMap = new ActionMap();
        }
        return this.actionMap;
    }

    public boolean isAborting() {
        return this.aborting;
    }

    public ExportAddOn[] getExportAddOns() {
        if (this.exportAddOns == null) {
            this.exportAddOns = new ArrayList<ExportAddOn>(10);
            this.exportAddOns.add(new DefaultXMLExportAddOn());
            this.exportAddOns.add(new PDFExportAddOn());
            this.exportAddOns.add(new HTMLExportAddOn());
            this.exportAddOns.add(new PlainTextExportAddOn());
        }
        return this.exportAddOns.toArray(new ExportAddOn[this.exportAddOns.size()]);
    }

    public void setActivePane(GTDFreePane c) {
        if (c == this.activePane) {
            return;
        }
        GTDFreePane old = this.activePane;
        this.activePane = c;
        this.firePropertyChange("activePane", old, this.activePane);
    }

    private void firePropertyChange(String name, Object old, Object val) {
        this.support.firePropertyChange(name, old, val);
    }

    public GTDFreePane getActivePane() {
        return this.activePane;
    }

    public WorkflowPane getActiveWorkflowPane() {
        if (this.activePane instanceof WorkflowPane) {
            return (WorkflowPane)this.activePane;
        }
        return null;
    }

    public void addPropertyChangeListener(String name, PropertyChangeListener l) {
        this.support.addPropertyChangeListener(name, l);
    }

    public void removePropertyChangeListener(String name, PropertyChangeListener l) {
        this.support.removePropertyChangeListener(name, l);
    }

    public VersionInfo[] checkForNewVersions(VersionInfo current) throws IOException {
        ArrayList<VersionInfo> l = new ArrayList<VersionInfo>(2);
        URI uri = null;
        try {
            uri = new URI(this.getConfiguration().getProperty("version.url", "http://gtd-free.sourceforge.net"));
        }
        catch (Exception e1) {
            Logger.getLogger(this.getClass()).error("URL load failed.", e1);
        }
        if (uri != null) {
            try {
                DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document doc = db.parse(uri.toString());
                VersionInfo[] inf = new VersionInfo[2];
                NodeList verL = doc.getElementsByTagName("version");
                NodeList typL = doc.getElementsByTagName("type");
                NodeList notL = doc.getElementsByTagName("notes");
                inf[0] = new VersionInfo(verL.item(0).getTextContent(), typL.item(0).getTextContent(), notL.item(0).getTextContent());
                inf[1] = new VersionInfo(verL.item(1).getTextContent(), typL.item(1).getTextContent(), notL.item(1).getTextContent());
                this.logger.debug("Remote versions: " + inf[0].toFullVersionString() + ", " + inf[1].toFullVersionString() + ".");
                if (current.isLaterThen(inf[0])) {
                    l.add(inf[0]);
                }
                if (current.isLaterThen(inf[1])) {
                    l.add(inf[1]);
                }
                return l.toArray(new VersionInfo[l.size()]);
            }
            catch (Exception e) {
                this.logger.error("Internal error.", e);
            }
        }
        return new VersionInfo[0];
    }

    public static class VersionInfo {
        public String version;
        public String type;
        public String notes;

        public VersionInfo(String version, String type, String notes) {
            this.version = version;
            this.type = type;
            this.notes = notes;
        }

        public VersionInfo(Properties config) {
            this.version = config.getProperty("build.version");
            this.type = config.getProperty("build.type");
        }

        public boolean isLaterThen(VersionInfo vinfo) {
            return this.version.compareTo(vinfo.version) < 0;
        }

        public String toFullVersionString() {
            StringBuilder sb = new StringBuilder(16);
            sb.append(this.version);
            if (this.type != null && this.type.length() > 0) {
                sb.append('-');
                sb.append(this.type);
            }
            return sb.toString();
        }
    }
}

