/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree;

import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.rmi.Remote;
import java.rmi.server.UnicastRemoteObject;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.gtdfree.ApplicationHelper;
import org.gtdfree.GTDFreeEngine;
import org.gtdfree.GTDFreeOperations;
import org.gtdfree.GlobalProperties;
import org.gtdfree.Messages;
import org.gtdfree.gui.DatabaseToolsDialog;
import org.gtdfree.gui.ExecutePane;
import org.gtdfree.gui.ExportDialog;
import org.gtdfree.gui.GTDFreePane;
import org.gtdfree.gui.ImportExampleDialog;
import org.gtdfree.gui.InBasketPane;
import org.gtdfree.gui.JournalPane;
import org.gtdfree.gui.Monitor;
import org.gtdfree.gui.OrganizePane;
import org.gtdfree.gui.ProcessPane;
import org.gtdfree.gui.QuickCollectPanel;
import org.gtdfree.gui.WorkflowPane;
import org.gtdfree.model.Action;
import org.gtdfree.model.ActionEvent;
import org.gtdfree.model.Folder;
import org.gtdfree.model.FolderEvent;
import org.gtdfree.model.GTDData;
import org.gtdfree.model.GTDDataODB;
import org.gtdfree.model.GTDDataXML;
import org.gtdfree.model.GTDModelListener;
import org.gtdfree.model.Utils;

public class GTDFree
implements GTDFreeOperations {
    private static final String STUB_FILE_NAME = "stub.bin";
    private static final int TAB_COLECT = 1;
    private static final int TAB_PROCESS = 2;
    private static final int TAB_ORGANIZE = 3;
    private static final int TAB_EXECUTE = 4;
    private static TrayIcon trayIcon;
    private JFrame jFrame = null;
    private JPanel jContentPane = null;
    private JMenuBar jJMenuBar = null;
    private JMenu fileMenu = null;
    private JMenu helpMenu = null;
    private JMenuItem exitMenuItem = null;
    private JMenuItem aboutMenuItem = null;
    private JMenuItem saveMenuItem = null;
    private JDialog aboutDialog = null;
    private JFileChooser fileChooser;
    private GTDFreeEngine engine;
    private JCheckBoxMenuItem autoSaveMenuItem;
    private ActionMap actionMap;
    private JCheckBoxMenuItem showAllActions;
    private JCheckBoxMenuItem showClosedFolders;
    private ProcessPane processPane;
    private OrganizePane organizePane;
    private InBasketPane inBasketPane;
    private ExecutePane executePane;
    private JournalPane journalPane;
    private boolean closed;
    private JPanel overview;
    private JTabbedPane tabbedPane;
    private SummaryBean summaryBean;
    private JCheckBoxMenuItem showOverviewTab;
    private QuickCollectPanel quickCollectPanel;
    private JCheckBoxMenuItem showQuickCollectBar;
    private ImportExampleDialog importDialog;
    private int executeTabIndex;
    private ExportDialog exportDialog;
    private ExportDialog printDialog;
    private DatabaseToolsDialog dbInfoDialog;
    private JPopupMenu trayIconPopup;
    private JCheckBoxMenuItem showTrayIcon;
    private Monitor monitor;
    private JCheckBoxMenuItem showEmptyFolders;
    private JWindow flasher;
    private JLabel flasherText;
    private Logger logger = Logger.getLogger(GTDFree.class);
    private GTDFreeOperations stub;

    public static void main(String[] args) {
        final Logger logger = Logger.getLogger(GTDFree.class);
        logger.setLevel(Level.ALL);
        BasicConfigurator.configure();
        Options op = new Options();
        op.addOption("data", true, Messages.getString("GTDFree.Options.data"));
        op.addOption("eodb", true, Messages.getString("GTDFree.Options.eodb"));
        op.addOption("exml", true, Messages.getString("GTDFree.Options.exml"));
        op.addOption("h", "help", false, Messages.getString("GTDFree.Options.help"));
        op.addOption("log", true, Messages.getString("GTDFree.Options.log"));
        Options op2 = new Options();
        OptionBuilder.hasArg();
        OptionBuilder.isRequired(false);
        OptionBuilder.withDescription(new MessageFormat(Messages.getString("GTDFree.Options.lang")).format(new Object[]{"'en'", "'de', 'en', 'fr', 'ja'"}));
        OptionBuilder.withArgName("de|en|fr|ja");
        OptionBuilder.withLongOpt("Duser.language");
        OptionBuilder.withValueSeparator('=');
        op2.addOption(OptionBuilder.create());
        OptionBuilder.hasArg();
        OptionBuilder.isRequired(false);
        OptionBuilder.withDescription(new MessageFormat(Messages.getString("GTDFree.Options.laf")).format(new Object[]{"'com.jgoodies.looks.plastic.Plastic3DLookAndFeel', 'com.jgoodies.looks.plastic.PlasticLookAndFeel', 'com.jgoodies.looks.plastic.PlasticXPLookAndFeel', 'com.jgoodies.looks.windows.WindowsLookAndFeel' (only on MS Windows), 'com.sun.java.swing.plaf.gtk.GTKLookAndFeel' (only on Linux with GTK), 'com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel', 'javax.swing.plaf.metal.MetalLookAndFeel'"}));
        OptionBuilder.withLongOpt("Dswing.crossplatformlaf");
        OptionBuilder.withValueSeparator('=');
        op2.addOption(OptionBuilder.create());
        GnuParser clp = new GnuParser();
        CommandLine cl = null;
        try {
            cl = clp.parse(op, args);
        }
        catch (ParseException e1) {
            logger.error("Parse error.", e1);
        }
        System.out.print("GTD-Free");
        String ver = "";
        try {
            ver = ApplicationHelper.getVersion();
            System.out.println(" version " + ver);
        }
        catch (Exception e) {
            System.out.println();
        }
        HelpFormatter hf = new HelpFormatter();
        hf.printHelp("java [Java options] -jar gtd-free.jar [gtd-free options]", "[gtd-free options] - " + Messages.getString("GTDFree.Options.appop"), op, "[Java options] - " + new MessageFormat(Messages.getString("GTDFree.Options.javaop")).format(new Object[]{"'-jar'"}), false);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        hf.setLongOptPrefix("-");
        hf.setWidth(88);
        hf.printOptions(pw, hf.getWidth(), op2, hf.getLeftPadding(), hf.getDescPadding());
        String s = sw.getBuffer().toString();
        s = s.replaceAll("\\A {3}", "");
        s = s.replaceAll("\n {3}", "\n");
        s = s.replaceAll(" <", "=<");
        System.out.print(s);
        String val = cl.getOptionValue("data");
        if (val != null) {
            System.setProperty("gtd-free.data", val);
            System.setProperty("gtd-free.title", "1");
        } else {
            System.setProperty("gtd-free.title", "0");
        }
        val = cl.getOptionValue("log");
        if (val != null) {
            Level l = Level.toLevel(val, Level.ALL);
            logger.setLevel(l);
        }
        if (!ApplicationHelper.tryLock(null)) {
            System.out.println("Instance of GTD-Free already running, pushing it to be visible...");
            GTDFree.remotePushVisible();
            System.out.println("Instance of GTD-Free already running, exiting.");
            System.exit(0);
        }
        if (!"OFF".equalsIgnoreCase(val)) {
            RollingFileAppender f = null;
            try {
                f = new RollingFileAppender(new PatternLayout("%r [%t] %p %c %x - %m%n"), ApplicationHelper.getLogFileName(), true);
                f.setMaxBackupIndex(3);
                BasicConfigurator.configure(f);
                f.rollOver();
            }
            catch (IOException e2) {
                logger.error("Logging error.", e2);
            }
        }
        logger.info("GTD-Free " + ver + " started.");
        logger.debug("Args: " + Arrays.toString(args));
        logger.info("Using data in: " + ApplicationHelper.getDataFolder());
        if (cl.getOptionValue("exml") != null || cl.getOptionValue("eodb") != null) {
            GTDFreeEngine engine;
            block45: {
                File f1;
                engine = null;
                try {
                    engine = new GTDFreeEngine();
                }
                catch (Exception e1) {
                    logger.fatal("Fatal error, exiting.", e1);
                }
                val = cl.getOptionValue("exml");
                if (val != null) {
                    f1 = new File(val);
                    if (f1.isDirectory()) {
                        f1 = new File(f1, "gtd-free-" + ApplicationHelper.formatLongISO(new Date()) + ".xml");
                    }
                    try {
                        f1.getParentFile().mkdirs();
                    }
                    catch (Exception e) {
                        logger.error("Export error.", e);
                    }
                    try {
                        engine.getGTDModel().exportXML(f1);
                        logger.info("Data successfully exported as XML to " + f1.toString());
                    }
                    catch (Exception e) {
                        logger.error("Export error.", e);
                    }
                }
                if ((val = cl.getOptionValue("eodb")) != null) {
                    f1 = new File(val);
                    if (f1.isDirectory()) {
                        f1 = new File(f1, "gtd-free-" + ApplicationHelper.formatLongISO(new Date()) + ".odb-xml");
                    }
                    try {
                        f1.getParentFile().mkdirs();
                    }
                    catch (Exception e) {
                        logger.error("Export error.", e);
                    }
                    try {
                        GTDData data = engine.getGTDModel().getDataRepository();
                        if (data instanceof GTDDataODB) {
                            try {
                                ((GTDDataODB)data).exportODB(f1);
                            }
                            catch (Exception e) {
                                logger.error("Export error.", e);
                            }
                            logger.info("Data successfully exported as ODB to " + f1.toString());
                            break block45;
                        }
                        logger.info("Data is not stored in ODB database, nothing is exported.");
                    }
                    catch (Exception e) {
                        logger.error("Export error.", e);
                    }
                }
            }
            try {
                engine.close(true, false);
            }
            catch (Exception e) {
                logger.error("Internal error.", e);
            }
            return;
        }
        logger.debug("Using OS '" + System.getProperty("os.name") + "', '" + System.getProperty("os.version") + "', '" + System.getProperty("os.arch") + "'.");
        logger.debug("Using Java '" + System.getProperty("java.runtime.name") + "' version '" + System.getProperty("java.runtime.version") + "'.");
        Locale[] supported = new Locale[]{Locale.ENGLISH, Locale.GERMAN};
        String def = Locale.getDefault().getLanguage();
        boolean toSet = true;
        for (Locale locale : supported) {
            toSet &= !locale.getLanguage().equals(def);
        }
        if (toSet) {
            logger.debug("System locale '" + def + "' not supported, setting to '" + Locale.ENGLISH.getLanguage() + "'.");
            try {
                Locale.setDefault(Locale.ENGLISH);
            }
            catch (Exception e) {
                logger.warn("Setting default locale failed.", e);
            }
        } else {
            logger.debug("Using locale '" + Locale.getDefault().toString() + "'.");
        }
        try {
            if (System.getProperty("swing.crossplatformlaf") == null) {
                String osName = System.getProperty("os.name");
                if (osName != null && osName.toLowerCase().indexOf("windows") != -1) {
                    UIManager.setLookAndFeel("com.jgoodies.looks.windows.WindowsLookAndFeel");
                } else {
                    try {
                        UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
                    }
                    catch (Throwable e) {
                        logger.debug("GTK L&F not supported.", e);
                        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    }
                }
            }
        }
        catch (Throwable e) {
            logger.warn("Setting L&F failed.", e);
        }
        logger.debug("Using L&F '" + UIManager.getLookAndFeel().getName() + "' by " + UIManager.getLookAndFeel().getClass().getName());
        try {
            final GTDFree application = new GTDFree();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        application.getJFrame();
                        application.restore();
                        application.pushVisible();
                        ApplicationHelper.executeInBackground(new Runnable(){

                            @Override
                            public void run() {
                                if (SystemTray.isSupported() && application.getEngine().getGlobalProperties().getBoolean("showTrayIcon", false)) {
                                    try {
                                        SystemTray.getSystemTray().add(application.getTrayIcon());
                                    }
                                    catch (AWTException e) {
                                        logger.error("Failed to activate system tray icon.", e);
                                    }
                                }
                            }
                        });
                        ApplicationHelper.executeInBackground(new Runnable(){

                            @Override
                            public void run() {
                                application.exportRemote();
                            }
                        });
                        if (application.getEngine().getGlobalProperties().getBoolean("checkForUpdateAtStart", true)) {
                            ApplicationHelper.executeInBackground(new Runnable(){

                                @Override
                                public void run() {
                                    application.checkForUpdates(false);
                                }
                            });
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        logger.fatal("Failed to start application, exiting.", t);
                        if (application != null) {
                            application.close(true);
                        }
                        System.exit(0);
                    }
                }
            });
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        application.close(true);
                    }
                    catch (Exception e) {
                        logger.warn("Failed to stop application.", e);
                    }
                    logger.info("Closed.");
                    ApplicationHelper.releaseLock();
                    LogManager.shutdown();
                }
            });
        }
        catch (Throwable t) {
            logger.fatal("Initialization failed, exiting.", t);
            t.printStackTrace();
            System.exit(0);
        }
    }

    private void flashMessage(String string, Point location) {
        if (this.flasher == null) {
            this.flasher = new JWindow();
            this.flasher.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    GTDFree.this.flasher.setVisible(false);
                }
            });
            this.flasherText = new JLabel();
            this.flasher.setContentPane(this.flasherText);
            this.flasherText.setBorder(new Border(){
                Insets insets = new Insets(5, 11, 5, 11);

                @Override
                public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                }

                @Override
                public boolean isBorderOpaque() {
                    return false;
                }

                @Override
                public Insets getBorderInsets(Component c) {
                    return this.insets;
                }
            });
            this.flasherText.setBackground(new Color(15987629));
            this.flasherText.setOpaque(true);
        }
        this.flasher.setVisible(false);
        this.flasherText.setText(string);
        this.flasher.pack();
        this.flasher.setLocation(location.x - this.flasher.getWidth() / 2, location.y - this.flasher.getHeight());
        if (this.flasher.getLocation().x < 0) {
            this.flasher.setLocation(0, this.flasher.getLocation().y);
        }
        if (this.flasher.getLocation().y < 0) {
            this.flasher.setLocation(this.flasher.getLocation().x, 0);
        }
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        if ((double)(this.flasher.getLocation().x + this.flasher.getWidth()) > d.getWidth()) {
            this.flasher.setLocation((int)(d.getWidth() - (double)this.flasher.getWidth()), this.flasher.getLocation().y);
        }
        if ((double)(this.flasher.getLocation().y + this.flasher.getHeight()) > d.getHeight()) {
            this.flasher.setLocation(this.flasher.getLocation().x, (int)(d.getHeight() - (double)this.flasher.getHeight()));
        }
        this.flasher.setVisible(true);
        new Thread(){

            @Override
            public synchronized void run() {
                try {
                    this.wait(3000L);
                }
                catch (InterruptedException e) {
                    Logger.getLogger(this.getClass()).debug("Internal error.", e);
                }
                GTDFree.this.flasher.setVisible(false);
            }
        }.start();
    }

    protected TrayIcon getTrayIcon() {
        if (trayIcon == null) {
            trayIcon = ApplicationHelper.isGTKLaF() ? new TrayIcon(ApplicationHelper.loadImage(ApplicationHelper.icon_name_large_tray_splash)) : new TrayIcon(ApplicationHelper.loadImage(ApplicationHelper.icon_name_small_tray_splash));
            trayIcon.setImageAutoSize(true);
            trayIcon.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 1) {
                        GTDFree.this.trayIconPopup.setVisible(false);
                        if (GTDFree.this.getJFrame().isVisible()) {
                            GTDFree.this.getJFrame().setVisible(false);
                        } else {
                            GTDFree.this.pushVisible();
                        }
                    } else if (GTDFree.this.trayIconPopup.isVisible()) {
                        GTDFree.this.trayIconPopup.setVisible(false);
                    } else {
                        Point p = new Point(e.getPoint());
                        GTDFree.this.trayIconPopup.show(null, p.x, p.y);
                    }
                }
            });
            trayIcon.setToolTip("GTD-Free - " + Messages.getString("GTDFree.Tray.desc"));
            MouseAdapter hideMe = new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent e) {
                    if (e.getComponent() instanceof JMenuItem) {
                        JMenuItem jm = (JMenuItem)e.getComponent();
                        jm.getModel().setRollover(false);
                        jm.getModel().setArmed(false);
                        jm.repaint();
                    }
                    Point p = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), GTDFree.this.trayIconPopup);
                    if (p.x < 0 || p.x >= GTDFree.this.trayIconPopup.getWidth() || p.y < 0 || p.y >= GTDFree.this.trayIconPopup.getHeight()) {
                        GTDFree.this.trayIconPopup.setVisible(false);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (e.getComponent() instanceof JMenuItem) {
                        JMenuItem jm = (JMenuItem)e.getComponent();
                        jm.getModel().setRollover(true);
                        jm.getModel().setArmed(true);
                        jm.repaint();
                    }
                }
            };
            this.trayIconPopup = new JPopupMenu();
            this.trayIconPopup.addMouseListener(hideMe);
            JMenuItem mi = new JMenuItem(Messages.getString("GTDFree.Tray.Drop"));
            mi.setIcon(ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_collecting));
            mi.setToolTipText(Messages.getString("GTDFree.Tray.Drop.desc"));
            mi.addMouseListener(hideMe);
            mi.addMouseListener(new MouseAdapter(){
                private boolean click = false;

                @Override
                public void mousePressed(MouseEvent e) {
                    this.click = true;
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (this.click) {
                        this.click = false;
                        this.doMouseClicked(e);
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    this.click = false;
                }

                private void doMouseClicked(MouseEvent e) {
                    GTDFree.this.trayIconPopup.setVisible(false);
                    Clipboard c = null;
                    if (e.getButton() == 1) {
                        c = Toolkit.getDefaultToolkit().getSystemClipboard();
                    } else if (e.getButton() == 2) {
                        c = Toolkit.getDefaultToolkit().getSystemSelection();
                    } else {
                        return;
                    }
                    try {
                        Object o = c.getData(DataFlavor.stringFlavor);
                        if (o != null) {
                            GTDFree.this.getEngine().getGTDModel().collectAction(o.toString());
                        }
                        GTDFree.this.flashMessage(Messages.getString("GTDFree.Tray.Collect.ok"), e.getLocationOnScreen());
                    }
                    catch (Exception e1) {
                        Logger.getLogger(this.getClass()).debug("Internal error.", e1);
                        GTDFree.this.flashMessage(Messages.getString("GTDFree.Tray.Collect.fail") + e1.getMessage(), e.getLocationOnScreen());
                    }
                }
            });
            TransferHandler th = new TransferHandler(){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
                    return DataFlavor.selectBestTextFlavor(transferFlavors) != null;
                }

                @Override
                public boolean importData(JComponent comp, Transferable t) {
                    try {
                        DataFlavor f = DataFlavor.selectBestTextFlavor(t.getTransferDataFlavors());
                        Object o = t.getTransferData(f);
                        if (o != null) {
                            GTDFree.this.getEngine().getGTDModel().collectAction(o.toString());
                        }
                        return true;
                    }
                    catch (UnsupportedFlavorException e) {
                        Logger.getLogger(this.getClass()).debug("Internal error.", e);
                    }
                    catch (IOException e) {
                        Logger.getLogger(this.getClass()).debug("Internal error.", e);
                    }
                    return false;
                }
            };
            mi.setTransferHandler(th);
            this.trayIconPopup.add(mi);
            mi = new JMenuItem();
            mi.setIcon(ApplicationHelper.getIcon(ApplicationHelper.icon_name_large_delete));
            mi.setText(Messages.getString("GTDFree.Tray.Hide"));
            mi.setToolTipText(Messages.getString("GTDFree.Tray.Hide.desc"));
            mi.addMouseListener(hideMe);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(java.awt.event.ActionEvent e) {
                    GTDFree.this.trayIconPopup.setVisible(false);
                    if (GTDFree.this.getJFrame().isVisible()) {
                        GTDFree.this.getJFrame().setVisible(false);
                    }
                }
            });
            this.trayIconPopup.add(mi);
            mi = new JMenuItem();
            mi.setIcon(ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_splash));
            mi.setText(Messages.getString("GTDFree.Tray.Show"));
            mi.setToolTipText(Messages.getString("GTDFree.Tray.Show.desc"));
            mi.addMouseListener(hideMe);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(java.awt.event.ActionEvent e) {
                    GTDFree.this.trayIconPopup.setVisible(false);
                    GTDFree.this.pushVisible();
                }
            });
            this.trayIconPopup.add(mi);
            mi = new JMenuItem();
            mi.setIcon(ApplicationHelper.getIcon(ApplicationHelper.icon_name_large_exit));
            mi.setText(Messages.getString("GTDFree.Tray.Exit"));
            mi.addMouseListener(hideMe);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(java.awt.event.ActionEvent e) {
                    GTDFree.this.trayIconPopup.setVisible(false);
                    GTDFree.this.close(false);
                }
            });
            this.trayIconPopup.add(mi);
        }
        return trayIcon;
    }

    protected void pushVisible() {
        int st;
        if (!this.getJFrame().isVisible()) {
            this.getJFrame().setVisible(true);
        }
        if (((st = this.getJFrame().getExtendedState()) & 1) != 0) {
            this.getJFrame().setExtendedState(st & 0xFFFFFFFE);
        }
        this.getJFrame().toFront();
        this.getJFrame().invalidate();
        this.getJFrame().repaint();
    }

    public SummaryBean getSummaryBean() {
        if (this.summaryBean == null) {
            this.summaryBean = new SummaryBean();
        }
        return this.summaryBean;
    }

    private JFrame getJFrame() {
        if (this.jFrame == null) {
            this.jFrame = new JFrame();
            this.jFrame.setDefaultCloseOperation(0);
            this.jFrame.setJMenuBar(this.getJMenuBar());
            this.jFrame.setSize(1000, 600);
            this.jFrame.setContentPane(this.getJContentPane());
            String s = System.getProperty("gtd-free.title");
            if ("1".equals(s)) {
                this.jFrame.setTitle("GTD-Free - " + ApplicationHelper.getDataFolder().toString());
            } else {
                this.jFrame.setTitle("GTD-Free");
            }
            this.jFrame.setIconImage(ApplicationHelper.loadImage(ApplicationHelper.icon_name_small_splash));
            this.jFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    GTDFree.this.close(false);
                }

                @Override
                public void windowOpened(WindowEvent e) {
                    GTDFree.this.logger.debug("GTD-Free is up.");
                }
            });
        }
        return this.jFrame;
    }

    boolean close(boolean terminal) {
        if (this.closed) {
            return true;
        }
        if (this.getEngine().isAborting()) {
            return true;
        }
        this.logger.info("Application closing requested" + (terminal ? " unconditionally." : "."));
        this.store(this.getEngine().getGlobalProperties());
        try {
            this.closed = this.getEngine().close(terminal, false);
            return this.closed;
        }
        catch (Exception e1) {
            this.logger.warn("Error while closing engine.", e1);
            return false;
        }
    }

    private void aborting() {
        this.logger.debug("Cleanup while engine aborting.");
        if (this.closed) {
            return;
        }
        if (this.monitor != null) {
            this.monitor.close();
        }
        if (this.flasher != null) {
            this.flasher.dispose();
        }
        if (this.dbInfoDialog != null) {
            this.dbInfoDialog.dispose();
        }
        if (this.jFrame != null) {
            this.jFrame.dispose();
        }
        if (this.trayIconPopup != null) {
            this.trayIconPopup.setVisible(false);
        }
        if (trayIcon != null) {
            SystemTray.getSystemTray().remove(trayIcon);
        }
        if (this.stub != null) {
            try {
                this.stub = null;
                UnicastRemoteObject.unexportObject(this, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void restore() {
        GlobalProperties p = this.getEngine().getGlobalProperties();
        Integer i1 = p.getInteger("window.position.x");
        Integer i2 = p.getInteger("window.position.y");
        if (i1 != null && i2 != null) {
            this.getJFrame().setLocation(i1, i2);
        }
        i1 = p.getInteger("window.width");
        i2 = p.getInteger("window.heght");
        if (i1 != null && i2 != null) {
            this.getJFrame().setSize(i1, i2);
        }
        this.restoreState();
    }

    private void restoreState() {
        GlobalProperties p = this.getEngine().getGlobalProperties();
        Integer i1 = p.getInteger("window.state");
        if (i1 != null) {
            this.getJFrame().setExtendedState(i1);
        }
    }

    private ActionMap getActionMap() {
        if (this.actionMap == null) {
            this.actionMap = new ActionMap();
            AbstractAction a = new AbstractAction(Messages.getString("GTDFree.View.Closed")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(java.awt.event.ActionEvent e) {
                    GTDFree.this.getEngine().getGlobalProperties().putProperty("showAllActions", !GTDFree.this.getEngine().getGlobalProperties().getBoolean("showAllActions"));
                }
            };
            a.putValue("ShortDescription", Messages.getString("GTDFree.View.Closed.desc"));
            this.actionMap.put("showAllActions", a);
            a = new AbstractAction(Messages.getString("GTDFree.View.Empty")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(java.awt.event.ActionEvent e) {
                    GTDFree.this.getEngine().getGlobalProperties().putProperty("showEmptyFolders", !GTDFree.this.getEngine().getGlobalProperties().getBoolean("showEmptyFolders", true));
                }
            };
            a.putValue("ShortDescription", Messages.getString("GTDFree.View.Empty.desc"));
            this.actionMap.put("showEmptyFolders", a);
            a = new AbstractAction(Messages.getString("GTDFree.View.ClosedLists")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(java.awt.event.ActionEvent e) {
                    GTDFree.this.getEngine().getGlobalProperties().putProperty("showClosedFolders", !GTDFree.this.getEngine().getGlobalProperties().getBoolean("showClosedFolders"));
                }
            };
            a.putValue("ShortDescription", Messages.getString("GTDFree.View.ClosedLists.desc"));
            this.actionMap.put("showClosedFolders", a);
            a = new AbstractAction(Messages.getString("GTDFree.View.Overview")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(java.awt.event.ActionEvent e) {
                    GTDFree.this.getEngine().getGlobalProperties().putProperty("showOverviewTab", !GTDFree.this.getEngine().getGlobalProperties().getBoolean("showOverviewTab"));
                }
            };
            a.putValue("ShortDescription", Messages.getString("GTDFree.View.Overview.desc"));
            this.actionMap.put("showOverviewTab", a);
            a = new AbstractAction(Messages.getString("GTDFree.View.Quick")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(java.awt.event.ActionEvent e) {
                    GTDFree.this.getEngine().getGlobalProperties().putProperty("showQuickCollectBar", !GTDFree.this.getEngine().getGlobalProperties().getBoolean("showQuickCollectBar"));
                }
            };
            a.putValue("ShortDescription", Messages.getString("GTDFree.View.Quick.desc"));
            this.actionMap.put("showQuickCollectBar", a);
            a = new AbstractAction(Messages.getString("GTDFree.View.Tray")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(java.awt.event.ActionEvent e) {
                    boolean b = !GTDFree.this.getEngine().getGlobalProperties().getBoolean("showTrayIcon");
                    GTDFree.this.getEngine().getGlobalProperties().putProperty("showTrayIcon", b);
                    if (b) {
                        try {
                            SystemTray.getSystemTray().add(GTDFree.this.getTrayIcon());
                        }
                        catch (AWTException e1) {
                            Logger.getLogger(this.getClass()).error("System tray icon initialization failed.", e1);
                        }
                    } else {
                        SystemTray.getSystemTray().remove(GTDFree.this.getTrayIcon());
                    }
                }
            };
            a.putValue("ShortDescription", Messages.getString("GTDFree.View.Tray.desc"));
            a.setEnabled(SystemTray.isSupported());
            this.actionMap.put("showTrayIcon", a);
            a = new AbstractAction(Messages.getString("GTDFree.ImportExamples")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(java.awt.event.ActionEvent e) {
                    GTDFree.this.getImportDialog().getDialog(GTDFree.this.getJFrame()).setVisible(true);
                }
            };
            a.putValue("ShortDescription", Messages.getString("GTDFree.ImportExamples.desc"));
            this.actionMap.put("importDialog", a);
        }
        return this.actionMap;
    }

    protected ImportExampleDialog getImportDialog() {
        if (this.importDialog == null) {
            this.importDialog = new ImportExampleDialog();
            this.importDialog.setEngine(this.getEngine());
        }
        return this.importDialog;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.tabbedPane = new JTabbedPane();
            if (this.getEngine().getGlobalProperties().getBoolean("showOverviewTab", true)) {
                this.tabbedPane.addTab(Messages.getString("GTDFree.Overview"), ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_overview), this.getOverviewPane());
            }
            this.inBasketPane = new InBasketPane();
            this.tabbedPane.addTab(Messages.getString("GTDFree.Collect"), ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_collecting), this.inBasketPane);
            this.processPane = new ProcessPane();
            this.tabbedPane.addTab(Messages.getString("GTDFree.Process"), ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_processing), this.processPane);
            this.organizePane = new OrganizePane();
            this.tabbedPane.addTab(Messages.getString("GTDFree.Organize"), ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_review), this.organizePane);
            this.executePane = new ExecutePane();
            this.tabbedPane.addTab(Messages.getString("GTDFree.Execute") + " (" + this.getSummaryBean().getQueueCount() + ")", ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_queue_execute), this.executePane);
            this.executeTabIndex = this.tabbedPane.getTabCount() - 1;
            this.getSummaryBean().addPropertyChangeListener("queueCount", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    GTDFree.this.tabbedPane.setTitleAt(GTDFree.this.executeTabIndex, Messages.getString("GTDFree.Execute") + " (" + GTDFree.this.getSummaryBean().getQueueCount() + ")");
                }
            });
            if (Boolean.valueOf(this.getEngine().getConfiguration().getProperty("journal.enabled", "false")).booleanValue()) {
                this.journalPane = new JournalPane();
                this.journalPane.setEngine(this.getEngine());
                this.tabbedPane.addTab("Journal", ApplicationHelper.getIcon(ApplicationHelper.icon_name_large_journaling), this.journalPane);
            }
            this.tabbedPane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    GTDFree.this.enableQuickCollectPanel();
                    Component c = GTDFree.this.tabbedPane.getSelectedComponent();
                    if (c instanceof WorkflowPane && !((WorkflowPane)((Object)c)).isInitialized()) {
                        ((WorkflowPane)((Object)c)).initialize(GTDFree.this.getEngine());
                    }
                    if (c instanceof GTDFreePane) {
                        GTDFree.this.getEngine().setActivePane((GTDFreePane)((Object)c));
                    } else {
                        GTDFree.this.getEngine().setActivePane(null);
                    }
                }
            });
            this.jContentPane.add(this.tabbedPane);
            this.quickCollectPanel = new QuickCollectPanel();
            this.quickCollectPanel.setEngine(this.getEngine());
            this.enableQuickCollectPanel();
            this.jContentPane.add((Component)this.quickCollectPanel, "South");
        }
        return this.jContentPane;
    }

    private void enableQuickCollectPanel() {
        this.quickCollectPanel.setVisible(this.getEngine().getGlobalProperties().getBoolean("showQuickCollectBar") && this.tabbedPane.getSelectedComponent() != this.inBasketPane && this.tabbedPane.getSelectedComponent() != this.overview);
    }

    private Component getOverviewPane() {
        if (this.overview == null) {
            this.overview = new JPanel();
            this.overview.setLayout(new GridBagLayout());
            int row = 0;
            JLabel l = new JLabel(Messages.getString("GTDFree.OW.Workflow"));
            l.setFont(l.getFont().deriveFont((float)((double)l.getFont().getSize() * 5.0 / 4.0)).deriveFont(1));
            this.overview.add((Component)l, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 10, 2, new Insets(18, 18, 7, 18), 0, 0));
            this.overview.add((Component)new OverviewTabPanel(ApplicationHelper.getIcon(ApplicationHelper.icon_name_large_collecting), 1, Messages.getString("GTDFree.Collect")), new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 18, 4, 18), 0, 0));
            this.overview.add((Component)new OverviewTabPanel(ApplicationHelper.getIcon(ApplicationHelper.icon_name_large_processing), 2, Messages.getString("GTDFree.Process")), new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 18, 4, 18), 0, 0));
            this.overview.add((Component)new OverviewTabPanel(ApplicationHelper.getIcon(ApplicationHelper.icon_name_large_review), 3, Messages.getString("GTDFree.Organize")), new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 18, 4, 18), 0, 0));
            this.overview.add((Component)new OverviewTabPanel(ApplicationHelper.getIcon(ApplicationHelper.icon_name_large_queue_execute), 4, Messages.getString("GTDFree.Execute")), new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 18, 4, 18), 0, 0));
            l = new JLabel(Messages.getString("GTDFree.OW.Summary"));
            l.setFont(l.getFont().deriveFont((float)((double)l.getFont().getSize() * 5.0 / 4.0)).deriveFont(1));
            this.overview.add((Component)l, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 10, 2, new Insets(14, 18, 7, 18), 0, 0));
            SummaryLabel sl = new SummaryLabel("inbucketCount"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(java.awt.event.ActionEvent e) {
                    GTDFree.this.tabbedPane.setSelectedIndex(2);
                }

                @Override
                void updateText(PropertyChangeEvent arg0) {
                    if (GTDFree.this.getSummaryBean().getInbucketCount() > 0) {
                        this.label.setText(GTDFree.this.getSummaryBean().getInbucketCount() + " " + Messages.getString("GTDFree.OW.Bucket") + " " + Messages.getString("GTDFree.OW.Process"));
                        this.button.setVisible(true);
                    } else {
                        this.label.setText(GTDFree.this.getSummaryBean().getInbucketCount() + " " + Messages.getString("GTDFree.OW.Bucket"));
                        this.button.setVisible(false);
                    }
                }
            };
            this.overview.add((Component)sl, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 18, 4, 18), 0, 0));
            sl = new SummaryLabel("pastActions"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(java.awt.event.ActionEvent e) {
                    GTDFree.this.tabbedPane.setSelectedIndex(3);
                    GTDFree.this.organizePane.openTicklerForPast();
                }

                @Override
                void updateText(PropertyChangeEvent arg0) {
                    if (GTDFree.this.getSummaryBean().getPastActions() > 0) {
                        this.label.setText(GTDFree.this.getSummaryBean().getPastActions() + " " + Messages.getString("GTDFree.OW.Reminder") + " " + Messages.getString("GTDFree.OW.Update"));
                        this.button.setVisible(true);
                    } else {
                        this.label.setText(GTDFree.this.getSummaryBean().getPastActions() + " " + Messages.getString("GTDFree.OW.Reminder"));
                        this.button.setVisible(false);
                    }
                }
            };
            this.overview.add((Component)sl, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 18, 4, 18), 0, 0));
            sl = new SummaryLabel("todayActions"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(java.awt.event.ActionEvent e) {
                    GTDFree.this.tabbedPane.setSelectedIndex(3);
                    GTDFree.this.organizePane.openTicklerForToday();
                }

                @Override
                void updateText(PropertyChangeEvent arg0) {
                    if (GTDFree.this.getSummaryBean().getTodayActions() > 0) {
                        this.label.setText(GTDFree.this.getSummaryBean().getTodayActions() + " " + Messages.getString("GTDFree.OW.Due") + " " + Messages.getString("GTDFree.OW.Tickler"));
                        this.button.setVisible(true);
                    } else {
                        this.label.setText(GTDFree.this.getSummaryBean().getTodayActions() + " " + Messages.getString("GTDFree.OW.Due"));
                        this.button.setVisible(false);
                    }
                }
            };
            this.overview.add((Component)sl, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 18, 4, 18), 0, 0));
            sl = new SummaryLabel("queueCount"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(java.awt.event.ActionEvent e) {
                    GTDFree.this.tabbedPane.setSelectedIndex(4);
                }

                @Override
                void updateText(PropertyChangeEvent arg0) {
                    if (GTDFree.this.getSummaryBean().getQueueCount() > 0) {
                        this.label.setText(GTDFree.this.getSummaryBean().getQueueCount() + " " + Messages.getString("GTDFree.OW.Queue") + " " + Messages.getString("GTDFree.OW.Execute"));
                        this.button.setVisible(true);
                    } else {
                        this.label.setText(GTDFree.this.getSummaryBean().getQueueCount() + " " + Messages.getString("GTDFree.OW.Queue"));
                        this.button.setVisible(false);
                    }
                }
            };
            this.overview.add((Component)sl, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 18, 4, 18), 0, 0));
            sl = new SummaryLabel("mainCounts"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(java.awt.event.ActionEvent e) {
                    GTDFree.this.getActionMap().get("importDialog").actionPerformed(e);
                    GTDFree.this.engine.getGlobalProperties().putProperty("examplesImported", true);
                    this.updateText(new PropertyChangeEvent(this, "mainCounts", -1, 1));
                }

                @Override
                void updateText(PropertyChangeEvent arg0) {
                    if (!GTDFree.this.getEngine().getGlobalProperties().getBoolean("examplesImported", false)) {
                        this.label.setText(GTDFree.this.getSummaryBean().getOpenCount() + " " + Messages.getString("GTDFree.OW.Open.1") + " " + GTDFree.this.getSummaryBean().getTotalCount() + " " + Messages.getString("GTDFree.OW.Open.2") + " " + Messages.getString("GTDFree.OW.Import"));
                        this.button.setVisible(true);
                    } else {
                        this.label.setText(GTDFree.this.getSummaryBean().getOpenCount() + " " + Messages.getString("GTDFree.OW.Open.1") + " " + GTDFree.this.getSummaryBean().getTotalCount() + " " + Messages.getString("GTDFree.OW.Open.2"));
                        this.button.setVisible(false);
                    }
                }
            };
            this.overview.add((Component)sl, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 18, 4, 18), 0, 0));
            this.overview.add((Component)new JPanel(), new GridBagConstraints(0, row++, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 11, 0, 11), 0, 0));
        }
        return this.overview;
    }

    public DatabaseToolsDialog getDatabaseInfoDialog() {
        if (this.dbInfoDialog == null) {
            this.dbInfoDialog = new DatabaseToolsDialog();
            this.dbInfoDialog.setEngine(this.getEngine());
        }
        return this.dbInfoDialog;
    }

    private JMenuBar getJMenuBar() {
        if (this.jJMenuBar == null) {
            this.jJMenuBar = new JMenuBar();
            this.jJMenuBar.add(this.getFileMenu());
            JMenu jm = new JMenu(Messages.getString("GTDFree.View"));
            jm.add(this.getShowAllActionsMenuItem());
            jm.add(this.getShowClosedFoldersMenuItem());
            jm.add(this.getShowEmptyFoldersMenuItem());
            jm.add(new JSeparator());
            jm.add(this.getShowOverviewTabMenuItem());
            jm.add(this.getShowQuickCollectBarMenuItem());
            jm.add(this.getShowTrayIconMenuItem());
            this.jJMenuBar.add(jm);
            jm = new JMenu(Messages.getString("GTDFree.Go"));
            JMenuItem jmi = new JMenuItem(Messages.getString("GTDFree.Go.Past"));
            jmi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(java.awt.event.ActionEvent e) {
                    GTDFree.this.tabbedPane.setSelectedIndex(3);
                    GTDFree.this.organizePane.openTicklerForPast();
                }
            });
            jm.add(jmi);
            jmi = new JMenuItem(Messages.getString("GTDFree.Go.Today"));
            jmi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(java.awt.event.ActionEvent e) {
                    GTDFree.this.tabbedPane.setSelectedIndex(3);
                    GTDFree.this.organizePane.openTicklerForToday();
                }
            });
            jm.add(jmi);
            this.jJMenuBar.add(jm);
            jm = new JMenu(Messages.getString("GTDFree.Tools"));
            this.jJMenuBar.add(jm);
            jmi = new JMenuItem(Messages.getString("GTDFree.Tools.DB"));
            jmi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(java.awt.event.ActionEvent e) {
                    GTDFree.this.getDatabaseInfoDialog().showDatabaseToolsDialog(GTDFree.this.getJFrame());
                }
            });
            jm.add(jmi);
            this.jJMenuBar.add(this.getHelpMenu());
        }
        return this.jJMenuBar;
    }

    private JMenu getFileMenu() {
        if (this.fileMenu == null) {
            this.fileMenu = new JMenu();
            this.fileMenu.setText(Messages.getString("GTDFree.File"));
            this.fileMenu.add(this.getSaveMenuItem());
            this.autoSaveMenuItem = new JCheckBoxMenuItem();
            this.autoSaveMenuItem.setText(Messages.getString("GTDFree.File.ASave"));
            if (this.getEngine().getGTDModel().getDataRepository() instanceof GTDDataXML) {
                this.autoSaveMenuItem.setSelected(this.getEngine().getGlobalProperties().getBoolean("autoSave", true));
            } else {
                this.autoSaveMenuItem.setSelected(true);
                this.autoSaveMenuItem.setEnabled(false);
            }
            this.autoSaveMenuItem.setToolTipText(Messages.getString("GTDFree.File.ASave.desc"));
            this.autoSaveMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(java.awt.event.ActionEvent e) {
                    GTDFree.this.getEngine().setAutoSave(GTDFree.this.autoSaveMenuItem.isSelected());
                    GTDFree.this.getEngine().getGlobalProperties().putProperty("autoSave", GTDFree.this.autoSaveMenuItem.isSelected());
                }
            });
            this.fileMenu.add(this.autoSaveMenuItem);
            this.fileMenu.add(new JSeparator());
            JMenuItem jmi = new JMenuItem(Messages.getString("GTDFree.File.Print"));
            jmi.setIcon(ApplicationHelper.getIcon(ApplicationHelper.icon_name_large_print));
            jmi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(java.awt.event.ActionEvent e) {
                    GTDFree.this.getPrintDialog().setVisible(true);
                }
            });
            this.fileMenu.add(jmi);
            this.fileMenu.add(new JSeparator());
            jmi = new JMenuItem(Messages.getString("GTDFree.File.Import"));
            jmi.setIcon(ApplicationHelper.getIcon(ApplicationHelper.icon_name_large_import));
            jmi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(java.awt.event.ActionEvent e) {
                    GTDFree.this.importFile();
                }
            });
            this.fileMenu.add(jmi);
            jmi = new JMenuItem(Messages.getString("GTDFree.File.Export"));
            jmi.setIcon(ApplicationHelper.getIcon(ApplicationHelper.icon_name_large_export));
            jmi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(java.awt.event.ActionEvent e) {
                    GTDFree.this.getExportDialog().setVisible(true);
                }
            });
            this.fileMenu.add(jmi);
            jmi = new JMenuItem(Messages.getString("GTDFree.File.All"));
            jmi.setToolTipText(Messages.getString("GTDFree.File.All.desc"));
            jmi.setIcon(ApplicationHelper.getIcon(ApplicationHelper.icon_name_large_export));
            jmi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(java.awt.event.ActionEvent e) {
                    GTDFree.this.exportFile();
                }
            });
            this.fileMenu.add(jmi);
            this.fileMenu.add(new JSeparator());
            this.fileMenu.add(this.getExitMenuItem());
        }
        return this.fileMenu;
    }

    private ExportDialog getExportDialog() {
        if (this.exportDialog == null) {
            this.exportDialog = new ExportDialog(this.getJFrame());
            this.exportDialog.setEngine(this.getEngine());
            this.exportDialog.setLocationRelativeTo(this.getJFrame());
        }
        return this.exportDialog;
    }

    private ExportDialog getPrintDialog() {
        if (this.printDialog == null) {
            this.printDialog = new ExportDialog((Frame)this.getJFrame(), true);
            this.printDialog.setEngine(this.getEngine());
            this.printDialog.setLocationRelativeTo(this.getJFrame());
        }
        return this.printDialog;
    }

    private void importFile() {
        if (0 == this.getFileChooser().showOpenDialog(this.getJFrame())) {
            try {
                this.getEngine().getGTDModel().importXMLFile(this.getFileChooser().getSelectedFile());
                this.logger.info("File imported '" + this.getFileChooser().getSelectedFile() + "'.");
                JOptionPane.showMessageDialog(this.getJFrame(), Messages.getString("GTDFree.Import.OK.1") + this.getFileChooser().getSelectedFile() + Messages.getString("GTDFree.Import.OK.2"), Messages.getString("GTDFree.Import.OK.title"), 1);
            }
            catch (Exception e) {
                this.logger.error("File import '" + this.getFileChooser().getSelectedFile() + "' faled.", e);
                JOptionPane.showMessageDialog(this.getJFrame(), Messages.getString("GTDFree.Import.Fail.1") + this.getFileChooser().getSelectedFile() + Messages.getString("GTDFree.Import.Fail.2") + e.getMessage(), Messages.getString("GTDFree.Import.Fail.title"), 0);
            }
        }
    }

    private void exportFile() {
        if (0 == this.getFileChooser().showSaveDialog(this.getJFrame())) {
            File f = this.getFileChooser().getSelectedFile();
            try {
                if (!f.getName().toLowerCase().endsWith(".xml")) {
                    f = new File(f.toString() + ".xml");
                }
                this.getEngine().getGTDModel().exportXML(f);
                this.logger.info("File exported '" + f + "'.");
                JOptionPane.showMessageDialog(this.getJFrame(), Messages.getString("GTDFree.Export.OK.1") + f + Messages.getString("GTDFree.Export.OK.2"), Messages.getString("GTDFree.Export.OK.title"), 1);
            }
            catch (Exception e) {
                this.logger.error("File export '" + f + "' faled.", e);
                JOptionPane.showMessageDialog(this.getJFrame(), Messages.getString("GTDFree.Export.Fail.1") + f + Messages.getString("GTDFree.Export.Fail.2") + e.getMessage(), Messages.getString("GTDFree.Export.Fail.title"), 0);
            }
        }
    }

    private JMenu getHelpMenu() {
        if (this.helpMenu == null) {
            this.helpMenu = new JMenu();
            this.helpMenu.setText(Messages.getString("GTDFree.Help"));
            JMenuItem jmi = new JMenuItem(Messages.getString("GTDFree.Help.Home"));
            jmi.setIcon(ApplicationHelper.getIcon(ApplicationHelper.icon_name_large_browser));
            jmi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(java.awt.event.ActionEvent e) {
                    try {
                        URI uri = new URI(GTDFree.this.getEngine().getConfiguration().getProperty("home.url", "http://gtd-free.sourceforge.net"));
                        Desktop.getDesktop().browse(uri);
                    }
                    catch (Exception e1) {
                        Logger.getLogger(this.getClass()).error("URL load failed.", e1);
                    }
                }
            });
            this.helpMenu.add(jmi);
            jmi = new JMenuItem(Messages.getString("GTDFree.Help.Manuals"));
            jmi.setIcon(ApplicationHelper.getIcon(ApplicationHelper.icon_name_large_browser));
            jmi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(java.awt.event.ActionEvent e) {
                    try {
                        URI uri = new URI(GTDFree.this.getEngine().getConfiguration().getProperty("manuals.url", "http://gtd-free.sourceforge.net/manuals.html"));
                        Desktop.getDesktop().browse(uri);
                    }
                    catch (Exception e1) {
                        Logger.getLogger(this.getClass()).error("URL load failed.", e1);
                    }
                }
            });
            this.helpMenu.add(jmi);
            jmi = new JMenuItem(this.getActionMap().get("importDialog"));
            this.helpMenu.add(jmi);
            this.helpMenu.add(new JSeparator());
            jmi = new JMenuItem();
            jmi.setText(Messages.getString("GTDFree.Check"));
            jmi.setIcon(ApplicationHelper.getIcon(ApplicationHelper.icon_name_large_update));
            jmi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(java.awt.event.ActionEvent e) {
                    new Thread(){

                        @Override
                        public void run() {
                            GTDFree.this.checkForUpdates(true);
                        }
                    }.start();
                }
            });
            this.helpMenu.add(jmi);
            JCheckBoxMenuItem jcbmi = new JCheckBoxMenuItem();
            jcbmi.setText(Messages.getString("GTDFree.CheckAtStartup"));
            try {
                this.getEngine().getGlobalProperties().connectBooleanProperty("checkForUpdateAtStart", jcbmi, "selected", "isSelected", "setSelected", true);
            }
            catch (Exception e1) {
                this.logger.debug("Internal error.", e1);
            }
            this.helpMenu.add(jcbmi);
            this.helpMenu.add(new JSeparator());
            jmi = new JMenuItem();
            jmi.setText(Messages.getString("GTDFree.Help.Mon"));
            jmi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(java.awt.event.ActionEvent e) {
                    GTDFree.this.getMonitor().getDialog().setVisible(true);
                }
            });
            this.helpMenu.add(jmi);
            this.helpMenu.add(new JSeparator());
            this.helpMenu.add(this.getAboutMenuItem());
        }
        return this.helpMenu;
    }

    private Monitor getMonitor() {
        if (this.monitor == null) {
            this.monitor = new Monitor();
        }
        return this.monitor;
    }

    private JMenuItem getExitMenuItem() {
        if (this.exitMenuItem == null) {
            this.exitMenuItem = new JMenuItem();
            this.exitMenuItem.setText(Messages.getString("GTDFree.File.Exit"));
            this.exitMenuItem.setIcon(ApplicationHelper.getIcon(ApplicationHelper.icon_name_large_exit));
            this.exitMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(java.awt.event.ActionEvent e) {
                    GTDFree.this.close(false);
                }
            });
        }
        return this.exitMenuItem;
    }

    private JMenuItem getAboutMenuItem() {
        if (this.aboutMenuItem == null) {
            this.aboutMenuItem = new JMenuItem();
            this.aboutMenuItem.setText(Messages.getString("GTDFree.Help.About"));
            this.aboutMenuItem.setIcon(ApplicationHelper.getIcon(ApplicationHelper.icon_name_large_about));
            this.aboutMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(java.awt.event.ActionEvent e) {
                    JDialog aboutDialog = GTDFree.this.getAboutDialog();
                    Point loc = GTDFree.this.getJFrame().getLocation();
                    loc.translate(20, 20);
                    aboutDialog.setLocation(loc);
                    aboutDialog.setVisible(true);
                }
            });
        }
        return this.aboutMenuItem;
    }

    private JDialog getAboutDialog() {
        if (this.aboutDialog == null) {
            this.aboutDialog = new JDialog((Frame)this.getJFrame(), true);
            this.aboutDialog.setTitle(Messages.getString("GTDFree.About.Free"));
            Image i = ApplicationHelper.loadImage(ApplicationHelper.icon_name_large_logo);
            ImageIcon ii = new ImageIcon(i);
            JTabbedPane jtp = new JTabbedPane();
            JPanel jp = new JPanel();
            jp.setLayout(new GridBagLayout());
            JLabel jl = new JLabel("GTD-Free", ii, 0);
            jl.setIconTextGap(22);
            jl.setFont(jl.getFont().deriveFont(24.0f));
            jp.add((Component)jl, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(11, 11, 11, 11), 0, 0));
            String s = "Version " + ApplicationHelper.getVersion();
            jp.add((Component)new JLabel(s, 0), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(4, 11, 4, 11), 0, 0));
            s = Messages.getString("GTDFree.About.DBType") + this.getEngine().getGTDModel().getDataRepository().getDatabaseType();
            jp.add((Component)new JLabel(s, 0), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(11, 11, 2, 11), 0, 0));
            s = Messages.getString("GTDFree.About.DBloc") + this.getEngine().getDataFolder();
            jp.add((Component)new JLabel(s, 0), new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 11, 4, 11), 0, 0));
            jp.add((Component)new JLabel("Copyright \u00a9 2008,2009 ikesan@users.sourceforge.net", 0), new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(11, 11, 11, 11), 0, 0));
            jtp.addTab("About", jp);
            jp = new JPanel();
            jp.setLayout(new GridBagLayout());
            AbstractTableModel tm = new AbstractTableModel(){
                private static final long serialVersionUID = -8449423008172417278L;
                private String[] props;

                private String[] getProperties() {
                    if (this.props == null) {
                        this.props = System.getProperties().keySet().toArray(new String[System.getProperties().size()]);
                        Arrays.sort(this.props);
                    }
                    return this.props;
                }

                @Override
                public String getColumnName(int column) {
                    switch (column) {
                        case 0: {
                            return Messages.getString("GTDFree.About.Prop");
                        }
                        case 1: {
                            return Messages.getString("GTDFree.About.Val");
                        }
                    }
                    return null;
                }

                @Override
                public int getColumnCount() {
                    return 2;
                }

                @Override
                public int getRowCount() {
                    return this.getProperties().length;
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    switch (columnIndex) {
                        case 0: {
                            return this.getProperties()[rowIndex];
                        }
                        case 1: {
                            return System.getProperty(this.getProperties()[rowIndex]);
                        }
                    }
                    return null;
                }
            };
            JTable jt = new JTable(tm);
            jp.add((Component)new JScrollPane(jt), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(11, 11, 11, 11), 0, 0));
            jtp.addTab(Messages.getString("GTDFree.About.SysP"), jp);
            jp = new JPanel();
            jp.setLayout(new GridBagLayout());
            JTextArea ta = new JTextArea();
            ta.setEditable(false);
            ta.setText(ApplicationHelper.loadLicense());
            ta.setCaretPosition(0);
            jp.add((Component)new JScrollPane(ta), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(11, 11, 11, 11), 0, 0));
            jtp.addTab("License", jp);
            this.aboutDialog.setContentPane(jtp);
            this.aboutDialog.setSize(550, 300);
            this.aboutDialog.setLocationRelativeTo(this.getJFrame());
        }
        return this.aboutDialog;
    }

    private JMenuItem getSaveMenuItem() {
        if (this.saveMenuItem == null) {
            this.saveMenuItem = new JMenuItem();
            this.saveMenuItem.setText(Messages.getString("GTDFree.File.Save"));
            this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2, true));
            this.saveMenuItem.setIcon(ApplicationHelper.getIcon(ApplicationHelper.icon_name_large_save));
            this.saveMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(java.awt.event.ActionEvent e) {
                    try {
                        GTDFree.this.getEngine().save();
                        Logger.getLogger(this.getClass()).debug("Save successful.");
                    }
                    catch (Exception ex) {
                        Logger.getLogger(this.getClass()).error("Save failed.", ex);
                        JOptionPane.showMessageDialog(GTDFree.this.getJFrame(), "Save failed: '" + ex.getMessage() + "'.", "Save Failed", 0);
                    }
                }
            });
        }
        return this.saveMenuItem;
    }

    public GTDFreeEngine getEngine() {
        if (this.engine == null) {
            try {
                this.engine = new GTDFreeEngine();
                this.engine.addPropertyChangeListener("aborting", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        GTDFree.this.aborting();
                    }
                });
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass()).fatal("Initialization failed.", e);
                this.close(true);
            }
        }
        return this.engine;
    }

    private JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setCurrentDirectory(new File(System.getProperty("user.home", ".")));
            this.fileChooser.setFileSelectionMode(0);
            this.fileChooser.setMultiSelectionEnabled(false);
            this.fileChooser.setFileHidingEnabled(false);
            this.fileChooser.setFileFilter(new FileNameExtensionFilter(Messages.getString("GTDFree.FileFilter"), "xml"));
        }
        return this.fileChooser;
    }

    private JCheckBoxMenuItem getShowAllActionsMenuItem() {
        if (this.showAllActions == null) {
            this.showAllActions = new JCheckBoxMenuItem(this.getActionMap().get("showAllActions"));
            this.showAllActions.setSelected(this.getEngine().getGlobalProperties().getBoolean("showAllActions"));
            this.getEngine().getGlobalProperties().addPropertyChangeListener("showAllActions", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    GTDFree.this.showAllActions.setSelected(GTDFree.this.getEngine().getGlobalProperties().getBoolean("showAllActions"));
                }
            });
        }
        return this.showAllActions;
    }

    private JCheckBoxMenuItem getShowClosedFoldersMenuItem() {
        if (this.showClosedFolders == null) {
            this.showClosedFolders = new JCheckBoxMenuItem(this.getActionMap().get("showClosedFolders"));
            this.showClosedFolders.setSelected(this.getEngine().getGlobalProperties().getBoolean("showClosedFolders"));
            this.getEngine().getGlobalProperties().addPropertyChangeListener("showClosedFolders", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    GTDFree.this.showClosedFolders.setSelected(GTDFree.this.getEngine().getGlobalProperties().getBoolean("showClosedFolders"));
                }
            });
        }
        return this.showClosedFolders;
    }

    private JCheckBoxMenuItem getShowEmptyFoldersMenuItem() {
        if (this.showEmptyFolders == null) {
            this.showEmptyFolders = new JCheckBoxMenuItem(this.getActionMap().get("showEmptyFolders"));
            this.showEmptyFolders.setSelected(this.getEngine().getGlobalProperties().getBoolean("showEmptyFolders", true));
            this.getEngine().getGlobalProperties().addPropertyChangeListener("showEmptyFolders", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    GTDFree.this.showEmptyFolders.setSelected(GTDFree.this.getEngine().getGlobalProperties().getBoolean("showEmptyFolders", true));
                }
            });
        }
        return this.showEmptyFolders;
    }

    private JCheckBoxMenuItem getShowOverviewTabMenuItem() {
        if (this.showOverviewTab == null) {
            this.showOverviewTab = new JCheckBoxMenuItem(this.getActionMap().get("showOverviewTab"));
            this.showOverviewTab.setSelected(this.getEngine().getGlobalProperties().getBoolean("showOverviewTab", true));
            this.getEngine().getGlobalProperties().addPropertyChangeListener("showOverviewTab", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    GTDFree.this.showOverviewTab.setSelected(GTDFree.this.getEngine().getGlobalProperties().getBoolean("showOverviewTab"));
                    if (GTDFree.this.getEngine().getGlobalProperties().getBoolean("showOverviewTab")) {
                        if (GTDFree.this.tabbedPane.getComponentAt(0) != GTDFree.this.getOverviewPane()) {
                            GTDFree.this.tabbedPane.insertTab(Messages.getString("GTDFree.Overview"), ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_overview), GTDFree.this.getOverviewPane(), "", 0);
                        }
                    } else if (GTDFree.this.tabbedPane.getComponentAt(0) == GTDFree.this.getOverviewPane()) {
                        GTDFree.this.tabbedPane.remove(0);
                    }
                }
            });
        }
        return this.showOverviewTab;
    }

    private JCheckBoxMenuItem getShowQuickCollectBarMenuItem() {
        if (this.showQuickCollectBar == null) {
            this.showQuickCollectBar = new JCheckBoxMenuItem(this.getActionMap().get("showQuickCollectBar"));
            this.showQuickCollectBar.setSelected(this.getEngine().getGlobalProperties().getBoolean("showQuickCollectBar"));
            this.getEngine().getGlobalProperties().addPropertyChangeListener("showQuickCollectBar", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    GTDFree.this.showQuickCollectBar.setSelected(GTDFree.this.getEngine().getGlobalProperties().getBoolean("showQuickCollectBar"));
                    GTDFree.this.enableQuickCollectPanel();
                }
            });
        }
        return this.showQuickCollectBar;
    }

    private JCheckBoxMenuItem getShowTrayIconMenuItem() {
        if (this.showTrayIcon == null) {
            this.showTrayIcon = new JCheckBoxMenuItem(this.getActionMap().get("showTrayIcon"));
            this.showTrayIcon.setSelected(this.getEngine().getGlobalProperties().getBoolean("showTrayIcon"));
            this.getEngine().getGlobalProperties().addPropertyChangeListener("showTrayIcon", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    GTDFree.this.showTrayIcon.setSelected(GTDFree.this.getEngine().getGlobalProperties().getBoolean("showTrayIcon"));
                }
            });
        }
        return this.showTrayIcon;
    }

    private void store(GlobalProperties p) {
        p.putProperty("window.heght", this.jFrame.getSize().height);
        p.putProperty("window.width", this.jFrame.getSize().width);
        p.putProperty("window.state", this.jFrame.getExtendedState());
        p.putProperty("window.position.x", this.jFrame.getLocation().x);
        p.putProperty("window.position.y", this.jFrame.getLocation().y);
        if (this.inBasketPane != null && this.inBasketPane.isInitialized()) {
            this.inBasketPane.store(p);
        }
        if (this.processPane != null && this.processPane.isInitialized()) {
            this.processPane.store(p);
        }
        if (this.organizePane != null && this.organizePane.isInitialized()) {
            this.organizePane.store(p);
        }
        if (this.executePane != null && this.executePane.isInitialized()) {
            this.executePane.store(p);
        }
    }

    private void checkForUpdates(boolean notifyOnSame) {
        GTDFreeEngine.VersionInfo[] v = null;
        GTDFreeEngine.VersionInfo current = new GTDFreeEngine.VersionInfo(this.getEngine().getConfiguration());
        if (this.closed) {
            return;
        }
        try {
            v = this.getEngine().checkForNewVersions(current);
        }
        catch (IOException e1) {
            this.logger.error(Messages.getString("GTDFree.CheckFailed"), e1);
            return;
        }
        if (this.closed) {
            return;
        }
        if (v.length == 0) {
            if (notifyOnSame) {
                JOptionPane.showMessageDialog(this.getJFrame(), Messages.getString("GTDFree.UpToDate"), Messages.getString("GTDFree.UpdateCheck"), 1);
            }
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("<html><body><p>");
            sb.append(Messages.getString("GTDFree.Update.1"));
            sb.append(" '");
            sb.append(current.toFullVersionString());
            sb.append("'. ");
            if (v.length == 1) {
                sb.append(Messages.getString("GTDFree.Update.2a"));
            } else {
                sb.append(Messages.getString("GTDFree.Update.2b"));
            }
            sb.append("</p><ul>");
            for (int i = 0; i < v.length; ++i) {
                sb.append("<li>'");
                sb.append(v[i].toFullVersionString());
                if (v[i].notes != null && v[i].notes.length() > 0) {
                    sb.append("' ");
                    sb.append(Messages.getString("GTDFree.Update.3"));
                    sb.append("<br/>'");
                    sb.append(v[i].notes);
                }
                sb.append("'.</li>");
            }
            sb.append("</ul></body></html>");
            if (this.closed) {
                return;
            }
            int option = JOptionPane.showOptionDialog(this.getJFrame(), sb.toString(), Messages.getString("GTDFree.UpdateCheck"), 0, 1, null, new Object[]{Messages.getString("GTDFree.VisitDL"), Messages.getString("GTDFree.Close")}, 0);
            if (this.closed) {
                System.exit(0);
                return;
            }
            if (option == 0) {
                try {
                    Desktop.getDesktop().browse(new URI(this.getEngine().getConfiguration().getProperty("download.url", "http://gtd-free.sourceforge.net/download.html")));
                }
                catch (Exception e) {
                    this.logger.error(Messages.getString("GTDFree.LoadFailed"), e);
                }
            }
        }
    }

    private void exportRemote() {
        if (this.stub != null) {
            return;
        }
        ObjectOutputStream oos = null;
        try {
            this.stub = (GTDFreeOperations)UnicastRemoteObject.exportObject((Remote)this, 0);
            File f = new File(ApplicationHelper.getDataFolder(), STUB_FILE_NAME);
            f.delete();
            oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(f)));
            oos.writeObject(this.stub);
            this.logger.debug("Remote connection exported.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void remotePushVisible() {
        ObjectInputStream ois = null;
        try {
            Object o;
            File f = new File(ApplicationHelper.getDataFolder(), STUB_FILE_NAME);
            if (f.exists() && (o = (ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(f)))).readObject()) instanceof GTDFreeOperations) {
                GTDFreeOperations stub = (GTDFreeOperations)o;
                ((GTDFreeOperations)o).pushAppVisible();
                System.out.println("Remote push to visible called.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void shutdown() {
        this.logger.info("Shutdown initiated by remote client.");
        this.close(false);
    }

    @Override
    public void pushAppVisible() {
        this.logger.info("Made visible by remote client.");
        this.pushVisible();
    }

    @Override
    public boolean isRunning() {
        return !this.getEngine().isAborting() && !this.isClosed();
    }

    @Override
    public String getDataLocation() {
        return ApplicationHelper.getDataFolder().toString();
    }

    abstract class SummaryLabel
    extends JPanel
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        protected JLabel label;
        protected JButton button;

        public SummaryLabel(String prop) {
            this.setLayout(new GridBagLayout());
            this.label = new JLabel();
            this.label.setFont(this.label.getFont().deriveFont(1));
            this.add((Component)this.label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            SummaryBean sb = GTDFree.this.getSummaryBean();
            sb.addPropertyChangeListener(prop, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    SummaryLabel.this.updateText(evt);
                }
            });
            this.button = new JButton();
            this.button.setIcon(ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_next));
            this.button.addActionListener(this);
            this.button.setMargin(new Insets(1, 1, 1, 1));
            this.add((Component)this.button, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
            this.add((Component)new JPanel(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.updateText(new PropertyChangeEvent(this, prop, null, null));
        }

        abstract void updateText(PropertyChangeEvent var1);
    }

    class SummaryBean
    implements GTDModelListener {
        private PropertyChangeSupport supp = new PropertyChangeSupport(this);
        private int inbucketCount;
        private int queueCount;
        private int pastActions;
        private int todayActions;
        private int totalCount;
        private int openCount;

        public SummaryBean() {
            GTDFree.this.getEngine().getGTDModel().addGTDModelListener(this);
            this.updateInBucket();
            this.updateQueue();
            this.updateReminders();
            this.updateMainCounts();
        }

        @Override
        public void folderAdded(Folder folder) {
        }

        @Override
        public void folderModified(FolderEvent folder) {
        }

        @Override
        public void folderRemoved(Folder folder) {
        }

        @Override
        public void elementAdded(FolderEvent a) {
            if (a.getFolder().isQueue()) {
                this.updateQueue();
            } else if (a.getFolder().isInBucket()) {
                this.updateInBucket();
            } else if (a.getFolder().isTickler()) {
                this.updateReminders();
            }
            this.updateMainCounts();
        }

        @Override
        public void elementModified(ActionEvent a) {
            if (a.getAction().getParent().isQueue() || a.getAction().isQueued()) {
                this.updateQueue();
            } else if (a.getAction().getParent().isInBucket()) {
                this.updateInBucket();
            } else if (a.getProperty().equals("remind") || a.getAction().getRemind() != null && a.getProperty().equals("resolution")) {
                this.updateReminders();
            }
        }

        @Override
        public void elementRemoved(FolderEvent a) {
            if (a.getFolder().isQueue()) {
                this.updateQueue();
            } else if (a.getFolder().isInBucket()) {
                this.updateInBucket();
            } else if (a.getFolder().isTickler()) {
                this.updateReminders();
            }
            this.updateMainCounts();
        }

        @Override
        public void orderChanged(Folder f) {
        }

        private void updateInBucket() {
            int n = GTDFree.this.getEngine().getGTDModel().getInBucketFolder().getOpenCount();
            if (n != this.inbucketCount) {
                int old = this.inbucketCount;
                this.inbucketCount = n;
                this.supp.firePropertyChange("inbucketCount", old, n);
            }
        }

        private void updateQueue() {
            int n = GTDFree.this.getEngine().getGTDModel().getQueue().getOpenCount();
            if (n != this.queueCount) {
                int old = this.queueCount;
                this.queueCount = n;
                this.supp.firePropertyChange("queueCount", old, n);
            }
        }

        private void updateMainCounts() {
            int open = 0;
            int total = 0;
            for (Folder f : GTDFree.this.getEngine().getGTDModel()) {
                if (f.isMeta()) continue;
                open += f.getOpenCount();
                total += f.size();
            }
            if (total != this.totalCount || open != this.openCount) {
                this.totalCount = total;
                this.openCount = open;
                this.supp.firePropertyChange("mainCounts", -1, total);
            }
        }

        private void updateReminders() {
            int past = 0;
            int today = 0;
            long time = Utils.today();
            for (Action a : GTDFree.this.getEngine().getGTDModel().getRemindFolder()) {
                if (a.getRemind() == null || !a.isOpen()) continue;
                long t = a.getRemind().getTime();
                if (t < time) {
                    ++past;
                    continue;
                }
                if (t < time || t >= time + 86400000L) continue;
                ++today;
            }
            if (past != this.pastActions) {
                this.pastActions = past;
                this.supp.firePropertyChange("pastActions", -1, this.pastActions);
            }
            if (today != this.todayActions) {
                this.todayActions = today;
                this.supp.firePropertyChange("todayActions", -1, this.todayActions);
            }
        }

        public int getInbucketCount() {
            return this.inbucketCount;
        }

        public int getQueueCount() {
            return this.queueCount;
        }

        public void addPropertyChangeListener(String prop, PropertyChangeListener l) {
            this.supp.addPropertyChangeListener(prop, l);
        }

        public int getPastActions() {
            return this.pastActions;
        }

        public int getTodayActions() {
            return this.todayActions;
        }

        public int getOpenCount() {
            return this.openCount;
        }

        public int getTotalCount() {
            return this.totalCount;
        }
    }

    class OverviewTabPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public OverviewTabPanel(Icon icon, final int tab, String desc) {
            this.setLayout(new GridBagLayout());
            JButton b = new JButton();
            b.setIcon(icon);
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(java.awt.event.ActionEvent e) {
                    GTDFree.this.tabbedPane.setSelectedIndex(tab);
                }
            });
            b.setMargin(new Insets(0, 0, 0, 0));
            this.add((Component)b, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 7), 0, 0));
            JLabel l = new JLabel(desc);
            l.setFont(l.getFont().deriveFont(1));
            this.add((Component)l, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
    }
}

