/*
 * Decompiled with CFR 0.152.
 */
package de.wannawork.jcalendar;

import de.wannawork.jcalendar.JCalendarComboBox;
import de.wannawork.jcalendar.JCalendarDialog;
import de.wannawork.jcalendar.JCalendarPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TestFrame
extends JFrame
implements ChangeListener {
    private static final long serialVersionUID = 1L;
    private JCalendarPanel calendarPanel;
    private JTextField calendarpanelTextField;
    private JCalendarComboBox calendarComboBox;
    private JTextField comboboxTextField;

    public TestFrame() {
        this.setTitle("JCalendar TestFrame");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.createGUI();
    }

    private void createGUI() {
        JPanel content = (JPanel)this.getContentPane();
        content.setLayout(new BorderLayout());
        JPanel comboPanel = new JPanel();
        comboPanel.setBorder(BorderFactory.createTitledBorder("JCalendarComboBox"));
        comboPanel.setLayout(new BorderLayout());
        this.calendarComboBox = new JCalendarComboBox(Calendar.getInstance());
        comboPanel.add((Component)this.calendarComboBox, "North");
        this.comboboxTextField = new JTextField();
        this.comboboxTextField.setEditable(false);
        this.calendarComboBox.addChangeListener(this);
        comboPanel.add((Component)this.comboboxTextField, "Center");
        content.add((Component)comboPanel, "North");
        JPanel monthPanel = new JPanel();
        monthPanel.setBorder(BorderFactory.createTitledBorder("JCalendarPanel"));
        monthPanel.setLayout(new BorderLayout());
        this.calendarPanel = new JCalendarPanel();
        this.calendarPanel.addChangeListener(this);
        monthPanel.add((Component)this.calendarPanel, "Center");
        this.calendarpanelTextField = new JTextField();
        this.calendarpanelTextField.setEditable(false);
        monthPanel.add((Component)this.calendarpanelTextField, "South");
        content.add((Component)monthPanel, "Center");
        JButton dialog = new JButton("Create Dialog");
        dialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestFrame.this.showCalendarDialog();
            }
        });
        content.add((Component)dialog, "South");
        this.pack();
        this.setVisible(true);
    }

    private void showCalendarDialog() {
        JCalendarDialog caldialog = new JCalendarDialog(this, "Get Date", "Please select the Date :");
        System.out.println(caldialog.getCalendar());
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        DateFormat format = DateFormat.getDateInstance();
        if (e.getSource() == this.calendarComboBox) {
            this.comboboxTextField.setText(format.format(this.calendarComboBox.getCalendar().getTime()));
        } else {
            this.calendarpanelTextField.setText(format.format(this.calendarPanel.getCalendar().getTime()));
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new TestFrame();
    }
}

