/*
 * Decompiled with CFR 0.152.
 */
package de.wannawork.jcalendar;

import de.wannawork.jcalendar.FlatButton;
import de.wannawork.jcalendar.JMonthPanel;
import de.wannawork.jcalendar.LocaleStrings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JCalendarPanel
extends JPanel
implements ItemListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    public static final int FIRE_EVERYTIME = 1;
    public static final int FIRE_DAYCHANGES = 2;
    private int _listenermode = 1;
    private boolean _updating = false;
    private Calendar _cal;
    private DateFormat _format;
    private Locale _locale;
    private JComboBox _month;
    private JComboBox _year;
    private JMonthPanel _monthPanel;
    private ArrayList<ChangeListener> _changeListener = new ArrayList();
    private boolean _fireingChangeEvent = false;

    public JCalendarPanel() {
        this.createGUI(Calendar.getInstance(), Locale.getDefault(), DateFormat.getDateInstance(2, Locale.getDefault()), true, 2100);
    }

    public JCalendarPanel(Calendar cal) {
        this.createGUI(cal, Locale.getDefault(), DateFormat.getDateInstance(2, Locale.getDefault()), true, 2100);
    }

    public JCalendarPanel(Locale locale) {
        this.createGUI(Calendar.getInstance(locale), locale, DateFormat.getDateInstance(2, locale), true, 2100);
    }

    public JCalendarPanel(Calendar cal, Locale locale) {
        this.createGUI(cal, locale, DateFormat.getDateInstance(2, locale), true, 2100);
    }

    public JCalendarPanel(Calendar cal, Locale locale, DateFormat dateFormat) {
        this.createGUI(cal, locale, dateFormat, true, 2100);
    }

    public JCalendarPanel(Calendar cal, Locale locale, DateFormat dateFormat, boolean flat) {
        this.createGUI(cal, locale, dateFormat, flat, 2100);
    }

    public JCalendarPanel(Calendar cal, Locale locale, DateFormat dateFormat, boolean flat, int maxYear) {
        this.createGUI(cal, locale, dateFormat, flat, maxYear);
    }

    private void createGUI(Calendar cal, Locale locale, DateFormat dateFormat, boolean flat, int maxYear) {
        this._locale = locale;
        this._cal = Calendar.getInstance(locale);
        this._cal.set(5, cal.get(5));
        this._cal.set(2, cal.get(2));
        this._cal.set(1, cal.get(1));
        this._format = dateFormat;
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this._month = this.createMonth();
        this._month.addItemListener(this);
        this.add((Component)this._month, c);
        this._year = this.createYear(maxYear);
        this._year.addItemListener(this);
        c.gridwidth = 0;
        this.add((Component)this._year, c);
        c.anchor = 10;
        c.fill = 1;
        c.insets = new Insets(1, 1, 1, 1);
        this._monthPanel = new JMonthPanel(this._cal, this._locale);
        this._monthPanel.addChangeListener(this);
        this.add((Component)this._monthPanel, c);
        c.insets = new Insets(0, 0, 1, 0);
        this.add((Component)this.createButtonPanel(flat), c);
        this._monthPanel.grabFocus();
    }

    private JPanel createButtonPanel(boolean flat) {
        JButton yearRight;
        JButton dayRight;
        JButton today;
        JButton dayLeft;
        JButton yearLeft;
        JPanel buttonpanel = new JPanel();
        if (flat) {
            yearLeft = new FlatButton("<<");
            dayLeft = new FlatButton("<");
            today = new FlatButton(LocaleStrings.getString("JCalendarPanel.Today"));
            dayRight = new FlatButton(">");
            yearRight = new FlatButton(">>");
        } else {
            yearLeft = new JButton("<<");
            yearLeft.setMargin(new Insets(1, 1, 1, 1));
            dayLeft = new JButton("<");
            dayLeft.setMargin(new Insets(1, 1, 1, 1));
            today = new JButton(LocaleStrings.getString("JCalendarPanel.Today"));
            today.setMargin(new Insets(2, 2, 2, 2));
            dayRight = new JButton(">");
            dayRight.setMargin(new Insets(1, 1, 1, 1));
            yearRight = new JButton(">>");
            yearRight.setMargin(new Insets(1, 1, 1, 1));
        }
        buttonpanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.insets = new Insets(0, 0, 0, 5);
        yearLeft.setMargin(new Insets(1, 1, 1, 1));
        yearLeft.setToolTipText(LocaleStrings.getString("JCalendarPanel.Last_Year"));
        yearLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JCalendarPanel.this._year.getSelectedIndex() > 0) {
                    int month = JCalendarPanel.this._cal.get(2);
                    JCalendarPanel.this._cal.set(1, JCalendarPanel.this._cal.get(1) - 1);
                    if (JCalendarPanel.this._cal.get(2) != month) {
                        JCalendarPanel.this._cal.set(2, month);
                    }
                    JCalendarPanel.this.setCalendar(JCalendarPanel.this._cal, false);
                }
            }
        });
        buttonpanel.add((Component)yearLeft, c);
        dayLeft.setMargin(new Insets(1, 1, 1, 1));
        dayLeft.setToolTipText(LocaleStrings.getString("JCalendarPanel.Last_Month"));
        dayLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int monthIndex = JCalendarPanel.this._cal.get(2);
                JCalendarPanel.this._cal.set(2, monthIndex - 1);
                if (JCalendarPanel.this._cal.get(2) == monthIndex) {
                    JCalendarPanel.this._cal.set(5, 0);
                }
                JCalendarPanel.this.setCalendar(JCalendarPanel.this._cal, false);
            }
        });
        buttonpanel.add((Component)dayLeft, c);
        GridBagConstraints c2 = new GridBagConstraints();
        c2.fill = 2;
        c2.weightx = 1.0;
        today.setMargin(new Insets(2, 2, 2, 2));
        today.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCalendarPanel.this.setCalendar(Calendar.getInstance());
                JCalendarPanel.this.fireChangeEvent();
            }
        });
        buttonpanel.add((Component)today, c2);
        c.insets = new Insets(0, 5, 0, 0);
        dayRight.setMargin(new Insets(1, 1, 1, 1));
        dayRight.setToolTipText(LocaleStrings.getString("JCalendarPanel.Next_Month"));
        dayRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int monthIndex = JCalendarPanel.this._cal.get(2);
                JCalendarPanel.this._cal.set(2, monthIndex + 1);
                if (JCalendarPanel.this._cal.get(2) != (monthIndex + 1) % 12) {
                    JCalendarPanel.this._cal.set(5, 0);
                }
                JCalendarPanel.this.setCalendar(JCalendarPanel.this._cal, false);
            }
        });
        buttonpanel.add((Component)dayRight, c);
        yearRight.setMargin(new Insets(1, 1, 1, 1));
        yearRight.setToolTipText(LocaleStrings.getString("JCalendarPanel.Next_Year"));
        yearRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JCalendarPanel.this._year.getSelectedIndex() < JCalendarPanel.this._year.getItemCount() - 1) {
                    int month = JCalendarPanel.this._cal.get(2);
                    JCalendarPanel.this._cal.set(1, JCalendarPanel.this._cal.get(1) + 1);
                    if (JCalendarPanel.this._cal.get(2) != month) {
                        JCalendarPanel.this._cal.set(2, month);
                    }
                    JCalendarPanel.this.setCalendar(JCalendarPanel.this._cal, false);
                }
            }
        });
        buttonpanel.add((Component)yearRight, c);
        return buttonpanel;
    }

    private JComboBox createYear(int maxYear) {
        JComboBox<String> year = new JComboBox<String>();
        int i = 1900;
        while (i <= maxYear) {
            year.addItem("" + i);
            ++i;
        }
        year.setSelectedIndex(this._cal.get(1) - 1900);
        return year;
    }

    private JComboBox createMonth() {
        JComboBox<String> month = new JComboBox<String>();
        month.setFocusable(false);
        String[] s = DateFormatSymbols.getInstance(this._locale).getMonths();
        int i = 0;
        while (i < 12) {
            month.addItem(s[i]);
            ++i;
        }
        month.setSelectedIndex(this._cal.get(2));
        return month;
    }

    private void updateCalendar() {
        if (!this._updating) {
            this._updating = true;
            this._cal.set(2, this._month.getSelectedIndex());
            this._cal.set(1, this._year.getSelectedIndex() + 1900);
            this._cal.set(5, this._monthPanel.getSelectedDayOfMonth());
            this._monthPanel.setCalendar(this._cal);
            this._monthPanel.grabFocus();
            this._updating = false;
        }
    }

    public Calendar getCalendar() {
        return this._cal;
    }

    public Date getDate() {
        if (this.isUnset()) {
            return null;
        }
        return this.getCalendar().getTime();
    }

    public void setCalendar(Calendar cal) {
        this.setCalendar(cal, true);
    }

    private void setCalendar(Calendar cal, boolean fireEvent) {
        this._updating = true;
        if (cal == null) {
            cal = Calendar.getInstance(this._locale);
            this._cal.set(5, cal.get(5));
            this._cal.set(2, cal.get(2));
            this._cal.set(1, cal.get(1));
            this._monthPanel.setCalendar(null);
        } else {
            if (this._cal != cal) {
                this._cal.set(5, cal.get(5));
                this._cal.set(2, cal.get(2));
                this._cal.set(1, cal.get(1));
            }
            this._monthPanel.setCalendar(this._cal);
        }
        this._year.setSelectedIndex(this._cal.get(1) - 1900);
        this._month.setSelectedIndex(this._cal.get(2));
        this._monthPanel.grabFocus();
        if (fireEvent) {
            this.fireChangeEvent();
        }
        this._updating = false;
    }

    public void setDate(Date date) {
        if (date == null) {
            this.setCalendar(null);
        } else {
            this._cal.setTime(date);
            this.setCalendar(this._cal);
        }
    }

    @Override
    public String toString() {
        if (this.isUnset()) {
            return "<No Date>";
        }
        return this._format.format(this._cal.getTime());
    }

    public String toString(DateFormat format) {
        return format.format(this._cal.getTime());
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.updateCalendar();
        if (this._listenermode == 1) {
            this.fireChangeEvent();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (!this._updating) {
            this._cal.set(5, this._monthPanel.getSelectedDayOfMonth());
            this.fireChangeEvent();
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this._changeListener.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this._changeListener.remove(listener);
    }

    public ChangeListener[] getChangeListener() {
        return (ChangeListener[])this._changeListener.toArray();
    }

    protected void fireChangeEvent() {
        if (!this._fireingChangeEvent) {
            this._fireingChangeEvent = true;
            ChangeEvent event = new ChangeEvent(this);
            int i = 0;
            while (i < this._changeListener.size()) {
                this._changeListener.get(i).stateChanged(event);
                ++i;
            }
            this._fireingChangeEvent = false;
        }
    }

    public void setListenerModus(int mode) {
        this._listenermode = mode;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this._month.setEnabled(enabled);
        this._year.setEnabled(enabled);
        this._monthPanel.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        return this._month.isEnabled();
    }

    public void setDateFormat(DateFormat format) {
        if (format == null) {
            throw new NullPointerException("format is null");
        }
        this._format = format;
    }

    public DateFormat getDateFormat() {
        return this._format;
    }

    public boolean isUnset() {
        return this._monthPanel.isUnset();
    }
}

